## Using the grid

You can use muliple rows ... and divide each row in multiple columns. The grid contains 12 rows.

## Rows

### Syntax

```php
$renderAdminLTE->addRow([HTML code]);
```

### Parameters

* [HTML code] - {string} Html code of the visible content

## Columns

### Syntax

```php
$renderAdminLTE->addCol([HTML code], [Width]);
```

### Parameters

* [HTML code] - {string} Html code of the visible content
* [Width] - {integer} number of column width; values: 1..12

### Example

You can define a width of 1..12 to define a screen width of your cell.

Here is an example with 3 rows ... first with fill width; then on row with 3 columns and a third row with 2 columns:

```php
echo ''
    .$renderAdminLTE->addRow(
        $renderAdminLTE->addCol("full width column", 12 )
    )
    . $renderAdminLTE->addRow(
        $renderAdminLTE->addCol("column 1/ 3", 4 )
        . $renderAdminLTE->addCol("column 2/ 3", 4 )
        . $renderAdminLTE->addCol("column 3/ 3", 4 )
    )
    .$renderAdminLTE->addRow(
        $renderAdminLTE->addCol("column 1/ 2", 6 )
        . $renderAdminLTE->addCol("column 1/ 2", 6 )
)
;
```
