## Callout

A div to display boxed content.

It has header, main text and a footer.

### Syntax

```php
$renderAdminLTE->getCard($aOptions);
```

### Parameters

* $aOptions - {array} options to describe the element

Styling:

Key      | Description
---      | ---
class    | optional: additional css classes
type     | one of [none]\|danger\|dark\|info\|primary\|secondary\|success\|warning
variant  | kind of coloring: one of<br>- "default"  - titlebar is colored<br>- "outline" - a small stripe on top border is colored<br>- "solid"    - whole card is colored<br>- "gradient" - whole card is colored with a gradient

Content:

Key      | Description
---      | ---
footer   | footer of the card
text     | visible text
title    | title of the card
tools    | html code for upper right corner

### Example

```php
$renderAdminLTE->getCard(array (
  'type' => 'primary',
  'variant' => 'solid',
  'title' => 'I am a card',
  'tools' => '123',
  'text' => 'Hello everybody out there!',
  'footer' => '&copy; Axel',
))
```
