#!/bin/bash
# ===============================================================
#
# PACKAGE MANAGER: APT
# Debian, Ubuntu
#
# included by ../check_packages2install
#
# ---------------------------------------------------------------
# ah <axel.hahn@iml.unibe.ch>
# 2022-06-03  v1.0  ah  first version
# 2022-06-07  v1.1  ah  remove text "Nothing to install"
#                       rename functions
# ===============================================================


# ---------------------------------------------------------------
# command to list of updates
function apt.getUpdates(){
    sudo apt-get -u upgrade --assume-no
}

# ---------------------------------------------------------------
# extract list of packages 2 install
# global  string  packagemanOut  output of update lister command
function apt.getPackageList(){

    # detect number of line containing "The following packages will be upgraded:"
    typeset -i local iStart
    iStart=$( echo "$packagemanOut" | grep -n '^The following packages will be upgraded:' | cut -f 1 -d ':' )

    if [ $iStart -gt 0 ]; then
        # show packages = text starting with 2 spaces below start line
        # packages are delimited with space -> replace with new line
        echo "$packagemanOut" | sed -n $iStart,\$p | grep "^\ \ " | sed "s#^\ \ ##g" | tr " " "\n"
    fi
}

# ---------------------------------------------------------------
# get status line on apt based systems (debian, ubuntu)
# global  string  packagemanOut  output of update lister command
function apt.getStatusLine(){
  echo "$packagemanOut" | grep "upgraded.*installed"
}

# ---------------------------------------------------------------
