#!/bin/bash
# ===============================================================
#
# PACKAGE MANAGER: YUM
# CentOS
#
# included by ../check_packages2install
#
# ---------------------------------------------------------------
# ah <axel.hahn@iml.unibe.ch>
# 2022-06-03  v1.0  ah  first version
# 2022-06-07  v1.1  ah  add sudo for yum --bugfix check-update
#                       rename functions
# 2022-08-31  v1.2  ah  status line depends on os major version
# ===============================================================


# ---------------------------------------------------------------
# command to list of updates
function yum.getUpdates(){
    sudo /usr/bin/yum -y check-update
}

# ---------------------------------------------------------------
# extract list of packages 2 install
# global  string  packagemanOut  output of update lister command
function yum.getPackageList(){
    local iStart=3
    # detect number of line containing "Obsoleting Packages"
    typeset -i local iEnd
    iEnd=$( echo "$packagemanOut" | grep -n '^Obsoleting Packages' | cut -f 1 -d ':' )-1

    local sEnd=$iEnd
    test "$iEnd" = "-1" && sEnd='$'

    echo "$packagemanOut" | sed -n ${iStart},${sEnd}p
}

# ---------------------------------------------------------------
# get custom status
function yum.getStatusLine(){
  typeset -i local _osversion
  _osversion=$( ph.getOSMajor )
  if [ $_osversion -ge 8 ]; then
    if ! sudo /usr/bin/yum --security check-update 2>&1 | grep "available" ; then
      echo "rc = $? [Not detected on v$_osversion]"
    fi
  else
    if ! sudo /usr/bin/yum --bugfix check-update 2>&1 | grep security; then
      echo "rc = $? [Not detected on v$_osversion]"
    fi
  fi
}

# ---------------------------------------------------------------
# extract count of critical packages
# param  string  text to extract critical counter from
function yum.getCriticalList(){
  local summary="$1"
  # example outputs:
  # I    No packages needed for security; 223 packages available
  # II   2 package(s) needed for security, out of 237 available
  # III  No security updates needed, but 61 updates available     << centos 8 stream
  echo "$summary" | cut -f 1  -d ' ' | sed "s#[^0-9]##g"
}

# ---------------------------------------------------------------
