#!/bin/bash
# ================================================================================
#
# TRANSFER :: PLUGIN - TEMPLATE
#
# this script will be included in ../../transfer.sh
#
# --------------------------------------------------------------------------------
# ah - Axel Hahn <axel.hahn@iml.unibe.ch>
# 2021-05-19  ah    v0.0   INIT ... WIP
# ================================================================================

# --------------------------------------------------------------------------------
# ENV VARS
# export variables that are needed by the backup tool
# --------------------------------------------------------------------------------

# export PASSPHRASE

# --------------------------------------------------------------------------------
# INIT
# --------------------------------------------------------------------------------

    function t_checkRequirements(){
        echo "DEBUG: function t_checkRequirements"
        j_requireUser "root"
        # j_requireBinary "duplicity"
    }

    # set variables 
    function t_setVars(){
        echo "DEBUG: t_setVars"
    }

# --------------------------------------------------------------------------------
# GENERATE PARAMS :: ALL DIRS
# --------------------------------------------------------------------------------

    # return a string with default params
    # param  string  param1 of transfer.sh; one of full|inc|auto
    # param  string  param2 of transfer.sh; for auto: date i.e. 3M for 3 monthes
    function t_getParamDefault(){
        echo "DEBUG: function t_getParamDefault $*"

        # local _method=

        # --- method
        # test "$1" = "full" && _method="full"
        # test "$1" = "auto" && _method="--full-if-older-than $2"
        # echo -n "$_method"

    }

    # return a cli parameter for a single exlude directory
    # param  string  cache directory for local index files
    function t_getParamCacheDir(){
        if [ ! -z "$1" ]; then
            local sCacheDir="$1"
            if [ ! -d $sCacheDir ]; then
                mkdir -p $sCacheDir
                chmod 750 $sCacheDir
            fi
            echo --archive-dir=$sCacheDir
        fi
    }

    # return a cli parameter for a single exlude directory
    # param  string  exlude pattern
    function t_getParamExlude(){
        # test -z "$1" || echo --exclude-regexp """$*"""
    }
    # return a cli parameter for a single exlude directory
    # param  string  exlude pattern
    function t_getParamInlude(){
        # test -z "$1" || echo --include-regexp """$*"""
    }

    # return a cli parameter to use an ssh keyfile
    # param  string  filename if ssh private key file
    function t_getParamSshKey(){
        # test -z "$1" || echo --ssh-options="""-oIdentityFile=$1"""
    }

# --------------------------------------------------------------------------------
# ACTIONS :: TRANSFER
# --------------------------------------------------------------------------------
    # pre backup actions
    # uses global vars from ../../transfer.sh
    function t_backupDoPreTasks(){
        # echo TODO PRE actions before starting transfer
    }


    # post backup actions
    # uses global vars from ../../transfer.sh
    function t_backupDoPostTasks(){
        # echo TODO POST actions after all transfers
    }

# --------------------------------------------------------------------------------
# GENERATE PARAMS :: SINGLE DIR
# --------------------------------------------------------------------------------

    # get target url/ directory
    # param  string  directory to backup
    function t_backupDirGetTarget(){
        # directory based target
        j_getFullTarget "$1"
        # for host based backup target - remove param:
        # j_getFullTarget ""
    }

    function t_backupDirGetCmdBackup(){
        # echo duplicity ${ARGS_BACKUP} ${mydir} ${sTarget}
    }

    # pre backup actions
    # uses global vars from ../../transfer.sh
    function t_backupDirDoPreTasks(){
    }


    # post backup actions
    # uses global vars from ../../transfer.sh
    function t_backupDirDoPostTasks(){
    }

# --------------------------------------------------------------------------------
# RESTORE
# --------------------------------------------------------------------------------

    # show stored volumes on backup repository
    # used in restore; directory param is checked before
    # param  string  name of backup dir, i.e. /etc
    function t_restoreDoShowVolumes(){
    }

    # select a snapshot to restore from
    function t_restoreDoSelect(){
        local _selid=
        echo "--- Existing snapshots:"
        color cmd
        t_restoreDoShowVolumes
        color reset
        showPrompt "ID of the snapshot or \"latest\" to restore from [${RESTORE_ITEM}] >"
        read _selid
        test -z "$_selid" && _selid=${RESTORE_ITEM}
        RESTORE_ITEM=${_selid}

        test "$RESTORE_ITEM" = "latest" && RESTORE_ITEMINFO="automatic value"
        test "$RESTORE_ITEM" = "latest" || RESTORE_ITEMINFO=$( t_restoreDoShowVolumes | grep "^${RESTORE_ITEM} " | awk '{ print $2 " " $3} ' )

        if [ -z "${RESTORE_ITEMINFO}" ]; then
            color error
            echo ERROR: A napshot ID \"${_selid}\" does not exist.
            RESTORE_ITEM=latest
            color reset
        fi
        echo using \"${RESTORE_ITEM}\"
        echo
    }

    # set a filter to reduce count of files to restore
    function t_restoreDoSetIncludeFilter(){
        local _inc=
        echo "You can enter ..."
        echo "  - a single directory name anywhere in the folderstructure"
        echo "  - a filename without path"
        echo "  - a filemask"
        showPrompt "Include >"
        read _inc
        RESTORE_FILTER="$( t_getParamInlude "${_inc}" )"
        echo using parameter \"${RESTORE_FILTER}\"
        echo
    }
    # show stored volumes on backup repository
    # used in restore; directory param is checked before
    # param  string  name of backup dir, i.e. /etc
    function t_restoreDoRestore(){
        echo ""
    }

    # Mount backup data
    function t_restoreDoMountBackupdata(){

    }

# --------------------------------------------------------------------------------
# VERIFY RETURNCODES
# --------------------------------------------------------------------------------

    # init repository
    function t_rcCheckInit(){
        case $1 in
            0) color ok;      echo "OK - the repository was created." ;;
            *) color error;   echo "Verify output above - returncode of init was $1" ;;
        esac
        color reset
    }
    # backup files
    function t_rcCheckBackup(){
        case $1 in
            0) color ok;      echo "OK" ;;
            *) color error;   echo "Backup error - returncode was $1" ;;
        esac
        color reset
    }

    # repoitory cleanup
    function t_rcCheckCleanup(){
        case $1 in
            0) color ok;      echo "OK" ;;
            *) color error;   echo "Cleanup error - returncode was $1" ;;
        esac
        color reset
    }

    # restore files
    function t_rcCheckRestore(){
        case $1 in
            0) color ok;      echo "OK" ;;
            *) color error;   echo "Restore error - returncode was $1" ;;
        esac
        color reset
    }

# --------------------------------------------------------------------------------
