#!/bin/bash
# ================================================================================
#
# Backup script to save slapd data
#
# --------------------------------------------------------------------------------
#
# Author: daniel.schueler@iml.unibe.ch
# Location: /root/bin/backup_ldap.sh
#
# This script is called by Cron and controlled by Puppet.
# --> Do not edit manualy!
# ================================================================================


if [ -z $BACKUP_TARGETDIR ]; then
  echo ERROR: you cannot start `basename $0` directly
  rc=$rc+1
  exit 1
fi

# --------------------------------------------------------------------------------
# CONFIG
# --------------------------------------------------------------------------------


SLAPCAT='/sbin/slapcat'
LDAP_CONF_DIR_PATH='/etc/openldap/slapd.d'


# --------------------------------------------------------------------------------
# FUNCTIONS
# --------------------------------------------------------------------------------

# ----------------------------------------------------------------------
# ldap backup with slapcat
# param  string  DN
# param  string  name of output file
# ----------------------------------------------------------------------
function dump_ldap(){
  DN=$1
  DUMPFILE=$2

  $SLAPCAT -F $LDAP_CONF_DIR_PATH -b $DN -l $DUMPFILE
  fetchrc

  if [ $rc -ne 0 ]; then
    echo ERROR during backup $LDAP_CONF_DIR_PATH
  else
    echo Dump OK
    compress_file $DUMPFILE
  fi
}

# ----------------------------------------------------------------------
# run ldap backups
# ----------------------------------------------------------------------
function doLdapBackup(){

  create_targetdir

  echo ----- LDAP BACKUP CONFIG
  for cfgname in `ldapsearch -H ldap:// -x -s base -b "" -LLL "configContext" | grep "configContext" | cut -f 2 -d ":"`
  do
    echo DN $cfgname
    cfg2=`echo $cfgname | sed "s#[\ =,]#_#g"`
    outfile=$(hostname)_ldap_olc_config__`get_outfile ${cfg2}`.ldif

    dump_ldap $cfgname $BACKUP_TARGETDIR/$outfile
  done


  echo ----- LDAP DATA
  for cfgname in `ldapsearch -H ldap:// -x -s base -b "" -LLL "namingContexts" | grep "namingContexts" | cut -f 2 -d ":"`
  do
    echo DN $cfgname
    cfg2=`echo $cfgname | sed "s#[\ =,]#_#g"`
    outfile=$(hostname)_ldap_data__`get_outfile ${cfg2}`.ldif

    dump_ldap $cfgname $BACKUP_TARGETDIR/$outfile
  done

  echo
  echo ----- DUMPS
  ls -l $BACKUP_TARGETDIR/*$BACKUP_DATE*
}


function restoreByFile(){
  echo "TODO :-/"
  rc=$rc+1
}


# --------------------------------------------------------------------------------
# MAIN
# --------------------------------------------------------------------------------


# ----- check requirements
j_requireBinary "ldapsearch" 1
j_requireBinary "slapcat"    1

j_requireProcess "slapd"     1


if [ $rc -ne 0 ]; then
  rc=0
  echo "SKIP: LDAP seems not to be here"
else
  if [ "$1" = "restore" ]; then
    echo
    restoreByFile "${2}"
  else

    doLdapBackup
  fi
fi

echo $0 $* [ldap] final returncode rc=$rc

# --------------------------------------------------------------------------------
