#!/bin/bash
# ================================================================================
#
# LOCALDUMP :: MYSQL / MARIADB
# create gzipped plain text backups from each scheme
#
# --------------------------------------------------------------------------------
# ah - Axel Hahn <axel.hahn@iml.unibe.ch>
# ds - Daniel Schueler <daniel.schueler@iml.unibe.ch>
#
# 2016-11-10  ah,ds  v0.8  needs to be testet
# 2017-03-28  .....  v1.0  added restore
# ================================================================================

if [ -z $BACKUP_TARGETDIR ]; then
  echo ERROR: you cannot start `basename $0` directly
  rc=$rc+1
  exit 1
fi

# --------------------------------------------------------------------------------
# CONFIG
# --------------------------------------------------------------------------------

SOURCE_DIR=/var/lib/mysql
MYSQLDUMP=/usr/bin/mysqldump

# --------------------------------------------------------------------------------
# FUNCTIONS
# --------------------------------------------------------------------------------

function doMysqlBackup(){

  create_targetdir

  for DATABASE_DIR in `find $SOURCE_DIR/* -type d -prune`;
  do
    # DATABASE=`basename $DATABASE_DIR`
    DATABASE=`basename $DATABASE_DIR | sed "s#\@002d#-#g" `
    TABLECOUNT=`find $DATABASE_DIR/. -type f -name *frm | wc -l`
    echo --- database $DATABASE - $TABLECOUNT tables
    if [ $TABLECOUNT -gt 0 ]; then
      echo -n "backup ... "
      OUTFILE=${BACKUP_TARGETDIR}/`get_outfile ${DATABASE}`.sql
      # task 1251 - "--master-data=2" was removed
      $MYSQLDUMP --opt \
               --default-character-set=utf8 \
               --flush-logs \
               --single-transaction \
               --no-autocommit \
               --result-file=$OUTFILE \
               $DATABASE
      fetchrc

      # $myrc is last returncode - set in fetchrc
      if [ $myrc -eq 0 ]; then
        echo -n "gzip ... "
        compress_file $OUTFILE
      else
        echo "ERROR occured - no gzip"
      fi
      ls -l $OUTFILE*
    fi
    echo
  done

}

# restore database dump file into database
# param  string  database dump file (gzipped)
# param  string  optional: database to import; default: database is parsed from file
function restoreByFile(){
  sMyfile=$1
  sMyDb=$2

  if [ -z $sMyDb ]; then
    h2 "analyze dump $sMyfile"
    sMyDb=`guessDB $sMyfile`
    echo "detected db schema from file: [${sMyDb}]"
  else
    echo "db schema from param 2: [${sMyDb}]"
  fi

  echo

  echo import to $sMyDb...

  h2 ensure that database exists ...
  color cmd
  echo "CREATE DATABASE IF NOT EXISTS ${sMyDb};" | mysql
  color reset

  h2 import ...
  ls -l $sMyfile
  echo import to database [${sMyDb}]
  color cmd
  zcat $sMyfile | mysql "${sMyDb}"
  fetchrc
  color reset

}

# --------------------------------------------------------------------------------
# MAIN
# --------------------------------------------------------------------------------


# ----- check requirements
j_requireBinary "mysql"             1
j_requireBinary "mysqldump"         1
j_requireProcess "mysqld|mariadb"   1

if [ ! -d $SOURCE_DIR ]; then
  echo "INFO: directory $SOURCE_DIR doees not exist."
  rc=$rc+1
fi


if [ $rc -ne 0 ]; then
  rc=0
  echo "SKIP: mysqld seems not to be here"
else
  if [ "$1" = "restore" ]; then
    echo
    shift 1
    restoreByFile $*

  else
    doMysqlBackup
  fi
fi

echo $0 $* [mysql] final returncode rc=$rc

# --------------------------------------------------------------------------------
