<?php

/**
 * WIP
 * base class for all plugin types to read available plugins
 * and its metadata
 * 
 * @example
 *        $CI_plugins=new ciplugins();
 *        print_r($CI_plugins->getPluginTypes());
 * 
 *        // $CI_plugins->setType('build');
 *        // print_r($CI_plugins->getPlugins());
 *        print_r($CI_plugins->getPlugins('build'));
 * 
 *        $CI_plugins->setPlugin('tgz', 'build');
 *
 * 
 * @author axel
 */
class ciplugins {
    
    protected $_sPlugindir=false;

    /**
     * @var string
     */
    protected $_sType=false;

    /**
     * @var string
     */
    protected $_sPluginname=false;


    protected $_sLang = "en-en";
    protected $_aLang = [];


    // ---------------------------------------------------------------
    // CONSTRUCTOR
    // ---------------------------------------------------------------

    /**
     * initialize plugins
     * @return boolean
     */
    public function __construct() {

        $this->_sPlugindir=dirname(__DIR__).'/plugins';

        return true;
    }
    
    // ---------------------------------------------------------------
    // LANGUAGE TEXTS
    // ---------------------------------------------------------------
    
    /**
     * get a translated text from lang_XX.json in plugin dir;
     * If the key is missed it returns "[KEY :: LANG]"
     * 
     * @see setLang()
     * @param string $sKey  key to find in lang file
     * @return string
     */
    protected function _t($sKey){
        return (isset($this->_aLang[$sKey]) && $this->_aLang[$sKey])
                ? $this->_aLang[$sKey]
                : "[ $sKey :: $this->_sLang ]"
        ;
    }

    /**
     * set language for output of formdata and other texts.
     * This method loads the language file into a hash. The output of 
     * translated texts can be done with $this->_t("your_key")
     * 
     * @see _t()
     * @param string   $sLang  language code, i.e. "de"
     * @return boolean
     */
    public function setLang($sLang=false){
        $this->_sLang=$sLang ? $sLang : $this->_sLang;
        
        $oReflection=new ReflectionClass($this);
        $sFile=dirname($oReflection->getFileName()) . '/lang_'.$this->_sLang.'.json';
        $this->_aLang=(file_exists($sFile)) ? json_decode(file_get_contents($sFile), 1) : $this->_aLang;
        return true;
    }
    // ---------------------------------------------------------------
    // SETTER
    // ---------------------------------------------------------------

    /**
     * set a type for plugins ... what is a name of a subdir in the plugins directory
     * @param  {string}  $sType  Name of a plugin type, e.g. build|rollout
     */
    public function setType($sType){
        if(!$sType || !is_dir($this->_sPlugindir.'/'.$sType)){
            return false;
        }
        return $this->_sType=$sType;
    }

    /**
     * set a plugin with autoload 
     * 
     * @param  {string}  $sPluginName  name of the plugin
     * @param  {string}  $sType        optuional: set a type
     * @return bool
     */
    public function setPlugin($sPluginName,$sType=false){
        if($sType){
            if (!$this->setType($sType)){
                return false;
            }
        }
        $sFile=$this->getPluginFilename($sPluginName);
        if(!file_exists($sFile)){
            return false;
        }
        include_once $sFile;
        return $this->_sPluginname=$sPluginName;
    }

    // ---------------------------------------------------------------
    // GETTER
    // ---------------------------------------------------------------


    /**
     * get a location of a plugin file with full path
     * The type must be initialized first with setType()
     * 
     * @param string  $sPluginName   optional: Name of plugin
     * @return string
     */
    public function getPluginFilename($sPluginName=false){
        if(!$sPluginName){
            $sPluginName=$this->_sPluginname;
        }
        return $this->_sPlugindir.'/'.$this->_sType.'/'.$sPluginName.'/'.$this->_sType.'_'.$sPluginName.'.php';
    }


    /**
     * get an array of available plugin types read from filesystem
     * @return array
     */
    public function getPluginTypes(){
        $aReturn=[];
        foreach(glob($this->_sPlugindir.'/*', GLOB_ONLYDIR) as $sMydir){
            $aReturn[]=basename($sMydir);
        }
        return $aReturn;
    }

    /**
     * get an array of available plugins read from filesystem
     * @return array
     */
    public function getPlugins($sType=false){
        $aReturn=[];
        if($sType){
            if (!$this->setType($sType)){
                return $aReturn;
            }
        }
        foreach(glob($this->_sPlugindir.'/'.$this->_sType.'/*', GLOB_ONLYDIR) as $sMydir){
            $aReturn[]=basename($sMydir);
        }
        return $aReturn;
    }

    /**
     * get a location of a plugin file with full path
     * @param  {bool}  $bAutoload  flag: autoload needed plugin file
     * @return string
     */
    public function getPluginClassname(){
        return $this->_sType.'_'.$this->_sPluginname;
    }

    public function initPlugin(){
        $sClassname=$this->_sType.'_'.$this->_sPlugindir;
        $TmpRolloutPlugin = new $sClassname([]);

    }

}
