<?php

/* ######################################################################

  IML DEPLOYMENT

  webgui - build a package

  ---------------------------------------------------------------------
  2014-11-14  Axel <axel.hahn@iml.unibe.ch>  selector for branches
  2014-02-14  Axel <axel.hahn@iml.unibe.ch>  build was "ajaxified"
  2013-11-08  Axel <axel.hahn@iml.unibe.ch>
  ###################################################################### */

require_once("./classes/project.class.php");


/**
 * helper: render html code for a table row
 * @global htmlguielements $oHtml
 * @param string   $sDescr  description
 * @param string   $sCode   php code
 * @return string
 */
function addHtmltestTest($sDescr, $sCode){
    $oHtml=new htmlguielements();
    $sOut='??';
    eval("\$sOut=$sCode;");
    
    return '<tr>'
    . '<td>'
            .  $sDescr
    . '</td>'
    . '<td style="padding: 0 1em;"><pre>'
            . htmlentities($sCode)
    . '</pre></td>'
    . '<td style="padding: 0 1em;">'
            .$sOut
    . '</td>'
    . '<td style="padding: 0 1em;"><pre>'
            .str_replace('&gt;', '&gt;<br>',htmlentities($sOut))
    . '</pre></td>'
    . '</tr>';
}


// ----------------------------------------------------------------------
// MAIN
// ----------------------------------------------------------------------
$oHtml=new htmlguielements();

// generate a List of al icons
$sIconlist='';
$sIconlist.='<strong>Buttons</strong><br>';
foreach ($oHtml->aCfg['buttons'] as $sLabel=>$aItems){
    $sIconlist.=$oHtml->getIcon($aItems['icon']).' - '.$sLabel.' - '.$aItems['icon'].'<br>';
}
$sIconlist.='<br><strong>Icons</strong><br>';
foreach ($oHtml->aCfg['icons'] as $sLabel=>$sIcon){
    $sIconlist.=$oHtml->getIcon($sIcon).' - '.$sLabel.': '.$sIcon.'<br>';
}

$sRows=''        
   .  addHtmltestTest("Box zeichnen - Fehler", "\$oHtml->getBox('error', 'errormessage')")
   .  addHtmltestTest("Box zeichnen - Warnung", "\$oHtml->getBox('warning', 'Message')")
   .  addHtmltestTest("Box zeichnen - Info", "\$oHtml->getBox('info', 'Message')")
   .  addHtmltestTest("Box zeichnen - OK", "\$oHtml->getBox('success', 'Message')")
        
   .  addHtmltestTest("Icon - Fontawesome", "\$oHtml->getIcon('fa-close');")
   .  addHtmltestTest("Icon - Glyphicon", "\$oHtml->getIcon('glyphicon-user');")
        
   .  '<tr>'
        . '<td>pre-defined icons</td>'
        . '<td>-</td>'
        . '<td>'.$sIconlist.'</td>'
        . '<td>-</td>'
   . '</tr>' 

   .  addHtmltestTest("Link", "\$oHtml->getLink(array(
    'href'=>'https://www.axel-hahn.de/',
    'icon'=>'fa-globe',
    'label'=>'Axels Webseite',
));")
   .  addHtmltestTest("Link als Button", "\$oHtml->getLinkButton(array(
    'href'=>'https://www.axel-hahn.de/',
    'target'=>'_blank',
    'icon'=>'fa-globe',
    'label'=>'Axels Webseite',
));")
   .  addHtmltestTest("Link als Button mit Type OK", "\$oHtml->getLinkButton(array('type'=>'ok',));")
   .  addHtmltestTest("Link als Button mit Type close", "\$oHtml->getLinkButton(array('type'=>'close',));")
   .  addHtmltestTest("Link als Button mit Type error", "\$oHtml->getLinkButton(array('type'=>'error','label'=>'Fehler'));")

   . addHtmltestTest("Tabs", "\$oHtml->getNav(
    array(
        'options' => array(
            'type'=>'tabs',
            'justified'=>1,
        ),
        'tabs' => array(
            'tab 1'=>'Inhalt #1',
            'tab 2'=>'Inhalt #2',
        ),
    )
);")
   . addHtmltestTest("Tabs", "\$oHtml->getNav(
    array(
        'options' => array(
            'type'=>'pills',
            'stacked'=>1,
        ),
        'tabs' => array(
            'tab 1'=>'Inhalt #1',
            'tab 2'=>'Inhalt #2',
        ),
    )
);")
   .  addHtmltestTest("Tabelle", "\$oHtml->getTable(
    array(
        'header'=>array('A', 'B'), 
        'body'=>array(
            array('Zelle A 1', 'Zelle B 1'),
            array('Zelle A 2', 'Zelle B 2'),
            array('Zelle A 3', 'Zelle B 3'),
        ),
));"
)
;

// ----------------------------------------------------------------------

echo '<table><thead>'
    . '<tr>'
        . '<th>Beschreibung</th>'
        . '<th>PHP-Code</th>'
        . '<th>Ausgabe</th>'
        . '<th>Ausgabe-Code</th>'
    . '</tr>'
. '</thead><tbody>'
    .$sRows
. '</tbody></table>'
;
