/**
 * vis.js
 * https://github.com/almende/vis
 *
 * A dynamic, browser-based visualization library.
 *
 * @version 4.20.1-SNAPSHOT
 * @date    2017-10-12
 *
 * @license
 * Copyright (C) 2011-2017 Almende B.V, http://almende.com
 *
 * Vis.js is dual licensed under both
 *
 * * The Apache 2.0 License
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * and
 *
 * * The MIT License
 *   http://opensource.org/licenses/MIT
 *
 * Vis.js may be distributed under either license.
 */
"use strict";!function(t,e){"object"==typeof exports&&"object"==typeof module?module.exports=e():"function"==typeof define&&define.amd?define([],e):"object"==typeof exports?exports.vis=e():t.vis=e()}(this,function(){return function(t){function e(i){if(n[i])return n[i].exports;var r=n[i]={i:i,l:!1,exports:{}};return t[i].call(r.exports,r,r.exports,e),r.l=!0,r.exports}var n={};return e.m=t,e.c=n,e.d=function(t,n,i){e.o(t,n)||Object.defineProperty(t,n,{configurable:!1,enumerable:!0,get:i})},e.n=function(t){var n=t&&t.__esModule?function(){return t.default}:function(){return t};return e.d(n,"a",n),n},e.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},e.p="",e(e.s=56)}([function(t,e){var n=t.exports={version:"2.5.1"};"number"==typeof __e&&(__e=n)},function(t,e){var n=t.exports="undefined"!=typeof window&&window.Math==Math?window:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")();"number"==typeof __g&&(__g=n)},function(t,e,n){var i=n(28)("wks"),r=n(17),o=n(1).Symbol,s="function"==typeof o;(t.exports=function(t){return i[t]||(i[t]=s&&o[t]||(s?o:r)("Symbol."+t))}).store=i},function(t,e,n){function i(t){return t&&t.__esModule?t:{default:t}}function r(t,e,n,i){var r=!1;!0===i&&(r=null===e[n]&&void 0!==t[n]),r?delete t[n]:t[n]=e[n]}var o=n(57),s=i(o),a=n(75),u=i(a),h=n(18),l=i(h),c=n(19),d=i(c),f=n(46),p=n(97);e.isNumber=function(t){return t instanceof Number||"number"==typeof t},e.recursiveDOMDelete=function(t){if(t)for(;!0===t.hasChildNodes();)e.recursiveDOMDelete(t.firstChild),t.removeChild(t.firstChild)},e.giveRange=function(t,e,n,i){if(e==t)return.5;var r=1/(e-t);return Math.max(0,(i-t)*r)},e.isString=function(t){return t instanceof String||"string"==typeof t},e.isDate=function(t){if(t instanceof Date)return!0;if(e.isString(t)){if(m.exec(t))return!0;if(!isNaN(Date.parse(t)))return!0}return!1},e.randomUUID=function(){return p.v4()},e.assignAllKeys=function(t,e){for(var n in t)t.hasOwnProperty(n)&&"object"!==(0,d.default)(t[n])&&(t[n]=e)},e.fillIfDefined=function(t,n){var i=arguments.length>2&&void 0!==arguments[2]&&arguments[2];for(var o in t)void 0!==n[o]&&(null===n[o]||"object"!==(0,d.default)(n[o])?r(t,n,o,i):"object"===(0,d.default)(t[o])&&e.fillIfDefined(t[o],n[o],i))},e.extend=function(t,e){for(var n=1;n<arguments.length;n++){var i=arguments[n];for(var r in i)i.hasOwnProperty(r)&&(t[r]=i[r])}return t},e.selectiveExtend=function(t,e,n){if(!Array.isArray(t))throw new Error("Array with property names expected as first argument");for(var i=2;i<arguments.length;i++)for(var r=arguments[i],o=0;o<t.length;o++){var s=t[o];r&&r.hasOwnProperty(s)&&(e[s]=r[s])}return e},e.selectiveDeepExtend=function(t,n,i){var o=arguments.length>3&&void 0!==arguments[3]&&arguments[3];if(Array.isArray(i))throw new TypeError("Arrays are not supported by deepExtend");for(var s=0;s<t.length;s++){var a=t[s];if(i.hasOwnProperty(a))if(i[a]&&i[a].constructor===Object)void 0===n[a]&&(n[a]={}),n[a].constructor===Object?e.deepExtend(n[a],i[a],!1,o):r(n,i,a,o);else{if(Array.isArray(i[a]))throw new TypeError("Arrays are not supported by deepExtend");r(n,i,a,o)}}return n},e.selectiveNotDeepExtend=function(t,n,i){var o=arguments.length>3&&void 0!==arguments[3]&&arguments[3];if(Array.isArray(i))throw new TypeError("Arrays are not supported by deepExtend");for(var s in i)if(i.hasOwnProperty(s)&&-1===t.indexOf(s))if(i[s]&&i[s].constructor===Object)void 0===n[s]&&(n[s]={}),n[s].constructor===Object?e.deepExtend(n[s],i[s]):r(n,i,s,o);else if(Array.isArray(i[s])){n[s]=[];for(var a=0;a<i[s].length;a++)n[s].push(i[s][a])}else r(n,i,s,o);return n},e.deepExtend=function(t,n){var i=arguments.length>2&&void 0!==arguments[2]&&arguments[2],o=arguments.length>3&&void 0!==arguments[3]&&arguments[3];for(var s in n)if(n.hasOwnProperty(s)||!0===i)if(n[s]&&n[s].constructor===Object)void 0===t[s]&&(t[s]={}),t[s].constructor===Object?e.deepExtend(t[s],n[s],i):r(t,n,s,o);else if(Array.isArray(n[s])){t[s]=[];for(var a=0;a<n[s].length;a++)t[s].push(n[s][a])}else r(t,n,s,o);return t},e.equalArray=function(t,e){if(t.length!=e.length)return!1;for(var n=0,i=t.length;n<i;n++)if(t[n]!=e[n])return!1;return!0},e.convert=function(t,n){var i;if(void 0!==t){if(null===t)return null;if(!n)return t;if("string"!=typeof n&&!(n instanceof String))throw new Error("Type must be a string");switch(n){case"boolean":case"Boolean":return Boolean(t);case"number":case"Number":return e.isString(t)&&!isNaN(Date.parse(t))?f(t).valueOf():Number(t.valueOf());case"string":case"String":return String(t);case"Date":if(e.isNumber(t))return new Date(t);if(t instanceof Date)return new Date(t.valueOf());if(f.isMoment(t))return new Date(t.valueOf());if(e.isString(t))return i=m.exec(t),i?new Date(Number(i[1])):f(new Date(t)).toDate();throw new Error("Cannot convert object of type "+e.getType(t)+" to type Date");case"Moment":if(e.isNumber(t))return f(t);if(t instanceof Date)return f(t.valueOf());if(f.isMoment(t))return f(t);if(e.isString(t))return i=m.exec(t),f(i?Number(i[1]):t);throw new Error("Cannot convert object of type "+e.getType(t)+" to type Date");case"ISODate":if(e.isNumber(t))return new Date(t);if(t instanceof Date)return t.toISOString();if(f.isMoment(t))return t.toDate().toISOString();if(e.isString(t))return i=m.exec(t),i?new Date(Number(i[1])).toISOString():f(t).format();throw new Error("Cannot convert object of type "+e.getType(t)+" to type ISODate");case"ASPDate":if(e.isNumber(t))return"/Date("+t+")/";if(t instanceof Date)return"/Date("+t.valueOf()+")/";if(e.isString(t)){i=m.exec(t);return"/Date("+(i?new Date(Number(i[1])).valueOf():new Date(t).valueOf())+")/"}throw new Error("Cannot convert object of type "+e.getType(t)+" to type ASPDate");default:throw new Error('Unknown type "'+n+'"')}}};var m=/^\/?Date\((\-?\d+)/i;e.getType=function(t){var e=void 0===t?"undefined":(0,d.default)(t);return"object"==e?null===t?"null":t instanceof Boolean?"Boolean":t instanceof Number?"Number":t instanceof String?"String":Array.isArray(t)?"Array":t instanceof Date?"Date":"Object":"number"==e?"Number":"boolean"==e?"Boolean":"string"==e?"String":void 0===e?"undefined":e},e.copyAndExtendArray=function(t,e){for(var n=[],i=0;i<t.length;i++)n.push(t[i]);return n.push(e),n},e.copyArray=function(t){for(var e=[],n=0;n<t.length;n++)e.push(t[n]);return e},e.getAbsoluteLeft=function(t){return t.getBoundingClientRect().left},e.getAbsoluteRight=function(t){return t.getBoundingClientRect().right},e.getAbsoluteTop=function(t){return t.getBoundingClientRect().top},e.addClassName=function(t,e){var n=t.className.split(" "),i=e.split(" ");n=n.concat(i.filter(function(t){return n.indexOf(t)<0})),t.className=n.join(" ")},e.removeClassName=function(t,e){var n=t.className.split(" "),i=e.split(" ");n=n.filter(function(t){return i.indexOf(t)<0}),t.className=n.join(" ")},e.forEach=function(t,e){var n,i;if(Array.isArray(t))for(n=0,i=t.length;n<i;n++)e(t[n],n,t);else for(n in t)t.hasOwnProperty(n)&&e(t[n],n,t)},e.toArray=function(t){var e=[];for(var n in t)t.hasOwnProperty(n)&&e.push(t[n]);return e},e.updateProperty=function(t,e,n){return t[e]!==n&&(t[e]=n,!0)},e.throttle=function(t){var e=!1;return function(){e||(e=!0,requestAnimationFrame(function(){e=!1,t()}))}},e.addEventListener=function(t,e,n,i){t.addEventListener?(void 0===i&&(i=!1),"mousewheel"===e&&navigator.userAgent.indexOf("Firefox")>=0&&(e="DOMMouseScroll"),t.addEventListener(e,n,i)):t.attachEvent("on"+e,n)},e.removeEventListener=function(t,e,n,i){t.removeEventListener?(void 0===i&&(i=!1),"mousewheel"===e&&navigator.userAgent.indexOf("Firefox")>=0&&(e="DOMMouseScroll"),t.removeEventListener(e,n,i)):t.detachEvent("on"+e,n)},e.preventDefault=function(t){t||(t=window.event),t.preventDefault?t.preventDefault():t.returnValue=!1},e.getTarget=function(t){t||(t=window.event);var e;return t.target?e=t.target:t.srcElement&&(e=t.srcElement),void 0!=e.nodeType&&3==e.nodeType&&(e=e.parentNode),e},e.hasParent=function(t,e){for(var n=t;n;){if(n===e)return!0;n=n.parentNode}return!1},e.option={},e.option.asBoolean=function(t,e){return"function"==typeof t&&(t=t()),null!=t?0!=t:e||null},e.option.asNumber=function(t,e){return"function"==typeof t&&(t=t()),null!=t?Number(t)||e||null:e||null},e.option.asString=function(t,e){return"function"==typeof t&&(t=t()),null!=t?String(t):e||null},e.option.asSize=function(t,n){return"function"==typeof t&&(t=t()),e.isString(t)?t:e.isNumber(t)?t+"px":n||null},e.option.asElement=function(t,e){return"function"==typeof t&&(t=t()),t||e||null},e.hexToRGB=function(t){var e=/^#?([a-f\d])([a-f\d])([a-f\d])$/i;t=t.replace(e,function(t,e,n,i){return e+e+n+n+i+i});var n=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(t);return n?{r:parseInt(n[1],16),g:parseInt(n[2],16),b:parseInt(n[3],16)}:null},e.overrideOpacity=function(t,n){var i;return-1!=t.indexOf("rgba")?t:-1!=t.indexOf("rgb")?(i=t.substr(t.indexOf("(")+1).replace(")","").split(","),"rgba("+i[0]+","+i[1]+","+i[2]+","+n+")"):(i=e.hexToRGB(t),null==i?t:"rgba("+i.r+","+i.g+","+i.b+","+n+")")},e.RGBToHex=function(t,e,n){return"#"+((1<<24)+(t<<16)+(e<<8)+n).toString(16).slice(1)},e.parseColor=function(t){var n;if(!0===e.isString(t)){if(!0===e.isValidRGB(t)){var i=t.substr(4).substr(0,t.length-5).split(",").map(function(t){return parseInt(t)});t=e.RGBToHex(i[0],i[1],i[2])}if(!0===e.isValidHex(t)){var r=e.hexToHSV(t),o={h:r.h,s:.8*r.s,v:Math.min(1,1.02*r.v)},s={h:r.h,s:Math.min(1,1.25*r.s),v:.8*r.v},a=e.HSVToHex(s.h,s.s,s.v),u=e.HSVToHex(o.h,o.s,o.v);n={background:t,border:a,highlight:{background:u,border:a},hover:{background:u,border:a}}}else n={background:t,border:t,highlight:{background:t,border:t},hover:{background:t,border:t}}}else n={},n.background=t.background||void 0,n.border=t.border||void 0,e.isString(t.highlight)?n.highlight={border:t.highlight,background:t.highlight}:(n.highlight={},n.highlight.background=t.highlight&&t.highlight.background||void 0,n.highlight.border=t.highlight&&t.highlight.border||void 0),e.isString(t.hover)?n.hover={border:t.hover,background:t.hover}:(n.hover={},n.hover.background=t.hover&&t.hover.background||void 0,n.hover.border=t.hover&&t.hover.border||void 0);return n},e.RGBToHSV=function(t,e,n){t/=255,e/=255,n/=255;var i=Math.min(t,Math.min(e,n)),r=Math.max(t,Math.max(e,n));if(i==r)return{h:0,s:0,v:i};var o=t==i?e-n:n==i?t-e:n-t;return{h:60*((t==i?3:n==i?1:5)-o/(r-i))/360,s:(r-i)/r,v:r}};var v={split:function(t){var e={};return t.split(";").forEach(function(t){if(""!=t.trim()){var n=t.split(":"),i=n[0].trim(),r=n[1].trim();e[i]=r}}),e},join:function(t){return(0,l.default)(t).map(function(e){return e+": "+t[e]}).join("; ")}};e.addCssText=function(t,n){var i=v.split(t.style.cssText),r=v.split(n),o=e.extend(i,r);t.style.cssText=v.join(o)},e.removeCssText=function(t,e){var n=v.split(t.style.cssText),i=v.split(e);for(var r in i)i.hasOwnProperty(r)&&delete n[r];t.style.cssText=v.join(n)},e.HSVToRGB=function(t,e,n){var i,r,o,s=Math.floor(6*t),a=6*t-s,u=n*(1-e),h=n*(1-a*e),l=n*(1-(1-a)*e);switch(s%6){case 0:i=n,r=l,o=u;break;case 1:i=h,r=n,o=u;break;case 2:i=u,r=n,o=l;break;case 3:i=u,r=h,o=n;break;case 4:i=l,r=u,o=n;break;case 5:i=n,r=u,o=h}return{r:Math.floor(255*i),g:Math.floor(255*r),b:Math.floor(255*o)}},e.HSVToHex=function(t,n,i){var r=e.HSVToRGB(t,n,i);return e.RGBToHex(r.r,r.g,r.b)},e.hexToHSV=function(t){var n=e.hexToRGB(t);return e.RGBToHSV(n.r,n.g,n.b)},e.isValidHex=function(t){return/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(t)},e.isValidRGB=function(t){return t=t.replace(" ",""),/rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/i.test(t)},e.isValidRGBA=function(t){return t=t.replace(" ",""),/rgba\((\d{1,3}),(\d{1,3}),(\d{1,3}),(.{1,3})\)/i.test(t)},e.selectiveBridgeObject=function(t,n){if(null!==n&&"object"===(void 0===n?"undefined":(0,d.default)(n))){for(var i=(0,u.default)(n),r=0;r<t.length;r++)n.hasOwnProperty(t[r])&&"object"==(0,d.default)(n[t[r]])&&(i[t[r]]=e.bridgeObject(n[t[r]]));return i}return null},e.bridgeObject=function(t){if(null!==t&&"object"===(void 0===t?"undefined":(0,d.default)(t))){var n=(0,u.default)(t);if(t instanceof Element)n=t;else{n=(0,u.default)(t);for(var i in t)t.hasOwnProperty(i)&&"object"==(0,d.default)(t[i])&&(n[i]=e.bridgeObject(t[i]))}return n}return null},e.insertSort=function(t,e){for(var n=0;n<t.length;n++){for(var i=t[n],r=n;r>0&&e(i,t[r-1])<0;r--)t[r]=t[r-1];t[r]=i}return t},e.mergeOptions=function(t,e,n){var i=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{},r=function(t){return null!==t&&void 0!==t},o=function(t){return null!==t&&"object"===(void 0===t?"undefined":(0,d.default)(t))};if(!o(t))throw new Error("Parameter mergeTarget must be an object");if(!o(e))throw new Error("Parameter options must be an object");if(!r(n))throw new Error("Parameter option must have a value");if(!o(i))throw new Error("Parameter globalOptions must be an object");var s=e[n],a=o(i)&&!function(t){for(var e in t)if(t.hasOwnProperty(e))return!1;return!0}(i),h=a?i[n]:void 0,l=h?h.enabled:void 0;if(void 0!==s){if("boolean"==typeof s)return o(t[n])||(t[n]={}),void(t[n].enabled=s);if(null===s&&!o(t[n])){if(!r(h))return;t[n]=(0,u.default)(h)}if(o(s)){var c=!0;void 0!==s.enabled?c=s.enabled:void 0!==l&&(c=h.enabled),function(t,e,n){o(t[n])||(t[n]={});var i=e[n],r=t[n];for(var s in i)i.hasOwnProperty(s)&&(r[s]=i[s])}(t,e,n),t[n].enabled=c}}},e.binarySearchCustom=function(t,e,n,i){for(var r=0,o=0,s=t.length-1;o<=s&&r<1e4;){var a=Math.floor((o+s)/2),u=t[a],h=void 0===i?u[n]:u[n][i],l=e(h);if(0==l)return a;-1==l?o=a+1:s=a-1,r++}return-1},e.binarySearchValue=function(t,e,n,i,r){var o,s,a,u,h=0,l=0,c=t.length-1;for(r=void 0!=r?r:function(t,e){return t==e?0:t<e?-1:1};l<=c&&h<1e4;){if(u=Math.floor(.5*(c+l)),o=t[Math.max(0,u-1)][n],s=t[u][n],a=t[Math.min(t.length-1,u+1)][n],0==r(s,e))return u;if(r(o,e)<0&&r(s,e)>0)return"before"==i?Math.max(0,u-1):u;if(r(s,e)<0&&r(a,e)>0)return"before"==i?u:Math.min(t.length-1,u+1);r(s,e)<0?l=u+1:c=u-1,h++}return-1},e.easingFunctions={linear:function(t){return t},easeInQuad:function(t){return t*t},easeOutQuad:function(t){return t*(2-t)},easeInOutQuad:function(t){return t<.5?2*t*t:(4-2*t)*t-1},easeInCubic:function(t){return t*t*t},easeOutCubic:function(t){return--t*t*t+1},easeInOutCubic:function(t){return t<.5?4*t*t*t:(t-1)*(2*t-2)*(2*t-2)+1},easeInQuart:function(t){return t*t*t*t},easeOutQuart:function(t){return 1- --t*t*t*t},easeInOutQuart:function(t){return t<.5?8*t*t*t*t:1-8*--t*t*t*t},easeInQuint:function(t){return t*t*t*t*t},easeOutQuint:function(t){return 1+--t*t*t*t*t},easeInOutQuint:function(t){return t<.5?16*t*t*t*t*t:1+16*--t*t*t*t*t}},e.getScrollBarWidth=function(){var t=document.createElement("p");t.style.width="100%",t.style.height="200px";var e=document.createElement("div");e.style.position="absolute",e.style.top="0px",e.style.left="0px",e.style.visibility="hidden",e.style.width="200px",e.style.height="150px",e.style.overflow="hidden",e.appendChild(t),document.body.appendChild(e);var n=t.offsetWidth;e.style.overflow="scroll";var i=t.offsetWidth;return n==i&&(i=e.clientWidth),document.body.removeChild(e),n-i},e.topMost=function(t,e){var n=void 0;Array.isArray(e)||(e=[e]);var i=!0,r=!1,o=void 0;try{for(var a,u=(0,s.default)(t);!(i=(a=u.next()).done);i=!0){var h=a.value;if(h){n=h[e[0]];for(var l=1;l<e.length;l++)n&&(n=n[e[l]]);if(void 0!==n)break}}}catch(t){r=!0,o=t}finally{try{!i&&u.return&&u.return()}finally{if(r)throw o}}return n}},function(t,e,n){var i=n(1),r=n(0),o=n(62),s=n(9),a=function(t,e,n){var u,h,l,c=t&a.F,d=t&a.G,f=t&a.S,p=t&a.P,m=t&a.B,v=t&a.W,y=d?r:r[e]||(r[e]={}),g=y.prototype,_=d?i:f?i[e]:(i[e]||{}).prototype;d&&(n=e);for(u in n)(h=!c&&_&&void 0!==_[u])&&u in y||(l=h?_[u]:n[u],y[u]=d&&"function"!=typeof _[u]?n[u]:m&&h?o(l,i):v&&_[u]==l?function(t){var e=function(e,n,i){if(this instanceof t){switch(arguments.length){case 0:return new t;case 1:return new t(e);case 2:return new t(e,n)}return new t(e,n,i)}return t.apply(this,arguments)};return e.prototype=t.prototype,e}(l):p&&"function"==typeof l?o(Function.call,l):l,p&&((y.virtual||(y.virtual={}))[u]=l,t&a.R&&g&&!g[u]&&s(g,u,l)))};a.F=1,a.G=2,a.S=4,a.P=8,a.B=16,a.W=32,a.U=64,a.R=128,t.exports=a},function(t,e,n){var i=n(11),r=n(40),o=n(24),s=Object.defineProperty;e.f=n(6)?Object.defineProperty:function(t,e,n){if(i(t),e=o(e,!0),i(n),r)try{return s(t,e,n)}catch(t){}if("get"in n||"set"in n)throw TypeError("Accessors not supported!");return"value"in n&&(t[e]=n.value),t}},function(t,e,n){t.exports=!n(10)(function(){return 7!=Object.defineProperty({},"a",{get:function(){return 7}}).a})},function(t,e){var n={}.hasOwnProperty;t.exports=function(t,e){return n.call(t,e)}},function(t,e,n){var i=n(38),r=n(22);t.exports=function(t){return i(r(t))}},function(t,e,n){var i=n(5),r=n(16);t.exports=n(6)?function(t,e,n){return i.f(t,e,r(1,n))}:function(t,e,n){return t[e]=n,t}},function(t,e){t.exports=function(t){try{return!!t()}catch(t){return!0}}},function(t,e,n){var i=n(15);t.exports=function(t){if(!i(t))throw TypeError(t+" is not an object!");return t}},function(t,e,n){var i=n(43),r=n(29);t.exports=Object.keys||function(t){return i(t,r)}},function(t,e,n){function i(t,e,n){this.x=void 0!==t?t:0,this.y=void 0!==e?e:0,this.z=void 0!==n?n:0}i.subtract=function(t,e){var n=new i;return n.x=t.x-e.x,n.y=t.y-e.y,n.z=t.z-e.z,n},i.add=function(t,e){var n=new i;return n.x=t.x+e.x,n.y=t.y+e.y,n.z=t.z+e.z,n},i.avg=function(t,e){return new i((t.x+e.x)/2,(t.y+e.y)/2,(t.z+e.z)/2)},i.crossProduct=function(t,e){var n=new i;return n.x=t.y*e.z-t.z*e.y,n.y=t.z*e.x-t.x*e.z,n.z=t.x*e.y-t.y*e.x,n},i.prototype.length=function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z)},t.exports=i},function(t,e){t.exports={}},function(t,e){t.exports=function(t){return"object"==typeof t?null!==t:"function"==typeof t}},function(t,e){t.exports=function(t,e){return{enumerable:!(1&t),configurable:!(2&t),writable:!(4&t),value:e}}},function(t,e){var n=0,i=Math.random();t.exports=function(t){return"Symbol(".concat(void 0===t?"":t,")_",(++n+i).toString(36))}},function(t,e,n){t.exports={default:n(78),__esModule:!0}},function(t,e,n){function i(t){return t&&t.__esModule?t:{default:t}}e.__esModule=!0;var r=n(81),o=i(r),s=n(83),a=i(s),u="function"==typeof a.default&&"symbol"==typeof o.default?function(t){return typeof t}:function(t){return t&&"function"==typeof a.default&&t.constructor===a.default&&t!==a.default.prototype?"symbol":typeof t};e.default="function"==typeof a.default&&"symbol"===u(o.default)?function(t){return void 0===t?"undefined":u(t)}:function(t){return t&&"function"==typeof a.default&&t.constructor===a.default&&t!==a.default.prototype?"symbol":void 0===t?"undefined":u(t)}},function(t,e){e.f={}.propertyIsEnumerable},function(t,e){var n={}.toString;t.exports=function(t){return n.call(t).slice(8,-1)}},function(t,e){t.exports=function(t){if(void 0==t)throw TypeError("Can't call method on  "+t);return t}},function(t,e){t.exports=!0},function(t,e,n){var i=n(15);t.exports=function(t,e){if(!i(t))return t;var n,r;if(e&&"function"==typeof(n=t.toString)&&!i(r=n.call(t)))return r;if("function"==typeof(n=t.valueOf)&&!i(r=n.call(t)))return r;if(!e&&"function"==typeof(n=t.toString)&&!i(r=n.call(t)))return r;throw TypeError("Can't convert object to primitive value")}},function(t,e,n){var i=n(11),r=n(65),o=n(29),s=n(27)("IE_PROTO"),a=function(){},u=function(){var t,e=n(41)("iframe"),i=o.length;for(e.style.display="none",n(69).appendChild(e),e.src="javascript:",t=e.contentWindow.document,t.open(),t.write("<script>document.F=Object<\/script>"),t.close(),u=t.F;i--;)delete u.prototype[o[i]];return u()};t.exports=Object.create||function(t,e){var n;return null!==t?(a.prototype=i(t),n=new a,a.prototype=null,n[s]=t):n=u(),void 0===e?n:r(n,e)}},function(t,e){var n=Math.ceil,i=Math.floor;t.exports=function(t){return isNaN(t=+t)?0:(t>0?i:n)(t)}},function(t,e,n){var i=n(28)("keys"),r=n(17);t.exports=function(t){return i[t]||(i[t]=r(t))}},function(t,e,n){var i=n(1),r=i["__core-js_shared__"]||(i["__core-js_shared__"]={});t.exports=function(t){return r[t]||(r[t]={})}},function(t,e){t.exports="constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf".split(",")},function(t,e,n){var i=n(5).f,r=n(7),o=n(2)("toStringTag");t.exports=function(t,e,n){t&&!r(t=n?t:t.prototype,o)&&i(t,o,{configurable:!0,value:e})}},function(t,e,n){var i=n(22);t.exports=function(t){return Object(i(t))}},function(t,e,n){e.f=n(2)},function(t,e,n){var i=n(1),r=n(0),o=n(23),s=n(32),a=n(5).f;t.exports=function(t){var e=r.Symbol||(r.Symbol=o?{}:i.Symbol||{});"_"==t.charAt(0)||t in e||a(e,t,{value:s.f(t)})}},function(t,e){e.f=Object.getOwnPropertySymbols},function(t,e,n){function i(t){return t&&t.__esModule?t:{default:t}}function r(t,e){if(t&&!Array.isArray(t)&&(e=t,t=null),this._options=e||{},this._data={},this.length=0,this._fieldId=this._options.fieldId||"id",this._type={},this._options.type)for(var n=(0,l.default)(this._options.type),i=0,r=n.length;i<r;i++){var o=n[i],s=this._options.type[o];this._type[o]="Date"==s||"ISODate"==s||"ASPDate"==s?"Date":s}this._subscribers={},t&&this.add(t),this.setOptions(e)}var o=n(47),s=i(o),a=n(19),u=i(a),h=n(18),l=i(h),c=n(3),d=n(48);r.prototype.setOptions=function(t){t&&void 0!==t.queue&&(!1===t.queue?this._queue&&(this._queue.destroy(),delete this._queue):(this._queue||(this._queue=d.extend(this,{replace:["add","update","remove"]})),"object"===(0,u.default)(t.queue)&&this._queue.setOptions(t.queue)))},r.prototype.on=function(t,e){var n=this._subscribers[t];n||(n=[],this._subscribers[t]=n),n.push({callback:e})},r.prototype.off=function(t,e){var n=this._subscribers[t];n&&(this._subscribers[t]=n.filter(function(t){return t.callback!=e}))},r.prototype._trigger=function(t,e,n){if("*"==t)throw new Error("Cannot trigger event *");var i=[];t in this._subscribers&&(i=i.concat(this._subscribers[t])),"*"in this._subscribers&&(i=i.concat(this._subscribers["*"]));for(var r=0,o=i.length;r<o;r++){var s=i[r];s.callback&&s.callback(t,e,n||null)}},r.prototype.add=function(t,e){var n,i=[],r=this;if(Array.isArray(t))for(var o=0,s=t.length;o<s;o++)n=r._addItem(t[o]),i.push(n);else{if(!t||"object"!==(void 0===t?"undefined":(0,u.default)(t)))throw new Error("Unknown dataType");n=r._addItem(t),i.push(n)}return i.length&&this._trigger("add",{items:i},e),i},r.prototype.update=function(t,e){var n=[],i=[],r=[],o=[],s=this,a=s._fieldId,h=function(t){var e=t[a];if(s._data[e]){var u=c.extend({},s._data[e]);e=s._updateItem(t),i.push(e),o.push(t),r.push(u)}else e=s._addItem(t),n.push(e)};if(Array.isArray(t))for(var l=0,d=t.length;l<d;l++)t[l]&&"object"===(0,u.default)(t[l])?h(t[l]):console.warn("Ignoring input item, which is not an object at index "+l);else{if(!t||"object"!==(void 0===t?"undefined":(0,u.default)(t)))throw new Error("Unknown dataType");h(t)}if(n.length&&this._trigger("add",{items:n},e),i.length){var f={items:i,oldData:r,data:o};this._trigger("update",f,e)}return n.concat(i)},r.prototype.get=function(t){var e,n,i,r=this,o=c.getType(arguments[0]);"String"==o||"Number"==o?(e=arguments[0],i=arguments[1]):"Array"==o?(n=arguments[0],i=arguments[1]):i=arguments[0];var s;if(i&&i.returnType){s=-1==["Array","Object"].indexOf(i.returnType)?"Array":i.returnType}else s="Array";var a,u,h,d,f,p=i&&i.type||this._options.type,m=i&&i.filter,v=[];if(void 0!=e)(a=r._getItem(e,p))&&m&&!m(a)&&(a=null);else if(void 0!=n)for(d=0,f=n.length;d<f;d++)a=r._getItem(n[d],p),m&&!m(a)||v.push(a);else for(u=(0,l.default)(this._data),d=0,f=u.length;d<f;d++)h=u[d],a=r._getItem(h,p),m&&!m(a)||v.push(a);if(i&&i.order&&void 0==e&&this._sort(v,i.order),i&&i.fields){var y=i.fields;if(void 0!=e)a=this._filterFields(a,y);else for(d=0,f=v.length;d<f;d++)v[d]=this._filterFields(v[d],y)}if("Object"==s){var g,_={};for(d=0,f=v.length;d<f;d++)g=v[d],_[g.id]=g;return _}return void 0!=e?a:v},r.prototype.getIds=function(t){var e,n,i,r,o,s=this._data,a=t&&t.filter,u=t&&t.order,h=t&&t.type||this._options.type,c=(0,l.default)(s),d=[];if(a)if(u){for(o=[],e=0,n=c.length;e<n;e++)i=c[e],r=this._getItem(i,h),a(r)&&o.push(r);for(this._sort(o,u),e=0,n=o.length;e<n;e++)d.push(o[e][this._fieldId])}else for(e=0,n=c.length;e<n;e++)i=c[e],r=this._getItem(i,h),a(r)&&d.push(r[this._fieldId]);else if(u){for(o=[],e=0,n=c.length;e<n;e++)i=c[e],o.push(s[i]);for(this._sort(o,u),e=0,n=o.length;e<n;e++)d.push(o[e][this._fieldId])}else for(e=0,n=c.length;e<n;e++)i=c[e],r=s[i],d.push(r[this._fieldId]);return d},r.prototype.getDataSet=function(){return this},r.prototype.forEach=function(t,e){var n,i,r,o,s=e&&e.filter,a=e&&e.type||this._options.type,u=this._data,h=(0,l.default)(u);if(e&&e.order){var c=this.get(e);for(n=0,i=c.length;n<i;n++)r=c[n],o=r[this._fieldId],t(r,o)}else for(n=0,i=h.length;n<i;n++)o=h[n],r=this._getItem(o,a),s&&!s(r)||t(r,o)},r.prototype.map=function(t,e){var n,i,r,o,s=e&&e.filter,a=e&&e.type||this._options.type,u=[],h=this._data,c=(0,l.default)(h);for(n=0,i=c.length;n<i;n++)r=c[n],o=this._getItem(r,a),s&&!s(o)||u.push(t(o,r));return e&&e.order&&this._sort(u,e.order),u},r.prototype._filterFields=function(t,e){if(!t)return t;var n,i,r={},o=(0,l.default)(t),s=o.length;if(Array.isArray(e))for(n=0;n<s;n++)i=o[n],-1!=e.indexOf(i)&&(r[i]=t[i]);else for(n=0;n<s;n++)i=o[n],e.hasOwnProperty(i)&&(r[e[i]]=t[i]);return r},r.prototype._sort=function(t,e){if(c.isString(e)){var n=e;t.sort(function(t,e){var i=t[n],r=e[n];return i>r?1:i<r?-1:0})}else{if("function"!=typeof e)throw new TypeError("Order must be a function or a string");t.sort(e)}},r.prototype.remove=function(t,e){var n,i,r,o,s=[],a=[],u=[];for(u=Array.isArray(t)?t:[t],n=0,i=u.length;n<i;n++)(o=this._remove(u[n]))&&void 0!=(r=o[this._fieldId])&&(s.push(r),a.push(o));return s.length&&this._trigger("remove",{items:s,oldData:a},e),s},r.prototype._remove=function(t){var e,n;return c.isNumber(t)||c.isString(t)?n=t:t&&"object"===(void 0===t?"undefined":(0,u.default)(t))&&(n=t[this._fieldId]),void 0!==n&&this._data[n]?(e=this._data[n],delete this._data[n],this.length--,e):null},r.prototype.clear=function(t){var e,n,i=(0,l.default)(this._data),r=[];for(e=0,n=i.length;e<n;e++)r.push(this._data[i[e]]);return this._data={},this.length=0,this._trigger("remove",{items:i,oldData:r},t),i},r.prototype.max=function(t){var e,n,i=this._data,r=(0,l.default)(i),o=null,s=null;for(e=0,n=r.length;e<n;e++){var a=r[e],u=i[a],h=u[t];null!=h&&(!o||h>s)&&(o=u,s=h)}return o},r.prototype.min=function(t){var e,n,i=this._data,r=(0,l.default)(i),o=null,s=null;for(e=0,n=r.length;e<n;e++){var a=r[e],u=i[a],h=u[t];null!=h&&(!o||h<s)&&(o=u,s=h)}return o},r.prototype.distinct=function(t){var e,n,i,r=this._data,o=(0,l.default)(r),s=[],a=this._options.type&&this._options.type[t]||null,u=0;for(e=0,i=o.length;e<i;e++){var h=o[e],d=r[h],f=d[t],p=!1;for(n=0;n<u;n++)if(s[n]==f){p=!0;break}p||void 0===f||(s[u]=f,u++)}if(a)for(e=0,i=s.length;e<i;e++)s[e]=c.convert(s[e],a);return s},r.prototype._addItem=function(t){var e=t[this._fieldId];if(void 0!=e){if(this._data[e])throw new Error("Cannot add item: item with id "+e+" already exists")}else e=c.randomUUID(),t[this._fieldId]=e;var n,i,r={},o=(0,l.default)(t);for(n=0,i=o.length;n<i;n++){var s=o[n],a=this._type[s];r[s]=c.convert(t[s],a)}return this._data[e]=r,this.length++,e},r.prototype._getItem=function(t,e){var n,i,r,o,s=this._data[t];if(!s)return null;var a={},u=(0,l.default)(s);if(e)for(r=0,o=u.length;r<o;r++)n=u[r],i=s[n],a[n]=c.convert(i,e[n]);else for(r=0,o=u.length;r<o;r++)n=u[r],i=s[n],a[n]=i;return a[this._fieldId]||(a[this._fieldId]=s.id),a},r.prototype._updateItem=function(t){var e=t[this._fieldId];if(void 0==e)throw new Error("Cannot update item: item has no id (item: "+(0,s.default)(t)+")");var n=this._data[e];if(!n)throw new Error("Cannot update item: no item with id "+e+" found");for(var i=(0,l.default)(t),r=0,o=i.length;r<o;r++){var a=i[r],u=this._type[a];n[a]=c.convert(t[a],u)}return e},t.exports=r},function(t,e,n){function i(t,e){this._data=null,this._ids={},this.length=0,this._options=e||{},this._fieldId="id",this._subscribers={};var n=this;this.listener=function(){n._onEvent.apply(n,arguments)},this.setData(t)}var r=n(18),o=function(t){return t&&t.__esModule?t:{default:t}}(r),s=n(3),a=n(35);i.prototype.setData=function(t){var e,n,i,r,o;if(this._data){for(this._data.off&&this._data.off("*",this.listener),e=this._data.getIds({filter:this._options&&this._options.filter}),o=[],i=0,r=e.length;i<r;i++)o.push(this._data._data[e[i]]);this._ids={},this.length=0,this._trigger("remove",{items:e,oldData:o})}if(this._data=t,this._data){for(this._fieldId=this._options.fieldId||this._data&&this._data.options&&this._data.options.fieldId||"id",e=this._data.getIds({filter:this._options&&this._options.filter}),i=0,r=e.length;i<r;i++)n=e[i],this._ids[n]=!0;this.length=e.length,this._trigger("add",{items:e}),this._data.on&&this._data.on("*",this.listener)}},i.prototype.refresh=function(){var t,e,n,i=this._data.getIds({filter:this._options&&this._options.filter}),r=(0,o.default)(this._ids),s={},a=[],u=[],h=[];for(e=0,n=i.length;e<n;e++)t=i[e],s[t]=!0,this._ids[t]||(a.push(t),this._ids[t]=!0);for(e=0,n=r.length;e<n;e++)t=r[e],s[t]||(u.push(t),h.push(this._data._data[t]),delete this._ids[t]);this.length+=a.length-u.length,a.length&&this._trigger("add",{items:a}),u.length&&this._trigger("remove",{items:u,oldData:h})},i.prototype.get=function(t){var e,n,i,r=this,o=s.getType(arguments[0]);"String"==o||"Number"==o||"Array"==o?(e=arguments[0],n=arguments[1],i=arguments[2]):(n=arguments[0],i=arguments[1]);var a=s.extend({},this._options,n);this._options.filter&&n&&n.filter&&(a.filter=function(t){return r._options.filter(t)&&n.filter(t)});var u=[];return void 0!=e&&u.push(e),u.push(a),u.push(i),this._data&&this._data.get.apply(this._data,u)},i.prototype.getIds=function(t){var e;if(this._data){var n,i=this._options.filter;n=t&&t.filter?i?function(e){return i(e)&&t.filter(e)}:t.filter:i,e=this._data.getIds({filter:n,order:t&&t.order})}else e=[];return e},i.prototype.map=function(t,e){var n=[];if(this._data){var i,r=this._options.filter;i=e&&e.filter?r?function(t){return r(t)&&e.filter(t)}:e.filter:r,n=this._data.map(t,{filter:i,order:e&&e.order})}else n=[];return n},i.prototype.getDataSet=function(){for(var t=this;t instanceof i;)t=t._data;return t||null},i.prototype._onEvent=function(t,e,n){var i,r,o,s,a=e&&e.items,u=[],h=[],l=[],c=[],d=[],f=[];if(a&&this._data){switch(t){case"add":for(i=0,r=a.length;i<r;i++)o=a[i],(s=this.get(o))&&(this._ids[o]=!0,u.push(o));break;case"update":for(i=0,r=a.length;i<r;i++)o=a[i],s=this.get(o),s?this._ids[o]?(h.push(o),d.push(e.data[i]),c.push(e.oldData[i])):(this._ids[o]=!0,u.push(o)):this._ids[o]&&(delete this._ids[o],l.push(o),f.push(e.oldData[i]));break;case"remove":for(i=0,r=a.length;i<r;i++)o=a[i],this._ids[o]&&(delete this._ids[o],l.push(o),f.push(e.oldData[i]))}this.length+=u.length-l.length,u.length&&this._trigger("add",{items:u},n),h.length&&this._trigger("update",{items:h,oldData:c,data:d},n),l.length&&this._trigger("remove",{items:l,oldData:f},n)}},i.prototype.on=a.prototype.on,i.prototype.off=a.prototype.off,i.prototype._trigger=a.prototype._trigger,i.prototype.subscribe=i.prototype.on,i.prototype.unsubscribe=i.prototype.off,t.exports=i},function(t,e,n){n(59);for(var i=n(1),r=n(9),o=n(14),s=n(2)("toStringTag"),a="CSSRuleList,CSSStyleDeclaration,CSSValueList,ClientRectList,DOMRectList,DOMStringList,DOMTokenList,DataTransferItemList,FileList,HTMLAllCollection,HTMLCollection,HTMLFormElement,HTMLSelectElement,MediaList,MimeTypeArray,NamedNodeMap,NodeList,PaintRequestList,Plugin,PluginArray,SVGLengthList,SVGNumberList,SVGPathSegList,SVGPointList,SVGStringList,SVGTransformList,SourceBufferList,StyleSheetList,TextTrackCueList,TextTrackList,TouchList".split(","),u=0;u<a.length;u++){var h=a[u],l=i[h],c=l&&l.prototype;c&&!c[s]&&r(c,s,h),o[h]=o.Array}},function(t,e,n){var i=n(21);t.exports=Object("z").propertyIsEnumerable(0)?Object:function(t){return"String"==i(t)?t.split(""):Object(t)}},function(t,e,n){var i=n(23),r=n(4),o=n(42),s=n(9),a=n(7),u=n(14),h=n(64),l=n(30),c=n(70),d=n(2)("iterator"),f=!([].keys&&"next"in[].keys()),p=function(){return this};t.exports=function(t,e,n,m,v,y,g){h(n,e,m);var _,w,b,x=function(t){if(!f&&t in D)return D[t];switch(t){case"keys":case"values":return function(){return new n(this,t)}}return function(){return new n(this,t)}},S=e+" Iterator",M="values"==v,T=!1,D=t.prototype,k=D[d]||D["@@iterator"]||v&&D[v],O=k||x(v),E=v?M?x("entries"):O:void 0,C="Array"==e?D.entries||k:k;if(C&&(b=c(C.call(new t)))!==Object.prototype&&b.next&&(l(b,S,!0),i||a(b,d)||s(b,d,p)),M&&k&&"values"!==k.name&&(T=!0,O=function(){return k.call(this)}),i&&!g||!f&&!T&&D[d]||s(D,d,O),u[e]=O,u[S]=p,v)if(_={values:M?O:x("values"),keys:y?O:x("keys"),entries:E},g)for(w in _)w in D||o(D,w,_[w]);else r(r.P+r.F*(f||T),e,_);return _}},function(t,e,n){t.exports=!n(6)&&!n(10)(function(){return 7!=Object.defineProperty(n(41)("div"),"a",{get:function(){return 7}}).a})},function(t,e,n){var i=n(15),r=n(1).document,o=i(r)&&i(r.createElement);t.exports=function(t){return o?r.createElement(t):{}}},function(t,e,n){t.exports=n(9)},function(t,e,n){var i=n(7),r=n(8),o=n(66)(!1),s=n(27)("IE_PROTO");t.exports=function(t,e){var n,a=r(t),u=0,h=[];for(n in a)n!=s&&i(a,n)&&h.push(n);for(;e.length>u;)i(a,n=e[u++])&&(~o(h,n)||h.push(n));return h}},function(t,e,n){var i=n(71)(!0);n(39)(String,"String",function(t){this._t=String(t),this._i=0},function(){var t,e=this._t,n=this._i;return n>=e.length?{value:void 0,done:!0}:(t=i(e,n),this._i+=t.length,{value:t,done:!1})})},function(t,e,n){var i=n(43),r=n(29).concat("length","prototype");e.f=Object.getOwnPropertyNames||function(t){return i(t,r)}},function(t,e,n){t.exports="undefined"!=typeof window&&window.moment||n(94)},function(t,e,n){t.exports={default:n(100),__esModule:!0}},function(t,e,n){function i(t){this.delay=null,this.max=1/0,this._queue=[],this._timeout=null,this._extended=null,this.setOptions(t)}i.prototype.setOptions=function(t){t&&void 0!==t.delay&&(this.delay=t.delay),t&&void 0!==t.max&&(this.max=t.max),this._flushIfNeeded()},i.extend=function(t,e){var n=new i(e);if(void 0!==t.flush)throw new Error("Target object already has a property flush");t.flush=function(){n.flush()};var r=[{name:"flush",original:void 0}];if(e&&e.replace)for(var o=0;o<e.replace.length;o++){var s=e.replace[o];r.push({name:s,original:t[s]}),n.replace(t,s)}return n._extended={object:t,methods:r},n},i.prototype.destroy=function(){if(this.flush(),this._extended){for(var t=this._extended.object,e=this._extended.methods,n=0;n<e.length;n++){var i=e[n];i.original?t[i.name]=i.original:delete t[i.name]}this._extended=null}},i.prototype.replace=function(t,e){var n=this,i=t[e];if(!i)throw new Error("Method "+e+" undefined");t[e]=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];n.queue({args:t,fn:i,context:this})}},i.prototype.queue=function(t){"function"==typeof t?this._queue.push({fn:t}):this._queue.push(t),this._flushIfNeeded()},i.prototype._flushIfNeeded=function(){if(this._queue.length>this.max&&this.flush(),clearTimeout(this._timeout),this.queue.length>0&&"number"==typeof this.delay){var t=this;this._timeout=setTimeout(function(){t.flush()},this.delay)}},i.prototype.flush=function(){for(;this._queue.length>0;){var t=this._queue.shift();t.fn.apply(t.context||t.fn,t.args||[])}},t.exports=i},function(t,e,n){function i(t,e){this.x=void 0!==t?t:0,this.y=void 0!==e?e:0}t.exports=i},function(t,e,n){function i(t,e){if(void 0===t)throw new Error("No container element defined");if(this.container=t,this.visible=!e||void 0==e.visible||e.visible,this.visible){this.frame=document.createElement("DIV"),this.frame.style.width="100%",this.frame.style.position="relative",this.container.appendChild(this.frame),this.frame.prev=document.createElement("INPUT"),this.frame.prev.type="BUTTON",this.frame.prev.value="Prev",this.frame.appendChild(this.frame.prev),this.frame.play=document.createElement("INPUT"),this.frame.play.type="BUTTON",this.frame.play.value="Play",this.frame.appendChild(this.frame.play),this.frame.next=document.createElement("INPUT"),this.frame.next.type="BUTTON",this.frame.next.value="Next",this.frame.appendChild(this.frame.next),this.frame.bar=document.createElement("INPUT"),this.frame.bar.type="BUTTON",this.frame.bar.style.position="absolute",this.frame.bar.style.border="1px solid red",this.frame.bar.style.width="100px",this.frame.bar.style.height="6px",this.frame.bar.style.borderRadius="2px",this.frame.bar.style.MozBorderRadius="2px",this.frame.bar.style.border="1px solid #7F7F7F",this.frame.bar.style.backgroundColor="#E5E5E5",this.frame.appendChild(this.frame.bar),this.frame.slide=document.createElement("INPUT"),this.frame.slide.type="BUTTON",this.frame.slide.style.margin="0px",this.frame.slide.value=" ",this.frame.slide.style.position="relative",this.frame.slide.style.left="-100px",this.frame.appendChild(this.frame.slide);var n=this;this.frame.slide.onmousedown=function(t){n._onMouseDown(t)},this.frame.prev.onclick=function(t){n.prev(t)},this.frame.play.onclick=function(t){n.togglePlay(t)},this.frame.next.onclick=function(t){n.next(t)}}this.onChangeCallback=void 0,this.values=[],this.index=void 0,this.playTimeout=void 0,this.playInterval=1e3,this.playLoop=!0}var r=n(3);i.prototype.prev=function(){var t=this.getIndex();t>0&&(t--,this.setIndex(t))},i.prototype.next=function(){var t=this.getIndex();t<this.values.length-1&&(t++,this.setIndex(t))},i.prototype.playNext=function(){var t=new Date,e=this.getIndex();e<this.values.length-1?(e++,this.setIndex(e)):this.playLoop&&(e=0,this.setIndex(e));var n=new Date,i=n-t,r=Math.max(this.playInterval-i,0),o=this;this.playTimeout=setTimeout(function(){o.playNext()},r)},i.prototype.togglePlay=function(){void 0===this.playTimeout?this.play():this.stop()},i.prototype.play=function(){this.playTimeout||(this.playNext(),this.frame&&(this.frame.play.value="Stop"))},i.prototype.stop=function(){clearInterval(this.playTimeout),this.playTimeout=void 0,this.frame&&(this.frame.play.value="Play")},i.prototype.setOnChangeCallback=function(t){this.onChangeCallback=t},i.prototype.setPlayInterval=function(t){this.playInterval=t},i.prototype.getPlayInterval=function(){return this.playInterval},i.prototype.setPlayLoop=function(t){this.playLoop=t},i.prototype.onChange=function(){void 0!==this.onChangeCallback&&this.onChangeCallback()},i.prototype.redraw=function(){if(this.frame){this.frame.bar.style.top=this.frame.clientHeight/2-this.frame.bar.offsetHeight/2+"px",this.frame.bar.style.width=this.frame.clientWidth-this.frame.prev.clientWidth-this.frame.play.clientWidth-this.frame.next.clientWidth-30+"px";var t=this.indexToLeft(this.index);this.frame.slide.style.left=t+"px"}},i.prototype.setValues=function(t){this.values=t,this.values.length>0?this.setIndex(0):this.index=void 0},i.prototype.setIndex=function(t){if(!(t<this.values.length))throw new Error("Index out of range");this.index=t,this.redraw(),this.onChange()},i.prototype.getIndex=function(){return this.index},i.prototype.get=function(){return this.values[this.index]},i.prototype._onMouseDown=function(t){if(t.which?1===t.which:1===t.button){this.startClientX=t.clientX,this.startSlideX=parseFloat(this.frame.slide.style.left),this.frame.style.cursor="move";var e=this;this.onmousemove=function(t){e._onMouseMove(t)},this.onmouseup=function(t){e._onMouseUp(t)},r.addEventListener(document,"mousemove",this.onmousemove),r.addEventListener(document,"mouseup",this.onmouseup),r.preventDefault(t)}},i.prototype.leftToIndex=function(t){var e=parseFloat(this.frame.bar.style.width)-this.frame.slide.clientWidth-10,n=t-3,i=Math.round(n/e*(this.values.length-1));return i<0&&(i=0),i>this.values.length-1&&(i=this.values.length-1),i},i.prototype.indexToLeft=function(t){var e=parseFloat(this.frame.bar.style.width)-this.frame.slide.clientWidth-10;return t/(this.values.length-1)*e+3},i.prototype._onMouseMove=function(t){var e=t.clientX-this.startClientX,n=this.startSlideX+e,i=this.leftToIndex(n);this.setIndex(i),r.preventDefault()},i.prototype._onMouseUp=function(t){this.frame.style.cursor="auto",r.removeEventListener(document,"mousemove",this.onmousemove),r.removeEventListener(document,"mouseup",this.onmouseup),r.preventDefault()},t.exports=i},function(t,e,n){function i(t,e,n,i){this._start=0,this._end=0,this._step=1,this.prettyStep=!0,this.precision=5,this._current=0,this.setRange(t,e,n,i)}i.prototype.isNumeric=function(t){return!isNaN(parseFloat(t))&&isFinite(t)},i.prototype.setRange=function(t,e,n,i){if(!this.isNumeric(t))throw new Error("Parameter 'start' is not numeric; value: "+t);if(!this.isNumeric(e))throw new Error("Parameter 'end' is not numeric; value: "+t);if(!this.isNumeric(n))throw new Error("Parameter 'step' is not numeric; value: "+t);this._start=t||0,this._end=e||0,this.setStep(n,i)},i.prototype.setStep=function(t,e){void 0===t||t<=0||(void 0!==e&&(this.prettyStep=e),!0===this.prettyStep?this._step=i.calculatePrettyStep(t):this._step=t)},i.calculatePrettyStep=function(t){var e=function(t){return Math.log(t)/Math.LN10},n=Math.pow(10,Math.round(e(t))),i=2*Math.pow(10,Math.round(e(t/2))),r=5*Math.pow(10,Math.round(e(t/5))),o=n;return Math.abs(i-t)<=Math.abs(o-t)&&(o=i),Math.abs(r-t)<=Math.abs(o-t)&&(o=r),o<=0&&(o=1),o},i.prototype.getCurrent=function(){return parseFloat(this._current.toPrecision(this.precision))},i.prototype.getStep=function(){return this._step},i.prototype.start=function(t){void 0===t&&(t=!1),this._current=this._start-this._start%this._step,t&&this.getCurrent()<this._start&&this.next()},i.prototype.next=function(){this._current+=this._step},i.prototype.end=function(){return this._current>this._end},t.exports=i},function(t,e,n){function i(t){for(var e in t)if(t.hasOwnProperty(e))return!1;return!0}function r(t){return void 0===t||""===t||"string"!=typeof t?t:t.charAt(0).toUpperCase()+t.slice(1)}function o(t,e){return void 0===t||""===t?e:t+r(e)}function s(t,e,n,i){for(var r,s,a=0;a<n.length;++a)r=n[a],s=o(i,r),e[s]=t[r]}function a(t,e,n,i){for(var r,s,a=0;a<n.length;++a)r=n[a],void 0!==t[r]&&(s=o(i,r),e[s]=t[r])}function u(t,e){if(void 0===t||i(t))throw new Error("No DEFAULTS passed");if(void 0===e)throw new Error("No dst passed");k=t,s(t,e,T),s(t,e,D,"default"),l(t,e),e.margin=10,e.showGrayBottom=!1,e.showTooltip=!1,e.onclick_callback=null,e.eye=new x(0,0,-1)}function h(t,e){if(void 0!==t){if(void 0===e)throw new Error("No dst passed");if(void 0===k||i(k))throw new Error("DEFAULTS not set for module Settings");a(t,e,T),a(t,e,D,"default"),l(t,e)}}function l(t,e){void 0!==t.backgroundColor&&m(t.backgroundColor,e),v(t.dataColor,e),p(t.style,e),c(t.showLegend,e),y(t.cameraPosition,e),void 0!==t.tooltip&&(e.showTooltip=t.tooltip),void 0!=t.onclick&&(e.onclick_callback=t.onclick),void 0!==t.tooltipStyle&&w.selectiveDeepExtend(["tooltipStyle"],e,t)}function c(t,e){if(void 0===t){if(void 0===k.showLegend){var n=e.style===S.DOTCOLOR||e.style===S.DOTSIZE;e.showLegend=n}}else e.showLegend=t}function d(t){var e=M[t];return void 0===e?-1:e}function f(t){var e=!1;for(var n in S)if(S[n]===t){e=!0;break}return e}function p(t,e){if(void 0!==t){var n;if("string"==typeof t){if(-1===(n=d(t)))throw new Error("Style '"+t+"' is invalid")}else{if(!f(t))throw new Error("Style '"+t+"' is invalid");n=t}e.style=n}}function m(t,e){var n="white",i="gray",r=1;if("string"==typeof t)n=t,i="none",r=0;else{if("object"!==(void 0===t?"undefined":(0,_.default)(t)))throw new Error("Unsupported type of backgroundColor");void 0!==t.fill&&(n=t.fill),void 0!==t.stroke&&(i=t.stroke),void 0!==t.strokeWidth&&(r=t.strokeWidth)}e.frame.style.backgroundColor=n,e.frame.style.borderColor=i,e.frame.style.borderWidth=r+"px",e.frame.style.borderStyle="solid"}function v(t,e){void 0!==t&&(void 0===e.dataColor&&(e.dataColor={}),"string"==typeof t?(e.dataColor.fill=t,e.dataColor.stroke=t):(t.fill&&(e.dataColor.fill=t.fill),t.stroke&&(e.dataColor.stroke=t.stroke),void 0!==t.strokeWidth&&(e.dataColor.strokeWidth=t.strokeWidth)))}function y(t,e){var n=t;void 0!==n&&(void 0===e.camera&&(e.camera=new b),e.camera.setArmRotation(n.horizontal,n.vertical),e.camera.setArmLength(n.distance))}var g=n(19),_=function(t){return t&&t.__esModule?t:{default:t}}(g),w=n(3),b=n(53),x=n(13),S={BAR:0,BARCOLOR:1,BARSIZE:2,DOT:3,DOTLINE:4,DOTCOLOR:5,DOTSIZE:6,GRID:7,LINE:8,SURFACE:9},M={dot:S.DOT,"dot-line":S.DOTLINE,"dot-color":S.DOTCOLOR,"dot-size":S.DOTSIZE,line:S.LINE,grid:S.GRID,surface:S.SURFACE,bar:S.BAR,"bar-color":S.BARCOLOR,"bar-size":S.BARSIZE},T=["width","height","filterLabel","legendLabel","xLabel","yLabel","zLabel","xValueLabel","yValueLabel","zValueLabel","showXAxis","showYAxis","showZAxis","showGrid","showPerspective","showShadow","keepAspectRatio","verticalRatio","dotSizeRatio","dotSizeMinFraction","dotSizeMaxFraction","showAnimationControls","animationInterval","animationPreload","animationAutoStart","axisColor","gridColor","xCenter","yCenter"],D=["xBarWidth","yBarWidth","valueMin","valueMax","xMin","xMax","xStep","yMin","yMax","yStep","zMin","zMax","zStep"],k=void 0;t.exports.STYLE=S,t.exports.setDefaults=u,t.exports.setOptions=h,t.exports.setCameraPosition=y},function(t,e,n){function i(){this.armLocation=new s,this.armRotation={},this.armRotation.horizontal=0,this.armRotation.vertical=0,this.armLength=1.7,this.cameraOffset=new s,this.offsetMultiplier=.6,this.cameraLocation=new s,this.cameraRotation=new s(.5*Math.PI,0,0),this.calculateCameraOrientation()}var r=n(107),o=function(t){return t&&t.__esModule?t:{default:t}}(r),s=n(13);i.prototype.setOffset=function(t,e){var n=Math.abs,i=o.default,r=this.offsetMultiplier,s=this.armLength*r;n(t)>s&&(t=i(t)*s),n(e)>s&&(e=i(e)*s),this.cameraOffset.x=t,this.cameraOffset.y=e,this.calculateCameraOrientation()},i.prototype.getOffset=function(){return this.cameraOffset},i.prototype.setArmLocation=function(t,e,n){this.armLocation.x=t,this.armLocation.y=e,this.armLocation.z=n,this.calculateCameraOrientation()},i.prototype.setArmRotation=function(t,e){void 0!==t&&(this.armRotation.horizontal=t),void 0!==e&&(this.armRotation.vertical=e,this.armRotation.vertical<0&&(this.armRotation.vertical=0),this.armRotation.vertical>.5*Math.PI&&(this.armRotation.vertical=.5*Math.PI)),void 0===t&&void 0===e||this.calculateCameraOrientation()},i.prototype.getArmRotation=function(){var t={};return t.horizontal=this.armRotation.horizontal,t.vertical=this.armRotation.vertical,t},i.prototype.setArmLength=function(t){void 0!==t&&(this.armLength=t,this.armLength<.71&&(this.armLength=.71),this.armLength>5&&(this.armLength=5),this.setOffset(this.cameraOffset.x,this.cameraOffset.y),this.calculateCameraOrientation())},i.prototype.getArmLength=function(){return this.armLength},i.prototype.getCameraLocation=function(){return this.cameraLocation},i.prototype.getCameraRotation=function(){return this.cameraRotation},i.prototype.calculateCameraOrientation=function(){this.cameraLocation.x=this.armLocation.x-this.armLength*Math.sin(this.armRotation.horizontal)*Math.cos(this.armRotation.vertical),this.cameraLocation.y=this.armLocation.y-this.armLength*Math.cos(this.armRotation.horizontal)*Math.cos(this.armRotation.vertical),this.cameraLocation.z=this.armLocation.z+this.armLength*Math.sin(this.armRotation.vertical),this.cameraRotation.x=Math.PI/2-this.armRotation.vertical,this.cameraRotation.y=0,this.cameraRotation.z=-this.armRotation.horizontal;var t=this.cameraRotation.x,e=this.cameraRotation.z,n=this.cameraOffset.x,i=this.cameraOffset.y,r=Math.sin,o=Math.cos;this.cameraLocation.x=this.cameraLocation.x+n*o(e)+i*-r(e)*o(t),this.cameraLocation.y=this.cameraLocation.y+n*r(e)+i*o(e)*o(t),this.cameraLocation.z=this.cameraLocation.z+i*r(t)},t.exports=i},function(t,e,n){function i(t){return t&&t.__esModule?t:{default:t}}Object.defineProperty(e,"__esModule",{value:!0}),e.printStyle=void 0;var r=n(47),o=i(r),s=n(19),a=i(s),u=n(18),h=i(u),l=n(111),c=i(l),d=n(112),f=i(d),p=n(3),m=!1,v=void 0,y="background: #FFeeee; color: #dd0000",g=function(){function t(){(0,c.default)(this,t)}return(0,f.default)(t,null,[{key:"validate",value:function(e,n,i){m=!1,v=n;var r=n;return void 0!==i&&(r=n[i]),t.parse(e,r,[]),m}},{key:"parse",value:function(e,n,i){for(var r in e)e.hasOwnProperty(r)&&t.check(r,e,n,i)}},{key:"check",value:function(e,n,i,r){if(void 0===i[e]&&void 0===i.__any__)return void t.getSuggestion(e,i,r);var o=e,s=!0;void 0===i[e]&&void 0!==i.__any__&&(o="__any__",s="object"===t.getType(n[e]));var a=i[o];s&&void 0!==a.__type__&&(a=a.__type__),t.checkFields(e,n,i,o,a,r)}},{key:"checkFields",value:function(e,n,i,r,o,s){var a=function(n){console.log("%c"+n+t.printLocation(s,e),y)},u=t.getType(n[e]),l=o[u];void 0!==l?"array"===t.getType(l)&&-1===l.indexOf(n[e])?(a('Invalid option detected in "'+e+'". Allowed values are:'+t.print(l)+' not "'+n[e]+'". '),m=!0):"object"===u&&"__any__"!==r&&(s=p.copyAndExtendArray(s,e),t.parse(n[e],i[r],s)):void 0===o.any&&(a('Invalid type received for "'+e+'". Expected: '+t.print((0,h.default)(o))+". Received ["+u+'] "'+n[e]+'"'),m=!0)}},{key:"getType",value:function(t){var e=void 0===t?"undefined":(0,a.default)(t);return"object"===e?null===t?"null":t instanceof Boolean?"boolean":t instanceof Number?"number":t instanceof String?"string":Array.isArray(t)?"array":t instanceof Date?"date":void 0!==t.nodeType?"dom":!0===t._isAMomentObject?"moment":"object":"number"===e?"number":"boolean"===e?"boolean":"string"===e?"string":void 0===e?"undefined":e}},{key:"getSuggestion",value:function(e,n,i){var r=t.findInOptions(e,n,i,!1),o=t.findInOptions(e,v,[],!0),s=void 0;s=void 0!==r.indexMatch?" in "+t.printLocation(r.path,e,"")+'Perhaps it was incomplete? Did you mean: "'+r.indexMatch+'"?\n\n':o.distance<=4&&r.distance>o.distance?" in "+t.printLocation(r.path,e,"")+"Perhaps it was misplaced? Matching option found at: "+t.printLocation(o.path,o.closestMatch,""):r.distance<=8?'. Did you mean "'+r.closestMatch+'"?'+t.printLocation(r.path,e):". Did you mean one of these: "+t.print((0,h.default)(n))+t.printLocation(i,e),console.log('%cUnknown option detected: "'+e+'"'+s,y),m=!0}},{key:"findInOptions",value:function(e,n,i){var r=arguments.length>3&&void 0!==arguments[3]&&arguments[3],o=1e9,s="",a=[],u=e.toLowerCase(),h=void 0;for(var l in n){var c=void 0;if(void 0!==n[l].__type__&&!0===r){var d=t.findInOptions(e,n[l],p.copyAndExtendArray(i,l));o>d.distance&&(s=d.closestMatch,a=d.path,o=d.distance,h=d.indexMatch)}else-1!==l.toLowerCase().indexOf(u)&&(h=l),c=t.levenshteinDistance(e,l),o>c&&(s=l,a=p.copyArray(i),o=c)}return{closestMatch:s,path:a,distance:o,indexMatch:h}}},{key:"printLocation",value:function(t,e){for(var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"Problem value found at: \n",i="\n\n"+n+"options = {\n",r=0;r<t.length;r++){for(var o=0;o<r+1;o++)i+="  ";i+=t[r]+": {\n"}for(var s=0;s<t.length+1;s++)i+="  ";i+=e+"\n";for(var a=0;a<t.length+1;a++){for(var u=0;u<t.length-a;u++)i+="  ";i+="}\n"}return i+"\n\n"}},{key:"print",value:function(t){return(0,o.default)(t).replace(/(\")|(\[)|(\])|(,"__type__")/g,"").replace(/(\,)/g,", ")}},{key:"levenshteinDistance",value:function(t,e){if(0===t.length)return e.length;if(0===e.length)return t.length;var n,i=[];for(n=0;n<=e.length;n++)i[n]=[n];var r;for(r=0;r<=t.length;r++)i[0][r]=r;for(n=1;n<=e.length;n++)for(r=1;r<=t.length;r++)e.charAt(n-1)==t.charAt(r-1)?i[n][r]=i[n-1][r-1]:i[n][r]=Math.min(i[n-1][r-1]+1,Math.min(i[n][r-1]+1,i[n-1][r]+1));return i[e.length][t.length]}}]),t}();e.default=g,e.printStyle=y},function(t,e,n){function i(t,e,n){this.dataGroup=t,this.column=e,this.graph=n,this.index=void 0,this.value=void 0,this.values=t.getDistinctValues(this.column),this.values.length>0&&this.selectValue(0),this.dataPoints=[],this.loaded=!1,this.onLoadCallback=void 0,n.animationPreload?(this.loaded=!1,this.loadInBackground()):this.loaded=!0}var r=n(36);i.prototype.isLoaded=function(){return this.loaded},i.prototype.getLoadedProgress=function(){for(var t=this.values.length,e=0;this.dataPoints[e];)e++;return Math.round(e/t*100)},i.prototype.getLabel=function(){return this.graph.filterLabel},i.prototype.getColumn=function(){return this.column},i.prototype.getSelectedValue=function(){if(void 0!==this.index)return this.values[this.index]},i.prototype.getValues=function(){return this.values},i.prototype.getValue=function(t){if(t>=this.values.length)throw new Error("Index out of range");return this.values[t]},i.prototype._getDataPoints=function(t){if(void 0===t&&(t=this.index),void 0===t)return[];var e;if(this.dataPoints[t])e=this.dataPoints[t];else{var n={};n.column=this.column,n.value=this.values[t];var i=new r(this.dataGroup.getDataSet(),{filter:function(t){return t[n.column]==n.value}}).get();e=this.dataGroup._getDataPoints(i),this.dataPoints[t]=e}return e},i.prototype.setOnLoadCallback=function(t){this.onLoadCallback=t},i.prototype.selectValue=function(t){if(t>=this.values.length)throw new Error("Index out of range");this.index=t,this.value=this.values[t]},i.prototype.loadInBackground=function(t){void 0===t&&(t=0);var e=this.graph.frame;if(t<this.values.length){void 0===e.progress&&(e.progress=document.createElement("DIV"),e.progress.style.position="absolute",e.progress.style.color="gray",e.appendChild(e.progress));var n=this.getLoadedProgress();e.progress.innerHTML="Loading animation... "+n+"%",e.progress.style.bottom="60px",e.progress.style.left="10px";var i=this;setTimeout(function(){i.loadInBackground(t+1)},10),this.loaded=!1}else this.loaded=!0,void 0!==e.progress&&(e.removeChild(e.progress),e.progress=void 0),this.onLoadCallback&&this.onLoadCallback()},t.exports=i},function(t,e,n){e.util=n(3),e.DOMutil=n(99),e.DataSet=n(35),e.DataView=n(36),e.Queue=n(48),e.Graph3d=n(101),e.graph3d={Camera:n(53),Filter:n(55),Point2d:n(49),Point3d:n(13),Slider:n(50),StepNumber:n(51)},e.moment=n(46),e.Hammer=n(119),e.keycharm=n(122)},function(t,e,n){t.exports={default:n(58),__esModule:!0}},function(t,e,n){n(37),n(44),t.exports=n(72)},function(t,e,n){var i=n(60),r=n(61),o=n(14),s=n(8);t.exports=n(39)(Array,"Array",function(t,e){this._t=s(t),this._i=0,this._k=e},function(){var t=this._t,e=this._k,n=this._i++;return!t||n>=t.length?(this._t=void 0,r(1)):"keys"==e?r(0,n):"values"==e?r(0,t[n]):r(0,[n,t[n]])},"values"),o.Arguments=o.Array,i("keys"),i("values"),i("entries")},function(t,e){t.exports=function(){}},function(t,e){t.exports=function(t,e){return{value:e,done:!!t}}},function(t,e,n){var i=n(63);t.exports=function(t,e,n){if(i(t),void 0===e)return t;switch(n){case 1:return function(n){return t.call(e,n)};case 2:return function(n,i){return t.call(e,n,i)};case 3:return function(n,i,r){return t.call(e,n,i,r)}}return function(){return t.apply(e,arguments)}}},function(t,e){t.exports=function(t){if("function"!=typeof t)throw TypeError(t+" is not a function!");return t}},function(t,e,n){var i=n(25),r=n(16),o=n(30),s={};n(9)(s,n(2)("iterator"),function(){return this}),t.exports=function(t,e,n){t.prototype=i(s,{next:r(1,n)}),o(t,e+" Iterator")}},function(t,e,n){var i=n(5),r=n(11),o=n(12);t.exports=n(6)?Object.defineProperties:function(t,e){r(t);for(var n,s=o(e),a=s.length,u=0;a>u;)i.f(t,n=s[u++],e[n]);return t}},function(t,e,n){var i=n(8),r=n(67),o=n(68);t.exports=function(t){return function(e,n,s){var a,u=i(e),h=r(u.length),l=o(s,h);if(t&&n!=n){for(;h>l;)if((a=u[l++])!=a)return!0}else for(;h>l;l++)if((t||l in u)&&u[l]===n)return t||l||0;return!t&&-1}}},function(t,e,n){var i=n(26),r=Math.min;t.exports=function(t){return t>0?r(i(t),9007199254740991):0}},function(t,e,n){var i=n(26),r=Math.max,o=Math.min;t.exports=function(t,e){return t=i(t),t<0?r(t+e,0):o(t,e)}},function(t,e,n){var i=n(1).document;t.exports=i&&i.documentElement},function(t,e,n){var i=n(7),r=n(31),o=n(27)("IE_PROTO"),s=Object.prototype;t.exports=Object.getPrototypeOf||function(t){return t=r(t),i(t,o)?t[o]:"function"==typeof t.constructor&&t instanceof t.constructor?t.constructor.prototype:t instanceof Object?s:null}},function(t,e,n){var i=n(26),r=n(22);t.exports=function(t){return function(e,n){var o,s,a=String(r(e)),u=i(n),h=a.length;return u<0||u>=h?t?"":void 0:(o=a.charCodeAt(u),o<55296||o>56319||u+1===h||(s=a.charCodeAt(u+1))<56320||s>57343?t?a.charAt(u):o:t?a.slice(u,u+2):s-56320+(o-55296<<10)+65536)}}},function(t,e,n){var i=n(11),r=n(73);t.exports=n(0).getIterator=function(t){var e=r(t);if("function"!=typeof e)throw TypeError(t+" is not iterable!");return i(e.call(t))}},function(t,e,n){var i=n(74),r=n(2)("iterator"),o=n(14);t.exports=n(0).getIteratorMethod=function(t){if(void 0!=t)return t[r]||t["@@iterator"]||o[i(t)]}},function(t,e,n){var i=n(21),r=n(2)("toStringTag"),o="Arguments"==i(function(){return arguments}()),s=function(t,e){try{return t[e]}catch(t){}};t.exports=function(t){var e,n,a;return void 0===t?"Undefined":null===t?"Null":"string"==typeof(n=s(e=Object(t),r))?n:o?i(e):"Object"==(a=i(e))&&"function"==typeof e.callee?"Arguments":a}},function(t,e,n){t.exports={default:n(76),__esModule:!0}},function(t,e,n){n(77);var i=n(0).Object;t.exports=function(t,e){return i.create(t,e)}},function(t,e,n){var i=n(4);i(i.S,"Object",{create:n(25)})},function(t,e,n){n(79),t.exports=n(0).Object.keys},function(t,e,n){var i=n(31),r=n(12);n(80)("keys",function(){return function(t){return r(i(t))}})},function(t,e,n){var i=n(4),r=n(0),o=n(10);t.exports=function(t,e){var n=(r.Object||{})[t]||Object[t],s={};s[t]=e(n),i(i.S+i.F*o(function(){n(1)}),"Object",s)}},function(t,e,n){t.exports={default:n(82),__esModule:!0}},function(t,e,n){n(44),n(37),t.exports=n(32).f("iterator")},function(t,e,n){t.exports={default:n(84),__esModule:!0}},function(t,e,n){n(85),n(91),n(92),n(93),t.exports=n(0).Symbol},function(t,e,n){var i=n(1),r=n(7),o=n(6),s=n(4),a=n(42),u=n(86).KEY,h=n(10),l=n(28),c=n(30),d=n(17),f=n(2),p=n(32),m=n(33),v=n(87),y=n(88),g=n(11),_=n(8),w=n(24),b=n(16),x=n(25),S=n(89),M=n(90),T=n(5),D=n(12),k=M.f,O=T.f,E=S.f,C=i.Symbol,P=i.JSON,L=P&&P.stringify,R=f("_hidden"),A=f("toPrimitive"),Y={}.propertyIsEnumerable,I=l("symbol-registry"),z=l("symbols"),N=l("op-symbols"),W=Object.prototype,j="function"==typeof C,F=i.QObject,V=!F||!F.prototype||!F.prototype.findChild,G=o&&h(function(){return 7!=x(O({},"a",{get:function(){return O(this,"a",{value:7}).a}})).a})?function(t,e,n){var i=k(W,e);i&&delete W[e],O(t,e,n),i&&t!==W&&O(W,e,i)}:O,B=function(t){var e=z[t]=x(C.prototype);return e._k=t,e},U=j&&"symbol"==typeof C.iterator?function(t){return"symbol"==typeof t}:function(t){return t instanceof C},H=function(t,e,n){return t===W&&H(N,e,n),g(t),e=w(e,!0),g(n),r(z,e)?(n.enumerable?(r(t,R)&&t[R][e]&&(t[R][e]=!1),n=x(n,{enumerable:b(0,!1)})):(r(t,R)||O(t,R,b(1,{})),t[R][e]=!0),G(t,e,n)):O(t,e,n)},X=function(t,e){g(t);for(var n,i=v(e=_(e)),r=0,o=i.length;o>r;)H(t,n=i[r++],e[n]);return t},Z=function(t,e){return void 0===e?x(t):X(x(t),e)},q=function(t){var e=Y.call(this,t=w(t,!0));return!(this===W&&r(z,t)&&!r(N,t))&&(!(e||!r(this,t)||!r(z,t)||r(this,R)&&this[R][t])||e)},$=function(t,e){if(t=_(t),e=w(e,!0),t!==W||!r(z,e)||r(N,e)){var n=k(t,e);return!n||!r(z,e)||r(t,R)&&t[R][e]||(n.enumerable=!0),n}},J=function(t){for(var e,n=E(_(t)),i=[],o=0;n.length>o;)r(z,e=n[o++])||e==R||e==u||i.push(e);return i},Q=function(t){for(var e,n=t===W,i=E(n?N:_(t)),o=[],s=0;i.length>s;)!r(z,e=i[s++])||n&&!r(W,e)||o.push(z[e]);return o};j||(C=function(){if(this instanceof C)throw TypeError("Symbol is not a constructor!");var t=d(arguments.length>0?arguments[0]:void 0),e=function(n){this===W&&e.call(N,n),r(this,R)&&r(this[R],t)&&(this[R][t]=!1),G(this,t,b(1,n))};return o&&V&&G(W,t,{configurable:!0,set:e}),B(t)},a(C.prototype,"toString",function(){return this._k}),M.f=$,T.f=H,n(45).f=S.f=J,n(20).f=q,n(34).f=Q,o&&!n(23)&&a(W,"propertyIsEnumerable",q,!0),p.f=function(t){return B(f(t))}),s(s.G+s.W+s.F*!j,{Symbol:C});for(var K="hasInstance,isConcatSpreadable,iterator,match,replace,search,species,split,toPrimitive,toStringTag,unscopables".split(","),tt=0;K.length>tt;)f(K[tt++]);for(var et=D(f.store),nt=0;et.length>nt;)m(et[nt++]);s(s.S+s.F*!j,"Symbol",{for:function(t){return r(I,t+="")?I[t]:I[t]=C(t)},keyFor:function(t){if(!U(t))throw TypeError(t+" is not a symbol!");for(var e in I)if(I[e]===t)return e},useSetter:function(){V=!0},useSimple:function(){V=!1}}),s(s.S+s.F*!j,"Object",{create:Z,defineProperty:H,defineProperties:X,getOwnPropertyDescriptor:$,getOwnPropertyNames:J,getOwnPropertySymbols:Q}),P&&s(s.S+s.F*(!j||h(function(){var t=C();return"[null]"!=L([t])||"{}"!=L({a:t})||"{}"!=L(Object(t))})),"JSON",{stringify:function(t){if(void 0!==t&&!U(t)){for(var e,n,i=[t],r=1;arguments.length>r;)i.push(arguments[r++]);return e=i[1],"function"==typeof e&&(n=e),!n&&y(e)||(e=function(t,e){if(n&&(e=n.call(this,t,e)),!U(e))return e}),i[1]=e,L.apply(P,i)}}}),C.prototype[A]||n(9)(C.prototype,A,C.prototype.valueOf),c(C,"Symbol"),c(Math,"Math",!0),c(i.JSON,"JSON",!0)},function(t,e,n){var i=n(17)("meta"),r=n(15),o=n(7),s=n(5).f,a=0,u=Object.isExtensible||function(){return!0},h=!n(10)(function(){return u(Object.preventExtensions({}))}),l=function(t){s(t,i,{value:{i:"O"+ ++a,w:{}}})},c=function(t,e){if(!r(t))return"symbol"==typeof t?t:("string"==typeof t?"S":"P")+t;if(!o(t,i)){if(!u(t))return"F";if(!e)return"E";l(t)}return t[i].i},d=function(t,e){if(!o(t,i)){if(!u(t))return!0;if(!e)return!1;l(t)}return t[i].w},f=function(t){return h&&p.NEED&&u(t)&&!o(t,i)&&l(t),t},p=t.exports={KEY:i,NEED:!1,fastKey:c,getWeak:d,onFreeze:f}},function(t,e,n){var i=n(12),r=n(34),o=n(20);t.exports=function(t){var e=i(t),n=r.f;if(n)for(var s,a=n(t),u=o.f,h=0;a.length>h;)u.call(t,s=a[h++])&&e.push(s);return e}},function(t,e,n){var i=n(21);t.exports=Array.isArray||function(t){return"Array"==i(t)}},function(t,e,n){var i=n(8),r=n(45).f,o={}.toString,s="object"==typeof window&&window&&Object.getOwnPropertyNames?Object.getOwnPropertyNames(window):[],a=function(t){try{return r(t)}catch(t){return s.slice()}};t.exports.f=function(t){return s&&"[object Window]"==o.call(t)?a(t):r(i(t))}},function(t,e,n){var i=n(20),r=n(16),o=n(8),s=n(24),a=n(7),u=n(40),h=Object.getOwnPropertyDescriptor;e.f=n(6)?h:function(t,e){if(t=o(t),e=s(e,!0),u)try{return h(t,e)}catch(t){}if(a(t,e))return r(!i.f.call(t,e),t[e])}},function(t,e){},function(t,e,n){n(33)("asyncIterator")},function(t,e,n){n(33)("observable")},function(t,e,n){(function(t){!function(e,n){t.exports=n()}(0,function(){function e(){return ki.apply(null,arguments)}function n(t){return t instanceof Array||"[object Array]"===Object.prototype.toString.call(t)}function i(t){return null!=t&&"[object Object]"===Object.prototype.toString.call(t)}function r(t){if(Object.getOwnPropertyNames)return 0===Object.getOwnPropertyNames(t).length;var e;for(e in t)if(t.hasOwnProperty(e))return!1;return!0}function o(t){return void 0===t}function s(t){return"number"==typeof t||"[object Number]"===Object.prototype.toString.call(t)}function a(t){return t instanceof Date||"[object Date]"===Object.prototype.toString.call(t)}function u(t,e){var n,i=[];for(n=0;n<t.length;++n)i.push(e(t[n],n));return i}function h(t,e){return Object.prototype.hasOwnProperty.call(t,e)}function l(t,e){for(var n in e)h(e,n)&&(t[n]=e[n]);return h(e,"toString")&&(t.toString=e.toString),h(e,"valueOf")&&(t.valueOf=e.valueOf),t}function c(t,e,n,i){return Me(t,e,n,i,!0).utc()}function d(){return{empty:!1,unusedTokens:[],unusedInput:[],overflow:-2,charsLeftOver:0,nullInput:!1,invalidMonth:null,invalidFormat:!1,userInvalidated:!1,iso:!1,parsedDateParts:[],meridiem:null,rfc2822:!1,weekdayMismatch:!1}}function f(t){return null==t._pf&&(t._pf=d()),t._pf}function p(t){if(null==t._isValid){var e=f(t),n=Oi.call(e.parsedDateParts,function(t){return null!=t}),i=!isNaN(t._d.getTime())&&e.overflow<0&&!e.empty&&!e.invalidMonth&&!e.invalidWeekday&&!e.weekdayMismatch&&!e.nullInput&&!e.invalidFormat&&!e.userInvalidated&&(!e.meridiem||e.meridiem&&n);if(t._strict&&(i=i&&0===e.charsLeftOver&&0===e.unusedTokens.length&&void 0===e.bigHour),null!=Object.isFrozen&&Object.isFrozen(t))return i;t._isValid=i}return t._isValid}function m(t){var e=c(NaN);return null!=t?l(f(e),t):f(e).userInvalidated=!0,e}function v(t,e){var n,i,r;if(o(e._isAMomentObject)||(t._isAMomentObject=e._isAMomentObject),o(e._i)||(t._i=e._i),o(e._f)||(t._f=e._f),o(e._l)||(t._l=e._l),o(e._strict)||(t._strict=e._strict),o(e._tzm)||(t._tzm=e._tzm),o(e._isUTC)||(t._isUTC=e._isUTC),o(e._offset)||(t._offset=e._offset),o(e._pf)||(t._pf=f(e)),o(e._locale)||(t._locale=e._locale),Ei.length>0)for(n=0;n<Ei.length;n++)i=Ei[n],r=e[i],o(r)||(t[i]=r);return t}function y(t){v(this,t),this._d=new Date(null!=t._d?t._d.getTime():NaN),this.isValid()||(this._d=new Date(NaN)),!1===Ci&&(Ci=!0,e.updateOffset(this),Ci=!1)}function g(t){return t instanceof y||null!=t&&null!=t._isAMomentObject}function _(t){return t<0?Math.ceil(t)||0:Math.floor(t)}function w(t){var e=+t,n=0;return 0!==e&&isFinite(e)&&(n=_(e)),n}function b(t,e,n){var i,r=Math.min(t.length,e.length),o=Math.abs(t.length-e.length),s=0;for(i=0;i<r;i++)(n&&t[i]!==e[i]||!n&&w(t[i])!==w(e[i]))&&s++;return s+o}function x(t){!1===e.suppressDeprecationWarnings&&"undefined"!=typeof console&&console.warn&&console.warn("Deprecation warning: "+t)}function S(t,n){var i=!0;return l(function(){if(null!=e.deprecationHandler&&e.deprecationHandler(null,t),i){for(var r,o=[],s=0;s<arguments.length;s++){if(r="","object"==typeof arguments[s]){r+="\n["+s+"] ";for(var a in arguments[0])r+=a+": "+arguments[0][a]+", ";r=r.slice(0,-2)}else r=arguments[s];o.push(r)}x(t+"\nArguments: "+Array.prototype.slice.call(o).join("")+"\n"+(new Error).stack),i=!1}return n.apply(this,arguments)},n)}function M(t,n){null!=e.deprecationHandler&&e.deprecationHandler(t,n),Pi[t]||(x(n),Pi[t]=!0)}function T(t){return t instanceof Function||"[object Function]"===Object.prototype.toString.call(t)}function D(t){var e,n;for(n in t)e=t[n],T(e)?this[n]=e:this["_"+n]=e;this._config=t,this._dayOfMonthOrdinalParseLenient=new RegExp((this._dayOfMonthOrdinalParse.source||this._ordinalParse.source)+"|"+/\d{1,2}/.source)}function k(t,e){var n,r=l({},t);for(n in e)h(e,n)&&(i(t[n])&&i(e[n])?(r[n]={},l(r[n],t[n]),l(r[n],e[n])):null!=e[n]?r[n]=e[n]:delete r[n]);for(n in t)h(t,n)&&!h(e,n)&&i(t[n])&&(r[n]=l({},r[n]));return r}function O(t){null!=t&&this.set(t)}function E(t,e,n){var i=this._calendar[t]||this._calendar.sameElse;return T(i)?i.call(e,n):i}function C(t){var e=this._longDateFormat[t],n=this._longDateFormat[t.toUpperCase()];return e||!n?e:(this._longDateFormat[t]=n.replace(/MMMM|MM|DD|dddd/g,function(t){return t.slice(1)}),this._longDateFormat[t])}function P(){return this._invalidDate}function L(t){return this._ordinal.replace("%d",t)}function R(t,e,n,i){var r=this._relativeTime[n];return T(r)?r(t,e,n,i):r.replace(/%d/i,t)}function A(t,e){var n=this._relativeTime[t>0?"future":"past"];return T(n)?n(e):n.replace(/%s/i,e)}function Y(t,e){var n=t.toLowerCase();zi[n]=zi[n+"s"]=zi[e]=t}function I(t){return"string"==typeof t?zi[t]||zi[t.toLowerCase()]:void 0}function z(t){var e,n,i={};for(n in t)h(t,n)&&(e=I(n))&&(i[e]=t[n]);return i}function N(t,e){Ni[t]=e}function W(t){var e=[];for(var n in t)e.push({unit:n,priority:Ni[n]});return e.sort(function(t,e){return t.priority-e.priority}),e}function j(t,e,n){var i=""+Math.abs(t),r=e-i.length;return(t>=0?n?"+":"":"-")+Math.pow(10,Math.max(0,r)).toString().substr(1)+i}function F(t,e,n,i){var r=i;"string"==typeof i&&(r=function(){return this[i]()}),t&&(Vi[t]=r),e&&(Vi[e[0]]=function(){return j(r.apply(this,arguments),e[1],e[2])}),n&&(Vi[n]=function(){return this.localeData().ordinal(r.apply(this,arguments),t)})}function V(t){return t.match(/\[[\s\S]/)?t.replace(/^\[|\]$/g,""):t.replace(/\\/g,"")}function G(t){var e,n,i=t.match(Wi);for(e=0,n=i.length;e<n;e++)Vi[i[e]]?i[e]=Vi[i[e]]:i[e]=V(i[e]);return function(e){var r,o="";for(r=0;r<n;r++)o+=T(i[r])?i[r].call(e,t):i[r];return o}}function B(t,e){return t.isValid()?(e=U(e,t.localeData()),Fi[e]=Fi[e]||G(e),Fi[e](t)):t.localeData().invalidDate()}function U(t,e){function n(t){return e.longDateFormat(t)||t}var i=5;for(ji.lastIndex=0;i>=0&&ji.test(t);)t=t.replace(ji,n),ji.lastIndex=0,i-=1;return t}function H(t,e,n){sr[t]=T(e)?e:function(t,i){return t&&n?n:e}}function X(t,e){return h(sr,t)?sr[t](e._strict,e._locale):new RegExp(Z(t))}function Z(t){return q(t.replace("\\","").replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g,function(t,e,n,i,r){return e||n||i||r}))}function q(t){return t.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")}function $(t,e){var n,i=e;for("string"==typeof t&&(t=[t]),s(e)&&(i=function(t,n){n[e]=w(t)}),n=0;n<t.length;n++)ar[t[n]]=i}function J(t,e){$(t,function(t,n,i,r){i._w=i._w||{},e(t,i._w,i,r)})}function Q(t,e,n){null!=e&&h(ar,t)&&ar[t](e,n._a,n,t)}function K(t){return tt(t)?366:365}function tt(t){return t%4==0&&t%100!=0||t%400==0}function et(){return tt(this.year())}function nt(t,n){return function(i){return null!=i?(rt(this,t,i),e.updateOffset(this,n),this):it(this,t)}}function it(t,e){return t.isValid()?t._d["get"+(t._isUTC?"UTC":"")+e]():NaN}function rt(t,e,n){t.isValid()&&!isNaN(n)&&("FullYear"===e&&tt(t.year())?t._d["set"+(t._isUTC?"UTC":"")+e](n,t.month(),ut(n,t.month())):t._d["set"+(t._isUTC?"UTC":"")+e](n))}function ot(t){return t=I(t),T(this[t])?this[t]():this}function st(t,e){if("object"==typeof t){t=z(t);for(var n=W(t),i=0;i<n.length;i++)this[n[i].unit](t[n[i].unit])}else if(t=I(t),T(this[t]))return this[t](e);return this}function at(t,e){return(t%e+e)%e}function ut(t,e){if(isNaN(t)||isNaN(e))return NaN;var n=at(e,12);return t+=(e-n)/12,1===n?tt(t)?29:28:31-n%7%2}function ht(t,e){return t?n(this._months)?this._months[t.month()]:this._months[(this._months.isFormat||_r).test(e)?"format":"standalone"][t.month()]:n(this._months)?this._months:this._months.standalone}function lt(t,e){return t?n(this._monthsShort)?this._monthsShort[t.month()]:this._monthsShort[_r.test(e)?"format":"standalone"][t.month()]:n(this._monthsShort)?this._monthsShort:this._monthsShort.standalone}function ct(t,e,n){var i,r,o,s=t.toLocaleLowerCase();if(!this._monthsParse)for(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[],i=0;i<12;++i)o=c([2e3,i]),this._shortMonthsParse[i]=this.monthsShort(o,"").toLocaleLowerCase(),this._longMonthsParse[i]=this.months(o,"").toLocaleLowerCase();return n?"MMM"===e?(r=yr.call(this._shortMonthsParse,s),-1!==r?r:null):(r=yr.call(this._longMonthsParse,s),-1!==r?r:null):"MMM"===e?-1!==(r=yr.call(this._shortMonthsParse,s))?r:(r=yr.call(this._longMonthsParse,s),-1!==r?r:null):-1!==(r=yr.call(this._longMonthsParse,s))?r:(r=yr.call(this._shortMonthsParse,s),-1!==r?r:null)}function dt(t,e,n){var i,r,o;if(this._monthsParseExact)return ct.call(this,t,e,n);for(this._monthsParse||(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[]),i=0;i<12;i++){if(r=c([2e3,i]),n&&!this._longMonthsParse[i]&&(this._longMonthsParse[i]=new RegExp("^"+this.months(r,"").replace(".","")+"$","i"),this._shortMonthsParse[i]=new RegExp("^"+this.monthsShort(r,"").replace(".","")+"$","i")),n||this._monthsParse[i]||(o="^"+this.months(r,"")+"|^"+this.monthsShort(r,""),this._monthsParse[i]=new RegExp(o.replace(".",""),"i")),n&&"MMMM"===e&&this._longMonthsParse[i].test(t))return i;if(n&&"MMM"===e&&this._shortMonthsParse[i].test(t))return i;if(!n&&this._monthsParse[i].test(t))return i}}function ft(t,e){var n;if(!t.isValid())return t;if("string"==typeof e)if(/^\d+$/.test(e))e=w(e);else if(e=t.localeData().monthsParse(e),!s(e))return t;return n=Math.min(t.date(),ut(t.year(),e)),t._d["set"+(t._isUTC?"UTC":"")+"Month"](e,n),t}function pt(t){return null!=t?(ft(this,t),e.updateOffset(this,!0),this):it(this,"Month")}function mt(){return ut(this.year(),this.month())}function vt(t){return this._monthsParseExact?(h(this,"_monthsRegex")||gt.call(this),t?this._monthsShortStrictRegex:this._monthsShortRegex):(h(this,"_monthsShortRegex")||(this._monthsShortRegex=xr),this._monthsShortStrictRegex&&t?this._monthsShortStrictRegex:this._monthsShortRegex)}function yt(t){return this._monthsParseExact?(h(this,"_monthsRegex")||gt.call(this),t?this._monthsStrictRegex:this._monthsRegex):(h(this,"_monthsRegex")||(this._monthsRegex=Sr),this._monthsStrictRegex&&t?this._monthsStrictRegex:this._monthsRegex)}function gt(){function t(t,e){return e.length-t.length}var e,n,i=[],r=[],o=[];for(e=0;e<12;e++)n=c([2e3,e]),i.push(this.monthsShort(n,"")),r.push(this.months(n,"")),o.push(this.months(n,"")),o.push(this.monthsShort(n,""));for(i.sort(t),r.sort(t),o.sort(t),e=0;e<12;e++)i[e]=q(i[e]),r[e]=q(r[e]);for(e=0;e<24;e++)o[e]=q(o[e]);this._monthsRegex=new RegExp("^("+o.join("|")+")","i"),this._monthsShortRegex=this._monthsRegex,this._monthsStrictRegex=new RegExp("^("+r.join("|")+")","i"),this._monthsShortStrictRegex=new RegExp("^("+i.join("|")+")","i")}function _t(t,e,n,i,r,o,s){var a=new Date(t,e,n,i,r,o,s);return t<100&&t>=0&&isFinite(a.getFullYear())&&a.setFullYear(t),a}function wt(t){var e=new Date(Date.UTC.apply(null,arguments));return t<100&&t>=0&&isFinite(e.getUTCFullYear())&&e.setUTCFullYear(t),e}function bt(t,e,n){var i=7+e-n;return-(7+wt(t,0,i).getUTCDay()-e)%7+i-1}function xt(t,e,n,i,r){var o,s,a=(7+n-i)%7,u=bt(t,i,r),h=1+7*(e-1)+a+u;return h<=0?(o=t-1,s=K(o)+h):h>K(t)?(o=t+1,s=h-K(t)):(o=t,s=h),{year:o,dayOfYear:s}}function St(t,e,n){var i,r,o=bt(t.year(),e,n),s=Math.floor((t.dayOfYear()-o-1)/7)+1;return s<1?(r=t.year()-1,i=s+Mt(r,e,n)):s>Mt(t.year(),e,n)?(i=s-Mt(t.year(),e,n),r=t.year()+1):(r=t.year(),i=s),{week:i,year:r}}function Mt(t,e,n){var i=bt(t,e,n),r=bt(t+1,e,n);return(K(t)-i+r)/7}function Tt(t){return St(t,this._week.dow,this._week.doy).week}function Dt(){return this._week.dow}function kt(){return this._week.doy}function Ot(t){var e=this.localeData().week(this);return null==t?e:this.add(7*(t-e),"d")}function Et(t){var e=St(this,1,4).week;return null==t?e:this.add(7*(t-e),"d")}function Ct(t,e){return"string"!=typeof t?t:isNaN(t)?(t=e.weekdaysParse(t),"number"==typeof t?t:null):parseInt(t,10)}function Pt(t,e){return"string"==typeof t?e.weekdaysParse(t)%7||7:isNaN(t)?null:t}function Lt(t,e){return t?n(this._weekdays)?this._weekdays[t.day()]:this._weekdays[this._weekdays.isFormat.test(e)?"format":"standalone"][t.day()]:n(this._weekdays)?this._weekdays:this._weekdays.standalone}function Rt(t){return t?this._weekdaysShort[t.day()]:this._weekdaysShort}function At(t){return t?this._weekdaysMin[t.day()]:this._weekdaysMin}function Yt(t,e,n){var i,r,o,s=t.toLocaleLowerCase();if(!this._weekdaysParse)for(this._weekdaysParse=[],this._shortWeekdaysParse=[],this._minWeekdaysParse=[],i=0;i<7;++i)o=c([2e3,1]).day(i),this._minWeekdaysParse[i]=this.weekdaysMin(o,"").toLocaleLowerCase(),this._shortWeekdaysParse[i]=this.weekdaysShort(o,"").toLocaleLowerCase(),this._weekdaysParse[i]=this.weekdays(o,"").toLocaleLowerCase();return n?"dddd"===e?(r=yr.call(this._weekdaysParse,s),-1!==r?r:null):"ddd"===e?(r=yr.call(this._shortWeekdaysParse,s),-1!==r?r:null):(r=yr.call(this._minWeekdaysParse,s),-1!==r?r:null):"dddd"===e?-1!==(r=yr.call(this._weekdaysParse,s))?r:-1!==(r=yr.call(this._shortWeekdaysParse,s))?r:(r=yr.call(this._minWeekdaysParse,s),-1!==r?r:null):"ddd"===e?-1!==(r=yr.call(this._shortWeekdaysParse,s))?r:-1!==(r=yr.call(this._weekdaysParse,s))?r:(r=yr.call(this._minWeekdaysParse,s),-1!==r?r:null):-1!==(r=yr.call(this._minWeekdaysParse,s))?r:-1!==(r=yr.call(this._weekdaysParse,s))?r:(r=yr.call(this._shortWeekdaysParse,s),-1!==r?r:null)}function It(t,e,n){var i,r,o;if(this._weekdaysParseExact)return Yt.call(this,t,e,n);for(this._weekdaysParse||(this._weekdaysParse=[],this._minWeekdaysParse=[],this._shortWeekdaysParse=[],this._fullWeekdaysParse=[]),i=0;i<7;i++){if(r=c([2e3,1]).day(i),n&&!this._fullWeekdaysParse[i]&&(this._fullWeekdaysParse[i]=new RegExp("^"+this.weekdays(r,"").replace(".",".?")+"$","i"),this._shortWeekdaysParse[i]=new RegExp("^"+this.weekdaysShort(r,"").replace(".",".?")+"$","i"),this._minWeekdaysParse[i]=new RegExp("^"+this.weekdaysMin(r,"").replace(".",".?")+"$","i")),this._weekdaysParse[i]||(o="^"+this.weekdays(r,"")+"|^"+this.weekdaysShort(r,"")+"|^"+this.weekdaysMin(r,""),this._weekdaysParse[i]=new RegExp(o.replace(".",""),"i")),n&&"dddd"===e&&this._fullWeekdaysParse[i].test(t))return i;if(n&&"ddd"===e&&this._shortWeekdaysParse[i].test(t))return i;if(n&&"dd"===e&&this._minWeekdaysParse[i].test(t))return i;if(!n&&this._weekdaysParse[i].test(t))return i}}function zt(t){if(!this.isValid())return null!=t?this:NaN;var e=this._isUTC?this._d.getUTCDay():this._d.getDay();return null!=t?(t=Ct(t,this.localeData()),this.add(t-e,"d")):e}function Nt(t){if(!this.isValid())return null!=t?this:NaN;var e=(this.day()+7-this.localeData()._week.dow)%7;return null==t?e:this.add(t-e,"d")}function Wt(t){if(!this.isValid())return null!=t?this:NaN;if(null!=t){var e=Pt(t,this.localeData());return this.day(this.day()%7?e:e-7)}return this.day()||7}function jt(t){return this._weekdaysParseExact?(h(this,"_weekdaysRegex")||Gt.call(this),t?this._weekdaysStrictRegex:this._weekdaysRegex):(h(this,"_weekdaysRegex")||(this._weekdaysRegex=Or),this._weekdaysStrictRegex&&t?this._weekdaysStrictRegex:this._weekdaysRegex)}function Ft(t){return this._weekdaysParseExact?(h(this,"_weekdaysRegex")||Gt.call(this),t?this._weekdaysShortStrictRegex:this._weekdaysShortRegex):(h(this,"_weekdaysShortRegex")||(this._weekdaysShortRegex=Er),this._weekdaysShortStrictRegex&&t?this._weekdaysShortStrictRegex:this._weekdaysShortRegex)}function Vt(t){return this._weekdaysParseExact?(h(this,"_weekdaysRegex")||Gt.call(this),t?this._weekdaysMinStrictRegex:this._weekdaysMinRegex):(h(this,"_weekdaysMinRegex")||(this._weekdaysMinRegex=Cr),this._weekdaysMinStrictRegex&&t?this._weekdaysMinStrictRegex:this._weekdaysMinRegex)}function Gt(){function t(t,e){return e.length-t.length}var e,n,i,r,o,s=[],a=[],u=[],h=[];for(e=0;e<7;e++)n=c([2e3,1]).day(e),i=this.weekdaysMin(n,""),r=this.weekdaysShort(n,""),o=this.weekdays(n,""),s.push(i),a.push(r),u.push(o),h.push(i),h.push(r),h.push(o);for(s.sort(t),a.sort(t),u.sort(t),h.sort(t),e=0;e<7;e++)a[e]=q(a[e]),u[e]=q(u[e]),h[e]=q(h[e]);this._weekdaysRegex=new RegExp("^("+h.join("|")+")","i"),this._weekdaysShortRegex=this._weekdaysRegex,this._weekdaysMinRegex=this._weekdaysRegex,this._weekdaysStrictRegex=new RegExp("^("+u.join("|")+")","i"),this._weekdaysShortStrictRegex=new RegExp("^("+a.join("|")+")","i"),this._weekdaysMinStrictRegex=new RegExp("^("+s.join("|")+")","i")}function Bt(){return this.hours()%12||12}function Ut(){return this.hours()||24}function Ht(t,e){F(t,0,0,function(){return this.localeData().meridiem(this.hours(),this.minutes(),e)})}function Xt(t,e){return e._meridiemParse}function Zt(t){return"p"===(t+"").toLowerCase().charAt(0)}function qt(t,e,n){return t>11?n?"pm":"PM":n?"am":"AM"}function $t(t){return t?t.toLowerCase().replace("_","-"):t}function Jt(t){for(var e,n,i,r,o=0;o<t.length;){for(r=$t(t[o]).split("-"),e=r.length,n=$t(t[o+1]),n=n?n.split("-"):null;e>0;){if(i=Qt(r.slice(0,e).join("-")))return i;if(n&&n.length>=e&&b(r,n,!0)>=e-1)break;e--}o++}return null}function Qt(e){var n=null;if(!Yr[e]&&void 0!==t&&t&&t.exports)try{n=Pr._abbr;!function(){var t=new Error('Cannot find module "./locale"');throw t.code="MODULE_NOT_FOUND",t}(),Kt(n)}catch(t){}return Yr[e]}function Kt(t,e){var n;return t&&(n=o(e)?ne(t):te(t,e))&&(Pr=n),Pr._abbr}function te(t,e){if(null!==e){var n=Ar;if(e.abbr=t,null!=Yr[t])M("defineLocaleOverride","use moment.updateLocale(localeName, config) to change an existing locale. moment.defineLocale(localeName, config) should only be used for creating a new locale See http://momentjs.com/guides/#/warnings/define-locale/ for more info."),n=Yr[t]._config;else if(null!=e.parentLocale){if(null==Yr[e.parentLocale])return Ir[e.parentLocale]||(Ir[e.parentLocale]=[]),Ir[e.parentLocale].push({name:t,config:e}),null;n=Yr[e.parentLocale]._config}return Yr[t]=new O(k(n,e)),Ir[t]&&Ir[t].forEach(function(t){te(t.name,t.config)}),Kt(t),Yr[t]}return delete Yr[t],null}function ee(t,e){if(null!=e){var n,i=Ar;null!=Yr[t]&&(i=Yr[t]._config),e=k(i,e),n=new O(e),n.parentLocale=Yr[t],Yr[t]=n,Kt(t)}else null!=Yr[t]&&(null!=Yr[t].parentLocale?Yr[t]=Yr[t].parentLocale:null!=Yr[t]&&delete Yr[t]);return Yr[t]}function ne(t){var e;if(t&&t._locale&&t._locale._abbr&&(t=t._locale._abbr),!t)return Pr;if(!n(t)){if(e=Qt(t))return e;t=[t]}return Jt(t)}function ie(){return Li(Yr)}function re(t){var e,n=t._a;return n&&-2===f(t).overflow&&(e=n[hr]<0||n[hr]>11?hr:n[lr]<1||n[lr]>ut(n[ur],n[hr])?lr:n[cr]<0||n[cr]>24||24===n[cr]&&(0!==n[dr]||0!==n[fr]||0!==n[pr])?cr:n[dr]<0||n[dr]>59?dr:n[fr]<0||n[fr]>59?fr:n[pr]<0||n[pr]>999?pr:-1,f(t)._overflowDayOfYear&&(e<ur||e>lr)&&(e=lr),f(t)._overflowWeeks&&-1===e&&(e=mr),f(t)._overflowWeekday&&-1===e&&(e=vr),f(t).overflow=e),t}function oe(t,e,n){return null!=t?t:null!=e?e:n}function se(t){var n=new Date(e.now());return t._useUTC?[n.getUTCFullYear(),n.getUTCMonth(),n.getUTCDate()]:[n.getFullYear(),n.getMonth(),n.getDate()]}function ae(t){var e,n,i,r,o=[];if(!t._d){for(i=se(t),t._w&&null==t._a[lr]&&null==t._a[hr]&&ue(t),null!=t._dayOfYear&&(r=oe(t._a[ur],i[ur]),(t._dayOfYear>K(r)||0===t._dayOfYear)&&(f(t)._overflowDayOfYear=!0),n=wt(r,0,t._dayOfYear),t._a[hr]=n.getUTCMonth(),t._a[lr]=n.getUTCDate()),e=0;e<3&&null==t._a[e];++e)t._a[e]=o[e]=i[e];for(;e<7;e++)t._a[e]=o[e]=null==t._a[e]?2===e?1:0:t._a[e];24===t._a[cr]&&0===t._a[dr]&&0===t._a[fr]&&0===t._a[pr]&&(t._nextDay=!0,t._a[cr]=0),t._d=(t._useUTC?wt:_t).apply(null,o),null!=t._tzm&&t._d.setUTCMinutes(t._d.getUTCMinutes()-t._tzm),t._nextDay&&(t._a[cr]=24),t._w&&void 0!==t._w.d&&t._w.d!==t._d.getDay()&&(f(t).weekdayMismatch=!0)}}function ue(t){var e,n,i,r,o,s,a,u;if(e=t._w,null!=e.GG||null!=e.W||null!=e.E)o=1,s=4,n=oe(e.GG,t._a[ur],St(Te(),1,4).year),i=oe(e.W,1),((r=oe(e.E,1))<1||r>7)&&(u=!0);else{o=t._locale._week.dow,s=t._locale._week.doy;var h=St(Te(),o,s);n=oe(e.gg,t._a[ur],h.year),i=oe(e.w,h.week),null!=e.d?((r=e.d)<0||r>6)&&(u=!0):null!=e.e?(r=e.e+o,(e.e<0||e.e>6)&&(u=!0)):r=o}i<1||i>Mt(n,o,s)?f(t)._overflowWeeks=!0:null!=u?f(t)._overflowWeekday=!0:(a=xt(n,i,r,o,s),t._a[ur]=a.year,t._dayOfYear=a.dayOfYear)}function he(t){var e,n,i,r,o,s,a=t._i,u=zr.exec(a)||Nr.exec(a);if(u){for(f(t).iso=!0,e=0,n=jr.length;e<n;e++)if(jr[e][1].exec(u[1])){r=jr[e][0],i=!1!==jr[e][2];break}if(null==r)return void(t._isValid=!1);if(u[3]){for(e=0,n=Fr.length;e<n;e++)if(Fr[e][1].exec(u[3])){o=(u[2]||" ")+Fr[e][0];break}if(null==o)return void(t._isValid=!1)}if(!i&&null!=o)return void(t._isValid=!1);if(u[4]){if(!Wr.exec(u[4]))return void(t._isValid=!1);s="Z"}t._f=r+(o||"")+(s||""),ye(t)}else t._isValid=!1}function le(t,e,n,i,r,o){var s=[ce(t),br.indexOf(e),parseInt(n,10),parseInt(i,10),parseInt(r,10)];return o&&s.push(parseInt(o,10)),s}function ce(t){var e=parseInt(t,10);return e<=49?2e3+e:e<=999?1900+e:e}function de(t){return t.replace(/\([^)]*\)|[\n\t]/g," ").replace(/(\s\s+)/g," ").trim()}function fe(t,e,n){if(t){if(Dr.indexOf(t)!==new Date(e[0],e[1],e[2]).getDay())return f(n).weekdayMismatch=!0,n._isValid=!1,!1}return!0}function pe(t,e,n){if(t)return Br[t];if(e)return 0;var i=parseInt(n,10),r=i%100;return(i-r)/100*60+r}function me(t){var e=Gr.exec(de(t._i));if(e){var n=le(e[4],e[3],e[2],e[5],e[6],e[7]);if(!fe(e[1],n,t))return;t._a=n,t._tzm=pe(e[8],e[9],e[10]),t._d=wt.apply(null,t._a),t._d.setUTCMinutes(t._d.getUTCMinutes()-t._tzm),f(t).rfc2822=!0}else t._isValid=!1}function ve(t){var n=Vr.exec(t._i);if(null!==n)return void(t._d=new Date(+n[1]));he(t),!1===t._isValid&&(delete t._isValid,me(t),!1===t._isValid&&(delete t._isValid,e.createFromInputFallback(t)))}function ye(t){if(t._f===e.ISO_8601)return void he(t);if(t._f===e.RFC_2822)return void me(t);t._a=[],f(t).empty=!0;var n,i,r,o,s,a=""+t._i,u=a.length,h=0;for(r=U(t._f,t._locale).match(Wi)||[],n=0;n<r.length;n++)o=r[n],i=(a.match(X(o,t))||[])[0],i&&(s=a.substr(0,a.indexOf(i)),s.length>0&&f(t).unusedInput.push(s),a=a.slice(a.indexOf(i)+i.length),h+=i.length),Vi[o]?(i?f(t).empty=!1:f(t).unusedTokens.push(o),Q(o,i,t)):t._strict&&!i&&f(t).unusedTokens.push(o);f(t).charsLeftOver=u-h,a.length>0&&f(t).unusedInput.push(a),t._a[cr]<=12&&!0===f(t).bigHour&&t._a[cr]>0&&(f(t).bigHour=void 0),f(t).parsedDateParts=t._a.slice(0),f(t).meridiem=t._meridiem,t._a[cr]=ge(t._locale,t._a[cr],t._meridiem),ae(t),re(t)}function ge(t,e,n){var i;return null==n?e:null!=t.meridiemHour?t.meridiemHour(e,n):null!=t.isPM?(i=t.isPM(n),i&&e<12&&(e+=12),i||12!==e||(e=0),e):e}function _e(t){var e,n,i,r,o;if(0===t._f.length)return f(t).invalidFormat=!0,void(t._d=new Date(NaN));for(r=0;r<t._f.length;r++)o=0,e=v({},t),null!=t._useUTC&&(e._useUTC=t._useUTC),e._f=t._f[r],ye(e),p(e)&&(o+=f(e).charsLeftOver,o+=10*f(e).unusedTokens.length,f(e).score=o,(null==i||o<i)&&(i=o,n=e));l(t,n||e)}function we(t){if(!t._d){var e=z(t._i);t._a=u([e.year,e.month,e.day||e.date,e.hour,e.minute,e.second,e.millisecond],function(t){return t&&parseInt(t,10)}),ae(t)}}function be(t){var e=new y(re(xe(t)));return e._nextDay&&(e.add(1,"d"),e._nextDay=void 0),e}function xe(t){var e=t._i,i=t._f;return t._locale=t._locale||ne(t._l),null===e||void 0===i&&""===e?m({nullInput:!0}):("string"==typeof e&&(t._i=e=t._locale.preparse(e)),g(e)?new y(re(e)):(a(e)?t._d=e:n(i)?_e(t):i?ye(t):Se(t),p(t)||(t._d=null),t))}function Se(t){var r=t._i;o(r)?t._d=new Date(e.now()):a(r)?t._d=new Date(r.valueOf()):"string"==typeof r?ve(t):n(r)?(t._a=u(r.slice(0),function(t){return parseInt(t,10)}),ae(t)):i(r)?we(t):s(r)?t._d=new Date(r):e.createFromInputFallback(t)}function Me(t,e,o,s,a){var u={};return!0!==o&&!1!==o||(s=o,o=void 0),(i(t)&&r(t)||n(t)&&0===t.length)&&(t=void 0),u._isAMomentObject=!0,u._useUTC=u._isUTC=a,u._l=o,u._i=t,u._f=e,u._strict=s,be(u)}function Te(t,e,n,i){return Me(t,e,n,i,!1)}function De(t,e){var i,r;if(1===e.length&&n(e[0])&&(e=e[0]),!e.length)return Te();for(i=e[0],r=1;r<e.length;++r)e[r].isValid()&&!e[r][t](i)||(i=e[r]);return i}function ke(){return De("isBefore",[].slice.call(arguments,0))}function Oe(){return De("isAfter",[].slice.call(arguments,0))}function Ee(t){for(var e in t)if(-1===yr.call(Zr,e)||null!=t[e]&&isNaN(t[e]))return!1;for(var n=!1,i=0;i<Zr.length;++i)if(t[Zr[i]]){if(n)return!1;parseFloat(t[Zr[i]])!==w(t[Zr[i]])&&(n=!0)}return!0}function Ce(){return this._isValid}function Pe(){return $e(NaN)}function Le(t){var e=z(t),n=e.year||0,i=e.quarter||0,r=e.month||0,o=e.week||0,s=e.day||0,a=e.hour||0,u=e.minute||0,h=e.second||0,l=e.millisecond||0;this._isValid=Ee(e),this._milliseconds=+l+1e3*h+6e4*u+1e3*a*60*60,this._days=+s+7*o,this._months=+r+3*i+12*n,this._data={},this._locale=ne(),this._bubble()}function Re(t){return t instanceof Le}function Ae(t){return t<0?-1*Math.round(-1*t):Math.round(t)}function Ye(t,e){F(t,0,0,function(){var t=this.utcOffset(),n="+";return t<0&&(t=-t,n="-"),n+j(~~(t/60),2)+e+j(~~t%60,2)})}function Ie(t,e){var n=(e||"").match(t);if(null===n)return null;var i=n[n.length-1]||[],r=(i+"").match(qr)||["-",0,0],o=60*r[1]+w(r[2]);return 0===o?0:"+"===r[0]?o:-o}function ze(t,n){var i,r;return n._isUTC?(i=n.clone(),r=(g(t)||a(t)?t.valueOf():Te(t).valueOf())-i.valueOf(),i._d.setTime(i._d.valueOf()+r),e.updateOffset(i,!1),i):Te(t).local()}function Ne(t){return 15*-Math.round(t._d.getTimezoneOffset()/15)}function We(t,n,i){var r,o=this._offset||0;if(!this.isValid())return null!=t?this:NaN;if(null!=t){if("string"==typeof t){if(null===(t=Ie(ir,t)))return this}else Math.abs(t)<16&&!i&&(t*=60);return!this._isUTC&&n&&(r=Ne(this)),this._offset=t,this._isUTC=!0,null!=r&&this.add(r,"m"),o!==t&&(!n||this._changeInProgress?en(this,$e(t-o,"m"),1,!1):this._changeInProgress||(this._changeInProgress=!0,e.updateOffset(this,!0),this._changeInProgress=null)),this}return this._isUTC?o:Ne(this)}function je(t,e){return null!=t?("string"!=typeof t&&(t=-t),this.utcOffset(t,e),this):-this.utcOffset()}function Fe(t){return this.utcOffset(0,t)}function Ve(t){return this._isUTC&&(this.utcOffset(0,t),this._isUTC=!1,t&&this.subtract(Ne(this),"m")),this}function Ge(){if(null!=this._tzm)this.utcOffset(this._tzm,!1,!0);else if("string"==typeof this._i){var t=Ie(nr,this._i);null!=t?this.utcOffset(t):this.utcOffset(0,!0)}return this}function Be(t){return!!this.isValid()&&(t=t?Te(t).utcOffset():0,(this.utcOffset()-t)%60==0)}function Ue(){return this.utcOffset()>this.clone().month(0).utcOffset()||this.utcOffset()>this.clone().month(5).utcOffset()}function He(){if(!o(this._isDSTShifted))return this._isDSTShifted;var t={};if(v(t,this),t=xe(t),t._a){var e=t._isUTC?c(t._a):Te(t._a);this._isDSTShifted=this.isValid()&&b(t._a,e.toArray())>0}else this._isDSTShifted=!1;return this._isDSTShifted}function Xe(){return!!this.isValid()&&!this._isUTC}function Ze(){return!!this.isValid()&&this._isUTC}function qe(){return!!this.isValid()&&(this._isUTC&&0===this._offset)}function $e(t,e){var n,i,r,o=t,a=null;return Re(t)?o={ms:t._milliseconds,d:t._days,M:t._months}:s(t)?(o={},e?o[e]=t:o.milliseconds=t):(a=$r.exec(t))?(n="-"===a[1]?-1:1,o={y:0,d:w(a[lr])*n,h:w(a[cr])*n,m:w(a[dr])*n,s:w(a[fr])*n,ms:w(Ae(1e3*a[pr]))*n}):(a=Jr.exec(t))?(n="-"===a[1]?-1:(a[1],1),o={y:Je(a[2],n),M:Je(a[3],n),w:Je(a[4],n),d:Je(a[5],n),h:Je(a[6],n),m:Je(a[7],n),s:Je(a[8],n)}):null==o?o={}:"object"==typeof o&&("from"in o||"to"in o)&&(r=Ke(Te(o.from),Te(o.to)),o={},o.ms=r.milliseconds,o.M=r.months),i=new Le(o),Re(t)&&h(t,"_locale")&&(i._locale=t._locale),i}function Je(t,e){var n=t&&parseFloat(t.replace(",","."));return(isNaN(n)?0:n)*e}function Qe(t,e){var n={milliseconds:0,months:0};return n.months=e.month()-t.month()+12*(e.year()-t.year()),t.clone().add(n.months,"M").isAfter(e)&&--n.months,n.milliseconds=+e-+t.clone().add(n.months,"M"),n}function Ke(t,e){var n;return t.isValid()&&e.isValid()?(e=ze(e,t),t.isBefore(e)?n=Qe(t,e):(n=Qe(e,t),n.milliseconds=-n.milliseconds,n.months=-n.months),n):{milliseconds:0,months:0}}function tn(t,e){return function(n,i){var r,o;return null===i||isNaN(+i)||(M(e,"moment()."+e+"(period, number) is deprecated. Please use moment()."+e+"(number, period). See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info."),o=n,n=i,i=o),n="string"==typeof n?+n:n,r=$e(n,i),en(this,r,t),this}}function en(t,n,i,r){var o=n._milliseconds,s=Ae(n._days),a=Ae(n._months);t.isValid()&&(r=null==r||r,a&&ft(t,it(t,"Month")+a*i),s&&rt(t,"Date",it(t,"Date")+s*i),o&&t._d.setTime(t._d.valueOf()+o*i),r&&e.updateOffset(t,s||a))}function nn(t,e){var n=t.diff(e,"days",!0);return n<-6?"sameElse":n<-1?"lastWeek":n<0?"lastDay":n<1?"sameDay":n<2?"nextDay":n<7?"nextWeek":"sameElse"}function rn(t,n){var i=t||Te(),r=ze(i,this).startOf("day"),o=e.calendarFormat(this,r)||"sameElse",s=n&&(T(n[o])?n[o].call(this,i):n[o]);return this.format(s||this.localeData().calendar(o,this,Te(i)))}function on(){return new y(this)}function sn(t,e){var n=g(t)?t:Te(t);return!(!this.isValid()||!n.isValid())&&(e=I(o(e)?"millisecond":e),"millisecond"===e?this.valueOf()>n.valueOf():n.valueOf()<this.clone().startOf(e).valueOf())}function an(t,e){var n=g(t)?t:Te(t);return!(!this.isValid()||!n.isValid())&&(e=I(o(e)?"millisecond":e),"millisecond"===e?this.valueOf()<n.valueOf():this.clone().endOf(e).valueOf()<n.valueOf())}function un(t,e,n,i){return i=i||"()",("("===i[0]?this.isAfter(t,n):!this.isBefore(t,n))&&(")"===i[1]?this.isBefore(e,n):!this.isAfter(e,n))}function hn(t,e){var n,i=g(t)?t:Te(t);return!(!this.isValid()||!i.isValid())&&(e=I(e||"millisecond"),"millisecond"===e?this.valueOf()===i.valueOf():(n=i.valueOf(),this.clone().startOf(e).valueOf()<=n&&n<=this.clone().endOf(e).valueOf()))}function ln(t,e){return this.isSame(t,e)||this.isAfter(t,e)}function cn(t,e){return this.isSame(t,e)||this.isBefore(t,e)}function dn(t,e,n){var i,r,o;if(!this.isValid())return NaN;if(i=ze(t,this),!i.isValid())return NaN;switch(r=6e4*(i.utcOffset()-this.utcOffset()),e=I(e)){case"year":o=fn(this,i)/12;break;case"month":o=fn(this,i);break;case"quarter":o=fn(this,i)/3;break;case"second":o=(this-i)/1e3;break;case"minute":o=(this-i)/6e4;break;case"hour":o=(this-i)/36e5;break;case"day":o=(this-i-r)/864e5;break;case"week":o=(this-i-r)/6048e5;break;default:o=this-i}return n?o:_(o)}function fn(t,e){var n,i,r=12*(e.year()-t.year())+(e.month()-t.month()),o=t.clone().add(r,"months");return e-o<0?(n=t.clone().add(r-1,"months"),i=(e-o)/(o-n)):(n=t.clone().add(r+1,"months"),i=(e-o)/(n-o)),-(r+i)||0}function pn(){return this.clone().locale("en").format("ddd MMM DD YYYY HH:mm:ss [GMT]ZZ")}function mn(){if(!this.isValid())return null;var t=this.clone().utc();return t.year()<0||t.year()>9999?B(t,"YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]"):T(Date.prototype.toISOString)?this.toDate().toISOString():B(t,"YYYY-MM-DD[T]HH:mm:ss.SSS[Z]")}function vn(){if(!this.isValid())return"moment.invalid(/* "+this._i+" */)";var t="moment",e="";this.isLocal()||(t=0===this.utcOffset()?"moment.utc":"moment.parseZone",e="Z");var n="["+t+'("]',i=0<=this.year()&&this.year()<=9999?"YYYY":"YYYYYY",r=e+'[")]';return this.format(n+i+"-MM-DD[T]HH:mm:ss.SSS"+r)}function yn(t){t||(t=this.isUtc()?e.defaultFormatUtc:e.defaultFormat);var n=B(this,t);return this.localeData().postformat(n)}function gn(t,e){return this.isValid()&&(g(t)&&t.isValid()||Te(t).isValid())?$e({to:this,from:t}).locale(this.locale()).humanize(!e):this.localeData().invalidDate()}function _n(t){return this.from(Te(),t)}function wn(t,e){return this.isValid()&&(g(t)&&t.isValid()||Te(t).isValid())?$e({from:this,to:t}).locale(this.locale()).humanize(!e):this.localeData().invalidDate()}function bn(t){return this.to(Te(),t)}function xn(t){var e;return void 0===t?this._locale._abbr:(e=ne(t),null!=e&&(this._locale=e),this)}function Sn(){return this._locale}function Mn(t){switch(t=I(t)){case"year":this.month(0);case"quarter":case"month":this.date(1);case"week":case"isoWeek":case"day":case"date":this.hours(0);case"hour":this.minutes(0);case"minute":this.seconds(0);case"second":this.milliseconds(0)}return"week"===t&&this.weekday(0),"isoWeek"===t&&this.isoWeekday(1),"quarter"===t&&this.month(3*Math.floor(this.month()/3)),this}function Tn(t){return void 0===(t=I(t))||"millisecond"===t?this:("date"===t&&(t="day"),this.startOf(t).add(1,"isoWeek"===t?"week":t).subtract(1,"ms"))}function Dn(){return this._d.valueOf()-6e4*(this._offset||0)}function kn(){return Math.floor(this.valueOf()/1e3)}function On(){return new Date(this.valueOf())}function En(){var t=this;return[t.year(),t.month(),t.date(),t.hour(),t.minute(),t.second(),t.millisecond()]}function Cn(){var t=this;return{years:t.year(),months:t.month(),date:t.date(),hours:t.hours(),minutes:t.minutes(),seconds:t.seconds(),milliseconds:t.milliseconds()}}function Pn(){return this.isValid()?this.toISOString():null}function Ln(){return p(this)}function Rn(){return l({},f(this))}function An(){return f(this).overflow}function Yn(){return{input:this._i,format:this._f,locale:this._locale,isUTC:this._isUTC,strict:this._strict}}function In(t,e){F(0,[t,t.length],0,e)}function zn(t){return Fn.call(this,t,this.week(),this.weekday(),this.localeData()._week.dow,this.localeData()._week.doy)}function Nn(t){return Fn.call(this,t,this.isoWeek(),this.isoWeekday(),1,4)}function Wn(){return Mt(this.year(),1,4)}function jn(){var t=this.localeData()._week;return Mt(this.year(),t.dow,t.doy)}function Fn(t,e,n,i,r){var o;return null==t?St(this,i,r).year:(o=Mt(t,i,r),e>o&&(e=o),Vn.call(this,t,e,n,i,r))}function Vn(t,e,n,i,r){var o=xt(t,e,n,i,r),s=wt(o.year,0,o.dayOfYear);return this.year(s.getUTCFullYear()),this.month(s.getUTCMonth()),this.date(s.getUTCDate()),this}function Gn(t){return null==t?Math.ceil((this.month()+1)/3):this.month(3*(t-1)+this.month()%3)}function Bn(t){var e=Math.round((this.clone().startOf("day")-this.clone().startOf("year"))/864e5)+1;return null==t?e:this.add(t-e,"d")}function Un(t,e){e[pr]=w(1e3*("0."+t))}function Hn(){return this._isUTC?"UTC":""}function Xn(){return this._isUTC?"Coordinated Universal Time":""}function Zn(t){return Te(1e3*t)}function qn(){return Te.apply(null,arguments).parseZone()}function $n(t){return t}function Jn(t,e,n,i){var r=ne(),o=c().set(i,e);return r[n](o,t)}function Qn(t,e,n){if(s(t)&&(e=t,t=void 0),t=t||"",null!=e)return Jn(t,e,n,"month");var i,r=[];for(i=0;i<12;i++)r[i]=Jn(t,i,n,"month");return r}function Kn(t,e,n,i){"boolean"==typeof t?(s(e)&&(n=e,e=void 0),e=e||""):(e=t,n=e,t=!1,s(e)&&(n=e,e=void 0),e=e||"");var r=ne(),o=t?r._week.dow:0;if(null!=n)return Jn(e,(n+o)%7,i,"day");var a,u=[];for(a=0;a<7;a++)u[a]=Jn(e,(a+o)%7,i,"day");return u}function ti(t,e){return Qn(t,e,"months")}function ei(t,e){return Qn(t,e,"monthsShort")}function ni(t,e,n){return Kn(t,e,n,"weekdays")}function ii(t,e,n){return Kn(t,e,n,"weekdaysShort")}function ri(t,e,n){return Kn(t,e,n,"weekdaysMin")}function oi(){var t=this._data;return this._milliseconds=uo(this._milliseconds),this._days=uo(this._days),this._months=uo(this._months),t.milliseconds=uo(t.milliseconds),t.seconds=uo(t.seconds),t.minutes=uo(t.minutes),t.hours=uo(t.hours),t.months=uo(t.months),t.years=uo(t.years),this}function si(t,e,n,i){var r=$e(e,n);return t._milliseconds+=i*r._milliseconds,t._days+=i*r._days,t._months+=i*r._months,t._bubble()}function ai(t,e){return si(this,t,e,1)}function ui(t,e){return si(this,t,e,-1)}function hi(t){return t<0?Math.floor(t):Math.ceil(t)}function li(){var t,e,n,i,r,o=this._milliseconds,s=this._days,a=this._months,u=this._data;return o>=0&&s>=0&&a>=0||o<=0&&s<=0&&a<=0||(o+=864e5*hi(di(a)+s),s=0,a=0),u.milliseconds=o%1e3,t=_(o/1e3),u.seconds=t%60,e=_(t/60),u.minutes=e%60,n=_(e/60),u.hours=n%24,s+=_(n/24),r=_(ci(s)),a+=r,s-=hi(di(r)),i=_(a/12),a%=12,u.days=s,u.months=a,u.years=i,this}function ci(t){return 4800*t/146097}function di(t){return 146097*t/4800}function fi(t){if(!this.isValid())return NaN;var e,n,i=this._milliseconds;if("month"===(t=I(t))||"year"===t)return e=this._days+i/864e5,n=this._months+ci(e),"month"===t?n:n/12;switch(e=this._days+Math.round(di(this._months)),t){case"week":return e/7+i/6048e5;case"day":return e+i/864e5;case"hour":return 24*e+i/36e5;case"minute":return 1440*e+i/6e4;case"second":return 86400*e+i/1e3;case"millisecond":return Math.floor(864e5*e)+i;default:throw new Error("Unknown unit "+t)}}function pi(){return this.isValid()?this._milliseconds+864e5*this._days+this._months%12*2592e6+31536e6*w(this._months/12):NaN}function mi(t){return function(){return this.as(t)}}function vi(){return $e(this)}function yi(t){return t=I(t),this.isValid()?this[t+"s"]():NaN}function gi(t){return function(){return this.isValid()?this._data[t]:NaN}}function _i(){return _(this.days()/7)}function wi(t,e,n,i,r){return r.relativeTime(e||1,!!n,t,i)}function bi(t,e,n){var i=$e(t).abs(),r=To(i.as("s")),o=To(i.as("m")),s=To(i.as("h")),a=To(i.as("d")),u=To(i.as("M")),h=To(i.as("y")),l=r<=Do.ss&&["s",r]||r<Do.s&&["ss",r]||o<=1&&["m"]||o<Do.m&&["mm",o]||s<=1&&["h"]||s<Do.h&&["hh",s]||a<=1&&["d"]||a<Do.d&&["dd",a]||u<=1&&["M"]||u<Do.M&&["MM",u]||h<=1&&["y"]||["yy",h];return l[2]=e,l[3]=+t>0,l[4]=n,wi.apply(null,l)}function xi(t){return void 0===t?To:"function"==typeof t&&(To=t,!0)}function Si(t,e){return void 0!==Do[t]&&(void 0===e?Do[t]:(Do[t]=e,"s"===t&&(Do.ss=e-1),!0))}function Mi(t){if(!this.isValid())return this.localeData().invalidDate();var e=this.localeData(),n=bi(this,!t,e);return t&&(n=e.pastFuture(+this,n)),e.postformat(n)}function Ti(t){return(t>0)-(t<0)||+t}function Di(){if(!this.isValid())return this.localeData().invalidDate();var t,e,n,i=ko(this._milliseconds)/1e3,r=ko(this._days),o=ko(this._months);t=_(i/60),e=_(t/60),i%=60,t%=60,n=_(o/12),o%=12;var s=n,a=o,u=r,h=e,l=t,c=i?i.toFixed(3).replace(/\.?0+$/,""):"",d=this.asSeconds();if(!d)return"P0D";var f=d<0?"-":"",p=Ti(this._months)!==Ti(d)?"-":"",m=Ti(this._days)!==Ti(d)?"-":"",v=Ti(this._milliseconds)!==Ti(d)?"-":"";return f+"P"+(s?p+s+"Y":"")+(a?p+a+"M":"")+(u?m+u+"D":"")+(h||l||c?"T":"")+(h?v+h+"H":"")+(l?v+l+"M":"")+(c?v+c+"S":"")}var ki,Oi;Oi=Array.prototype.some?Array.prototype.some:function(t){for(var e=Object(this),n=e.length>>>0,i=0;i<n;i++)if(i in e&&t.call(this,e[i],i,e))return!0;return!1};var Ei=e.momentProperties=[],Ci=!1,Pi={};e.suppressDeprecationWarnings=!1,e.deprecationHandler=null;var Li;Li=Object.keys?Object.keys:function(t){var e,n=[];for(e in t)h(t,e)&&n.push(e);return n};var Ri={sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},Ai={LTS:"h:mm:ss A",LT:"h:mm A",L:"MM/DD/YYYY",LL:"MMMM D, YYYY",LLL:"MMMM D, YYYY h:mm A",LLLL:"dddd, MMMM D, YYYY h:mm A"},Yi=/\d{1,2}/,Ii={future:"in %s",past:"%s ago",s:"a few seconds",ss:"%d seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},zi={},Ni={},Wi=/(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g,ji=/(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g,Fi={},Vi={},Gi=/\d/,Bi=/\d\d/,Ui=/\d{3}/,Hi=/\d{4}/,Xi=/[+-]?\d{6}/,Zi=/\d\d?/,qi=/\d\d\d\d?/,$i=/\d\d\d\d\d\d?/,Ji=/\d{1,3}/,Qi=/\d{1,4}/,Ki=/[+-]?\d{1,6}/,tr=/\d+/,er=/[+-]?\d+/,nr=/Z|[+-]\d\d:?\d\d/gi,ir=/Z|[+-]\d\d(?::?\d\d)?/gi,rr=/[+-]?\d+(\.\d{1,3})?/,or=/[0-9]*['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+|[\u0600-\u06FF\/]+(\s*?[\u0600-\u06FF]+){1,2}/i,sr={},ar={},ur=0,hr=1,lr=2,cr=3,dr=4,fr=5,pr=6,mr=7,vr=8;F("Y",0,0,function(){var t=this.year();return t<=9999?""+t:"+"+t}),F(0,["YY",2],0,function(){return this.year()%100}),F(0,["YYYY",4],0,"year"),F(0,["YYYYY",5],0,"year"),F(0,["YYYYYY",6,!0],0,"year"),Y("year","y"),N("year",1),H("Y",er),H("YY",Zi,Bi),H("YYYY",Qi,Hi),H("YYYYY",Ki,Xi),H("YYYYYY",Ki,Xi),$(["YYYYY","YYYYYY"],ur),$("YYYY",function(t,n){n[ur]=2===t.length?e.parseTwoDigitYear(t):w(t)}),$("YY",function(t,n){n[ur]=e.parseTwoDigitYear(t)}),$("Y",function(t,e){e[ur]=parseInt(t,10)}),e.parseTwoDigitYear=function(t){return w(t)+(w(t)>68?1900:2e3)};var yr,gr=nt("FullYear",!0);yr=Array.prototype.indexOf?Array.prototype.indexOf:function(t){var e;for(e=0;e<this.length;++e)if(this[e]===t)return e;return-1},F("M",["MM",2],"Mo",function(){return this.month()+1}),F("MMM",0,0,function(t){return this.localeData().monthsShort(this,t)}),F("MMMM",0,0,function(t){return this.localeData().months(this,t)}),Y("month","M"),N("month",8),H("M",Zi),H("MM",Zi,Bi),H("MMM",function(t,e){return e.monthsShortRegex(t)}),H("MMMM",function(t,e){return e.monthsRegex(t)}),$(["M","MM"],function(t,e){e[hr]=w(t)-1}),$(["MMM","MMMM"],function(t,e,n,i){var r=n._locale.monthsParse(t,i,n._strict);null!=r?e[hr]=r:f(n).invalidMonth=t});var _r=/D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/,wr="January_February_March_April_May_June_July_August_September_October_November_December".split("_"),br="Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),xr=or,Sr=or;F("w",["ww",2],"wo","week"),F("W",["WW",2],"Wo","isoWeek"),Y("week","w"),Y("isoWeek","W"),N("week",5),N("isoWeek",5),H("w",Zi),H("ww",Zi,Bi),H("W",Zi),H("WW",Zi,Bi),J(["w","ww","W","WW"],function(t,e,n,i){e[i.substr(0,1)]=w(t)});var Mr={dow:0,doy:6};F("d",0,"do","day"),F("dd",0,0,function(t){return this.localeData().weekdaysMin(this,t)}),F("ddd",0,0,function(t){return this.localeData().weekdaysShort(this,t)}),F("dddd",0,0,function(t){return this.localeData().weekdays(this,t)}),F("e",0,0,"weekday"),F("E",0,0,"isoWeekday"),Y("day","d"),Y("weekday","e"),Y("isoWeekday","E"),N("day",11),N("weekday",11),N("isoWeekday",11),H("d",Zi),H("e",Zi),H("E",Zi),H("dd",function(t,e){return e.weekdaysMinRegex(t)}),H("ddd",function(t,e){return e.weekdaysShortRegex(t)}),H("dddd",function(t,e){return e.weekdaysRegex(t)}),J(["dd","ddd","dddd"],function(t,e,n,i){var r=n._locale.weekdaysParse(t,i,n._strict);null!=r?e.d=r:f(n).invalidWeekday=t}),J(["d","e","E"],function(t,e,n,i){e[i]=w(t)});var Tr="Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),Dr="Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),kr="Su_Mo_Tu_We_Th_Fr_Sa".split("_"),Or=or,Er=or,Cr=or;F("H",["HH",2],0,"hour"),F("h",["hh",2],0,Bt),F("k",["kk",2],0,Ut),F("hmm",0,0,function(){return""+Bt.apply(this)+j(this.minutes(),2)}),F("hmmss",0,0,function(){return""+Bt.apply(this)+j(this.minutes(),2)+j(this.seconds(),2)}),F("Hmm",0,0,function(){return""+this.hours()+j(this.minutes(),2)}),F("Hmmss",0,0,function(){return""+this.hours()+j(this.minutes(),2)+j(this.seconds(),2)}),Ht("a",!0),Ht("A",!1),Y("hour","h"),N("hour",13),H("a",Xt),H("A",Xt),H("H",Zi),H("h",Zi),H("k",Zi),H("HH",Zi,Bi),H("hh",Zi,Bi),H("kk",Zi,Bi),H("hmm",qi),H("hmmss",$i),H("Hmm",qi),H("Hmmss",$i),$(["H","HH"],cr),$(["k","kk"],function(t,e,n){var i=w(t);e[cr]=24===i?0:i}),$(["a","A"],function(t,e,n){n._isPm=n._locale.isPM(t),n._meridiem=t}),$(["h","hh"],function(t,e,n){e[cr]=w(t),f(n).bigHour=!0}),$("hmm",function(t,e,n){var i=t.length-2;e[cr]=w(t.substr(0,i)),e[dr]=w(t.substr(i)),f(n).bigHour=!0}),$("hmmss",function(t,e,n){var i=t.length-4,r=t.length-2;e[cr]=w(t.substr(0,i)),e[dr]=w(t.substr(i,2)),e[fr]=w(t.substr(r)),f(n).bigHour=!0}),$("Hmm",function(t,e,n){var i=t.length-2;e[cr]=w(t.substr(0,i)),e[dr]=w(t.substr(i))}),$("Hmmss",function(t,e,n){var i=t.length-4,r=t.length-2;e[cr]=w(t.substr(0,i)),e[dr]=w(t.substr(i,2)),e[fr]=w(t.substr(r))});var Pr,Lr=/[ap]\.?m?\.?/i,Rr=nt("Hours",!0),Ar={calendar:Ri,longDateFormat:Ai,invalidDate:"Invalid date",ordinal:"%d",dayOfMonthOrdinalParse:Yi,relativeTime:Ii,months:wr,monthsShort:br,week:Mr,weekdays:Tr,weekdaysMin:kr,weekdaysShort:Dr,meridiemParse:Lr},Yr={},Ir={},zr=/^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/,Nr=/^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/,Wr=/Z|[+-]\d\d(?::?\d\d)?/,jr=[["YYYYYY-MM-DD",/[+-]\d{6}-\d\d-\d\d/],["YYYY-MM-DD",/\d{4}-\d\d-\d\d/],["GGGG-[W]WW-E",/\d{4}-W\d\d-\d/],["GGGG-[W]WW",/\d{4}-W\d\d/,!1],["YYYY-DDD",/\d{4}-\d{3}/],["YYYY-MM",/\d{4}-\d\d/,!1],["YYYYYYMMDD",/[+-]\d{10}/],["YYYYMMDD",/\d{8}/],["GGGG[W]WWE",/\d{4}W\d{3}/],["GGGG[W]WW",/\d{4}W\d{2}/,!1],["YYYYDDD",/\d{7}/]],Fr=[["HH:mm:ss.SSSS",/\d\d:\d\d:\d\d\.\d+/],["HH:mm:ss,SSSS",/\d\d:\d\d:\d\d,\d+/],["HH:mm:ss",/\d\d:\d\d:\d\d/],["HH:mm",/\d\d:\d\d/],["HHmmss.SSSS",/\d\d\d\d\d\d\.\d+/],["HHmmss,SSSS",/\d\d\d\d\d\d,\d+/],["HHmmss",/\d\d\d\d\d\d/],["HHmm",/\d\d\d\d/],["HH",/\d\d/]],Vr=/^\/?Date\((\-?\d+)/i,Gr=/^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\s)?(\d{1,2})\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(\d{2,4})\s(\d\d):(\d\d)(?::(\d\d))?\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|([+-]\d{4}))$/,Br={UT:0,GMT:0,EDT:-240,EST:-300,CDT:-300,CST:-360,MDT:-360,MST:-420,PDT:-420,PST:-480};e.createFromInputFallback=S("value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are discouraged and will be removed in an upcoming major release. Please refer to http://momentjs.com/guides/#/warnings/js-date/ for more info.",function(t){t._d=new Date(t._i+(t._useUTC?" UTC":""))}),e.ISO_8601=function(){},e.RFC_2822=function(){};var Ur=S("moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/",function(){var t=Te.apply(null,arguments);return this.isValid()&&t.isValid()?t<this?this:t:m()}),Hr=S("moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/",function(){var t=Te.apply(null,arguments);return this.isValid()&&t.isValid()?t>this?this:t:m()}),Xr=function(){return Date.now?Date.now():+new Date},Zr=["year","quarter","month","week","day","hour","minute","second","millisecond"];Ye("Z",":"),Ye("ZZ",""),H("Z",ir),H("ZZ",ir),$(["Z","ZZ"],function(t,e,n){n._useUTC=!0,n._tzm=Ie(ir,t)});var qr=/([\+\-]|\d\d)/gi;e.updateOffset=function(){};var $r=/^(\-|\+)?(?:(\d*)[. ])?(\d+)\:(\d+)(?:\:(\d+)(\.\d*)?)?$/,Jr=/^(-|\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;$e.fn=Le.prototype,$e.invalid=Pe;var Qr=tn(1,"add"),Kr=tn(-1,"subtract");e.defaultFormat="YYYY-MM-DDTHH:mm:ssZ",e.defaultFormatUtc="YYYY-MM-DDTHH:mm:ss[Z]";var to=S("moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.",function(t){return void 0===t?this.localeData():this.locale(t)});F(0,["gg",2],0,function(){return this.weekYear()%100}),F(0,["GG",2],0,function(){return this.isoWeekYear()%100}),In("gggg","weekYear"),In("ggggg","weekYear"),In("GGGG","isoWeekYear"),In("GGGGG","isoWeekYear"),Y("weekYear","gg"),Y("isoWeekYear","GG"),N("weekYear",1),N("isoWeekYear",1),H("G",er),H("g",er),H("GG",Zi,Bi),H("gg",Zi,Bi),H("GGGG",Qi,Hi),H("gggg",Qi,Hi),H("GGGGG",Ki,Xi),H("ggggg",Ki,Xi),J(["gggg","ggggg","GGGG","GGGGG"],function(t,e,n,i){e[i.substr(0,2)]=w(t)}),J(["gg","GG"],function(t,n,i,r){n[r]=e.parseTwoDigitYear(t)}),F("Q",0,"Qo","quarter"),Y("quarter","Q"),N("quarter",7),H("Q",Gi),$("Q",function(t,e){e[hr]=3*(w(t)-1)}),F("D",["DD",2],"Do","date"),Y("date","D"),N("date",9),H("D",Zi),H("DD",Zi,Bi),H("Do",function(t,e){return t?e._dayOfMonthOrdinalParse||e._ordinalParse:e._dayOfMonthOrdinalParseLenient}),$(["D","DD"],lr),$("Do",function(t,e){e[lr]=w(t.match(Zi)[0],10)});var eo=nt("Date",!0);F("DDD",["DDDD",3],"DDDo","dayOfYear"),Y("dayOfYear","DDD"),N("dayOfYear",4),H("DDD",Ji),H("DDDD",Ui),$(["DDD","DDDD"],function(t,e,n){n._dayOfYear=w(t)}),F("m",["mm",2],0,"minute"),Y("minute","m"),N("minute",14),H("m",Zi),H("mm",Zi,Bi),$(["m","mm"],dr);var no=nt("Minutes",!1);F("s",["ss",2],0,"second"),Y("second","s"),N("second",15),H("s",Zi),H("ss",Zi,Bi),$(["s","ss"],fr);var io=nt("Seconds",!1);F("S",0,0,function(){return~~(this.millisecond()/100)}),F(0,["SS",2],0,function(){return~~(this.millisecond()/10)}),F(0,["SSS",3],0,"millisecond"),F(0,["SSSS",4],0,function(){return 10*this.millisecond()}),F(0,["SSSSS",5],0,function(){return 100*this.millisecond()}),F(0,["SSSSSS",6],0,function(){return 1e3*this.millisecond()}),F(0,["SSSSSSS",7],0,function(){return 1e4*this.millisecond()}),F(0,["SSSSSSSS",8],0,function(){return 1e5*this.millisecond()}),F(0,["SSSSSSSSS",9],0,function(){return 1e6*this.millisecond()}),Y("millisecond","ms"),N("millisecond",16),H("S",Ji,Gi),H("SS",Ji,Bi),H("SSS",Ji,Ui);var ro;for(ro="SSSS";ro.length<=9;ro+="S")H(ro,tr);for(ro="S";ro.length<=9;ro+="S")$(ro,Un);var oo=nt("Milliseconds",!1);F("z",0,0,"zoneAbbr"),F("zz",0,0,"zoneName");var so=y.prototype;so.add=Qr,so.calendar=rn,so.clone=on,so.diff=dn,so.endOf=Tn,so.format=yn,so.from=gn,so.fromNow=_n,so.to=wn,so.toNow=bn,so.get=ot,so.invalidAt=An,so.isAfter=sn,so.isBefore=an,so.isBetween=un,so.isSame=hn,so.isSameOrAfter=ln,so.isSameOrBefore=cn,so.isValid=Ln,so.lang=to,so.locale=xn,so.localeData=Sn,so.max=Hr,so.min=Ur,so.parsingFlags=Rn,so.set=st,so.startOf=Mn,so.subtract=Kr,so.toArray=En,so.toObject=Cn,so.toDate=On,so.toISOString=mn,so.inspect=vn,so.toJSON=Pn,so.toString=pn,so.unix=kn,so.valueOf=Dn,so.creationData=Yn,so.year=gr,so.isLeapYear=et,so.weekYear=zn,so.isoWeekYear=Nn,so.quarter=so.quarters=Gn,so.month=pt,so.daysInMonth=mt,so.week=so.weeks=Ot,so.isoWeek=so.isoWeeks=Et,so.weeksInYear=jn,so.isoWeeksInYear=Wn,so.date=eo,so.day=so.days=zt,so.weekday=Nt,so.isoWeekday=Wt,so.dayOfYear=Bn,so.hour=so.hours=Rr,so.minute=so.minutes=no,so.second=so.seconds=io,so.millisecond=so.milliseconds=oo,so.utcOffset=We,so.utc=Fe,so.local=Ve,so.parseZone=Ge,so.hasAlignedHourOffset=Be,so.isDST=Ue,so.isLocal=Xe,so.isUtcOffset=Ze,so.isUtc=qe,so.isUTC=qe,so.zoneAbbr=Hn,so.zoneName=Xn,so.dates=S("dates accessor is deprecated. Use date instead.",eo),so.months=S("months accessor is deprecated. Use month instead",pt),so.years=S("years accessor is deprecated. Use year instead",gr),so.zone=S("moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/",je),so.isDSTShifted=S("isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information",He);var ao=O.prototype;ao.calendar=E,ao.longDateFormat=C,ao.invalidDate=P,ao.ordinal=L,ao.preparse=$n,ao.postformat=$n,ao.relativeTime=R,ao.pastFuture=A,ao.set=D,ao.months=ht,ao.monthsShort=lt,ao.monthsParse=dt,ao.monthsRegex=yt,ao.monthsShortRegex=vt,ao.week=Tt,ao.firstDayOfYear=kt,ao.firstDayOfWeek=Dt,ao.weekdays=Lt,ao.weekdaysMin=At,ao.weekdaysShort=Rt,ao.weekdaysParse=It,ao.weekdaysRegex=jt,ao.weekdaysShortRegex=Ft,ao.weekdaysMinRegex=Vt,ao.isPM=Zt,ao.meridiem=qt,Kt("en",{dayOfMonthOrdinalParse:/\d{1,2}(th|st|nd|rd)/,ordinal:function(t){var e=t%10;return t+(1===w(t%100/10)?"th":1===e?"st":2===e?"nd":3===e?"rd":"th")}}),e.lang=S("moment.lang is deprecated. Use moment.locale instead.",Kt),e.langData=S("moment.langData is deprecated. Use moment.localeData instead.",ne);var uo=Math.abs,ho=mi("ms"),lo=mi("s"),co=mi("m"),fo=mi("h"),po=mi("d"),mo=mi("w"),vo=mi("M"),yo=mi("y"),go=gi("milliseconds"),_o=gi("seconds"),wo=gi("minutes"),bo=gi("hours"),xo=gi("days"),So=gi("months"),Mo=gi("years"),To=Math.round,Do={ss:44,s:45,m:45,h:22,d:26,M:11},ko=Math.abs,Oo=Le.prototype;return Oo.isValid=Ce,Oo.abs=oi,Oo.add=ai,Oo.subtract=ui,Oo.as=fi,Oo.asMilliseconds=ho,Oo.asSeconds=lo,Oo.asMinutes=co,Oo.asHours=fo,Oo.asDays=po,Oo.asWeeks=mo,Oo.asMonths=vo,Oo.asYears=yo,Oo.valueOf=pi,Oo._bubble=li,Oo.clone=vi,Oo.get=yi,Oo.milliseconds=go,Oo.seconds=_o,Oo.minutes=wo,Oo.hours=bo,Oo.days=xo,Oo.weeks=_i,Oo.months=So,Oo.years=Mo,Oo.humanize=Mi,Oo.toISOString=Di,Oo.toString=Di,Oo.toJSON=Di,Oo.locale=xn,Oo.localeData=Sn,Oo.toIsoString=S("toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)",Di),Oo.lang=to,F("X",0,0,"unix"),F("x",0,0,"valueOf"),H("x",er),H("X",rr),$("X",function(t,e,n){n._d=new Date(1e3*parseFloat(t,10))}),$("x",function(t,e,n){n._d=new Date(w(t))}),e.version="2.19.1",function(t){ki=t}(Te),e.fn=so,e.min=ke,e.max=Oe,e.now=Xr,e.utc=c,e.unix=Zn,e.months=ti,e.isDate=a,e.locale=Kt,e.invalid=m,e.duration=$e,e.isMoment=g,e.weekdays=ni,e.parseZone=qn,e.localeData=ne,e.isDuration=Re,e.monthsShort=ei,e.weekdaysMin=ri,e.defineLocale=te,e.updateLocale=ee,e.locales=ie,e.weekdaysShort=ii,e.normalizeUnits=I,e.relativeTimeRounding=xi,e.relativeTimeThreshold=Si,e.calendarFormat=nn,e.prototype=so,e})}).call(e,n(95)(t))},function(t,e){t.exports=function(t){return t.webpackPolyfill||(t.deprecate=function(){},t.paths=[],t.children||(t.children=[]),Object.defineProperty(t,"loaded",{enumerable:!0,get:function(){return t.l}}),Object.defineProperty(t,"id",{enumerable:!0,get:function(){return t.i}}),t.webpackPolyfill=1),t}},function(t,e){function n(t){throw new Error("Cannot find module '"+t+"'.")}n.keys=function(){return[]},n.resolve=n,t.exports=n,n.id=96},function(t,e,n){(function(e){function n(t,e,n){var i=e&&n||0,r=0;for(e=e||[],t.toLowerCase().replace(/[0-9a-f]{2}/g,function(t){r<16&&(e[i+r++]=c[t])});r<16;)e[i+r++]=0;return e}function i(t,e){var n=e||0,i=l;return i[t[n++]]+i[t[n++]]+i[t[n++]]+i[t[n++]]+"-"+i[t[n++]]+i[t[n++]]+"-"+i[t[n++]]+i[t[n++]]+"-"+i[t[n++]]+i[t[n++]]+"-"+i[t[n++]]+i[t[n++]]+i[t[n++]]+i[t[n++]]+i[t[n++]]+i[t[n++]]}function r(t,e,n){var r=e&&n||0,o=e||[];t=t||{};var s=void 0!==t.clockseq?t.clockseq:m,a=void 0!==t.msecs?t.msecs:(new Date).getTime(),u=void 0!==t.nsecs?t.nsecs:y+1,h=a-v+(u-y)/1e4;if(h<0&&void 0===t.clockseq&&(s=s+1&16383),(h<0||a>v)&&void 0===t.nsecs&&(u=0),u>=1e4)throw new Error("uuid.v1(): Can't create more than 10M uuids/sec");v=a,y=u,m=s,a+=122192928e5;var l=(1e4*(268435455&a)+u)%4294967296;o[r++]=l>>>24&255,o[r++]=l>>>16&255,o[r++]=l>>>8&255,o[r++]=255&l;var c=a/4294967296*1e4&268435455;o[r++]=c>>>8&255,o[r++]=255&c,o[r++]=c>>>24&15|16,o[r++]=c>>>16&255,o[r++]=s>>>8|128,o[r++]=255&s;for(var d=t.node||p,f=0;f<6;f++)o[r+f]=d[f];return e||i(o)}function o(t,e,n){var r=e&&n||0;"string"==typeof t&&(e="binary"==t?new Array(16):null,t=null),t=t||{};var o=t.random||(t.rng||s)();if(o[6]=15&o[6]|64,o[8]=63&o[8]|128,e)for(var a=0;a<16;a++)e[r+a]=o[a];return e||i(o)}var s,a="undefined"!=typeof window?window:void 0!==e?e:null;if(a&&a.crypto&&crypto.getRandomValues){var u=new Uint8Array(16);s=function(){return crypto.getRandomValues(u),u}}if(!s){var h=new Array(16);s=function(){for(var t,e=0;e<16;e++)0==(3&e)&&(t=4294967296*Math.random()),h[e]=t>>>((3&e)<<3)&255;return h}}for(var l=[],c={},d=0;d<256;d++)l[d]=(d+256).toString(16).substr(1),c[l[d]]=d;var f=s(),p=[1|f[0],f[1],f[2],f[3],f[4],f[5]],m=16383&(f[6]<<8|f[7]),v=0,y=0,g=o;g.v1=r,g.v4=o,g.parse=n,g.unparse=i,t.exports=g}).call(e,n(98))},function(t,e){var n;n=function(){return this}();try{n=n||Function("return this")()||(0,eval)("this")}catch(t){"object"==typeof window&&(n=window)}t.exports=n},function(t,e,n){e.prepareElements=function(t){for(var e in t)t.hasOwnProperty(e)&&(t[e].redundant=t[e].used,t[e].used=[])},e.cleanupElements=function(t){for(var e in t)if(t.hasOwnProperty(e)&&t[e].redundant){for(var n=0;n<t[e].redundant.length;n++)t[e].redundant[n].parentNode.removeChild(t[e].redundant[n]);t[e].redundant=[]}},e.resetElements=function(t){e.prepareElements(t),e.cleanupElements(t),e.prepareElements(t)},e.getSVGElement=function(t,e,n){var i;return e.hasOwnProperty(t)?e[t].redundant.length>0?(i=e[t].redundant[0],e[t].redundant.shift()):(i=document.createElementNS("http://www.w3.org/2000/svg",t),n.appendChild(i)):(i=document.createElementNS("http://www.w3.org/2000/svg",t),e[t]={used:[],redundant:[]},n.appendChild(i)),e[t].used.push(i),i},e.getDOMElement=function(t,e,n,i){var r;return e.hasOwnProperty(t)?e[t].redundant.length>0?(r=e[t].redundant[0],e[t].redundant.shift()):(r=document.createElement(t),void 0!==i?n.insertBefore(r,i):n.appendChild(r)):(r=document.createElement(t),e[t]={used:[],redundant:[]},void 0!==i?n.insertBefore(r,i):n.appendChild(r)),e[t].used.push(r),r},e.drawPoint=function(t,n,i,r,o,s){var a;if("circle"==i.style?(a=e.getSVGElement("circle",r,o),a.setAttributeNS(null,"cx",t),a.setAttributeNS(null,"cy",n),a.setAttributeNS(null,"r",.5*i.size)):(a=e.getSVGElement("rect",r,o),a.setAttributeNS(null,"x",t-.5*i.size),a.setAttributeNS(null,"y",n-.5*i.size),a.setAttributeNS(null,"width",i.size),a.setAttributeNS(null,"height",i.size)),void 0!==i.styles&&a.setAttributeNS(null,"style",i.styles),a.setAttributeNS(null,"class",i.className+" vis-point"),s){var u=e.getSVGElement("text",r,o);s.xOffset&&(t+=s.xOffset),s.yOffset&&(n+=s.yOffset),s.content&&(u.textContent=s.content),s.className&&u.setAttributeNS(null,"class",s.className+" vis-label"),u.setAttributeNS(null,"x",t),u.setAttributeNS(null,"y",n)}return a},e.drawBar=function(t,n,i,r,o,s,a,u){if(0!=r){r<0&&(r*=-1,n-=r);var h=e.getSVGElement("rect",s,a);h.setAttributeNS(null,"x",t-.5*i),h.setAttributeNS(null,"y",n),h.setAttributeNS(null,"width",i),h.setAttributeNS(null,"height",r),h.setAttributeNS(null,"class",o),u&&h.setAttributeNS(null,"style",u)}}},function(t,e,n){var i=n(0),r=i.JSON||(i.JSON={stringify:JSON.stringify});t.exports=function(t){return r.stringify.apply(r,arguments)}},function(t,e,n){function i(t,e,n){if(!(this instanceof i))throw new SyntaxError("Constructor must be called with the new operator");this.containerElement=t,this.dataGroup=new w,this.dataPoints=null,this.create(),p.setDefaults(i.DEFAULTS,this),this.colX=void 0,this.colY=void 0,this.colZ=void 0,this.colValue=void 0,this.setOptions(n),this.setData(e)}function r(t){return"clientX"in t?t.clientX:t.targetTouches[0]&&t.targetTouches[0].clientX||0}function o(t){return"clientY"in t?t.clientY:t.targetTouches[0]&&t.targetTouches[0].clientY||0}var s=n(102),a=function(t){return t&&t.__esModule?t:{default:t}}(s),u=n(106),h=n(3),l=n(13),c=n(49),d=n(50),f=n(51),p=n(52),m=n(54).default,v=n(54),y=v.printStyle,g=n(116),_=g.allOptions,w=n(117);i.STYLE=p.STYLE;i.DEFAULTS={width:"400px",height:"400px",filterLabel:"time",legendLabel:"value",xLabel:"x",yLabel:"y",zLabel:"z",xValueLabel:function(t){return t},yValueLabel:function(t){return t},zValueLabel:function(t){return t},showXAxis:!0,showYAxis:!0,showZAxis:!0,showGrid:!0,showPerspective:!0,showShadow:!1,keepAspectRatio:!0,verticalRatio:.5,dotSizeRatio:.02,dotSizeMinFraction:.5,dotSizeMaxFraction:2.5,showAnimationControls:void 0,animationInterval:1e3,animationPreload:!1,animationAutoStart:void 0,axisColor:"#4D4D4D",gridColor:"#D3D3D3",xCenter:"55%",yCenter:"50%",style:i.STYLE.DOT,tooltip:!1,tooltipStyle:{content:{padding:"10px",border:"1px solid #4d4d4d",color:"#1a1a1a",background:"rgba(255,255,255,0.7)",borderRadius:"2px",boxShadow:"5px 5px 10px rgba(128,128,128,0.5)"},line:{height:"40px",width:"0",borderLeft:"1px solid #4d4d4d"},dot:{height:"0",width:"0",border:"5px solid #4d4d4d",borderRadius:"5px"}},dataColor:{fill:"#7DC1FF",stroke:"#3267D2",strokeWidth:1},cameraPosition:{horizontal:1,vertical:.5,distance:1.7},showLegend:void 0,backgroundColor:void 0,xBarWidth:void 0,yBarWidth:void 0,valueMin:void 0,valueMax:void 0,xMin:void 0,xMax:void 0,xStep:void 0,yMin:void 0,yMax:void 0,yStep:void 0,zMin:void 0,zMax:void 0,zStep:void 0},u(i.prototype),i.prototype._setScale=function(){this.scale=new l(1/this.xRange.range(),1/this.yRange.range(),1/this.zRange.range()),this.keepAspectRatio&&(this.scale.x<this.scale.y?this.scale.y=this.scale.x:this.scale.x=this.scale.y),this.scale.z*=this.verticalRatio,void 0!==this.valueRange&&(this.scale.value=1/this.valueRange.range());var t=this.xRange.center()*this.scale.x,e=this.yRange.center()*this.scale.y,n=this.zRange.center()*this.scale.z;this.camera.setArmLocation(t,e,n)},i.prototype._convert3Dto2D=function(t){var e=this._convertPointToTranslation(t);return this._convertTranslationToScreen(e)},i.prototype._convertPointToTranslation=function(t){var e=this.camera.getCameraLocation(),n=this.camera.getCameraRotation(),i=t.x*this.scale.x,r=t.y*this.scale.y,o=t.z*this.scale.z,s=e.x,a=e.y,u=e.z,h=Math.sin(n.x),c=Math.cos(n.x),d=Math.sin(n.y),f=Math.cos(n.y),p=Math.sin(n.z),m=Math.cos(n.z);return new l(f*(p*(r-a)+m*(i-s))-d*(o-u),h*(f*(o-u)+d*(p*(r-a)+m*(i-s)))+c*(m*(r-a)-p*(i-s)),c*(f*(o-u)+d*(p*(r-a)+m*(i-s)))-h*(m*(r-a)-p*(i-s)))},i.prototype._convertTranslationToScreen=function(t){var e,n,i=this.eye.x,r=this.eye.y,o=this.eye.z,s=t.x,a=t.y,u=t.z;return this.showPerspective?(e=o/u*(s-i),n=o/u*(a-r)):(e=s*(-o/this.camera.getArmLength()),n=a*(-o/this.camera.getArmLength())),new c(this.currentXCenter+e*this.frame.canvas.clientWidth,this.currentYCenter-n*this.frame.canvas.clientWidth)},i.prototype._calcTranslations=function(t){for(var e=0;e<t.length;e++){var n=t[e];n.trans=this._convertPointToTranslation(n.point),n.screen=this._convertTranslationToScreen(n.trans);var i=this._convertPointToTranslation(n.bottom);n.dist=this.showPerspective?i.length():-i.z}var r=function(t,e){return e.dist-t.dist};t.sort(r)},i.prototype._initializeRanges=function(){var t=this.dataGroup;this.xRange=t.xRange,this.yRange=t.yRange,this.zRange=t.zRange,this.valueRange=t.valueRange,this.xStep=t.xStep,this.yStep=t.yStep,this.zStep=t.zStep,this.xBarWidth=t.xBarWidth,this.yBarWidth=t.yBarWidth,this.colX=t.colX,this.colY=t.colY,this.colZ=t.colZ,this.colValue=t.colValue,this._setScale()},i.prototype.getDataPoints=function(t){for(var e=[],n=0;n<t.length;n++){var i=new l;i.x=t[n][this.colX]||0,i.y=t[n][this.colY]||0,i.z=t[n][this.colZ]||0,i.data=t[n],void 0!==this.colValue&&(i.value=t[n][this.colValue]||0);var r={};r.point=i,r.bottom=new l(i.x,i.y,this.zRange.min),r.trans=void 0,r.screen=void 0,e.push(r)}return e},i.prototype._getDataPoints=function(t){var e,n,r,o,s=[];if(this.style===i.STYLE.GRID||this.style===i.STYLE.SURFACE){var a=this.dataGroup.getDistinctValues(this.colX,t),u=this.dataGroup.getDistinctValues(this.colY,t);s=this.getDataPoints(t);var h=[];for(r=0;r<s.length;r++){o=s[r];var l=a.indexOf(o.point.x),c=u.indexOf(o.point.y);void 0===h[l]&&(h[l]=[]),h[l][c]=o}for(e=0;e<h.length;e++)for(n=0;n<h[e].length;n++)h[e][n]&&(h[e][n].pointRight=e<h.length-1?h[e+1][n]:void 0,h[e][n].pointTop=n<h[e].length-1?h[e][n+1]:void 0,h[e][n].pointCross=e<h.length-1&&n<h[e].length-1?h[e+1][n+1]:void 0)}else if(this._checkValueField(t),s=this.getDataPoints(t),this.style===i.STYLE.LINE)for(r=0;r<s.length;r++)r>0&&(s[r-1].pointNext=s[r]);return s},i.prototype.create=function(){for(;this.containerElement.hasChildNodes();)this.containerElement.removeChild(this.containerElement.firstChild);this.frame=document.createElement("div"),this.frame.style.position="relative",this.frame.style.overflow="hidden",this.frame.canvas=document.createElement("canvas"),this.frame.canvas.style.position="relative",this.frame.appendChild(this.frame.canvas);var t=document.createElement("DIV");t.style.color="red",t.style.fontWeight="bold",t.style.padding="10px",t.innerHTML="Error: your browser does not support HTML canvas",this.frame.canvas.appendChild(t),this.frame.filter=document.createElement("div"),this.frame.filter.style.position="absolute",this.frame.filter.style.bottom="0px",this.frame.filter.style.left="0px",this.frame.filter.style.width="100%",this.frame.appendChild(this.frame.filter);var e=this,n=function(t){e._onMouseDown(t)},i=function(t){e._onTouchStart(t)},r=function(t){e._onWheel(t)},o=function(t){e._onTooltip(t)},s=function(t){e._onClick(t)};h.addEventListener(this.frame.canvas,"mousedown",n),h.addEventListener(this.frame.canvas,"touchstart",i),h.addEventListener(this.frame.canvas,"mousewheel",r),h.addEventListener(this.frame.canvas,"mousemove",o),h.addEventListener(this.frame.canvas,"click",s),this.containerElement.appendChild(this.frame)},i.prototype._setSize=function(t,e){this.frame.style.width=t,this.frame.style.height=e,this._resizeCanvas()},i.prototype._resizeCanvas=function(){this.frame.canvas.style.width="100%",this.frame.canvas.style.height="100%",this.frame.canvas.width=this.frame.canvas.clientWidth,this.frame.canvas.height=this.frame.canvas.clientHeight,this.frame.filter.style.width=this.frame.canvas.clientWidth-20+"px"},i.prototype.animationStart=function(){if(this.animationAutoStart&&this.dataGroup.dataFilter){if(!this.frame.filter||!this.frame.filter.slider)throw new Error("No animation available");this.frame.filter.slider.play()}},i.prototype.animationStop=function(){this.frame.filter&&this.frame.filter.slider&&this.frame.filter.slider.stop()},i.prototype._resizeCenter=function(){"%"===this.xCenter.charAt(this.xCenter.length-1)?this.currentXCenter=parseFloat(this.xCenter)/100*this.frame.canvas.clientWidth:this.currentXCenter=parseFloat(this.xCenter),"%"===this.yCenter.charAt(this.yCenter.length-1)?this.currentYCenter=parseFloat(this.yCenter)/100*(this.frame.canvas.clientHeight-this.frame.filter.clientHeight):this.currentYCenter=parseFloat(this.yCenter)},i.prototype.getCameraPosition=function(){var t=this.camera.getArmRotation();return t.distance=this.camera.getArmLength(),t},i.prototype._readData=function(t){this.dataPoints=this.dataGroup.initializeData(this,t,this.style),this._initializeRanges(),this._redrawFilter()},i.prototype.setData=function(t){void 0!==t&&null!==t&&(this._readData(t),this.redraw(),this.animationStart())},i.prototype.setOptions=function(t){if(void 0!==t){!0===m.validate(t,_)&&console.log("%cErrors have been found in the supplied options object.",y),this.animationStop(),p.setOptions(t,this),this.setPointDrawingMethod(),this._setSize(this.width,this.height),this.setData(this.dataGroup.getDataTable()),this.animationStart()}},i.prototype.setPointDrawingMethod=function(){var t=void 0;switch(this.style){case i.STYLE.BAR:t=i.prototype._redrawBarGraphPoint;break;case i.STYLE.BARCOLOR:t=i.prototype._redrawBarColorGraphPoint;break;case i.STYLE.BARSIZE:t=i.prototype._redrawBarSizeGraphPoint;break;case i.STYLE.DOT:t=i.prototype._redrawDotGraphPoint;break;case i.STYLE.DOTLINE:t=i.prototype._redrawDotLineGraphPoint;break;case i.STYLE.DOTCOLOR:t=i.prototype._redrawDotColorGraphPoint;break;case i.STYLE.DOTSIZE:t=i.prototype._redrawDotSizeGraphPoint;break;case i.STYLE.SURFACE:t=i.prototype._redrawSurfaceGraphPoint;break;case i.STYLE.GRID:t=i.prototype._redrawGridGraphPoint;break;case i.STYLE.LINE:t=i.prototype._redrawLineGraphPoint;break;default:throw new Error("Can not determine point drawing method for graph style '"+this.style+"'")}this._pointDrawingMethod=t},i.prototype.redraw=function(){if(void 0===this.dataPoints)throw new Error("Graph data not initialized");this._resizeCanvas(),this._resizeCenter(),this._redrawSlider(),this._redrawClear(),this._redrawAxis(),this._redrawDataGraph(),this._redrawInfo(),this._redrawLegend()},i.prototype._getContext=function(){var t=this.frame.canvas,e=t.getContext("2d");return e.lineJoin="round",e.lineCap="round",e},i.prototype._redrawClear=function(){var t=this.frame.canvas;t.getContext("2d").clearRect(0,0,t.width,t.height)},i.prototype._dotSize=function(){return this.frame.clientWidth*this.dotSizeRatio},i.prototype._getLegendWidth=function(){var t;if(this.style===i.STYLE.DOTSIZE){t=this._dotSize()*this.dotSizeMaxFraction}else t=this.style===i.STYLE.BARSIZE?this.xBarWidth:20;return t},i.prototype._redrawLegend=function(){if(!0===this.showLegend&&this.style!==i.STYLE.LINE&&this.style!==i.STYLE.BARSIZE){var t=this.style===i.STYLE.BARSIZE||this.style===i.STYLE.DOTSIZE,e=this.style===i.STYLE.DOTSIZE||this.style===i.STYLE.DOTCOLOR||this.style===i.STYLE.BARCOLOR,n=Math.max(.25*this.frame.clientHeight,100),r=this.margin,o=this._getLegendWidth(),s=this.frame.clientWidth-this.margin,a=s-o,u=r+n,h=this._getContext();if(h.lineWidth=1,h.font="14px arial",!1===t){var l,d=n;for(l=0;l<d;l++){var p=(l-0)/(d-0),m=240*p,v=this._hsv2rgb(m,1,1);h.strokeStyle=v,h.beginPath(),h.moveTo(a,r+l),h.lineTo(s,r+l),h.stroke()}h.strokeStyle=this.axisColor,h.strokeRect(a,r,o,n)}else{var y;this.style===i.STYLE.DOTSIZE?y=o*(this.dotSizeMinFraction/this.dotSizeMaxFraction):(this.style,i.STYLE.BARSIZE),h.strokeStyle=this.axisColor,h.fillStyle=this.dataColor.fill,h.beginPath(),h.moveTo(a,r),h.lineTo(s,r),h.lineTo(a+y,u),h.lineTo(a,u),h.closePath(),h.fill(),h.stroke()}var g=e?this.valueRange.min:this.zRange.min,_=e?this.valueRange.max:this.zRange.max,w=new f(g,_,(_-g)/5,!0);w.start(!0);for(var b,x;!w.end();)l=u-(w.getCurrent()-g)/(_-g)*n,b=new c(a-5,l),x=new c(a,l),this._line(h,b,x),h.textAlign="right",h.textBaseline="middle",h.fillStyle=this.axisColor,h.fillText(w.getCurrent(),a-10,l),w.next();h.textAlign="right",h.textBaseline="top";var S=this.legendLabel;h.fillText(S,s,u+this.margin)}},i.prototype._redrawFilter=function(){var t=this.dataGroup.dataFilter,e=this.frame.filter;if(e.innerHTML="",!t)return void(e.slider=void 0);var n={visible:this.showAnimationControls},i=new d(e,n);e.slider=i,e.style.padding="10px",i.setValues(t.values),i.setPlayInterval(this.animationInterval);var r=this,o=function(){var t=r.dataGroup.dataFilter,e=i.getIndex();t.selectValue(e),r.dataPoints=t._getDataPoints(),r.redraw()};i.setOnChangeCallback(o)},i.prototype._redrawSlider=function(){void 0!==this.frame.filter.slider&&this.frame.filter.slider.redraw()},i.prototype._redrawInfo=function(){var t=this.dataGroup.getInfo();if(void 0!==t){var e=this._getContext();e.font="14px arial",e.lineStyle="gray",e.fillStyle="gray",e.textAlign="left",e.textBaseline="top";var n=this.margin,i=this.margin;e.fillText(t,n,i)}},i.prototype._line=function(t,e,n,i){void 0!==i&&(t.strokeStyle=i),t.beginPath(),t.moveTo(e.x,e.y),t.lineTo(n.x,n.y),t.stroke()},i.prototype.drawAxisLabelX=function(t,e,n,i,r){void 0===r&&(r=0);var o=this._convert3Dto2D(e);Math.cos(2*i)>0?(t.textAlign="center",t.textBaseline="top",o.y+=r):Math.sin(2*i)<0?(t.textAlign="right",t.textBaseline="middle"):(t.textAlign="left",t.textBaseline="middle"),t.fillStyle=this.axisColor,t.fillText(n,o.x,o.y)},i.prototype.drawAxisLabelY=function(t,e,n,i,r){void 0===r&&(r=0);var o=this._convert3Dto2D(e);Math.cos(2*i)<0?(t.textAlign="center",t.textBaseline="top",o.y+=r):Math.sin(2*i)>0?(t.textAlign="right",t.textBaseline="middle"):(t.textAlign="left",t.textBaseline="middle"),t.fillStyle=this.axisColor,t.fillText(n,o.x,o.y)},i.prototype.drawAxisLabelZ=function(t,e,n,i){void 0===i&&(i=0);var r=this._convert3Dto2D(e);t.textAlign="right",t.textBaseline="middle",t.fillStyle=this.axisColor,t.fillText(n,r.x-i,r.y)},i.prototype._line3d=function(t,e,n,i){var r=this._convert3Dto2D(e),o=this._convert3Dto2D(n);this._line(t,r,o,i)},i.prototype._redrawAxis=function(){var t,e,n,i,r,o,s,a,u,h,d,p=this._getContext();p.font=24/this.camera.getArmLength()+"px arial";var m,v=.025/this.scale.x,y=.025/this.scale.y,g=5/this.camera.getArmLength(),_=this.camera.getArmRotation().horizontal,w=new c(Math.cos(_),Math.sin(_)),b=this.xRange,x=this.yRange,S=this.zRange;for(p.lineWidth=1,i=void 0===this.defaultXStep,n=new f(b.min,b.max,this.xStep,i),n.start(!0);!n.end();){var M=n.getCurrent();if(this.showGrid?(t=new l(M,x.min,S.min),e=new l(M,x.max,S.min),this._line3d(p,t,e,this.gridColor)):this.showXAxis&&(t=new l(M,x.min,S.min),e=new l(M,x.min+v,S.min),this._line3d(p,t,e,this.axisColor),t=new l(M,x.max,S.min),e=new l(M,x.max-v,S.min),this._line3d(p,t,e,this.axisColor)),this.showXAxis){s=w.x>0?x.min:x.max,m=new l(M,s,S.min);var T="  "+this.xValueLabel(M)+"  ";this.drawAxisLabelX(p,m,T,_,g)}n.next()}for(p.lineWidth=1,i=void 0===this.defaultYStep,n=new f(x.min,x.max,this.yStep,i),n.start(!0);!n.end();){var D=n.getCurrent();if(this.showGrid?(t=new l(b.min,D,S.min),e=new l(b.max,D,S.min),this._line3d(p,t,e,this.gridColor)):this.showYAxis&&(t=new l(b.min,D,S.min),e=new l(b.min+y,D,S.min),this._line3d(p,t,e,this.axisColor),t=new l(b.max,D,S.min),e=new l(b.max-y,D,S.min),this._line3d(p,t,e,this.axisColor)),this.showYAxis){o=w.y>0?b.min:b.max,m=new l(o,D,S.min);var k="  "+this.yValueLabel(D)+"  ";this.drawAxisLabelY(p,m,k,_,g)}n.next()}if(this.showZAxis){for(p.lineWidth=1,i=void 0===this.defaultZStep,n=new f(S.min,S.max,this.zStep,i),n.start(!0),o=w.x>0?b.min:b.max,s=w.y<0?x.min:x.max;!n.end();){var O=n.getCurrent(),E=new l(o,s,O),C=this._convert3Dto2D(E);e=new c(C.x-g,C.y),this._line(p,C,e,this.axisColor);var P=this.zValueLabel(O)+" ";this.drawAxisLabelZ(p,E,P,5),n.next()}p.lineWidth=1,t=new l(o,s,S.min),e=new l(o,s,S.max),this._line3d(p,t,e,this.axisColor)}if(this.showXAxis){var L,R;p.lineWidth=1,L=new l(b.min,x.min,S.min),R=new l(b.max,x.min,S.min),this._line3d(p,L,R,this.axisColor),L=new l(b.min,x.max,S.min),R=new l(b.max,x.max,S.min),this._line3d(p,L,R,this.axisColor)}this.showYAxis&&(p.lineWidth=1,t=new l(b.min,x.min,S.min),e=new l(b.min,x.max,S.min),this._line3d(p,t,e,this.axisColor),t=new l(b.max,x.min,S.min),e=new l(b.max,x.max,S.min),this._line3d(p,t,e,this.axisColor));var A=this.xLabel;A.length>0&&this.showXAxis&&(d=.1/this.scale.y,o=(b.max+3*b.min)/4,s=w.x>0?x.min-d:x.max+d,r=new l(o,s,S.min),this.drawAxisLabelX(p,r,A,_));var Y=this.yLabel;Y.length>0&&this.showYAxis&&(h=.1/this.scale.x,o=w.y>0?b.min-h:b.max+h,s=(x.max+3*x.min)/4,r=new l(o,s,S.min),this.drawAxisLabelY(p,r,Y,_));var I=this.zLabel;I.length>0&&this.showZAxis&&(u=30,o=w.x>0?b.min:b.max,s=w.y<0?x.min:x.max,a=(S.max+3*S.min)/4,r=new l(o,s,a),this.drawAxisLabelZ(p,r,I,u))},i.prototype._hsv2rgb=function(t,e,n){var i,r,o,s,a,u;switch(s=n*e,a=Math.floor(t/60),u=s*(1-Math.abs(t/60%2-1)),a){case 0:i=s,r=u,o=0;break;case 1:i=u,r=s,o=0;break;case 2:i=0,r=s,o=u;break;case 3:i=0,r=u,o=s;break;case 4:i=u,r=0,o=s;break;case 5:i=s,r=0,o=u;break;default:i=0,r=0,o=0}return"RGB("+parseInt(255*i)+","+parseInt(255*r)+","+parseInt(255*o)+")"},i.prototype._getStrokeWidth=function(t){return void 0!==t?this.showPerspective?1/-t.trans.z*this.dataColor.strokeWidth:-this.eye.z/this.camera.getArmLength()*this.dataColor.strokeWidth:this.dataColor.strokeWidth},i.prototype._redrawBar=function(t,e,n,i,r,o){var s,a=this,u=e.point,h=this.zRange.min,c=[{point:new l(u.x-n,u.y-i,u.z)},{point:new l(u.x+n,u.y-i,u.z)},{point:new l(u.x+n,u.y+i,u.z)},{point:new l(u.x-n,u.y+i,u.z)}],d=[{point:new l(u.x-n,u.y-i,h)},{point:new l(u.x+n,u.y-i,h)},{point:new l(u.x+n,u.y+i,h)},{point:new l(u.x-n,u.y+i,h)}];c.forEach(function(t){t.screen=a._convert3Dto2D(t.point)}),d.forEach(function(t){t.screen=a._convert3Dto2D(t.point)});var f=[{corners:c,center:l.avg(d[0].point,d[2].point)},{corners:[c[0],c[1],d[1],d[0]],center:l.avg(d[1].point,d[0].point)},{corners:[c[1],c[2],d[2],d[1]],center:l.avg(d[2].point,d[1].point)},{corners:[c[2],c[3],d[3],d[2]],center:l.avg(d[3].point,d[2].point)},{corners:[c[3],c[0],d[0],d[3]],center:l.avg(d[0].point,d[3].point)}];e.surfaces=f;for(var p=0;p<f.length;p++){s=f[p];var m=this._convertPointToTranslation(s.center);s.dist=this.showPerspective?m.length():-m.z}f.sort(function(t,e){var n=e.dist-t.dist;return n||(t.corners===c?1:e.corners===c?-1:0)}),t.lineWidth=this._getStrokeWidth(e),t.strokeStyle=o,t.fillStyle=r;for(var v=2;v<f.length;v++)s=f[v],this._polygon(t,s.corners)},i.prototype._polygon=function(t,e,n,i){if(!(e.length<2)){void 0!==n&&(t.fillStyle=n),void 0!==i&&(t.strokeStyle=i),t.beginPath(),t.moveTo(e[0].screen.x,e[0].screen.y);for(var r=1;r<e.length;++r){var o=e[r];t.lineTo(o.screen.x,o.screen.y)}t.closePath(),t.fill(),t.stroke()}},i.prototype._drawCircle=function(t,e,n,i,r){var o=this._calcRadius(e,r);t.lineWidth=this._getStrokeWidth(e),t.strokeStyle=i,t.fillStyle=n,t.beginPath(),t.arc(e.screen.x,e.screen.y,o,0,2*Math.PI,!0),t.fill(),t.stroke()},i.prototype._getColorsRegular=function(t){var e=240*(1-(t.point.z-this.zRange.min)*this.scale.z/this.verticalRatio);return{fill:this._hsv2rgb(e,1,1),border:this._hsv2rgb(e,1,.8)}},i.prototype._getColorsColor=function(t){var e,n;if("string"==typeof t.point.value)e=t.point.value,n=t.point.value;else{var i=240*(1-(t.point.value-this.valueRange.min)*this.scale.value);e=this._hsv2rgb(i,1,1),n=this._hsv2rgb(i,1,.8)}return{fill:e,border:n}},i.prototype._getColorsSize=function(){return{fill:this.dataColor.fill,border:this.dataColor.stroke}},i.prototype._calcRadius=function(t,e){void 0===e&&(e=this._dotSize());var n;return n=this.showPerspective?e/-t.trans.z:e*(-this.eye.z/this.camera.getArmLength()),n<0&&(n=0),n},i.prototype._redrawBarGraphPoint=function(t,e){var n=this.xBarWidth/2,i=this.yBarWidth/2,r=this._getColorsRegular(e);this._redrawBar(t,e,n,i,r.fill,r.border)},i.prototype._redrawBarColorGraphPoint=function(t,e){var n=this.xBarWidth/2,i=this.yBarWidth/2,r=this._getColorsColor(e);this._redrawBar(t,e,n,i,r.fill,r.border)},i.prototype._redrawBarSizeGraphPoint=function(t,e){var n=(e.point.value-this.valueRange.min)/this.valueRange.range(),i=this.xBarWidth/2*(.8*n+.2),r=this.yBarWidth/2*(.8*n+.2),o=this._getColorsSize();this._redrawBar(t,e,i,r,o.fill,o.border)},i.prototype._redrawDotGraphPoint=function(t,e){var n=this._getColorsRegular(e);this._drawCircle(t,e,n.fill,n.border)},i.prototype._redrawDotLineGraphPoint=function(t,e){var n=this._convert3Dto2D(e.bottom);t.lineWidth=1,this._line(t,n,e.screen,this.gridColor),this._redrawDotGraphPoint(t,e)},i.prototype._redrawDotColorGraphPoint=function(t,e){var n=this._getColorsColor(e);this._drawCircle(t,e,n.fill,n.border)},i.prototype._redrawDotSizeGraphPoint=function(t,e){var n=this._dotSize(),i=(e.point.value-this.valueRange.min)/this.valueRange.range(),r=n*this.dotSizeMinFraction,o=n*this.dotSizeMaxFraction-r,s=r+o*i,a=this._getColorsSize();this._drawCircle(t,e,a.fill,a.border,s)},i.prototype._redrawSurfaceGraphPoint=function(t,e){var n=e.pointRight,i=e.pointTop,r=e.pointCross;if(void 0!==e&&void 0!==n&&void 0!==i&&void 0!==r){var o,s,a=!0;if(this.showGrayBottom||this.showShadow){var u=l.subtract(r.trans,e.trans),h=l.subtract(i.trans,n.trans),c=l.crossProduct(u,h),d=c.length();a=c.z>0}if(a){var f,p=(e.point.z+n.point.z+i.point.z+r.point.z)/4,m=240*(1-(p-this.zRange.min)*this.scale.z/this.verticalRatio);this.showShadow?(f=Math.min(1+c.x/d/2,1),o=this._hsv2rgb(m,1,f),s=o):(f=1,o=this._hsv2rgb(m,1,f),s=this.axisColor)}else o="gray",s=this.axisColor;t.lineWidth=this._getStrokeWidth(e);var v=[e,n,r,i];this._polygon(t,v,o,s)}},i.prototype._drawGridLine=function(t,e,n){if(void 0!==e&&void 0!==n){var i=(e.point.z+n.point.z)/2,r=240*(1-(i-this.zRange.min)*this.scale.z/this.verticalRatio);t.lineWidth=2*this._getStrokeWidth(e),t.strokeStyle=this._hsv2rgb(r,1,1),this._line(t,e.screen,n.screen)}},i.prototype._redrawGridGraphPoint=function(t,e){this._drawGridLine(t,e,e.pointRight),this._drawGridLine(t,e,e.pointTop)},i.prototype._redrawLineGraphPoint=function(t,e){void 0!==e.pointNext&&(t.lineWidth=this._getStrokeWidth(e),t.strokeStyle=this.dataColor.stroke,this._line(t,e.screen,e.pointNext.screen))},i.prototype._redrawDataGraph=function(){var t,e=this._getContext();if(!(void 0===this.dataPoints||this.dataPoints.length<=0))for(this._calcTranslations(this.dataPoints),t=0;t<this.dataPoints.length;t++){var n=this.dataPoints[t];this._pointDrawingMethod.call(this,e,n)}},i.prototype._storeMousePosition=function(t){this.startMouseX=r(t),this.startMouseY=o(t),this._startCameraOffset=this.camera.getOffset()},i.prototype._onMouseDown=function(t){if(t=t||window.event,this.leftButtonDown&&this._onMouseUp(t),this.leftButtonDown=t.which?1===t.which:1===t.button,this.leftButtonDown||this.touchDown){this._storeMousePosition(t),this.startStart=new Date(this.start),this.startEnd=new Date(this.end),this.startArmRotation=this.camera.getArmRotation(),this.frame.style.cursor="move";var e=this;this.onmousemove=function(t){e._onMouseMove(t)},this.onmouseup=function(t){e._onMouseUp(t)},h.addEventListener(document,"mousemove",e.onmousemove),h.addEventListener(document,"mouseup",e.onmouseup),h.preventDefault(t)}},i.prototype._onMouseMove=function(t){this.moving=!0,t=t||window.event;var e=parseFloat(r(t))-this.startMouseX,n=parseFloat(o(t))-this.startMouseY;if(t&&!0===t.ctrlKey){var i=.5*this.frame.clientWidth,s=.5*this.frame.clientHeight,a=(this._startCameraOffset.x||0)-e/i*this.camera.armLength*.8,u=(this._startCameraOffset.y||0)+n/s*this.camera.armLength*.8;this.camera.setOffset(a,u),this._storeMousePosition(t)}else{var l=this.startArmRotation.horizontal+e/200,c=this.startArmRotation.vertical+n/200,d=Math.sin(4/360*2*Math.PI);Math.abs(Math.sin(l))<d&&(l=Math.round(l/Math.PI)*Math.PI-.001),Math.abs(Math.cos(l))<d&&(l=(Math.round(l/Math.PI-.5)+.5)*Math.PI-.001),Math.abs(Math.sin(c))<d&&(c=Math.round(c/Math.PI)*Math.PI),Math.abs(Math.cos(c))<d&&(c=(Math.round(c/Math.PI-.5)+.5)*Math.PI),this.camera.setArmRotation(l,c)}this.redraw();var f=this.getCameraPosition();this.emit("cameraPositionChange",f),h.preventDefault(t)},i.prototype._onMouseUp=function(t){this.frame.style.cursor="auto",this.leftButtonDown=!1,h.removeEventListener(document,"mousemove",this.onmousemove),h.removeEventListener(document,"mouseup",this.onmouseup),h.preventDefault(t)},i.prototype._onClick=function(t){if(this.onclick_callback){if(this.moving)this.moving=!1;else{var e=this.frame.getBoundingClientRect(),n=r(t)-e.left,i=o(t)-e.top,s=this._dataPointFromXY(n,i);s&&this.onclick_callback(s.point.data)}h.preventDefault(t)}},i.prototype._onTooltip=function(t){var e=this.frame.getBoundingClientRect(),n=r(t)-e.left,i=o(t)-e.top;if(this.showTooltip){if(this.tooltipTimeout&&clearTimeout(this.tooltipTimeout),this.leftButtonDown)return void this._hideTooltip();if(this.tooltip&&this.tooltip.dataPoint){var s=this._dataPointFromXY(n,i);s!==this.tooltip.dataPoint&&(s?this._showTooltip(s):this._hideTooltip())}else{var a=this;this.tooltipTimeout=setTimeout(function(){a.tooltipTimeout=null;var t=a._dataPointFromXY(n,i);t&&a._showTooltip(t)},300)}}},i.prototype._onTouchStart=function(t){this.touchDown=!0;var e=this;this.ontouchmove=function(t){e._onTouchMove(t)},this.ontouchend=function(t){e._onTouchEnd(t)},h.addEventListener(document,"touchmove",e.ontouchmove),h.addEventListener(document,"touchend",e.ontouchend),this._onMouseDown(t)},i.prototype._onTouchMove=function(t){this._onMouseMove(t)},i.prototype._onTouchEnd=function(t){this.touchDown=!1,h.removeEventListener(document,"touchmove",this.ontouchmove),h.removeEventListener(document,"touchend",this.ontouchend),this._onMouseUp(t)},i.prototype._onWheel=function(t){t||(t=window.event);var e=0;if(t.wheelDelta?e=t.wheelDelta/120:t.detail&&(e=-t.detail/3),e){var n=this.camera.getArmLength(),i=n*(1-e/10);this.camera.setArmLength(i),this.redraw(),this._hideTooltip()}var r=this.getCameraPosition();this.emit("cameraPositionChange",r),h.preventDefault(t)},i.prototype._insideTriangle=function(t,e){function n(t){return t>0?1:t<0?-1:0}var i=e[0],r=e[1],o=e[2],s=n((r.x-i.x)*(t.y-i.y)-(r.y-i.y)*(t.x-i.x)),a=n((o.x-r.x)*(t.y-r.y)-(o.y-r.y)*(t.x-r.x)),u=n((i.x-o.x)*(t.y-o.y)-(i.y-o.y)*(t.x-o.x));return!(0!=s&&0!=a&&s!=a||0!=a&&0!=u&&a!=u||0!=s&&0!=u&&s!=u)},i.prototype._dataPointFromXY=function(t,e){var n,r=null,o=null,s=null,a=new c(t,e);if(this.style===i.STYLE.BAR||this.style===i.STYLE.BARCOLOR||this.style===i.STYLE.BARSIZE)for(n=this.dataPoints.length-1;n>=0;n--){r=this.dataPoints[n];var u=r.surfaces;if(u)for(var h=u.length-1;h>=0;h--){var l=u[h],d=l.corners,f=[d[0].screen,d[1].screen,d[2].screen],p=[d[2].screen,d[3].screen,d[0].screen];if(this._insideTriangle(a,f)||this._insideTriangle(a,p))return r}}else for(n=0;n<this.dataPoints.length;n++){r=this.dataPoints[n];var m=r.screen;if(m){var v=Math.abs(t-m.x),y=Math.abs(e-m.y),g=Math.sqrt(v*v+y*y);(null===s||g<s)&&g<100&&(s=g,o=r)}}return o},i.prototype.hasBars=function(t){return t==i.STYLE.BAR||t==i.STYLE.BARCOLOR||t==i.STYLE.BARSIZE},i.prototype._showTooltip=function(t){var e,n,i;this.tooltip?(e=this.tooltip.dom.content,n=this.tooltip.dom.line,i=this.tooltip.dom.dot):(e=document.createElement("div"),(0,a.default)(e.style,{},this.tooltipStyle.content),e.style.position="absolute",n=document.createElement("div"),(0,a.default)(n.style,{},this.tooltipStyle.line),n.style.position="absolute",i=document.createElement("div"),(0,a.default)(i.style,{},this.tooltipStyle.dot),i.style.position="absolute",this.tooltip={dataPoint:null,dom:{content:e,line:n,dot:i}}),this._hideTooltip(),this.tooltip.dataPoint=t,"function"==typeof this.showTooltip?e.innerHTML=this.showTooltip(t.point):e.innerHTML="<table><tr><td>"+this.xLabel+":</td><td>"+t.point.x+"</td></tr><tr><td>"+this.yLabel+":</td><td>"+t.point.y+"</td></tr><tr><td>"+this.zLabel+":</td><td>"+t.point.z+"</td></tr></table>",e.style.left="0",e.style.top="0",this.frame.appendChild(e),this.frame.appendChild(n),this.frame.appendChild(i);var r=e.offsetWidth,o=e.offsetHeight,s=n.offsetHeight,u=i.offsetWidth,h=i.offsetHeight,l=t.screen.x-r/2;l=Math.min(Math.max(l,10),this.frame.clientWidth-10-r),n.style.left=t.screen.x+"px",n.style.top=t.screen.y-s+"px",e.style.left=l+"px",e.style.top=t.screen.y-s-o+"px",i.style.left=t.screen.x-u/2+"px",i.style.top=t.screen.y-h/2+"px"},i.prototype._hideTooltip=function(){if(this.tooltip){this.tooltip.dataPoint=null;for(var t in this.tooltip.dom)if(this.tooltip.dom.hasOwnProperty(t)){var e=this.tooltip.dom[t];e&&e.parentNode&&e.parentNode.removeChild(e)}}},i.prototype.setCameraPosition=function(t){p.setCameraPosition(t,this),this.redraw()},i.prototype.setSize=function(t,e){this._setSize(t,e),this.redraw()},t.exports=i},function(t,e,n){t.exports={default:n(103),__esModule:!0}},function(t,e,n){n(104),t.exports=n(0).Object.assign},function(t,e,n){var i=n(4);i(i.S+i.F,"Object",{assign:n(105)})},function(t,e,n){var i=n(12),r=n(34),o=n(20),s=n(31),a=n(38),u=Object.assign;t.exports=!u||n(10)(function(){var t={},e={},n=Symbol(),i="abcdefghijklmnopqrst";return t[n]=7,i.split("").forEach(function(t){e[t]=t}),7!=u({},t)[n]||Object.keys(u({},e)).join("")!=i})?function(t,e){for(var n=s(t),u=arguments.length,h=1,l=r.f,c=o.f;u>h;)for(var d,f=a(arguments[h++]),p=l?i(f).concat(l(f)):i(f),m=p.length,v=0;m>v;)c.call(f,d=p[v++])&&(n[d]=f[d]);return n}:u},function(t,e){function n(t){if(t)return i(t)}function i(t){for(var e in n.prototype)t[e]=n.prototype[e];return t}t.exports=n,n.prototype.on=n.prototype.addEventListener=function(t,e){return this._callbacks=this._callbacks||{},(this._callbacks[t]=this._callbacks[t]||[]).push(e),this},n.prototype.once=function(t,e){function n(){i.off(t,n),e.apply(this,arguments)}var i=this;return this._callbacks=this._callbacks||{},n.fn=e,this.on(t,n),this},n.prototype.off=n.prototype.removeListener=n.prototype.removeAllListeners=n.prototype.removeEventListener=function(t,e){if(this._callbacks=this._callbacks||{},0==arguments.length)return this._callbacks={},this;var n=this._callbacks[t];if(!n)return this;if(1==arguments.length)return delete this._callbacks[t],this;for(var i,r=0;r<n.length;r++)if((i=n[r])===e||i.fn===e){n.splice(r,1);break}return this},n.prototype.emit=function(t){this._callbacks=this._callbacks||{};var e=[].slice.call(arguments,1),n=this._callbacks[t];if(n){n=n.slice(0);for(var i=0,r=n.length;i<r;++i)n[i].apply(this,e)}return this},n.prototype.listeners=function(t){return this._callbacks=this._callbacks||{},this._callbacks[t]||[]},n.prototype.hasListeners=function(t){return!!this.listeners(t).length}},function(t,e,n){t.exports={default:n(108),__esModule:!0}},function(t,e,n){n(109),t.exports=n(0).Math.sign},function(t,e,n){var i=n(4);i(i.S,"Math",{sign:n(110)})},function(t,e){t.exports=Math.sign||function(t){return 0==(t=+t)||t!=t?t:t<0?-1:1}},function(t,e,n){e.__esModule=!0,e.default=function(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")}},function(t,e,n){e.__esModule=!0;var i=n(113),r=function(t){return t&&t.__esModule?t:{default:t}}(i);e.default=function(){function t(t,e){for(var n=0;n<e.length;n++){var i=e[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),(0,r.default)(t,i.key,i)}}return function(e,n,i){return n&&t(e.prototype,n),i&&t(e,i),e}}()},function(t,e,n){t.exports={default:n(114),__esModule:!0}},function(t,e,n){n(115);var i=n(0).Object;t.exports=function(t,e,n){return i.defineProperty(t,e,n)}},function(t,e,n){var i=n(4);i(i.S+i.F*!n(6),"Object",{defineProperty:n(5).f})},function(t,e,n){Object.defineProperty(e,"__esModule",{value:!0});var i="string",r="boolean",o="number",s={fill:{string:i},stroke:{string:i},strokeWidth:{number:o},__type__:{string:i,object:"object",undefined:"undefined"}},a={animationAutoStart:{boolean:r,undefined:"undefined"},animationInterval:{number:o},animationPreload:{boolean:r},axisColor:{string:i},backgroundColor:s,xBarWidth:{number:o,undefined:"undefined"},yBarWidth:{number:o,undefined:"undefined"},cameraPosition:{distance:{number:o},horizontal:{number:o},vertical:{number:o},__type__:{object:"object"}},xCenter:{string:i},yCenter:{string:i},dataColor:s,dotSizeMinFraction:{number:o},dotSizeMaxFraction:{number:o},dotSizeRatio:{number:o},filterLabel:{string:i},gridColor:{string:i},onclick:{function:"function"},keepAspectRatio:{boolean:r},xLabel:{string:i},yLabel:{string:i},zLabel:{string:i},legendLabel:{string:i},xMin:{number:o,undefined:"undefined"},yMin:{number:o,undefined:"undefined"},zMin:{number:o,undefined:"undefined"},xMax:{number:o,undefined:"undefined"},yMax:{number:o,undefined:"undefined"},zMax:{number:o,undefined:"undefined"},showAnimationControls:{boolean:r,undefined:"undefined"},showGrid:{boolean:r},showLegend:{boolean:r,undefined:"undefined"},showPerspective:{boolean:r},showShadow:{boolean:r},showXAxis:{boolean:r},showYAxis:{boolean:r},showZAxis:{boolean:r},xStep:{number:o,undefined:"undefined"},yStep:{number:o,undefined:"undefined"},zStep:{number:o,undefined:"undefined"},style:{number:o,string:["bar","bar-color","bar-size","dot","dot-line","dot-color","dot-size","line","grid","surface"]},tooltip:{boolean:r,function:"function"},tooltipStyle:{content:{color:{string:i},background:{string:i},border:{string:i},borderRadius:{string:i},boxShadow:{string:i},padding:{string:i},__type__:{object:"object"}},line:{borderLeft:{string:i},height:{string:i},width:{string:i},__type__:{object:"object"}},dot:{border:{string:i},borderRadius:{string:i},height:{string:i},width:{string:i},__type__:{object:"object"}},__type__:{object:"object"}},xValueLabel:{function:"function"},yValueLabel:{function:"function"},zValueLabel:{function:"function"},valueMax:{number:o,undefined:"undefined"},valueMin:{number:o,undefined:"undefined"},verticalRatio:{number:o},height:{string:i},width:{string:i},__type__:{object:"object"}};e.allOptions=a},function(t,e,n){function i(){this.dataTable=null}var r=n(35),o=n(36),s=n(118),a=n(55),u=n(52),h=n(13);i.prototype.initializeData=function(t,e,n){if(void 0!==e){Array.isArray(e)&&(e=new r(e));var i;if(!(e instanceof r||e instanceof o))throw new Error("Array, DataSet, or DataView expected");if(i=e.get(),0!=i.length){this.style=n,this.dataSet&&this.dataSet.off("*",this._onChange),this.dataSet=e,this.dataTable=i;var s=this;this._onChange=function(){t.setData(s.dataSet)},this.dataSet.on("*",this._onChange),this.colX="x",this.colY="y",this.colZ="z";var u=t.hasBars(n);if(u&&(void 0!==t.defaultXBarWidth?this.xBarWidth=t.defaultXBarWidth:this.xBarWidth=this.getSmallestDifference(i,this.colX)||1,void 0!==t.defaultYBarWidth?this.yBarWidth=t.defaultYBarWidth:this.yBarWidth=this.getSmallestDifference(i,this.colY)||1),this._initializeRange(i,this.colX,t,u),this._initializeRange(i,this.colY,t,u),this._initializeRange(i,this.colZ,t,!1),i[0].hasOwnProperty("style")){this.colValue="style";var h=this.getColumnRange(i,this.colValue);this._setRangeDefaults(h,t.defaultValueMin,t.defaultValueMax),this.valueRange=h}this.getDataTable()[0].hasOwnProperty("filter")&&void 0===this.dataFilter&&(this.dataFilter=new a(this,"filter",t),this.dataFilter.setOnLoadCallback(function(){t.redraw()}));return this.dataFilter?this.dataFilter._getDataPoints():this._getDataPoints(this.getDataTable())}}},i.prototype._collectRangeSettings=function(t,e){if(-1==["x","y","z"].indexOf(t))throw new Error("Column '"+t+"' invalid");var n=t.toUpperCase();return{barWidth:this[t+"BarWidth"],min:e["default"+n+"Min"],max:e["default"+n+"Max"],step:e["default"+n+"Step"],range_label:t+"Range",step_label:t+"Step"}},i.prototype._initializeRange=function(t,e,n,i){var r=this._collectRangeSettings(e,n),o=this.getColumnRange(t,e);i&&"z"!=e&&o.expand(r.barWidth/2),this._setRangeDefaults(o,r.min,r.max),this[r.range_label]=o,this[r.step_label]=void 0!==r.step?r.step:o.range()/5},i.prototype.getDistinctValues=function(t,e){void 0===e&&(e=this.dataTable);for(var n=[],i=0;i<e.length;i++){var r=e[i][t]||0;-1===n.indexOf(r)&&n.push(r)}return n.sort(function(t,e){return t-e})},i.prototype.getSmallestDifference=function(t,e){for(var n=this.getDistinctValues(t,e),i=null,r=1;r<n.length;r++){var o=n[r]-n[r-1];(null==i||i>o)&&(i=o)}return i},i.prototype.getColumnRange=function(t,e){for(var n=new s,i=0;i<t.length;i++){var r=t[i][e];n.adjust(r)}return n},i.prototype.getNumberOfRows=function(){return this.dataTable.length},i.prototype._setRangeDefaults=function(t,e,n){void 0!==e&&(t.min=e),void 0!==n&&(t.max=n),t.max<=t.min&&(t.max=t.min+1)},i.prototype.getDataTable=function(){return this.dataTable},i.prototype.getDataSet=function(){return this.dataSet},i.prototype.getDataPoints=function(t){for(var e=[],n=0;n<t.length;n++){var i=new h;i.x=t[n][this.colX]||0,i.y=t[n][this.colY]||0,i.z=t[n][this.colZ]||0,i.data=t[n],void 0!==this.colValue&&(i.value=t[n][this.colValue]||0);var r={};r.point=i,r.bottom=new h(i.x,i.y,this.zRange.min),r.trans=void 0,r.screen=void 0,e.push(r)}return e},i.prototype.initDataAsMatrix=function(t){var e,n,i,r,o=this.getDistinctValues(this.colX,t),s=this.getDistinctValues(this.colY,t),a=this.getDataPoints(t),u=[];for(i=0;i<a.length;i++){r=a[i];var h=o.indexOf(r.point.x),l=s.indexOf(r.point.y);void 0===u[h]&&(u[h]=[]),u[h][l]=r}for(e=0;e<u.length;e++)for(n=0;n<u[e].length;n++)u[e][n]&&(u[e][n].pointRight=e<u.length-1?u[e+1][n]:void 0,u[e][n].pointTop=n<u[e].length-1?u[e][n+1]:void 0,u[e][n].pointCross=e<u.length-1&&n<u[e].length-1?u[e+1][n+1]:void 0);return a},i.prototype.getInfo=function(){var t=this.dataFilter;if(t)return t.getLabel()+": "+t.getSelectedValue()},i.prototype.reload=function(){this.dataTable&&this.setData(this.dataTable)},i.prototype._getDataPoints=function(t){var e=[];if(this.style===u.STYLE.GRID||this.style===u.STYLE.SURFACE)e=this.initDataAsMatrix(t);else if(this._checkValueField(t),e=this.getDataPoints(t),this.style===u.STYLE.LINE)for(var n=0;n<e.length;n++)n>0&&(e[n-1].pointNext=e[n]);return e},i.prototype._checkValueField=function(t){if(this.style===u.STYLE.BARCOLOR||this.style===u.STYLE.BARSIZE||this.style===u.STYLE.DOTCOLOR||this.style===u.STYLE.DOTSIZE){if(void 0===this.colValue)throw new Error("Expected data to have  field 'style'  for graph style '"+this.style+"'");if(void 0===t[0][this.colValue])throw new Error("Expected data to have  field '"+this.colValue+"'  for graph style '"+this.style+"'")}},t.exports=i},function(t,e,n){function i(){this.min=void 0,this.max=void 0}i.prototype.adjust=function(t){void 0!==t&&((void 0===this.min||this.min>t)&&(this.min=t),(void 0===this.max||this.max<t)&&(this.max=t))},i.prototype.combine=function(t){this.add(t.min),this.add(t.max)},i.prototype.expand=function(t){if(void 0!==t){var e=this.min-t,n=this.max+t;if(e>n)throw new Error("Passed expansion value makes range invalid");this.min=e,this.max=n}},i.prototype.range=function(){return this.max-this.min},i.prototype.center=function(){return(this.min+this.max)/2},t.exports=i},function(t,e,n){function i(){var t=function(){};return{on:t,off:t,destroy:t,emit:t,get:function(e){return{set:t}}}}if("undefined"!=typeof window){var r=n(120),o=window.Hammer||n(121);t.exports=r(o,{preventDefault:"mouse"})}else t.exports=function(){return i()}},function(t,e,n){var i,r,o;!function(n){r=[],i=n,void 0!==(o="function"==typeof i?i.apply(e,r):i)&&(t.exports=o)}(function(){var t=null;return function e(n,i){function r(t){return t.match(/[^ ]+/g)}function o(e){if("hammer.input"!==e.type){if(e.srcEvent._handled||(e.srcEvent._handled={}),e.srcEvent._handled[e.type])return;e.srcEvent._handled[e.type]=!0}var n=!1;e.stopPropagation=function(){n=!0};var i=e.srcEvent.stopPropagation.bind(e.srcEvent);"function"==typeof i&&(e.srcEvent.stopPropagation=function(){i(),e.stopPropagation()}),e.firstTarget=t;for(var r=t;r&&!n;){var o=r.hammer;if(o)for(var s,a=0;a<o.length;a++)if(s=o[a]._handlers[e.type])for(var u=0;u<s.length&&!n;u++)s[u](e);r=r.parentNode}}var s=i||{preventDefault:!1};if(n.Manager){var a=n,u=function(t,n){var i=Object.create(s);return n&&a.assign(i,n),e(new a(t,i),i)};return a.assign(u,a),u.Manager=function(t,n){var i=Object.create(s);return n&&a.assign(i,n),e(new a.Manager(t,i),i)},u}var h=Object.create(n),l=n.element;return l.hammer||(l.hammer=[]),l.hammer.push(h),n.on("hammer.input",function(e){!0!==s.preventDefault&&s.preventDefault!==e.pointerType||e.preventDefault(),e.isFirst&&(t=e.target)}),h._handlers={},h.on=function(t,e){return r(t).forEach(function(t){var i=h._handlers[t];i||(h._handlers[t]=i=[],n.on(t,o)),i.push(e)}),h},h.off=function(t,e){return r(t).forEach(function(t){var i=h._handlers[t];i&&(i=e?i.filter(function(t){return t!==e}):[],i.length>0?h._handlers[t]=i:(n.off(t,o),delete h._handlers[t]))}),h},h.emit=function(e,i){t=i.target,n.emit(e,i)},h.destroy=function(){var t=n.element.hammer,e=t.indexOf(h);-1!==e&&t.splice(e,1),t.length||delete n.element.hammer,h._handlers={},n.destroy()},h}})},function(t,e,n){var i;/*! Hammer.JS - v2.0.7 - 2016-04-22
 * http://hammerjs.github.io/
 *
 * Copyright (c) 2016 Jorik Tangelder;
 * Licensed under the MIT license */
!function(r,o,s,a){function u(t,e,n){return setTimeout(f(t,n),e)}function h(t,e,n){return!!Array.isArray(t)&&(l(t,n[e],n),!0)}function l(t,e,n){var i;if(t)if(t.forEach)t.forEach(e,n);else if(t.length!==a)for(i=0;i<t.length;)e.call(n,t[i],i,t),i++;else for(i in t)t.hasOwnProperty(i)&&e.call(n,t[i],i,t)}function c(t,e,n){var i="DEPRECATED METHOD: "+e+"\n"+n+" AT \n";return function(){var e=new Error("get-stack-trace"),n=e&&e.stack?e.stack.replace(/^[^\(]+?[\n$]/gm,"").replace(/^\s+at\s+/gm,"").replace(/^Object.<anonymous>\s*\(/gm,"{anonymous}()@"):"Unknown Stack Trace",o=r.console&&(r.console.warn||r.console.log);return o&&o.call(r.console,i,n),t.apply(this,arguments)}}function d(t,e,n){var i,r=e.prototype;i=t.prototype=Object.create(r),i.constructor=t,i._super=r,n&&pt(i,n)}function f(t,e){return function(){return t.apply(e,arguments)}}function p(t,e){return typeof t==yt?t.apply(e?e[0]||a:a,e):t}function m(t,e){return t===a?e:t}function v(t,e,n){l(w(e),function(e){t.addEventListener(e,n,!1)})}function y(t,e,n){l(w(e),function(e){t.removeEventListener(e,n,!1)})}function g(t,e){for(;t;){if(t==e)return!0;t=t.parentNode}return!1}function _(t,e){return t.indexOf(e)>-1}function w(t){return t.trim().split(/\s+/g)}function b(t,e,n){if(t.indexOf&&!n)return t.indexOf(e);for(var i=0;i<t.length;){if(n&&t[i][n]==e||!n&&t[i]===e)return i;i++}return-1}function x(t){return Array.prototype.slice.call(t,0)}function S(t,e,n){for(var i=[],r=[],o=0;o<t.length;){var s=e?t[o][e]:t[o];b(r,s)<0&&i.push(t[o]),r[o]=s,o++}return n&&(i=e?i.sort(function(t,n){return t[e]>n[e]}):i.sort()),i}function M(t,e){for(var n,i,r=e[0].toUpperCase()+e.slice(1),o=0;o<mt.length;){if(n=mt[o],(i=n?n+r:e)in t)return i;o++}return a}function T(){return St++}function D(t){var e=t.ownerDocument||t;return e.defaultView||e.parentWindow||r}function k(t,e){var n=this;this.manager=t,this.callback=e,this.element=t.element,this.target=t.options.inputTarget,this.domHandler=function(e){p(t.options.enable,[t])&&n.handler(e)},this.init()}function O(t){var e=t.options.inputClass;return new(e||(Dt?V:kt?U:Tt?X:F))(t,E)}function E(t,e,n){var i=n.pointers.length,r=n.changedPointers.length,o=e&Et&&i-r==0,s=e&(Pt|Lt)&&i-r==0;n.isFirst=!!o,n.isFinal=!!s,o&&(t.session={}),n.eventType=e,C(t,n),t.emit("hammer.input",n),t.recognize(n),t.session.prevInput=n}function C(t,e){var n=t.session,i=e.pointers,r=i.length;n.firstInput||(n.firstInput=R(e)),r>1&&!n.firstMultiple?n.firstMultiple=R(e):1===r&&(n.firstMultiple=!1);var o=n.firstInput,s=n.firstMultiple,a=s?s.center:o.center,u=e.center=A(i);e.timeStamp=wt(),e.deltaTime=e.timeStamp-o.timeStamp,e.angle=N(a,u),e.distance=z(a,u),P(n,e),e.offsetDirection=I(e.deltaX,e.deltaY);var h=Y(e.deltaTime,e.deltaX,e.deltaY);e.overallVelocityX=h.x,e.overallVelocityY=h.y,e.overallVelocity=_t(h.x)>_t(h.y)?h.x:h.y,e.scale=s?j(s.pointers,i):1,e.rotation=s?W(s.pointers,i):0,e.maxPointers=n.prevInput?e.pointers.length>n.prevInput.maxPointers?e.pointers.length:n.prevInput.maxPointers:e.pointers.length,L(n,e);var l=t.element;g(e.srcEvent.target,l)&&(l=e.srcEvent.target),e.target=l}function P(t,e){var n=e.center,i=t.offsetDelta||{},r=t.prevDelta||{},o=t.prevInput||{};e.eventType!==Et&&o.eventType!==Pt||(r=t.prevDelta={x:o.deltaX||0,y:o.deltaY||0},i=t.offsetDelta={x:n.x,y:n.y}),e.deltaX=r.x+(n.x-i.x),e.deltaY=r.y+(n.y-i.y)}function L(t,e){var n,i,r,o,s=t.lastInterval||e,u=e.timeStamp-s.timeStamp;if(e.eventType!=Lt&&(u>Ot||s.velocity===a)){var h=e.deltaX-s.deltaX,l=e.deltaY-s.deltaY,c=Y(u,h,l);i=c.x,r=c.y,n=_t(c.x)>_t(c.y)?c.x:c.y,o=I(h,l),t.lastInterval=e}else n=s.velocity,i=s.velocityX,r=s.velocityY,o=s.direction;e.velocity=n,e.velocityX=i,e.velocityY=r,e.direction=o}function R(t){for(var e=[],n=0;n<t.pointers.length;)e[n]={clientX:gt(t.pointers[n].clientX),clientY:gt(t.pointers[n].clientY)},n++;return{timeStamp:wt(),pointers:e,center:A(e),deltaX:t.deltaX,deltaY:t.deltaY}}function A(t){var e=t.length;if(1===e)return{x:gt(t[0].clientX),y:gt(t[0].clientY)};for(var n=0,i=0,r=0;r<e;)n+=t[r].clientX,i+=t[r].clientY,r++;return{x:gt(n/e),y:gt(i/e)}}function Y(t,e,n){return{x:e/t||0,y:n/t||0}}function I(t,e){return t===e?Rt:_t(t)>=_t(e)?t<0?At:Yt:e<0?It:zt}function z(t,e,n){n||(n=Ft);var i=e[n[0]]-t[n[0]],r=e[n[1]]-t[n[1]];return Math.sqrt(i*i+r*r)}function N(t,e,n){n||(n=Ft);var i=e[n[0]]-t[n[0]],r=e[n[1]]-t[n[1]];return 180*Math.atan2(r,i)/Math.PI}function W(t,e){return N(e[1],e[0],Vt)+N(t[1],t[0],Vt)}function j(t,e){return z(e[0],e[1],Vt)/z(t[0],t[1],Vt)}function F(){this.evEl=Bt,this.evWin=Ut,this.pressed=!1,k.apply(this,arguments)}function V(){this.evEl=Zt,this.evWin=qt,k.apply(this,arguments),this.store=this.manager.session.pointerEvents=[]}function G(){this.evTarget=Jt,this.evWin=Qt,this.started=!1,k.apply(this,arguments)}function B(t,e){var n=x(t.touches),i=x(t.changedTouches);return e&(Pt|Lt)&&(n=S(n.concat(i),"identifier",!0)),[n,i]}function U(){this.evTarget=te,this.targetIds={},k.apply(this,arguments)}function H(t,e){var n=x(t.touches),i=this.targetIds;if(e&(Et|Ct)&&1===n.length)return i[n[0].identifier]=!0,[n,n];var r,o,s=x(t.changedTouches),a=[],u=this.target;if(o=n.filter(function(t){return g(t.target,u)}),e===Et)for(r=0;r<o.length;)i[o[r].identifier]=!0,r++;for(r=0;r<s.length;)i[s[r].identifier]&&a.push(s[r]),e&(Pt|Lt)&&delete i[s[r].identifier],r++;return a.length?[S(o.concat(a),"identifier",!0),a]:void 0}function X(){k.apply(this,arguments);var t=f(this.handler,this);this.touch=new U(this.manager,t),this.mouse=new F(this.manager,t),this.primaryTouch=null,this.lastTouches=[]}function Z(t,e){t&Et?(this.primaryTouch=e.changedPointers[0].identifier,q.call(this,e)):t&(Pt|Lt)&&q.call(this,e)}function q(t){var e=t.changedPointers[0];if(e.identifier===this.primaryTouch){var n={x:e.clientX,y:e.clientY};this.lastTouches.push(n);var i=this.lastTouches,r=function(){var t=i.indexOf(n);t>-1&&i.splice(t,1)};setTimeout(r,ee)}}function $(t){for(var e=t.srcEvent.clientX,n=t.srcEvent.clientY,i=0;i<this.lastTouches.length;i++){var r=this.lastTouches[i],o=Math.abs(e-r.x),s=Math.abs(n-r.y);if(o<=ne&&s<=ne)return!0}return!1}function J(t,e){this.manager=t,this.set(e)}function Q(t){if(_(t,ae))return ae;var e=_(t,ue),n=_(t,he);return e&&n?ae:e||n?e?ue:he:_(t,se)?se:oe}function K(t){this.options=pt({},this.defaults,t||{}),this.id=T(),this.manager=null,this.options.enable=m(this.options.enable,!0),this.state=ce,this.simultaneous={},this.requireFail=[]}function tt(t){return t&ve?"cancel":t&pe?"end":t&fe?"move":t&de?"start":""}function et(t){return t==zt?"down":t==It?"up":t==At?"left":t==Yt?"right":""}function nt(t,e){var n=e.manager;return n?n.get(t):t}function it(){K.apply(this,arguments)}function rt(){it.apply(this,arguments),this.pX=null,this.pY=null}function ot(){it.apply(this,arguments)}function st(){K.apply(this,arguments),this._timer=null,this._input=null}function at(){it.apply(this,arguments)}function ut(){it.apply(this,arguments)}function ht(){K.apply(this,arguments),this.pTime=!1,this.pCenter=!1,this._timer=null,this._input=null,this.count=0}function lt(t,e){return e=e||{},e.recognizers=m(e.recognizers,lt.defaults.preset),new ct(t,e)}function ct(t,e){this.options=pt({},lt.defaults,e||{}),this.options.inputTarget=this.options.inputTarget||t,this.handlers={},this.session={},this.recognizers=[],this.oldCssProps={},this.element=t,this.input=O(this),this.touchAction=new J(this,this.options.touchAction),dt(this,!0),l(this.options.recognizers,function(t){var e=this.add(new t[0](t[1]));t[2]&&e.recognizeWith(t[2]),t[3]&&e.requireFailure(t[3])},this)}function dt(t,e){var n=t.element;if(n.style){var i;l(t.options.cssProps,function(r,o){i=M(n.style,o),e?(t.oldCssProps[i]=n.style[i],n.style[i]=r):n.style[i]=t.oldCssProps[i]||""}),e||(t.oldCssProps={})}}function ft(t,e){var n=o.createEvent("Event");n.initEvent(t,!0,!0),n.gesture=e,e.target.dispatchEvent(n)}var pt,mt=["","webkit","Moz","MS","ms","o"],vt=o.createElement("div"),yt="function",gt=Math.round,_t=Math.abs,wt=Date.now;pt="function"!=typeof Object.assign?function(t){if(t===a||null===t)throw new TypeError("Cannot convert undefined or null to object");for(var e=Object(t),n=1;n<arguments.length;n++){var i=arguments[n];if(i!==a&&null!==i)for(var r in i)i.hasOwnProperty(r)&&(e[r]=i[r])}return e}:Object.assign;var bt=c(function(t,e,n){for(var i=Object.keys(e),r=0;r<i.length;)(!n||n&&t[i[r]]===a)&&(t[i[r]]=e[i[r]]),r++;return t},"extend","Use `assign`."),xt=c(function(t,e){return bt(t,e,!0)},"merge","Use `assign`."),St=1,Mt=/mobile|tablet|ip(ad|hone|od)|android/i,Tt="ontouchstart"in r,Dt=M(r,"PointerEvent")!==a,kt=Tt&&Mt.test(navigator.userAgent),Ot=25,Et=1,Ct=2,Pt=4,Lt=8,Rt=1,At=2,Yt=4,It=8,zt=16,Nt=At|Yt,Wt=It|zt,jt=Nt|Wt,Ft=["x","y"],Vt=["clientX","clientY"];k.prototype={handler:function(){},init:function(){this.evEl&&v(this.element,this.evEl,this.domHandler),this.evTarget&&v(this.target,this.evTarget,this.domHandler),this.evWin&&v(D(this.element),this.evWin,this.domHandler)},destroy:function(){this.evEl&&y(this.element,this.evEl,this.domHandler),this.evTarget&&y(this.target,this.evTarget,this.domHandler),this.evWin&&y(D(this.element),this.evWin,this.domHandler)}};var Gt={mousedown:Et,mousemove:Ct,mouseup:Pt},Bt="mousedown",Ut="mousemove mouseup";d(F,k,{handler:function(t){var e=Gt[t.type];e&Et&&0===t.button&&(this.pressed=!0),e&Ct&&1!==t.which&&(e=Pt),this.pressed&&(e&Pt&&(this.pressed=!1),this.callback(this.manager,e,{pointers:[t],changedPointers:[t],pointerType:"mouse",srcEvent:t}))}});var Ht={pointerdown:Et,pointermove:Ct,pointerup:Pt,pointercancel:Lt,pointerout:Lt},Xt={2:"touch",3:"pen",4:"mouse",5:"kinect"},Zt="pointerdown",qt="pointermove pointerup pointercancel";r.MSPointerEvent&&!r.PointerEvent&&(Zt="MSPointerDown",qt="MSPointerMove MSPointerUp MSPointerCancel"),d(V,k,{handler:function(t){var e=this.store,n=!1,i=t.type.toLowerCase().replace("ms",""),r=Ht[i],o=Xt[t.pointerType]||t.pointerType,s="touch"==o,a=b(e,t.pointerId,"pointerId");r&Et&&(0===t.button||s)?a<0&&(e.push(t),a=e.length-1):r&(Pt|Lt)&&(n=!0),a<0||(e[a]=t,this.callback(this.manager,r,{pointers:e,changedPointers:[t],pointerType:o,srcEvent:t}),n&&e.splice(a,1))}});var $t={touchstart:Et,touchmove:Ct,touchend:Pt,touchcancel:Lt},Jt="touchstart",Qt="touchstart touchmove touchend touchcancel";d(G,k,{handler:function(t){var e=$t[t.type];if(e===Et&&(this.started=!0),this.started){var n=B.call(this,t,e);e&(Pt|Lt)&&n[0].length-n[1].length==0&&(this.started=!1),this.callback(this.manager,e,{pointers:n[0],changedPointers:n[1],pointerType:"touch",srcEvent:t})}}});var Kt={touchstart:Et,touchmove:Ct,touchend:Pt,touchcancel:Lt},te="touchstart touchmove touchend touchcancel";d(U,k,{handler:function(t){var e=Kt[t.type],n=H.call(this,t,e);n&&this.callback(this.manager,e,{pointers:n[0],changedPointers:n[1],pointerType:"touch",srcEvent:t})}});var ee=2500,ne=25;d(X,k,{handler:function(t,e,n){var i="touch"==n.pointerType,r="mouse"==n.pointerType;if(!(r&&n.sourceCapabilities&&n.sourceCapabilities.firesTouchEvents)){if(i)Z.call(this,e,n);else if(r&&$.call(this,n))return;this.callback(t,e,n)}},destroy:function(){this.touch.destroy(),this.mouse.destroy()}});var ie=M(vt.style,"touchAction"),re=ie!==a,oe="auto",se="manipulation",ae="none",ue="pan-x",he="pan-y",le=function(){if(!re)return!1;var t={},e=r.CSS&&r.CSS.supports;return["auto","manipulation","pan-y","pan-x","pan-x pan-y","none"].forEach(function(n){t[n]=!e||r.CSS.supports("touch-action",n)}),t}();J.prototype={set:function(t){"compute"==t&&(t=this.compute()),re&&this.manager.element.style&&le[t]&&(this.manager.element.style[ie]=t),this.actions=t.toLowerCase().trim()},update:function(){this.set(this.manager.options.touchAction)},compute:function(){var t=[];return l(this.manager.recognizers,function(e){p(e.options.enable,[e])&&(t=t.concat(e.getTouchAction()))}),Q(t.join(" "))},preventDefaults:function(t){var e=t.srcEvent,n=t.offsetDirection;if(this.manager.session.prevented)return void e.preventDefault();var i=this.actions,r=_(i,ae)&&!le[ae],o=_(i,he)&&!le[he],s=_(i,ue)&&!le[ue];if(r){var a=1===t.pointers.length,u=t.distance<2,h=t.deltaTime<250;if(a&&u&&h)return}return s&&o?void 0:r||o&&n&Nt||s&&n&Wt?this.preventSrc(e):void 0},preventSrc:function(t){this.manager.session.prevented=!0,t.preventDefault()}};var ce=1,de=2,fe=4,pe=8,me=pe,ve=16;K.prototype={defaults:{},set:function(t){return pt(this.options,t),this.manager&&this.manager.touchAction.update(),this},recognizeWith:function(t){if(h(t,"recognizeWith",this))return this;var e=this.simultaneous;return t=nt(t,this),e[t.id]||(e[t.id]=t,t.recognizeWith(this)),this},dropRecognizeWith:function(t){return h(t,"dropRecognizeWith",this)?this:(t=nt(t,this),delete this.simultaneous[t.id],this)},requireFailure:function(t){if(h(t,"requireFailure",this))return this;var e=this.requireFail;return t=nt(t,this),-1===b(e,t)&&(e.push(t),t.requireFailure(this)),this},dropRequireFailure:function(t){if(h(t,"dropRequireFailure",this))return this;t=nt(t,this);var e=b(this.requireFail,t);return e>-1&&this.requireFail.splice(e,1),this},hasRequireFailures:function(){return this.requireFail.length>0},canRecognizeWith:function(t){return!!this.simultaneous[t.id]},emit:function(t){function e(e){n.manager.emit(e,t)}var n=this,i=this.state;i<pe&&e(n.options.event+tt(i)),e(n.options.event),t.additionalEvent&&e(t.additionalEvent),i>=pe&&e(n.options.event+tt(i))},tryEmit:function(t){if(this.canEmit())return this.emit(t);this.state=32},canEmit:function(){for(var t=0;t<this.requireFail.length;){if(!(this.requireFail[t].state&(32|ce)))return!1;t++}return!0},recognize:function(t){var e=pt({},t);if(!p(this.options.enable,[this,e]))return this.reset(),void(this.state=32);this.state&(me|ve|32)&&(this.state=ce),this.state=this.process(e),this.state&(de|fe|pe|ve)&&this.tryEmit(e)},process:function(t){},getTouchAction:function(){},reset:function(){}},d(it,K,{defaults:{pointers:1},attrTest:function(t){var e=this.options.pointers;return 0===e||t.pointers.length===e},process:function(t){var e=this.state,n=t.eventType,i=e&(de|fe),r=this.attrTest(t);return i&&(n&Lt||!r)?e|ve:i||r?n&Pt?e|pe:e&de?e|fe:de:32}}),d(rt,it,{defaults:{event:"pan",threshold:10,pointers:1,direction:jt},getTouchAction:function(){var t=this.options.direction,e=[];return t&Nt&&e.push(he),t&Wt&&e.push(ue),e},directionTest:function(t){var e=this.options,n=!0,i=t.distance,r=t.direction,o=t.deltaX,s=t.deltaY;return r&e.direction||(e.direction&Nt?(r=0===o?Rt:o<0?At:Yt,n=o!=this.pX,i=Math.abs(t.deltaX)):(r=0===s?Rt:s<0?It:zt,n=s!=this.pY,i=Math.abs(t.deltaY))),t.direction=r,n&&i>e.threshold&&r&e.direction},attrTest:function(t){return it.prototype.attrTest.call(this,t)&&(this.state&de||!(this.state&de)&&this.directionTest(t))},emit:function(t){this.pX=t.deltaX,this.pY=t.deltaY;var e=et(t.direction);e&&(t.additionalEvent=this.options.event+e),this._super.emit.call(this,t)}}),d(ot,it,{defaults:{event:"pinch",threshold:0,pointers:2},getTouchAction:function(){return[ae]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.scale-1)>this.options.threshold||this.state&de)},emit:function(t){if(1!==t.scale){var e=t.scale<1?"in":"out";t.additionalEvent=this.options.event+e}this._super.emit.call(this,t)}}),d(st,K,{defaults:{event:"press",pointers:1,time:251,threshold:9},getTouchAction:function(){return[oe]},process:function(t){var e=this.options,n=t.pointers.length===e.pointers,i=t.distance<e.threshold,r=t.deltaTime>e.time;if(this._input=t,!i||!n||t.eventType&(Pt|Lt)&&!r)this.reset();else if(t.eventType&Et)this.reset(),this._timer=u(function(){this.state=me,this.tryEmit()},e.time,this);else if(t.eventType&Pt)return me;return 32},reset:function(){clearTimeout(this._timer)},emit:function(t){this.state===me&&(t&&t.eventType&Pt?this.manager.emit(this.options.event+"up",t):(this._input.timeStamp=wt(),this.manager.emit(this.options.event,this._input)))}}),d(at,it,{defaults:{event:"rotate",threshold:0,pointers:2},getTouchAction:function(){return[ae]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.rotation)>this.options.threshold||this.state&de)}}),d(ut,it,{defaults:{event:"swipe",threshold:10,velocity:.3,direction:Nt|Wt,pointers:1},getTouchAction:function(){return rt.prototype.getTouchAction.call(this)},attrTest:function(t){var e,n=this.options.direction;return n&(Nt|Wt)?e=t.overallVelocity:n&Nt?e=t.overallVelocityX:n&Wt&&(e=t.overallVelocityY),this._super.attrTest.call(this,t)&&n&t.offsetDirection&&t.distance>this.options.threshold&&t.maxPointers==this.options.pointers&&_t(e)>this.options.velocity&&t.eventType&Pt},emit:function(t){var e=et(t.offsetDirection);e&&this.manager.emit(this.options.event+e,t),this.manager.emit(this.options.event,t)}}),d(ht,K,{defaults:{event:"tap",pointers:1,taps:1,interval:300,time:250,threshold:9,posThreshold:10},getTouchAction:function(){return[se]},process:function(t){var e=this.options,n=t.pointers.length===e.pointers,i=t.distance<e.threshold,r=t.deltaTime<e.time;if(this.reset(),t.eventType&Et&&0===this.count)return this.failTimeout();if(i&&r&&n){if(t.eventType!=Pt)return this.failTimeout();var o=!this.pTime||t.timeStamp-this.pTime<e.interval,s=!this.pCenter||z(this.pCenter,t.center)<e.posThreshold;this.pTime=t.timeStamp,this.pCenter=t.center,s&&o?this.count+=1:this.count=1,this._input=t;if(0===this.count%e.taps)return this.hasRequireFailures()?(this._timer=u(function(){this.state=me,this.tryEmit()},e.interval,this),de):me}return 32},failTimeout:function(){return this._timer=u(function(){this.state=32},this.options.interval,this),32},reset:function(){clearTimeout(this._timer)},emit:function(){this.state==me&&(this._input.tapCount=this.count,this.manager.emit(this.options.event,this._input))}}),lt.VERSION="2.0.7",lt.defaults={domEvents:!1,touchAction:"compute",enable:!0,inputTarget:null,inputClass:null,preset:[[at,{enable:!1}],[ot,{enable:!1},["rotate"]],[ut,{direction:Nt}],[rt,{direction:Nt},["swipe"]],[ht],[ht,{event:"doubletap",taps:2},["tap"]],[st]],cssProps:{userSelect:"none",touchSelect:"none",touchCallout:"none",contentZooming:"none",userDrag:"none",tapHighlightColor:"rgba(0,0,0,0)"}};ct.prototype={set:function(t){return pt(this.options,t),t.touchAction&&this.touchAction.update(),t.inputTarget&&(this.input.destroy(),this.input.target=t.inputTarget,this.input.init()),this},stop:function(t){this.session.stopped=t?2:1},recognize:function(t){var e=this.session;if(!e.stopped){this.touchAction.preventDefaults(t);var n,i=this.recognizers,r=e.curRecognizer;(!r||r&&r.state&me)&&(r=e.curRecognizer=null);for(var o=0;o<i.length;)n=i[o],2===e.stopped||r&&n!=r&&!n.canRecognizeWith(r)?n.reset():n.recognize(t),!r&&n.state&(de|fe|pe)&&(r=e.curRecognizer=n),o++}},get:function(t){if(t instanceof K)return t;for(var e=this.recognizers,n=0;n<e.length;n++)if(e[n].options.event==t)return e[n];return null},add:function(t){if(h(t,"add",this))return this;var e=this.get(t.options.event);return e&&this.remove(e),this.recognizers.push(t),t.manager=this,this.touchAction.update(),t},remove:function(t){if(h(t,"remove",this))return this;if(t=this.get(t)){var e=this.recognizers,n=b(e,t);-1!==n&&(e.splice(n,1),this.touchAction.update())}return this},on:function(t,e){if(t!==a&&e!==a){var n=this.handlers;return l(w(t),function(t){n[t]=n[t]||[],n[t].push(e)}),this}},off:function(t,e){if(t!==a){var n=this.handlers;return l(w(t),function(t){e?n[t]&&n[t].splice(b(n[t],e),1):delete n[t]}),this}},emit:function(t,e){this.options.domEvents&&ft(t,e);var n=this.handlers[t]&&this.handlers[t].slice();if(n&&n.length){e.type=t,e.preventDefault=function(){e.srcEvent.preventDefault()};for(var i=0;i<n.length;)n[i](e),i++}},destroy:function(){this.element&&dt(this,!1),this.handlers={},this.session={},this.input.destroy(),this.element=null}},pt(lt,{INPUT_START:Et,INPUT_MOVE:Ct,INPUT_END:Pt,INPUT_CANCEL:Lt,STATE_POSSIBLE:ce,STATE_BEGAN:de,STATE_CHANGED:fe,STATE_ENDED:pe,STATE_RECOGNIZED:me,STATE_CANCELLED:ve,STATE_FAILED:32,DIRECTION_NONE:Rt,DIRECTION_LEFT:At,DIRECTION_RIGHT:Yt,DIRECTION_UP:It,DIRECTION_DOWN:zt,DIRECTION_HORIZONTAL:Nt,DIRECTION_VERTICAL:Wt,DIRECTION_ALL:jt,Manager:ct,Input:k,TouchAction:J,TouchInput:U,MouseInput:F,PointerEventInput:V,TouchMouseInput:X,SingleTouchInput:G,Recognizer:K,AttrRecognizer:it,Tap:ht,Pan:rt,Swipe:ut,Pinch:ot,Rotate:at,Press:st,on:v,off:y,each:l,merge:xt,extend:bt,assign:pt,inherit:d,bindFn:f,prefixed:M}),(void 0!==r?r:"undefined"!=typeof self?self:{}).Hammer=lt,(i=function(){return lt}.call(e,n,e,t))!==a&&(t.exports=i)}(window,document)},function(t,e,n){var i,r,o;!function(n,s){r=[],i=s,void 0!==(o="function"==typeof i?i.apply(e,r):i)&&(t.exports=o)}(0,function(){function t(t){var e,n=t&&t.preventDefault||!1,i=t&&t.container||window,r={},o={keydown:{},keyup:{}},s={};for(e=97;e<=122;e++)s[String.fromCharCode(e)]={code:e-97+65,shift:!1};for(e=65;e<=90;e++)s[String.fromCharCode(e)]={code:e,shift:!0};for(e=0;e<=9;e++)s[""+e]={code:48+e,shift:!1};for(e=1;e<=12;e++)s["F"+e]={code:111+e,shift:!1};for(e=0;e<=9;e++)s["num"+e]={code:96+e,shift:!1};s["num*"]={code:106,shift:!1},s["num+"]={code:107,shift:!1},s["num-"]={code:109,shift:!1},s["num/"]={code:111,shift:!1},s["num."]={code:110,shift:!1},s.left={code:37,shift:!1},s.up={code:38,shift:!1},s.right={code:39,shift:!1},s.down={code:40,shift:!1},s.space={code:32,shift:!1},s.enter={code:13,shift:!1},s.shift={code:16,shift:void 0},s.esc={code:27,shift:!1},s.backspace={code:8,shift:!1},s.tab={code:9,shift:!1},s.ctrl={code:17,shift:!1},s.alt={code:18,shift:!1},s.delete={code:46,shift:!1},s.pageup={code:33,shift:!1},s.pagedown={code:34,shift:!1},s["="]={code:187,shift:!1},s["-"]={code:189,shift:!1},s["]"]={code:221,shift:!1},s["["]={code:219,shift:!1};var a=function(t){h(t,"keydown")},u=function(t){h(t,"keyup")},h=function(t,e){if(void 0!==o[e][t.keyCode]){for(var i=o[e][t.keyCode],r=0;r<i.length;r++)void 0===i[r].shift?i[r].fn(t):1==i[r].shift&&1==t.shiftKey?i[r].fn(t):0==i[r].shift&&0==t.shiftKey&&i[r].fn(t);1==n&&t.preventDefault()}};return r.bind=function(t,e,n){if(void 0===n&&(n="keydown"),void 0===s[t])throw new Error("unsupported key: "+t);void 0===o[n][s[t].code]&&(o[n][s[t].code]=[]),o[n][s[t].code].push({fn:e,shift:s[t].shift})},r.bindAll=function(t,e){void 0===e&&(e="keydown");for(var n in s)s.hasOwnProperty(n)&&r.bind(n,t,e)},r.getKey=function(t){for(var e in s)if(s.hasOwnProperty(e)){if(1==t.shiftKey&&1==s[e].shift&&t.keyCode==s[e].code)return e;if(0==t.shiftKey&&0==s[e].shift&&t.keyCode==s[e].code)return e;if(t.keyCode==s[e].code&&"shift"==e)return e}return"unknown key, currently not supported"},r.unbind=function(t,e,n){if(void 0===n&&(n="keydown"),void 0===s[t])throw new Error("unsupported key: "+t);if(void 0!==e){var i=[],r=o[n][s[t].code];if(void 0!==r)for(var a=0;a<r.length;a++)r[a].fn==e&&r[a].shift==s[t].shift||i.push(o[n][s[t].code][a]);o[n][s[t].code]=i}else o[n][s[t].code]=[]},r.reset=function(){o={keydown:{},keyup:{}}},r.destroy=function(){o={keydown:{},keyup:{}},i.removeEventListener("keydown",a,!0),i.removeEventListener("keyup",u,!0)},i.addEventListener("keydown",a,!0),i.addEventListener("keyup",u,!0),r}return t})}])});