<?php

/* ######################################################################

  IML DEPLOYMENT

  webgui - check all ssh connections to puppet, git repos and taregt hosts
 
  ---------------------------------------------------------------------
  2018-02-01  Axel <axel.hahn@iml.unibe.ch>
  ###################################################################### */

$sOK='<span class="ok">' . t('ok') . '</span>';
$sFAILED='<span class="error">' . t('error') . '</span>';
$aErrors=array();
global $sOK;
global $sFAILED;
global $aErrors;

// test only
// $aConfig['mirrorPackages']=array('puppet' => array('target' => 'ladmin@calcium.iml.unibe.ch:/share/imldeployment'),);

// ----------------------------------------------------------------------
// functions
// ----------------------------------------------------------------------

/**
 * exec a command and show OK or FAILED
 * 
 * @global string $sOK
 * @global string $sFAILED
 * @param string   $sCmd  command to execute
 * @return string
 */
function myExec($sCmd){
    global $sOK, $sFAILED, $aErrors;
    $sReturn='';
    
    exec($sCmd . " 2>&1 && echo '$sOK' || echo '$sFAILED' ", $aOut);
    $sReturn .= "<pre><strong>\$ $sCmd</strong><br>"
            . implode('<br>', $aOut)."<br>"
            . "</pre>";
    if (strpos($sReturn, $sFAILED)){
        $aErrors[]=$sCmd;
    }
    return $sReturn;
}

// ----------------------------------------------------------------------
// main
// ----------------------------------------------------------------------

$sOut = '<h2>SSH</h2>';

if(isset($aConfig['mirrorPackages']) && count($aConfig['mirrorPackages'])){
    // test puppet
    $sOut = '<h3>Puppet</h3>'
            . '<ul>';
    foreach ($aConfig['mirrorPackages'] as $sServer=>$aSettings) {
        $sCmd = 'ssh ' . preg_replace('#\:\/.*#', '' , $aSettings['target']) . ' echo "hello from \`hostname -f\`"';
        $sOut .= '<li><strong>' . $sServer . '</strong> ' . myExec($sCmd);
    }
    $sOut.='</ul>';
}

// ... then loop over all projects ...
$oPrj1 = new project();
foreach ($oPrj1->getProjects() as $sPrj) {
    $oPrj = new project($sPrj);
    $aPrjConfig = $oPrj->getConfig();
    $sOut .= '<h3>' . $oPrj->getLabel() . '</h3>'
            // . '<pre>'.print_r($aPrjConfig, 1).'</pre>'
            . '<ul>';

    // test repository
    $sOut .= '<li>'.t('repositoryinfos').' <strong>' . $aPrjConfig['build']['url'] . '</strong> - ';
    if($oPrj->getRepoRevision()){
        $sOut .= $sOK;
    } else {
        $sOut .= $sFAILED;
        $aErrors[] = $aPrjConfig['build']['url'];
    }
    
    // loop over phases ...
    foreach (array_keys($oPrj->getPhases()) as $sPhase) {
        $sOut .= '<li>'.t('phase').' <strong>' . $sPhase . '</strong><ul>';
        $sDeployhosts = array_key_exists("hosts", $aPrjConfig["phases"][$sPhase]) ? $aPrjConfig["phases"][$sPhase]["hosts"] : "";

        if ($sDeployhosts) {
            foreach(explode(',', $sDeployhosts) as $sSingleSshTarget){
                $sOut .= '<li>' . $sSingleSshTarget . '<br>';
                $sCmd = 'ssh ' . $aConfig["installPackages"]["user"] . '@' . $sSingleSshTarget . ' echo "hello from \`hostname -f\`"';
                $sOut.= myExec($sCmd);
            }
        }
        $sOut.='</ul>';
    }
    $sOut.='</ul>';
}

if(count($aErrors)){
    echo $oHtml->getBox('error', '<ol><li>'.implode('<li>', $aErrors), '</ol>');
}
echo $sOut;
