<?php

/**
 * WIP
 * base class for all plugin types to read available plugins
 * and its metadata
 * 
 * @example
 *        $CI_plugins=new ciplugins();
 *        print_r($CI_plugins->getPluginTypes());
 * 
 *        // $CI_plugins->setType('build');
 *        // print_r($CI_plugins->getPlugins());
 *        print_r($CI_plugins->getPlugins('build'));
 * 
 *        $CI_plugins->setPlugin('tgz', 'build'); // plugin name + type
 *
 * 
 * @author axel
 */
class ciplugins {
    
    /**
     * start path of all plugin types (as subdirs)
     * @var string
     */
    protected $_sPlugindir=false;

    /**
     * path of the currently set plugin
     * @var string
     */
    protected $_sSelfdir=false;

    /**
     * url of set plugin
     * @var string
     */
    protected $_sSelfurl=false;

    /**
     * current plugin type - can be set via setType or setPlugin
     * @var string
     */
    protected $_sType=false;

    /**
     * current plugin name - can be set via setPlugin
     * @var string
     */
    protected $_sPluginname=false;

    /**
     * plugin language
     * @var string
     */
    protected $_sLang = "en-en";

    /**
     * plugin language texts (lang*.json)
     * @var array
     */
    protected $_aLang = [];

    /**
     * plugin configuration data (config.json)
     * @var array
     */
    protected $_aConfig = [];

    /**
     * global plugins config
     * see config/config_custom.php - key plugins
     * @var array
     */
    protected $_aGlobals = [];

    // ---------------------------------------------------------------
    // CONSTRUCTOR
    // ---------------------------------------------------------------

    /**
     * initialize plugins
     *
     * @param  array  $aGlobals  global settings for plugins
     * @return boolean
     */
    public function __construct($aGlobals=[]) {

        $this->_sPlugindir=dirname(__DIR__).'/plugins';
        $this->setGlobalCustoms($aGlobals);

        return true;
    }

    /**
     * global configs
     * see config/config_custom.php - key plugins
     * 
     * @param  array  $aGlobals  global settings for plugins
     * @return boolean
     */
    public function setGlobalCustoms($aGlobals){
        $this->_aGlobals=$aGlobals;
        return true;
    }
    // ---------------------------------------------------------------
    // FOR LISTING :: GETTER
    // ---------------------------------------------------------------

    /**
     * get an array of available plugin types read from filesystem
     * @return array
     */
    public function getPluginTypes(){
        $aReturn=[];
        foreach(glob($this->_sPlugindir.'/*', GLOB_ONLYDIR) as $sMydir){
            $aReturn[]=basename($sMydir);
        }
        return $aReturn;
    }

    /**
     * get an array of available plugins read from filesystem
     * 
     * @param  string  $sType  set a new type of plugin; default: use current type
     * @return array
     */
    public function getPlugins($sType=false){
        $aReturn=[];
        if($sType){
            if (!$this->setType($sType)){
                return $aReturn;
            }
        }
        foreach(glob($this->_sPlugindir.'/'.$this->_sType.'/*', GLOB_ONLYDIR) as $sMydir){
            $aReturn[]=basename($sMydir);
        }
        return $aReturn;
    }

    /**
     * get an array of enabled plugins
     * config/config_custom.php - key "plugins" -> [type] -> [plugin] -> enabled
     * and it must be physically available
     * 
     * @param  string  $sType  set a new type of plugin; default: use current type
     * @return array
     */
    public function getEnabledPlugins($sType=false){
        $aReturn = [];
        if($sType){
            if (!$this->setType($sType)){
                return $aReturn;
            }
        }
        if (isset($this->_aGlobals[$this->_sType]) 
            && is_array($this->_aGlobals[$this->_sType])
        ){
            foreach($this->_aGlobals[$this->_sType] as $sPluginName=>$aData){
                if (
                    isset($aData['enabled']) 
                    && $aData['enabled']
                    && is_dir($this->_sPlugindir.'/'.$this->_sType.'/'.$sPluginName)
                ){
                    $aReturn[]=$sPluginName;
                }
            }
        }
        return $aReturn;
    }

    // ---------------------------------------------------------------
    // 
    // BELOW ARE METHODS FOR A SPECIFICLY SET PLUGIN AND TYPE
    // 
    // ---------------------------------------------------------------

    // ---------------------------------------------------------------
    // SETTER
    // ---------------------------------------------------------------

    /**
     * set a type for plugins ... what is a name of a subdir in the plugins directory
     * @param  {string}  $sType  Name of a plugin type, e.g. build|rollout
     */
    public function setType($sType){
        $this->_sType=false;
        if(!$sType || !is_dir($this->_sPlugindir.'/'.$sType)){
            return false;
        }
        return $this->_sType=$sType;
    }

    /**
     * reset vars before setting a new plugin;
     * called in testPlugin()
     * @return boolean
     */
    protected function _resetPluginData(){
        $this->_sPluginname=false;
        $this->_sSelfdir=false;
        $this->_sSelfurl=false;
        $this->_aLang=[];
        $this->_aConfig=[];
        return true;
    }

    /**
     * set a plugin without autoload of its php class
     * It returns the path of php class for true 
     * or boolean false if it does not exist
     * 
     * This can be used standalone to embed html code 
     * without loading any php code of the plugin class.
     * 
     * @param  {string}  $sPluginName  name of the plugin
     * @param  {string}  $sType        optional: set a type
     * @return bool|string
     */
    public function testPlugin($sPluginName,$sType=false){
        $this->_resetPluginData();
        if($sType){
            if (!$this->setType($sType)){
                return false;
            }
        }
        $this->_sSelfdir=$this->_sPlugindir.'/'.$this->_sType.'/'.$sPluginName;
        $sFile=$this->_sSelfdir.'/plugin.php';
        if(!file_exists($sFile)){
            // die(' MISS '.$sFile);
            $this->_sSelfdir=false;
            return false;
        }
        $this->_sPluginname=$sPluginName;
        $this->_sSelfurl='/deployment/plugins/'.$this->_sType.'/'.$sPluginName;
        return $sFile;
    }

    /**
     * set a plugin with autoload of its php class
     * It returns a boolean
     * 
     * @param  {string}  $sPluginName  name of the plugin
     * @param  {string}  $sType        optional: set a type
     * @return bool
     */
    public function setPlugin($sPluginName,$sType=false){
        $sFile=$this->testPlugin($sPluginName,$sType);
        if(!$sFile){
            return false;
        }
        include_once $sFile;
        return true;
    }
    // ---------------------------------------------------------------
    // getter for plugin
    // ---------------------------------------------------------------
    /**
     * get config entry
     * @param  string  $sKey  name of config value
     */
    public function getConfigitem($sKey){
        return isset($this->_aConfig[$sKey]) ? $this->_aConfig[$sKey] : false;
    }    
    /**
     * get plugin config from its config.json
     * works with
     *   - shellcmd plugin
     * @return array
     */
    public function getPluginConfig(){
        if(count($this->_aConfig)){
            return $this->_aConfig;
        }
        $this->_aConfig=(file_exists($this->_sSelfdir.'/config.json'))
            ? json_decode(file_get_contents($this->_sSelfdir.'/config.json'), 1)
            : ["error" => "config.json not found in ".$this->_sSelfdir]
        ;
        return $this->_aConfig;
    }
    // ---------------------------------------------------------------
    // access plugin php class
    // ---------------------------------------------------------------

    /**
     * get a location of a plugin file with full path
     * @param  {bool}  $bAutoload  flag: autoload needed plugin file
     * @return string
     */
    public function getPluginClassname(){
        return $this->_sType.'_'.$this->_sPluginname;
    }

    public function initPlugin(){
        $sClassname=$this->_sType.'_'.$this->_sPlugindir;
        $TmpRolloutPlugin = new $sClassname([]);

    }

}
