<?php
/**
 * GENERAL CLASS TO FETCH DATA FROM A SHELL COMMAND 
 * FOR THE WEB UI
 * 
 * Used in ../plugins/shellcmd/getdata.php
 * 
 */

require_once('plugins.class.php');

class req_shellcmd {

    protected $_sPlugin=false;
    protected $_oPlugin=false;
    protected $_aReturn=false;

    protected $_aPluginConfig=[];

    protected $_aResult=[];
    protected $_debug=false;

    /**
     * plugins class instance
     * @var object
     */
    protected $CI_plugins=false;

    // ---------------------------------------------------------------
    // CONSTRUCTOR
    // ---------------------------------------------------------------

    /**
     * constructor
     * @return bool
     */
    public function __construct(){
        return $this->detectPlugin();
    }

    // ---------------------------------------------------------------
    // PRIVATE METHODS
    // ---------------------------------------------------------------

    /**
     * helper execute a given command and return array with executed
     * command, returncode, output
     * @return
     */
    protected function _execCommand($sCmd){
        exec("$sCmd", $aOut, $iResult);
        return [
            'command'=>$sCmd,
            'exitcode'=>$iResult,
            'time'=>date("H:i:s"),
            'output'=>$aOut,
        ];
    }


    /**
     * initialize the shellcmd plugin
     * @returm boolean
     */
    protected function _loadPlugin(){
        $this->CI_plugins=new ciplugins();
        $this->CI_plugins->setPlugin($this->_sPlugin, 'shellcmd');

        $sPluginclass=$this->CI_plugins->getPluginClassname();        
        $this->_oPlugin=new $sPluginclass();

    }

    /**
     * write debug output ... if enabled
     */
    protected function _wd($s){
        echo $this->_debug ? 'DEBUG '.__CLASS__ . ' '.$s."<br>\n" : '';
    }

    // ---------------------------------------------------------------
    // PUBLIC METHODS
    // ---------------------------------------------------------------

    /**
     * detect plugin name to load from GET param "plugin"
     */
    public function detectPlugin(){
        $this->_sPlugin=isset($_GET['plugin']) && $_GET['plugin'] ? preg_replace('/^a-z0-9/', '', $_GET['plugin']) : false;
        $this->_wd("detected plugin: ".$this->_sPlugin);
        return true;
    }


    /**
     * get data from plugin command and return array with executed
     * command, returncode, output, parsed data
     * @return array
     */
    public function get(){
        $this->_loadPlugin();
        if (!$this->_oPlugin){
            return $this->_aReturn;
        }
        $this->CI_plugins->getPluginConfig();
        $sCmd=$this->CI_plugins->getConfigitem('command');
        $this->_wd("sCmd=$sCmd");
        
        $this->_aResult=$this->_execCommand($sCmd);
        if (method_exists($this->_oPlugin, "parsedata")){
            $this->_aResult=$this->_oPlugin->parsedata($this->_aResult);
        }
        return $this->_aResult;
    }

    /**
     * send response as json
     */
    public function sendResponse(){
        header('Content-Type: application/json');
        echo json_encode($this->get(), JSON_PRETTY_PRINT);
    }

}
