<?php

/* ######################################################################

  IML DEPLOYMENT

  included functions for the act_*.php files

  ---------------------------------------------------------------------
  2013-11-08  Axel <axel.hahn@iml.unibe.ch>
  ###################################################################### */

global $aParams;
$aParams = array();


// remark: $_SERVER does not exist in CLI
if (isset($_SERVER) && is_array($_SERVER) && array_key_exists("REQUEST_URI", $_SERVER)) {
    /*
      print_r($_GET);
      print_r($_POST);
      print_r($aParams);
      print_r($_SERVER);
      echo $_SERVER["REQUEST_URI"];
     */
    $aTmp = preg_split("#/#", $_SERVER["REQUEST_URI"]);
    if (count($aTmp) > 1 && $aTmp[1] == "deployment" && $aTmp[2] != "?") {
        array_shift($aTmp);
        array_shift($aTmp);
        if (
            count($aTmp) && $aTmp[count($aTmp) - 1] && $aTmp[count($aTmp) - 1][0] == "?"
        ) {
            array_pop($aTmp);
        }
        if (count($aTmp) && $aTmp[0])
            $aParams["prj"] = $aTmp[0];
        if (count($aTmp) > 1 && $aTmp[1])
            $aParams["action"] = $aTmp[1];
        if (count($aTmp) > 2 && $aTmp[2])
            $aParams["par3"] = $aTmp[2];
        if (count($aTmp) > 3 && $aTmp[3])
            $aParams["par4"] = $aTmp[3];
    }
    if (count($_GET))
        foreach ($_GET as $key => $value)
            $aParams[$key] = $value;
    if (count($_POST))
        foreach ($_POST as $key => $value)
            $aParams[$key] = $value;

    /* force integer params
      foreach (array("id") as $sKey) {
      if (array_key_exists($sKey, $aParams)) {
      $aParams[$sKey]=(int)$aParams[$sKey];
      }
      }
     */

    foreach (array_keys($aParams) as $sKey) {
        $aParams[$sKey] = is_string($aParams[$sKey])
            ? str_replace(array('\\', "\0", "\n", "\r", "'", '"', "\x1a"), array('\\\\', '\\0', '\\n', '\\r', "\\'", '\\"', '\\Z'), $aParams[$sKey])
            : $aParams[$sKey];
    }
}

/**
 * get home link as button
 * @return string
 */
function aHome($sClass = "btn btn-default")
{
    global $oHtml;
    // if (!array_key_exists("prj", $aParams)) return false;
    return $oHtml->getLinkButton(array(
        'href' => '/deployment/?',
        'icon' => 'overview',
        'class' => $sClass,
        'label' => t("menu-overview"),
    ));
}

/**
 * get project Home link as button
 * @return string
 */
function aPrjHome($sClass = "btn btn-default")
{
    global $aParams, $oHtml;
    if (!array_key_exists("prj", $aParams)) {
        return false;
    }
    if ($aParams["prj"] == "all") {
        return aHome($sClass);
    }
    // if (!array_key_exists("action", $aParams)) return false;

    require_once("./classes/project.class.php");
    $oPrj = new project($aParams["prj"]);
    return $oHtml->getLinkButton(array(
        'href' => '/deployment/' . $aParams["prj"] . '/',
        'icon' => 'project',
        'class' => $sClass,
        'label' => $oPrj->getLabel(),
    ));
}

/**
 * get go back link as button
 * @return string
 */
function aGoback($sClass = "btn btn-default")
{
    global $oHtml;
    return $oHtml->getLinkButton(array(
        'href' => '#',
        'onclick' => 'history.back();',
        'title' => t("back"),
        'icon' => 'back',
        'class' => $sClass,
        'label' => t("back")
    ));
}
/**
 * get go top link as button
 * @return string
 */
function aGotop($sClass = "scroll-link btn btn-default")
{
    global $oHtml;
    return $oHtml->getLinkButton(array(
        'href' => '#top',
        'class' => $sClass,
        'title' => t("gotop"),
        'icon' => 'gotop',
        'label' => ' '
    ));
}

/**
 * get array top left navigation
 * @return array
 */
function getTopNavLeft($aEmbed = [])
{
    global $aParams, $oHtml;
    $aReturn = [];
    require_once("./classes/project.class.php");
    require_once("./classes/user.class.php");
    $oUser = new user();
    $sBaseUrl = '/deployment/';

    $sBaseUrl = '/deployment/';
    $sCurrentProject = (array_key_exists("prj", $aParams) && $aParams["prj"] <> "all") ? $aParams["prj"] : false;
    $sCurrentAction = (array_key_exists("action", $aParams) && $aParams["action"]) ? $aParams["action"] : false;
    $sCurrentPar3 = (array_key_exists("par3", $aParams) && $aParams["par3"]) ? $aParams["par3"] : false;

    // $aReturn[]=['label'=>'=' ];
    $aReturn[] = ['href' => $sBaseUrl . '', 'label' => '&nbsp;Deployment UI <small class="badge bg-info"><nobr>v' . APP_VERSION . '</nobr></small>',    'icon' => '', 'class' => 'imllogo topbrand'];

    if ($oUser->getUsername()) {
        $oPrj1 = new project();
        $aPrjItems = [];
        foreach ($oPrj1->getProjects("label") as $aProject) {
            $aPrjItems[] = [
                'href' => $sBaseUrl . $aProject['id'] . '/',
                'label' => $aProject['label'],
                'class' => $sCurrentProject === $aProject['id'] ? 'active' : '',
                'icon' => 'fa-solid fa-book',
            ];
        }
        /* to test a scrolling menu
        $aPrjItems=array_merge(
            $aPrjItems,$aPrjItems,$aPrjItems,$aPrjItems,$aPrjItems,
            $aPrjItems,$aPrjItems,$aPrjItems,$aPrjItems,$aPrjItems,
            $aPrjItems,$aPrjItems,$aPrjItems,$aPrjItems,$aPrjItems,
        );
        */

        $aReturn[] = [
            'href' => $sBaseUrl, 'label' => t("menu"),
            'icon' => 'fa-solid fa-chevron-right',
            'class' => ($sCurrentAction === 'setup' || $sCurrentAction === 'valuestore' ? 'active' : ''),
            'children' => [
                ['href' => $sBaseUrl . 'all/setup/new/',       'label' => t("menu-new-project"), 'icon' => 'fa-regular fa-star',           'class' => ($sCurrentPar3   === 'new'        ? 'active' : ''),],
                ['href' => $sBaseUrl . 'all/setup/actionlog/', 'label' => t("menu-logs"),        'icon' => 'fa-regular fa-rectangle-list', 'class' => ($sCurrentPar3   === 'actionlog'  ? 'active' : ''),],
                ['href' => $sBaseUrl . 'all/valuestore/',      'label' => t("menu-valuestore"),  'icon' => 'fa-solid fa-tags',             'class' => ($sCurrentAction === 'valuestore' ? 'active' : ''),],
                ['href' => $sBaseUrl . 'all/setup/checklang/', 'label' => t("menu-checklang"),   'icon' => 'fa-regular fa-comment',        'class' => ($sCurrentPar3   === 'checklang'  ? 'active' : ''),],
                ['label' => '-'],
                ['href' => $sBaseUrl . 'all/setup/',           'label' => t("menu-settings"),    'icon' => 'fa-solid fa-gear'],
            ]
        ];
        if (count($aPrjItems)) {
            $aReturn[] = [
                'href' => '#', 'label' => t("menu-projects"), 'icon' => 'fa-solid fa-box-open',
                'children' => $aPrjItems
            ];
        }
        if ($sCurrentProject) {
            $oPrj = new project($aParams["prj"]);
            $aPrjChildren = [
                ['href' => $sBaseUrl . $sCurrentProject . '/', 'label' => $oHtml->getIcon('project-home') . t("project-home"), 'icon' => '', 'class' => ($sCurrentAction == '' ? 'active' : '')],
                ['label' => '-'],
            ];
            $aPhases = $oPrj->getActivePhases();
            if (count($aPhases)) {
                $aPrjChildren[] = ['href' => $sBaseUrl . $sCurrentProject . '/build/', 'label' => $oHtml->getIcon('build') . t("build"), 'icon' => '', 'class' => ($sCurrentAction === 'build' ? 'active' : '')];
                $aPrjChildren[] = ['label' => '-'];

                foreach ($aPhases as $sPhase) {
                    $aPrjChildren[] = ['href' => $sBaseUrl . $sCurrentProject . '/phase/' . $sPhase . '/', 'label' => $oHtml->getIcon('phase') . $sPhase, 'icon' => '', 'class' => (isset($aParams['par3']) && $aParams['par3'] === $sPhase ? 'active' : '')];
                }
                $aPrjChildren[] = ['label' => '-'];
            }
            $aPrjChildren[] = ['href' => $sBaseUrl . $sCurrentProject . '/setup/',   'label' => $oHtml->getIcon('setup') . t("menu-project-settings"), 'icon' => '',  'class' => ($sCurrentAction === 'setup'   ? 'active' : '')];
            $aPrjChildren[] = ['href' => $sBaseUrl . $sCurrentProject . '/cleanup/', 'label' => $oHtml->getIcon('cleanup') . t("menu-project-cleanup"), 'icon' => '', 'class' => ($sCurrentAction === 'cleanup' ? 'active' : '')];
            $aPrjChildren[] = ['href' => $sBaseUrl . $sCurrentProject . '/delete/',  'label' => $oHtml->getIcon('delete') . t("menu-project-delete"), 'icon' => '',   'class' => ($sCurrentAction === 'delete'  ? 'active' : '')];

            $aReturn[] = [
                'href' => '#', 'label' => $oPrj->getLabel(), 'icon' => 'fa-solid fa-book', 'class' => 'active',
                'children' => $aPrjChildren
            ];
        }
    }
    // echo '<pre>'.print_r($aReturn, 1); die(__FUNCTION__);
    return $aReturn;
}

/**
 * get array top left navigation
 * @return array
 */
function getTopNavRight()
{
    global $aParams, $oHtml;
    $aReturn = [];
    require_once("./classes/project.class.php");
    require_once("./classes/user.class.php");
    $oUser = new user();

    $sBaseUrl = '/deployment/';
    $sWikiBaseUrl = 'https://intranet.iml.unibe.ch/wiki/doku.php';
    $sCurrentAction = (array_key_exists("action", $aParams) && $aParams["action"]) ? $aParams["action"] : false;

    if ($oUser->getUsername()) {
        $aReturn = [
            [
                'href' => '#', 'label' => $oUser->getUsername(),    'icon' => 'fa-solid fa-user',
                'class' => ($sCurrentAction == 'login' ? 'active' : ''),
                'children' => [
                    ['href' => $sBaseUrl . 'all/login/',           'label' => t("menu-userprofile"),            'icon' => 'fa-regular fa-id-card', 'class' => ($sCurrentAction == 'login' ? 'active' : '')],
                ]
            ]
        ];
    } else {
        $aReturn[] = ['href' => $sBaseUrl . 'all/login/',           'label' => t("login"),            'icon' => 'fa-solid fa-right-to-bracket', 'class' => ($sCurrentAction == 'login' ? 'active' : '')];
    }
    $aReturn[] = [
        'href' => '#', 'label' => t('menu-help'), 'icon' => 'fa-solid fa-life-ring', 'class' => '',
        'children' => [
            ['href' => $sWikiBaseUrl . '/it/entwicklung/continuous_deployment',                'target' => '_help', 'label' => 'WIKI: Übersicht Continous Deployment',    'icon' => ''],
            ['href' => $sWikiBaseUrl . '/it/entwicklung/continuous_deployment#konventionen',   'target' => '_help', 'label' => 'WIKI: Konventionen für Entwickler',       'icon' => ''],
            ['href' => $sWikiBaseUrl . '/it/infrastruktur/se/snippets/iml.deployment_profile', 'target' => '_help', 'label' => 'WIKI (Admin): Snippets für den Sysadmin', 'icon' => ''],
            ['href' => $sWikiBaseUrl . '/it/infrastruktur/dienste/imldeployment',              'target' => '_help', 'label' => 'WIKI (Admin): Verzeichnisse und Dateien', 'icon' => ''],
            ['href' => $sBaseUrl . 'all/doc',                                                                       'label' => t('menu-help-classes'),                    'icon' => ''],
        ]
    ];

    // echo '<pre>'.print_r($aReturn, 1); die(__FUNCTION__);
    return $aReturn;
}

/**
 * get h2 headline with action
 * @global type $aParams
 * @param  string  $sLinkClass  classname for links; default: "" (adds class="btn btn-default")
 * @return string
 */
function getBreadcrumb($sLinkClass = "")
{
    global $aParams, $oHtml;
    $sReturn = '';
    $sNav = '';
    $sLabel = '';
    // $sDelim=$oHtml->getIcon('fa-chevron-right');

    $sDelim = '&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;';
    if (array_key_exists("action", $aParams)) {
        $sLabel .= $oHtml->getIcon($aParams["action"]) . t($aParams["action"]);
        $sNav .= aHome($sLinkClass);
        if ($aParams['prj'] === 'all') {
            // $sNav .= ' ' . $oHtml->getIcon('fa-chevron-right') . '[ci-GUI]';
        } else {
            $sNav .= ' ' . $sDelim . aPrjHome($sLinkClass);
        }
        $sClass = 'action ' . $aParams["action"];
        if (array_key_exists("par3", $aParams)) {
            $sLabel = $oHtml->getIcon($aParams["par3"]) . $aParams["par3"];
            $sClass = 'action ' . $aParams["action"];
        }
        // $sReturn.='<h2 class="action ' . $aParams["action"] . '">' . $sLabel . '</h2>';
    } else if (array_key_exists("prj", $aParams)) {
        $sNav .= aHome($sLinkClass);
        $sClass = 'action prjhome';
        // $sLabel.=$oHtml->getIcon('project').t('project-home');
        $sLabel .= aPrjHome($sLinkClass);
        // $sReturn.='<h2 class="action prjhome"> Projekt-Home</h2>';
    }
        // $sReturn.=($sNav ? '<div id="navtop">' . $sNav .  ' ' . $sDelim . ' <span class="current">'.$sLabel.'</span></div>':'')
        // .'<h2 class="'.$sClass.'"> '.$sLabel.'</h2>'
    ;
    $sReturn .= ($sNav ? '' . $sNav .  ' ' . $sDelim . ' <span class="current">' . $sLabel . '</span>' : '');
    if ($sLinkClass) {
        $sReturn = str_replace(['btn-default ', 'btn '], ['', ''], $sReturn);
    }
    return $sReturn;
}

/**
 * get version info
 * @return string
 */
function getVersioninfo()
{
    $sMyRev = "";

    $aFiles = glob(dirname(dirname(__DIR__)) . "/*.json");
    if (isset($aFiles[0])) {
        $aJson = json_decode(file_get_contents($aFiles[0]), true);
        $sMyRev = (isset($aJson["branch"]) ? $aJson["branch"] . ' - ' : '')
            . (isset($aJson["date"]) ? $aJson["date"] : '');
    }
    return ($sMyRev  ? $sMyRev . ' @ ' : '') . php_uname("n");
}
/**
 * translate function
 * @global type $aConfig
 * @staticvar array $aLang
 * @param string $s text
 * @return string
 */
function t($s)
{
    global $aConfig;
    static $aLang = array();

    if (!is_array($aConfig) || !array_key_exists("lang", $aConfig)) {
        die("ERROR: \$aConfig[\"lang\"] does not exist.\n");
    }
    if (!count($aLang)) {
        $sLangfile = __DIR__ . "/../../config/lang/" . $aConfig["lang"] . ".json";
        if (!file_exists($sLangfile)) {
            die("language file was not found: $sLangfile");
        }
        $aLang = json_decode(file_get_contents($sLangfile), true);
    }

    if (!array_key_exists($s, $aLang)) {
        return '<span class="warning">' . $s . '</span>';
    }
    // return $aLang[$s].' ('.$s.')';
    return $aLang[$s];
}

/**
 * enter user and comment 
 * @global type $aParams
 * @return string
 */
function enterDeployinfos()
{
    global $aParams;
    $sIdUser = "inputUser";
    $sIdComment = "inputComment";
    $sUser = (array_key_exists($sIdUser, $aParams)) ? $aParams[$sIdUser] : "";
    $sComment = (array_key_exists($sIdComment, $aParams)) ? $aParams[$sIdComment] : "";

    $sOut = '
        <div class="control-group">
            <label class="control-label" for="inputUser">Benutzername</label>
            <div class="controls">
                <input type="text" id="inputUser" name="inputUser" placeholder="Benutzername" value="' . $sUser . '">
            </div>
        </div>
        <div class="control-group">
            <label class="control-label" for="inputComment">Kommentar zum Deployment</label>
            <div class="controls">
                <textarea id= rows="3" id="inputComment" name="inputComment" placeholder="Kommentar">' . $sComment . '</textarea>
            </div>
        </div>
        ';

    return $sOut;
}
