<?php

/**
 * 
 * Build plugin - TGZ
 * 
 * @author <axel.hahn@iml.unibe.ch>
 */
class build_zip extends build_base {
    
    /**
     * check requirements if the plugin could work
     * @return array
     */
    public function checkRequirements() {
        return [
            'which zip'
        ];
    }
    
    /**
     * get an array with shell commands to execute
     * used zip params:
     *   -9   compress better
     *   -q   quiet operation
     *   -r   recurse into directories
     * @return array
     */
    public function getBuildCommands(){
        return [
            'cd "'. $this->getBuildDir(). '" && zip -9qr "'. $this->getOutfile().'" .'
        ];
    }
   

}
