<?php

define("APP_VERSION", '2.0-alpha');

session_start();

require_once("./classes/project_gui.class.php");
require_once('./classes/queryparam.class.php');
# require_once('./classes/icon.class.php');


$sPpage=queryparam::get('page', '/^[a-z]*$/');

require_once('./classes/render-adminlte.class.php');
$renderAdminLTE=new renderadminlte();

$aReplace=include("./ui/page_replacements.php");


// detect first run
$bFirstRun=!file_exists("../../config/config_custom.php") || !file_exists("../../config/inc_user2roles.php");

require_once("../../config/inc_projects_config.php");
require_once("./classes/logger.class.php");
require_once("./classes/user.class.php");
global $oCLog;
$oCLog = new logger();
$oCLog->enableDebugByIp($aConfig['showdebug']['ip']);

require_once("./inc_functions.php");
require_once("./classes/htmlguielements.class.php");
require_once("./classes/plugins_renderer.class.php");
$oHtml=new htmlguielements();

$sPrj = "";
$sAction = "overview";

// ----------------------------------------------------------------------
// check params
// ----------------------------------------------------------------------

if (array_key_exists("prj", $aParams)) {
    $sPrj = $aParams["prj"];
}
if (array_key_exists("action", $aParams)) {
    if (file_exists(__DIR__ . '/pages/act_' . $aParams["action"] . ".php")) {
        $sAction = $aParams["action"];
    }
}
$oCLog->add("parsing params "
        . '<pre>GET '.print_r($_GET, true).'</pre>'
        . '<pre>POST '.print_r($_POST, true).'</pre>'
        . '<pre>aParams: '.print_r($aParams, true).'</pre>'
        );

if($bFirstRun){
    $sAction='installer';
}

// ------ action 
$oUser = new user();

if (isset($aConfig["auth"]['forceuser']) && $aConfig["auth"]['forceuser']){
    $oCLog->add("Found config -> auth -> forceuser: using fake identity [".$aConfig["auth"]['forceuser'].']', "warning");
    $oUser->setUser($aConfig["auth"]['forceuser']);
}
        
// ----------------------------------------------------------------------
// html header
// ----------------------------------------------------------------------

$sHeader = "\n<!-- generated CSS for phases -->\n<style>\n";
foreach ($aConfig["phases"] as $sPhase => $aData) {
    $sHeader.=array_key_exists("bgdark", $aData["css"]) ? 'th.' . $sPhase . '{' . $aData["css"]["bgdark"] . '}' : '';
    $sHeader.=array_key_exists("bglight", $aData["css"]) ? 'td.' . $sPhase . ', div.' . $sPhase . '{' . $aData["css"]["bglight"] . '}' : '';
    $sHeader.=array_key_exists("bgbutton", $aData["css"]) ? 'a.' . $sPhase . ',a.' . $sPhase . ':hover,button.' . $sPhase . ',button.' . $sPhase . ':hover{' . $aData["css"]["bgbutton"] . '}' : '';
}
$sHeader.="</style>\n";

// add shellcmd files
$sShellOuptut='';
$sTopRight='';

$CI_plugins=new plugin_renderer(isset($aConfig['plugins']) ? $aConfig['plugins'] : []);
$CI_plugins->setType('shellcmd');

$aEnabledShellPlugins=$CI_plugins->getEnabledPlugins('shellcmd');
$sHeader.= count($aEnabledShellPlugins) 
    ? '' 
        ."\n<!-- for shellcmd plugins -->\n"
        .'<script src="/vendor/axelhahn/js/ubd.class.js"></script>'."\n"
        .'<script src="/vendor/winbox/0.2.82/winbox.min.js"></script>'."\n"
        .'<link rel="stylesheet" type="text/css" href="/vendor/winbox/0.2.82/winbox.min.css"/>'."\n"
        ."<!-- shellcmd scripts -->\n"
    : ''
    ;
$aNavRight=[];
if($oUser->getUsername()){
    foreach ($aEnabledShellPlugins as $sPlugin){
        if ($CI_plugins->testPlugin($sPlugin)){
            $aPluginConfig=$CI_plugins->getPluginConfig();
            $sHeader.=$CI_plugins->getHtmlLoadScript('render.js');
            $sShellOuptut.=$CI_plugins->getHtmlOutwindow();
            $aNavRight[]=['href'=>'#' , 'label'=>$sPlugin, 'icon'=>(isset($aPluginConfig['icon']) ? $aPluginConfig['icon'] : ''), 'onclick'=>'toggleShellWindow(\''.$CI_plugins->getHtmlOutId().'\', this);'];
            /*
            $sTopRight.=''
                .'<li >'
                .$oHtml->getLink(array(
                    'href'=>'#',
                    // 'onclick'=>'toggleShellWindow(\''.$CI_plugins->getHtmlOutIdWrapper().'\', this);',
                    'onclick'=>'toggleShellWindow(\''.$CI_plugins->getHtmlOutId().'\', this);',
                    'role'=>'button',
                    'aria-expanded'=>'false',
                    'icon'=> (isset($aPluginConfig['icon']) ? $aPluginConfig['icon'] : ''),
                    'label'=>$sPlugin,
                ))
                .'</li>'
            ;
            */
        }
    }
    if(count($aNavRight)){
        $aNavRight[]=['label'=>'|'];
    }
}

// ----------------------------------------------------------------------
// html body
// ----------------------------------------------------------------------
$BODY="";
$TITLE="";

$sBanner=isset($aConfig['banner']) && $aConfig['banner'] ? '<div class="alert alert-info">'.$aConfig['banner'].'</div>' : '';

if(isset($aParams["prj"])){
    $oPrj = new project($aParams["prj"]);
    $TITLE=$oPrj->getLabel().' <div class="description">'.$oPrj->getDescription().'</div>';
} else {
    $TITLE=t("overview-label") . '<div class="description">' . t("overview-hint") . '</div>';
}
// $sReturn.='<h1>' . $oPrj->getLabel() . '</h1>'
//         . '<span class="description">' . $oPrj->getDescription() . '</span>';

// ------ action 
if (isset($aConfig["auth"]['forceuser']) && $aConfig["auth"]['forceuser']){
    $oCLog->add("Found config -> auth -> forceuser: using fake identity [".$aConfig["auth"]['forceuser'].']', "warning");
    $oUser->setUser($aConfig["auth"]['forceuser']);
}

// ------ action
if (isset($aConfig["auth"]['forceuser']) && $aConfig["auth"]['forceuser']){
    $oCLog->add("Found config -> auth -> forceuser: using fake identity [".$aConfig["auth"]['forceuser'].']', "warning");
    $oUser->setUser($aConfig["auth"]['forceuser']);
}

if ($oUser->hasPermission('page_'.$sAction)){

    $sActionFile = __DIR__ . '/pages/act_' . $sAction . ".php";

    $oCLog->add("including $sActionFile");
    ob_start();
    if (!@include($sActionFile)) {
        include("./pages/error_404.php");
    }
    $OUT = ob_get_contents();
    ob_end_clean();
    $oCLog->add("including done $sActionFile");

    // echo "BODY is $BODY";
    // echo "OUT is $OUT";
    if(!$BODY){
        $BODY=""
            // ."INFO: $sActionFile did not set \$BODY<br><br>"
            .$renderAdminLTE->getCard([
                // 'title'=>'Hello',
                'type'=>'gray',
                'variant'=>'outline',
                'text'=>$OUT,
            ])
        ;
    }
    if(!$TITLE){
        $TITLE="WARNING: $sActionFile did not set \$TITLE";
    }
    $oCLog->add("adding actionlog.class");

    if ($oUser->getUsername()){
        require_once("./classes/actionlog.class.php");
        $aFilter=array('limit'=>'0, 10');
        if ($sPrj && $sPrj!="all"){
            $aFilter['project']=$sPrj;
        }
        $oLog=new Actionlog($sPrj);
        $sLogOutput=$oLog->renderLogs($aFilter);
        $BODY.=($sLogOutput > ' '
            ? $renderAdminLTE->getCard([
                'type'=>'',
                'variant'=>'outline',
                'text'=>$sLogOutput
            ])
            : ''
        )
        ;

    }
    $oCLog->add("adding actionlog.class done");
} else {
    $BODY=$oUser->showDenied();
    // return false;
}



// ----------------------------------------------------------------------
// render page
// ----------------------------------------------------------------------

$oCLog->add("Finally: rendering page ...");

$BODY = '
    ' 
    . $sHeader
    . $sShellOuptut
    .'
        ' . $sBanner . ($oUser->getUsername() ? getBreadcrumb() : '') . '
    
        ' . $BODY . '
    

    <!--        
    <div id="footer">
        '.t("menu-brand").' &copy; 2013-' . date("Y") . ' <a href="https://git-repo.iml.unibe.ch/iml-open-source/imldeployment/" target="_blank">Institut f&uuml;r Medizinische Lehre; Universit&auml;t Bern</a>
    </div>
    -->
    '
    .$oCLog->render();

$aTopnav=getTopNavLeft();

$aReplace['{{NAVI_TOP}}']=''
. $renderAdminLTE->addWrapper(
    'nav', ['class'=>'main-header navbar navbar-expand navbar-white navbar-light'],
    $renderAdminLTE->getTopNavigation($aTopnav,false, array_merge($aNavRight, getTopNavRight()), false)
    // add 2nd navbar if needed
)
;
$aSidebarNav=[];
$aReplace['{{NAVI_LEFT}}']=''
    . $renderAdminLTE->addWrapper(
        'nav', ['class'=>'mt-2'],
        $renderAdminLTE->getSidebarNavigation($aSidebarNav)
    );


// ---------- include page content
$sIncfile='pages/'.$sPpage.'.php';
if(!file_exists($sIncfile)){
    $sIncfile='pages/error404.php';
}

// include($sIncfile);


// ---------- generate output
$aReplace['{{PAGE_BODY}}']=$BODY;
$aReplace['{{PAGE_BODY}}']=$BODY;
$aReplace['{{PAGE_HEADER_LEFT}}']='<h2>'.$TITLE.'</h2>';
$aReplace['{{PAGE_HEADER_RIGHT}}']=$oUser->getUsername() ? getBreadcrumb("link") : '';

$sTemplate=file_get_contents('ui/page.tpl.php');
echo $renderAdminLTE->render($sTemplate,$aReplace);
