<?php

/* ######################################################################

  IML DEPLOYMENT

  webgui - delete

  Maybe we can delete file (see inc_functions.php there is the menu).
  Cleanup will be done in build method.

  ---------------------------------------------------------------------
  2014-03-24  Axel <axel.hahn@iml.unibe.ch>
  ###################################################################### */

require_once("./classes/project_gui.class.php");
require_once("./classes/formgen.class.php");

$oPrj = new projectgui($sPrj);

$sOut = '<h3>' . t('page-delete-project-info') . '</h3>';


if (!array_key_exists("confirm", $aParams)) {

    // ----- form to confirm deletion

    $sOut .= '<p>' . t('page-delete-project-introtext') . '</p>'
            . $oPrj->renderVersionUsage() . '<br><br>';


    $i = 0;
    $aForms = array(
        'setup' => array(
            'meta' => array(
                'method' => 'POST',
                'action' => '?',
            ),
            'validate' => array(),
            'form' => array(
                'input' . $i++ => array(
                    'type' => 'hidden',
                    'name' => 'confirm',
                    'value' => '1',
                ),
                'input' . $i++ => array(
                    'type' => 'checkbox',
                    'name' => 'removeOptions',
                    'label' => t("page-delete-remove-options"),
                    'validate' => 'isastring',
                    'value' => 1,
                    'options' => array(
                        'bRemoveRepolinks' => array(
                            'label' => t("page-delete-cb-label-remove-links-for-repo"),
                            'checked' => false,
                        ),
                        'bRemoveArchive' => array(
                            'label' => t("page-delete-cb-label-remove-archive"),
                            'checked' => false,
                        ),
                        'bRemoveConfig' => array(
                            'label' => t("page-delete-cb-label-remove-config"),
                            'checked' => true,
                        ),
                    ),
                ),
                'markup' . $i++ => array(
                    'type' => 'markup',
                    'value' => '<hr>',
                ),
                'button' . $i++ => array(
                    'type' => 'submit',
                    'class' => 'btn-danger',
                    'value' => $oHtml->getIcon('delete') . t("page-delete-project-buttonlabel"),
                ),
            ),
        ),
    );
    $oForm = new formgen($aForms);
    $sOut .= $oForm->renderHtml("setup");
    $sHome= aPrjHome();
    
} else {

    // ----- delete the project
    $sHome= aHome();

    $aOptions = array();
    foreach (array("bRemoveRepolinks", "bRemoveArchive", "bRemoveConfig") as $sOption) {
        if (array_search($sOption, $aParams["removeOptions"]) !== false) {
            $aOptions[$sOption] = 1;
        }
    }
    $sErrors=$oPrj->delete($aOptions);
    if ($sErrors) {
        $sOut.=$oHtml->getBox("error", t('page-delete-project-delete-failed') . $sErrors);
    } else {
        $sOut.=$oHtml->getBox("success", t('page-delete-project-delete-success'));
    }
}

// $sOut.= '<div id="navbuttom">' . $sHome . '</div>';

    // -- Ausgabe
echo $sOut;
