<?php

/* ######################################################################

  IML DEPLOYMENT

  webgui - login

  ---------------------------------------------------------------------
  2015-04-21  Axel <axel.hahn@iml.unibe.ch>
  ###################################################################### */

require_once("./inc_functions.php");
$sOut = '';

require_once("./classes/user.class.php");
$oUser = new user();

// ----------------------------------------------------------------------
// actions
// ----------------------------------------------------------------------

// if logoff was sent ...
if ($oUser->getUsername() && array_key_exists('logoff', $aParams)) {
    $oUser->logoff();
    header('Location: ?');
}

// if user is logged off and credentials were sent: try to authenticate
if (!$oUser->getUsername() && array_key_exists('user', $aParams)) {
    $oUser->authenticate();
}

    // if user is logged in and credentials were sent: reload to remove post vars
    if ($oUser->getUsername() && array_key_exists('user', $aParams)) {
        if (array_key_exists("goback", $_SESSION)){
            $sUrl=$_SESSION["goback"];
            unset($_SESSION["goback"]);
        } else {
            $sUrl='/deployment';
        }
        header("location: $sUrl");
    }

// ----------------------------------------------------------------------
// show infos or login form
// ----------------------------------------------------------------------

// if user is logged in, then show user infos        
if ($oUser->getUsername()) {

    // ------------------------------------------------------------
    // show user and roles + logoff
    // ------------------------------------------------------------
    $sGrouplist='';
    foreach ($oUser->getUserGroups() as $sGroupname){
        $sGrouplist.='<i class="fa-regular fa-bookmark"></i> ' . $sGroupname . '<br>';
    }
    $sPermlist='';
    foreach ($oUser->getUserPermission() as $sPerm){
        $sPermlist.='<i class="fa-solid fa-caret-right"></i> ' . $sPerm . '<br>';
    }
    
    $sOut.=''
            . '<h2>' . t("page-login-profile") . '</h2>'
            .'<table>
                <tr>
                    <td>'.t("page-login-userloggedin") . '</td>
                    <td><strong>' . $oUser->getUsername() . '</strong></td>
                </tr>
                <tr>
                    <td>'.t("page-login-usergroups").'</td>
                    <td>'.$sGrouplist . '</td>
                </tr>
                <tr>
                    <td>'.t("page-login-userperms").'</td>
                    <td>'.$sPermlist . '</td>
                </tr>
            </table>'
                . '<div style="clear: both; margin-bottom: 1em;"></div>'
                . ' ' . aPrjHome() . ' '
                . '<a href="?logoff=1" class="btn btn-danger">' . $oHtml->getIcon('poweroff') . t('logoff') . '</a>'
            
                // . '<br><br>INFO: <pre style="">roles:<br>' . print_r($oUser->getUserPermission(), true) . '</pre>'
            . '</p>'
            ;
} else {
    // ------------------------------------------------------------
    // login page
    // ------------------------------------------------------------
    if (!isset($_SESSION['goback']) || true){
        $sUrlback=$_SERVER["HTTP_REFERER"];
        if(
           strpos($sUrlback, $_SERVER["SERVER_NAME"])>0
           && !strpos($sUrlback, '/all/login/')
        ){
            $_SESSION["goback"]=$sUrlback;
        }
    }
    $i = 0;
    require_once ("./classes/formgen.class.php");

    $aForms = array(
        'login' => array(
            'meta' => array(
                'method' => 'POST',
                'action' => '?',
            ),
            'validate' => array(),
            'form' => array(
                'input' . $i++ => array(
                    'type' => 'text',
                    'name' => 'user',
                    'label' => t('page-login-username'),
                    'required' => 'required',
                    'validate' => 'isastring',
                    'size' => 10,
                    'value' => $aParams['user'],
                    'placeholder' => t('page-login-username'),
                    'autofocus' => 'autofocus',
                    'inline' => '1',
                ),
                'input' . $i++ => array(
                    'type' => 'markup',
                    'value' => '<div style="clear: both; "></div>'
                ),
                'input' . $i++ => array(
                    'type' => 'password',
                    'name' => 'password',
                    'label' => t('page-login-password'),
                    'required' => 'required',
                    'validate' => 'isastring',
                    'size' => 10,
                    'value' => $aParams['password'],
                    'placeholder' => t('page-login-password'),
                    'inline' => '1',
                ),
                'input' . $i++ => array(
                    'type' => 'markup',
                    'value' => '<div style="clear: both; margin-bottom: 3em;"></div>'
                    . '<div style="text-align: left; margin-left: 12em;">'
                ),
                'input' . $i++ => array(
                    'type' => 'submit',
                    'name' => 'btnsave',
                    'label' => t("login"),
                    'value' => $oHtml->getIcon('sign-ok') . t("login"),
                ),
                'input' . $i++ => array(
                    'type' => 'markup',
                    'value' => '</div>'
                ),
            ),
        )
    );

    $oForm = new formgen($aForms);
    $sOut.=''
            . '<h2>' . t("page-login-info") . '</h2>'
            . '<p>' . t("page-login-info-introtext") . '</p>'
            . (array_key_exists('user', $aParams)
                ? '<div class="alert alert-danger" role="alert">'.t('page-login-auth-failed').'</div>'
                : ''
            )
            .$oForm->renderHtml("login");    
}
// $sOut.= '<div id="navbuttom">' . aPrjHome() . '</div>';

// -- Ausgabe
// echo $sOut;
$BODY=
$renderAdminLTE->addRow(
    $renderAdminLTE->addCol('',3)
    .$renderAdminLTE->addCol(
        $renderAdminLTE->getCard([
        'type'=>'',
        'variant'=>'outline',
        'text'=>$sOut,
        ]), 
    )
    .$renderAdminLTE->addCol('',3)
);
