<?php

/**
 * Generator for HTML Tags
 * 
 * see getTag() ... 
 *    it generates html code for tags 
 *    - with and without label
 *    - with and without closing tag
 * 
 * see _setAttributes($aAttributes) ... 
 *    attribute will be inserted with given key-value array
 *    BUT with special attribute keys:
 *    - label - will be used as label
 *    - icon  - will be added as <i class="[icon value]"></i> to the label
 * 
 * @author Axel
 * 
 * 2024-08-23  v1.1  Axel Hahn  php8 only; added variable types; short array syntax; remove unneeded methods
 */
class htmlelements
{

    /**
     * Extracted label from array with attributes
     * @var string
     */
    var $_sLabel = '';

    /**
     * Array of attributes for a html tag
     * @var array
     */
    var $_aAttributes = [];


    // ----------------------------------------------------------------------
    // CONSTRUCTOR
    // ----------------------------------------------------------------------

    public function __construct()
    {
        // nothiung here
    }

    // ----------------------------------------------------------------------
    // 
    // PRIVATE FUNCTIONS 
    // 
    // ----------------------------------------------------------------------


    /**
     * generate html attibutes with all internal attributes key -> values
     * to be added in opening tag
     * @return string
     */
    protected function _addAttributes(): string
    {
        $sReturn = '';
        foreach ($this->_aAttributes as $sAttr => $sValue) {
            if (is_array($sValue)) {
                echo "ERROR: an html tag was defined with array in attribute [$sAttr]:<br><pre>" . print_r($this->_aAttributes, 1) . "</pre>";
            }
            $sReturn .= " $sAttr=\"$sValue\"";
        }
        return $sReturn;
    }


    /**
     * Internal helper: fetch all attributes from key-value hash; 
     * Specialties here:
     * - label will be extracted from key 'label' 
     * - and optional existing key 'icon' will be added at beginning of a label
     * 
     * @param array $aAttributes
     * @return boolean
     */
    protected function _setAttributes(array $aAttributes): bool
    {
        $this->_sLabel = '';
        if (isset($aAttributes['icon']) && $aAttributes['icon']) {
            $this->_sLabel .= $this->getIcon($aAttributes['icon']);
            unset($aAttributes['icon']);
        }
        if (isset($aAttributes['label']) && $aAttributes['label']) {
            $this->_sLabel .= $aAttributes['label'];
            unset($aAttributes['label']);
        }
        $this->_aAttributes = $aAttributes;
        return true;
    }

    // ----------------------------------------------------------------------
    // 
    // PUBLIC FUNCTIONS
    // HTML GENERIC
    // 
    // ----------------------------------------------------------------------

    /**
     * Generic function to get html code for a single tag 
     * 
     * @param string   $sTag          tag name
     * @param array    $aAttributes   array with attributes (optional including 'icon' and 'label')
     * @param boolean  $bCloseTag     optional: set false if tag has no closing tag (= ending with "/>")
     * @return string html code
     */
    public function getTag(string $sTag, array $aAttributes, bool $bCloseTag = true): string
    {
        $sTpl = $bCloseTag ? "<$sTag%s>%s</$sTag>" : "<$sTag %s/>%s";
        $this->_setAttributes($aAttributes);
        return sprintf($sTpl, $this->_addAttributes(), $this->_sLabel);
    }

    // ----------------------------------------------------------------------
    // 
    // PUBLIC FUNCTIONS
    // SIMPLE HTML ELEMENTS
    // 
    // ----------------------------------------------------------------------

    /**
     * Helper detect prefix of a string add prefix of a framework
     * i.e. value "fa-close" detects font awesome and adds "fa " as prefix
     * 
     * @param string $sIconclass
     * @return string HTML code
     */
    public function getIcon(string $sIconclass = ''): string
    {
        if (!$sIconclass) {
            return '';
        }

        // do not use this .. it overrides internal attribute vars
        // return $this->getTag('i', ['class'=>$sIconclass]);

        return "<i class=\"$sIconclass\"></i>&nbsp;&nbsp;";
    }

}
