<?php

/**
 * send messenger notifications
 *
 * @author hahn
 * 
 * 2024-08-23  v1.1  Axel Hahn  php8 only; added variable types
 */
class messenger
{

    /**
     * config array for messengers
     * @var array 
     */
    protected array $_aCfg = [];

    /**
     * content of messagetext to send
     * @var string
     */
    protected string $_sMessage = '';

    /**
     * Constructor
     * 
     * @example
     * $oMessenger = new messenger([
     *   'slack'=>[
     *     'incomingurl'=>[WebHook url],
     *     'user'=>[visible username in slack],
     *     'icon'=>[Slack Icon], // hm, does not seem to work
     *   ],
     *   'email'=>[
     *     'from'=>[senders e-mail]
     *     'to'=>[email-address(es)] // multiple emails must be delimited with ";"
     *   ]
     * ]);
     * @param array $aCfg  config array for notification targets
     */
    public function __construct(array $aCfg)
    {
        $this->_aCfg = $aCfg;
    }

    /**
     * Send an email if _aCfg['email']['to'] exists
     * @return bool
     */
    private function _sendEmail(): bool
    {
        if (isset($this->_aCfg['email']['to']) && $this->_aCfg['email']['to']) {
            preg_match('/^(.*)\n/', $this->_sMessage, $aTmp);
            $sSubject = $aTmp[0];
            return mail(
                $this->_aCfg['email']['to'],
                $sSubject,
                $this->_sMessage,
                "From: " . $this->_aCfg['email']['from'] . "\r\n" .
                "Reply-To: " . $this->_aCfg['email']['from'] . "\r\n"
            );
        }
        return false;
    }

    /**
     * Send a message to slack if _aCfg['slack']['incomingurl'] exists
     * @return bool|string
     */
    private function _sendToSlack(): bool|string
    {
        if (isset($this->_aCfg['slack']['incomingurl']) && $this->_aCfg['slack']['incomingurl']) {
            require_once(__DIR__ . '/../../vendor/shooker/shooker.php');
            $shkr = new Shooker();
            $shkr->setupIncoming($this->_aCfg['slack']['incomingurl']);
            $sUser = (isset($this->_aCfg['slack']['user']) ? $this->_aCfg['slack']['user'] : false);
            $sIcon = (isset($this->_aCfg['slack']['icon']) ? $this->_aCfg['slack']['icon'] : false);

            // returns bool or string with response from Slack API
            return $shkr->sendMessage($this->_sMessage, $sUser, $sIcon);
        }
        return false;
    }


    /**
     * send a message to all targets
     * @param string $sMessage
     * @return void
     */
    public function sendMessage(string $sMessage): void
    {
        $this->_sMessage = $sMessage;
        // echo '<pre>'.print_r($this->_aCfg, 1).'</pre>'.$sMessage.'<br>';
        $this->_sendEmail();
        $this->_sendToSlack();
    }

}
