<?php
require_once('plugins.class.php');
/**
 * WIP
 * base class for all plugin types to read available plugins
 * and its metadata
 * 
 * @example
 *        $CI_plugins=new ciplugins();
 *        print_r($CI_plugins->getPluginTypes());
 * 
 *        // $CI_plugins->setType('build');
 *        // print_r($CI_plugins->getPlugins());
 *        print_r($CI_plugins->getPlugins('build'));
 * 
 *        $CI_plugins->setPlugin('tgz', 'build'); // plugin name + type
 *
 * 
 * @author axel
 */
class plugin_renderer extends ciplugins
{

    // ---------------------------------------------------------------
    // 
    // BELOW ARE METHODS FOR A SET SPECIFIC PLUGIN AND TYPE
    // 
    // ---------------------------------------------------------------


    // ---------------------------------------------------------------
    // LANGUAGE TEXTS (needed in ui only)
    // ---------------------------------------------------------------

    /**
     * Get a translated text from lang_XX.json in plugin dir;
     * If the key is missed it returns "[KEY :: LANG]"
     * 
     * @see setLang()
     * @param string $sKey  key to find in lang file
     * @return string
     */
    protected function _t(string $sKey): string
    {
        return (isset($this->_aLang[$sKey]) && $this->_aLang[$sKey])
            ? $this->_aLang[$sKey]
            : "[ $sKey :: $this->_sLang ]"
        ;
    }

    /**
     * Set language for output of formdata and other texts.
     * This method loads the language file into a hash. The output of 
     * translated texts can be done with $this->_t("your_key")
     * 
     * @see _t()
     * 
     * @param string   $sLang  language code, i.e. "de"
     * @return boolean
     */
    public function setLang(string $sLang = ''): bool
    {
        $this->_sLang = $sLang ?: $this->_sLang;

        $oReflection = new ReflectionClass($this);
        $sFile = dirname($oReflection->getFileName()) . '/lang_' . $this->_sLang . '.json';
        $this->_aLang = (file_exists($sFile)) ? json_decode(file_get_contents($sFile), 1) : $this->_aLang;
        return !!count($this->_aLang);
    }
    // ---------------------------------------------------------------
    // SETTER
    // ---------------------------------------------------------------


    // ---------------------------------------------------------------
    // prepare html code
    // ---------------------------------------------------------------

    /**
     * For shellcmd plugins: get html code to load javascript file
     * The file must exist in the plugin directory
     * 
     * @param  string  $sFile  (basename of) filename, eg. render.js
     * @return string
     */
    public function getHtmlLoadScript(string $sFile): string
    {
        return (file_exists($this->_sSelfdir . '/' . $sFile))
            ? '<script src="' . $this->_sSelfurl . '/' . $sFile . '"></script>' . "\n"
            : ''
        ;
    }

    /**
     * Get id for an output div
     * @return string
     */
    public function getHtmlOutId(): string
    {
        return $this->_sPluginname ? 'divPlugin' . $this->_sType . '' . $this->_sPluginname : false;
    }

    /**
     * Get id for the wrapper div of an output div
     * @return string
     */
    public function getHtmlOutIdWrapper(): string
    {
        return $this->getHtmlOutId() . 'Wrapper';
    }

    /**
     * Get html code for a shellcmd output window
     * @return string The HTML code
     */
    public function getHtmlOutwindow(): string
    {
        $aConfig = $this->getPluginConfig();
        return '<div id="' . $this->getHtmlOutIdWrapper() . '" class="cmdoutbox">'
            . '<div id="' . $this->getHtmlOutId() . '" '
            . 'class="out'
            . (isset($aConfig['window-cols']) && $aConfig['window-cols'] ? ' cmd-cols-' . $aConfig['window-cols'] : '')
            . (isset($aConfig['window-lines']) && $aConfig['window-lines'] ? ' cmd-lines-' . $aConfig['window-lines'] : '')
            . '"></div>'
            . '</div>';
    }

    // ---------------------------------------------------------------
    // access plugin php class
    // ---------------------------------------------------------------


}
