<?php

require_once("userauth.interface.php");
require_once("ldap.class.php");

/**
 * user authentication :: LDAP
 * implements userauth interface
 * 
 * @author hahn
 */
class userauthLdap implements iUserAuth {

    /**
     * object for ldap actions
     * @var object
     */
    private $_oLdap=false;
    
    // ----------------------------------------------------------------------
    // 
    // ----------------------------------------------------------------------
    public function __construct() {
        global $aConfig;
        $this->_oLdap=new imlldap($aConfig['auth']['ldap']);
        
        // first test of ldap connection
        // $this->_oLdap->debugOn();
        $this->_oLdap->connect();
        return true;
    }
    
    public function __destruct() {
        $this->_oLdap->close();
    }
    
    // ----------------------------------------------------------------------
    // implementation
    // ----------------------------------------------------------------------
    /**
     * verify if a given user and password combination is correct
     * @param string   $sUser      username
     * @param password $sPassword  password
     * @return boolean
     */
    public function authenticate($sUser, $sPassword){
        return $this->_oLdap->verifyPassword($sUser, $sPassword);
    }

}
