// ----------------------------------------------------------------------
// JS FOR OVERVIEW PAGE
// ----------------------------------------------------------------------


// ----------------------------------------------------------------------
// COUNTER
// ----------------------------------------------------------------------

// reload after N seconds
var iReload = 60;


/**
 * get the current unix ts
 * @returns {Number}
 */
function getUnixTS() {
    return Date.now() / 1000;
}


/**
 * show a timer and progress bar
 * @returns {undefined}
 */
function refreshTimer() {
    if (iRefreshCounter == 0) {
        $('#counter').html(
            '<span>-</span><br>'
            + '<div style="width:100%; float: left;">&nbsp;</div>'
        );
    }
    $('#counter span').html(iReload - iRefreshCounter + 's');
    $('#counter div').css('width', (100 - (iRefreshCounter / iReload * 100)) + '%');
    iRefreshCounter++;

    if (iRefreshCounter > iReload) {
        document.location.reload();
    }
}


// ----------------------------------------------------------------------
// FILTERING
// ----------------------------------------------------------------------

/**
* filter table by chosen select values for project and phase
*/
function filterOverviewTable() {

    // --- reset
    $('.trproject').removeClass("trproject-textfilter");
    $('.trproject').removeClass("trproject-progressfilter");
    $('.trproject').removeClass("trproject-projectfilter");
    $('.trproject').removeClass("trproject-projectgroupfilter");
    $('.trproject').removeClass("trprojectfiltered");
    $('button.prjprogress').removeClass('selected');

    // --- get free filter
    var sSearch = $("#efilter").val();
    localStorage.setItem("efilter", sSearch);

    $("table").removeHighlight();
    if (sSearch) {
        $("td").highlight(sSearch);
    } else {
        $("td").removeHighlight();
        $('tr').show();
    }

    var RegexFreetext = new RegExp(sSearch, "i");

    // --- get project filter
    var sPrj = $("#prjfilter").val();
    localStorage.setItem("selectedPrj", sPrj);

    // --- get project group filter
    var sPrjGroup = $("#prjgroupfilter").val();
    localStorage.setItem("selectedPrjGroup", sPrjGroup);

    // --- get progress filter
    var sProgress = $("#progressfilter").val();
    localStorage.setItem("progress", sProgress);
    $('#btnProgress' + sProgress).addClass('selected').blur();

    // --- loop over project rows   

    $(".trproject").each(function () {
        if (!RegexFreetext.exec(this.innerHTML)) {
            $(this).addClass("trproject-textfilter");
        }

        if (sPrj) {
            if ($(this).hasClass(sPrj)) {
                $(this).addClass("trprojectfiltered");
            } else {
                $(this).addClass("trproject-projectfilter");
            }
        }
        if (sPrjGroup) {
            if ($(this).hasClass("group-" + sPrjGroup)) {
                $(this).addClass("trprojectgroupfiltered");
            } else {
                $(this).addClass("trproject-projectgroupfilter");
            }
        }
        if (sProgress && !$(this).hasClass("progress" + sProgress)) {
            $(this).addClass("trproject-progressfilter");
        }

    });

    showResetbtn();
}

/**
* onclick event of [filter] button in table row of a project
* toggle: show a single project/ all projects
*/
function setProjectFilter(sPrj) {
    var sCurrentPrj = $('#prjfilter').val();
    if (sCurrentPrj != '') {
        $('#prjfilter').val('');
    } else {
        $('#prjfilter').val(sPrj);
    }
    window.setTimeout('filterOverviewTable();', 10);
    setview('extended');
}

/**
* filter table and tiles by filtertext
*/
function filterTableByTyping() {
    filterOverviewTable();
    return false;
}

/**
* switch view between tiles and table
*/
function setview(sMode) {
    $('.view').hide();
    $('.view' + sMode).show();
    localStorage.setItem("mode", sMode);
    return false;
}

/**
* filter table by role
*/
function setrole() {
    var sRole = $("#rolefilter").val();
    $('.role').hide();
    $('.role' + sRole).show();
    localStorage.setItem("role", sRole);
    showResetbtn();
    return false;
}
/**
* filter table by progress status
*/
function setprogress() {
    filterOverviewTable();
    return false;
}

/**
* set default view; it gets the last values for filter text,
* and selected values in dropdowns and restores the
* last view
*/
function setDefaultView() {


    if (localStorage.getItem("progress") && localStorage.getItem("progress") != 'null') {
        $("#progressfilter").val(localStorage.getItem("progress"));
    } else {
        $("#progressfilter").val($("#progressfilter option:first").val());
    }
    if (localStorage.getItem("efilter") && localStorage.getItem("efilter") != 'null') {
        $("#efilter").val(localStorage.getItem("efilter"));
        window.setTimeout("filterTableByTyping();", 10);
    }

    if (localStorage.getItem("selectedPrjGroup") && localStorage.getItem("selectedPrjGroup") != 'null') {
        $("#prjgroupfilter").val(localStorage.getItem("selectedPrjGroup"));
    } else {
        // $("#selectedPrjGroup").val($("#selectedPrjgroup option:first").val());
    }

    // window.setTimeout("filterOverviewTable();", 10);
    filterOverviewTable();


}

/**
* Button zum Filter reset anzeigen/ verbergen
*/
function showResetbtn() {
    var sVisible = $("#efilter").val() ? "visible" : "hidden";
    if ($("#prjfilter").val() > "") sVisible = "visible";
    if ($("#prjgroupfilter").val() > "") sVisible = "visible";
    // if ($("#phasefilter").val()!="' . $sColClass . '")sVisible="visible";
    if ($("#rolefilter").val()) sVisible = "visible";
    if ($("#progressfilter").val()) sVisible = "visible";
    $("#btnresetfilter").css("visibility", sVisible);

    $("#btnresetefilter").css("visibility", $("#efilter").val() ? "visible" : "hidden");
    return false;
}

/**
* Aktion des Filter reset: Filter zurücksetzen
*/
function resetFilter() {
    $("#prjfilter").val("");
    $("#prjgroupfilter").val("");
    // $("#phasefilter").val("");
    filterOverviewTable();
    $("#efilter").val("");
    window.setTimeout("filterTableByTyping();", 10);
    $("#rolefilter").val("");
    window.setTimeout("setrole();", 20);
    $("#progressfilter").val("");
    window.setTimeout("setprogress();", 30);
    showResetbtn();
    return false;
}

// ----------------------------------------------------------------------
// MAIN
// ----------------------------------------------------------------------

iStartTime = getUnixTS();
iRefreshCounter = 0;

refreshTimer();
window.setInterval('refreshTimer()', 1000);
window.setTimeout("setDefaultView();", 50);

// ----------------------------------------------------------------------
