<?php

/* ######################################################################

  IML DEPLOYMENT

  VALUESTORE

  ---------------------------------------------------------------------
  2023-11-24  Axel <axel.hahn@unibe.ch>
  ###################################################################### */


$TITLE=t('menu-valuestore');

// ----------------------------------------------------------------------
// functions
// ----------------------------------------------------------------------

/**
 * show an error message and quit with http status code 400 (Bad request)
 * @param string  $sMessage  message to show
 * @return boolean
 */
function quit($sMessage)
{
  $sProtocol = (isset($_SERVER['SERVER_PROTOCOL']) ? $_SERVER['SERVER_PROTOCOL'] : 'HTTP/1.0');
  header("$sProtocol 400: Bad request");
  die("<h1>Bad request</h1>" . $sMessage);
  return false;
}

/**
 * get a request param from GET and POST scope (POST has priority) and
 * verify it with execution of a cleanup array
 * @param string  $sKey            key to search for in GET or POST
 * @param string  $sRegex4Cleanup  regex for filtering
 * @return type
 */
function getParam($sKey, $sRegex4Cleanup = false)
{
  $sValue = false;
  if (array_key_exists($sKey, $_GET)) {
    $sValue = $_GET[$sKey];
  }
  if (array_key_exists($sKey, $_POST)) {
    $sValue = $_POST[$sKey];
  }
  if (!$sValue) {
    return false;
  }
  $sReturn = $sRegex4Cleanup ? preg_replace($sRegex4Cleanup, '', $sValue) : $sValue;

  if ($sReturn !== $sValue) {
    quit("ERROR: the parameter value in [$sKey = ...] has a wrong format.");
  }
  return $sReturn;
}

// ----------------------------------------------------------------------
// check required params
// ----------------------------------------------------------------------
/*
if (!$_GET || !count($_GET)) {
  quit("no parameter was found.");
}

foreach (array("action", "project") as $sKey) {
  if (!array_key_exists($sKey, $_GET)) {
      quit("value required: $sKey=");
  }
}
*/


// ----------------------------------------------------------------------
// get vars
// ----------------------------------------------------------------------


$sAction = getParam('action', '/[^a-z]/');

$sProject = getParam('project', '/[^a-z\-0-9]/');
$sPhase = getParam('phase', '/[^a-z]/');
$sPlace = getParam('place', '/[^a-z]/');
$sHost = getParam('host', '/[^a-z\.\-0-9]/');

if ($sHost && !$sPlace) {
  $sPlace = 'installed';
}

$sVarname = getParam('variable', '/[^a-z]/');
$sValue = getParam('value', '');


// ----------------------------------------------------------------------
// init class
// ----------------------------------------------------------------------

$sOut = '';
$sHeader = '';
$sOut .= ''
  .'<p>'.t('page-valuestore-hint').'</p>'
  ;
require './../valuestore/classes/valuestore.class.php';

$oVersion = new valuestore();

$aData = $oVersion->dumpdb();
$sTable = '';
$sTableHead = '';
if (is_array($aData) && count($aData)) {
  // echo '<pre>' . print_r($aData, 1);
  $aMyColumns = ['time', 'package', 'phase', 'place', 'host', /*'variable',*/ 'data'];
  foreach ($aData as $aRow) {
    $sItemUrl = '/valuestore/index.php?action=show&project=' . $aRow['project'] . '&package=' . $aRow['package'] . '&phase=' . $aRow['phase'] . '&host=' . $aRow['host'] . '&variable=' . $aRow['variable'] . '';
    $sTable .= '<tr ondblclick="location.href=\'' . $sItemUrl . '\'">';
    // $sTable.='<tr>';
    // foreach ($aRow as $sKey=>$sValue){
    foreach ($aMyColumns as $sKey) {
      $sValue = $aRow[$sKey];
      // $sTable.='<td class="'.$sKey.'"><a href="'.$sUrl.'">'.$sValue.'</a></td>';
      $sOnclick = '';
      $sLabel = strstr($sValue, '"')
        ? '<small>'.htmlentities($sValue).'</small>'
        : '<a href="#" onclick="$(\'#eFilter\').val(\'' . $sValue . '\');filterTable();" title="click to filter by [' . $sValue . ']">' . htmlentities($sValue) . '</a>';
      $sTable .= '<td class="' . $sKey . '" ' . $sOnclick . '>' . $sLabel . '</td>' . "\n";
    }
    $sTable .= '<td>'
      // . '<button onclick="location.href=\''.$sItemUrl.'&action=get\'">View</button>'
      . '<form method="POST" action="' . $sItemUrl . '">'
      . '<input type="hidden" name="action" value="delete">'
      . '<button class="btn btn-secondary">Delete</button>'
      . '</form>'
      . '</td>'
      . '</tr>' . "\n";
  }
  foreach ($aMyColumns as $sKey) {
    $sTableHead .= '<th class="' . $sKey . '">' . $sKey . '</th>';
  }
  $sOut .= ''
    . '<form method="POST" action="/valuestore/index.php">'
    . '<input type="hidden" name="action" value="cleanupTEST">'
    . '<button class="btn btn-secondary">Cleanup (older 1d)</button>'
    . '</form><hr>'

    . '<table id="tbldata" class="table">'
    . '<tr>' . $sTableHead . '<th>action</th></tr>'
    . '</thead>'
    . '<tbody>' . $sTable . '</tbody></table>';
  $JS .= 'addFilterToTable(); filterTable();';
} else {
  $sOut .= 'no data yet.';
}

// -- Ausgabe
echo $sOut;
