# CI server Plugins

## Structure

The plugin base dir is `public_html/deployment/plugins`

Subdirs are the different plugin types

```txt
build/
rollout/
shellcmd/
```

In the 2nd level is 1 subdir per plugin.

```txt
.
├── build
│   ├── tgz
│   │   ├── build_tgz.php
│   │   ├── info.json
│   │   ├── lang_de-de.json
│   │   └── lang_en-en.json
│   └── zip
│       ├── build_zip.php
│       ├── info.json
│       ├── lang_de-de.json
│       └── lang_en-en.json
├── rollout
:   ...
└── shellcmd
    ...
```

Bisher hatte ich für Build und Rollout je 1 Klasse gehabt. 
Shellcmd Plugins kommen gerade dazu.

Alle sollen von 1 Plugin-Klasse handhabbar sein - und einer Plugin-Renderere-Klasse.

## Files in a plugin folder

* **info.json** - meta data with plugin infos
* **plugin.php** - plugin class
* **config.json** - configuration data
* **render.js** - javascript file to load
* **lang_*.js** - language specific texts

## Config

For plugins that can handle project data there is an override mechanism:

* global configuration data are in the ci server config
* the project setting can override / extend the global settings
* each phase can override/ extend the project settings

## shellcmd

### config.json

contains keys
 
* command --> shell command with params

### class plugins.php

must have the method 

```php
    public function parsedata($aResult){
        $aReturn=[];
        // do some magic
        return $aReturn;
    }
```

### render.js

MUST inituilaize request and repeat rate.

```
window.setTimeout("shellcmd_plugin_init('load', "+<plugin>_render+", <repeat_in_sec>);", 200);``
```

- MUST have function "<plugin>_render()"
