<?php
/**
 * 
 * SHELLCMD PLUGIN :: LOAD
 * 
 * ----------------------------------------------------------------------
 * 2022-08-05  axel.hahn@iml.unibe.ch
 * 2023-12-13  axel.hahn@unibe.ch      minified
 */
class shellcmd_load {
    /**
     * parse output and extract wanted values in section "data"
     * @return array
     */
    public function parsedata($aResult){
        $aTmp1=array_reverse(explode(',', $aResult['output'][0]));
        $aResult['data']=[
            'uptime'=>(isset($aTmp1[5])
                ? trim(substr($aTmp1[5], 10) . $aTmp1[4])
                : trim(substr($aTmp1[4], 10))
            ).' h'
            ,
            'users'=>trim(str_replace(' users', '', $aTmp1[3])),
            'load'=>trim(preg_replace('/^.*:/', '', $aTmp1[2])),
            'load5'=>trim($aTmp1[1]),
            'load15'=>trim($aTmp1[0]),
        ];
        return $aResult;
    }

}
/*

EXAMPLE OUTPUT

{
    "command": "uptime",
    "exitcode": 0,
    "output": [
        " 13:36:54 up 1 day,  7:39,  0 users,  load average: 1.18, 1.29, 1.33"
    ],
    "data": {
        "uptime": "7:39",
        "users": "0",
        "load": "1.18",
        "load5": "1.29",
        "load15": "1.33"
    }
}

*/