<?php

/* ######################################################################

  IML DEPLOYMENT

  webgui - documentation of the classes

  ---------------------------------------------------------------------
  2013-11-19  Axel <axel.hahn@iml.unibe.ch>
  ###################################################################### */

require_once("./classes/classinfos.class.php");
$aClasses = array(
    "project" => array("name" => "project"),
    "projectlist" => array("name" => "projectlist"),
    "actionlog" => array("name" => "Actionlog"),
    "page" => array("name" => "Page"),
    "formgen" => array("name" => "formgen"),
);

$sOut = '';
$sOut.='<a href="/deployment/all/doc/">Start</a> | ';
foreach ($aClasses as $sClassfile => $aInfos) {
    $sOut.='<a href="/deployment/all/doc/' . $sClassfile . '/">' . $sClassfile . '</a> | ';
}
$sOut.= '<hr>';

if (array_key_exists("par3", $aParams)) {
    $sClass = $aParams["par3"];
    if (!array_key_exists($sClass, $aClasses)) {
        $sOut.= $oPrj->getBox("error", sprintf(t("page-doc-error-class-not-configured"), $sClass, __FILE__));
    } else {
        require_once("./classes/$sClass.class.php");
        $o = new classinfos($aClasses[$sClass]["name"]);
        $sOut.=t("page-doc-info-" . $sClass) . $o->render();
    }
} else {
    $sOut.=t("page-doc-info-select-class") . '<ul>';
    foreach (array_keys($aClasses) as $sClassfile) {
        $sOut.='<li>'
                . '<a href="/deployment/all/doc/' . $sClassfile . '/">' . $sClassfile . '</a>'
                . ' ' . t("page-doc-info-" . $sClassfile)
                . '</li>';
    }
    $sOut.='</ul>';
}

// -- Ausgabe
echo $sOut;
?>

