<?php

/* ######################################################################

  IML DEPLOYMENT

  webgui - shows build versions in all places (onhold, ready2install, deployed)
  of a given phase.

  ---------------------------------------------------------------------
  2013-11-08  Axel <axel.hahn@iml.unibe.ch>
  ###################################################################### */

require_once("./classes/project.class.php");
require_once("./inc_functions.php");


// --- Checks
$oPrj = new project($aParams["prj"]);

$sOut = '';
if (array_key_exists("par3", $aParams)) {
    $sPhase = $aParams["par3"];
}

if ($sPhase) {
    $sPhase = $aParams["par3"];
    // $sFirst = $oPrj->getNextPhase();

    $sOut.='
    <h3>' . t("versions") . '</h3>
    <table>
     <thead>
         <tr>
             <th class="' . $sPhase . '" colspan="3">' . $sPhase . '</th>
         </tr>
     </thead>
     <tbody>
        <tr>' . $oPrj->renderPlacesAsTd($sPhase) . '</tr>
        <tr>
         ' . $oPrj->renderAllPhaseDetails($sPhase, true) . '
        </tr>
     </tbody>
    </table>
    '
    // show all  phases if there are more than one
    . (count($oPrj->getActivePhases())>1
        ? '<h3>' . t("phases") . '</h3>' .  $oPrj->renderPhaseInfo()
        : ''
    )
    ;
    /*
      if ($sFirst == $sPhase) {
      $sOut.='<br><h3>weitere Aktionen</h3>' . $oPrj->renderLink("build");
      }
     * 
     */
} else {
    $sOut.=$oPrj->getBox("error", t("error-no-phase"));
}

$sOut.= '<div id="navbuttom">' . aPrjHome() . '</div>';

// -- Ausgabe
echo $sOut;
