<?php
/**
 * BRAINSTORMING ONLY
 * 
 * interface for a version control system
 * @author hahn
 */
interface iVcs {

    // ----------------------------------------------------------------------
    // get metadata 
    // ----------------------------------------------------------------------

    /**
     * return url to vcs sources
     */
    public function getUrl();
    
    /**
     * return url to view sources in webrowser to generate an infolink
     */
    public function getWebGuiUrl();
    
    /**
     * return the build type, i.e. git|svn|cvs|
     */
    public function getBuildType();
    
    // ----------------------------------------------------------------------
    // actions
    // ----------------------------------------------------------------------
    /**
     * cleanup unneeded files and directories in a checked out directory
     * and remove all vcs specific files and directories
     * @return bool
     */
    public function cleanupWorkdir($sWorkDir);
    
    /**
     * get current revision and commit message from remote repository
     * @param boolean  $bRefresh  optional: refresh data; default: use cache
     * @return array
     */
    public function getRepoRevision($bRefresh=false);
    
    /**
     * get current revision and log message from given directory
     * @return array
     */
    public function getRevision($sWorkDir);
    
    /**
     * get sources from vsc and check them out in given directory
     * @return bool
     */
    public function getSources($sWorkDir);
    

}

