<?php

/* ######################################################################

  IML DEPLOYMENT

  webgui - login

  ---------------------------------------------------------------------
  2015-04-21  Axel <axel.hahn@iml.unibe.ch>
  ###################################################################### */

require_once("./inc_functions.php");
$sOut = '';

require_once("./classes/user.class.php");
$oUser = new user();

// ----------------------------------------------------------------------
// actions
// ----------------------------------------------------------------------

// if logoff was sent ...
if ($oUser->getUsername() && array_key_exists('logoff', $aParams)) {
    $oUser->logoff();
    header('Location: ?');
}

// if user is logged off and credentials were sent: try to authenticate
if (!$oUser->getUsername() && array_key_exists('user', $aParams)) {
    $oUser->authenticate();
}

    // if user is logged in and credentials were sent: reload to remove post vars
    if ($oUser->getUsername() && array_key_exists('user', $aParams)) {
        if (array_key_exists("goback", $_SESSION)){
            $sUrl=$_SESSION["goback"];
            unset($_SESSION["goback"]);
        } else {
            $sUrl='?';
        }
        header("location: $sUrl");
    }

// ----------------------------------------------------------------------
// show infos or login form
// ----------------------------------------------------------------------

// if user is logged in, then show user infos        
if ($oUser->getUsername()) {
    $sGrouplist='';
    foreach ($oUser->getUserGroups() as $sGroupname){
        $sGrouplist.='<li>' . $sGroupname . '</li>';
    }
    $sOut.='<div style="width: 50%; margin-left: 25%;">'
            . '<h2>' . t("page-login-info") . '</h2>'
            . '<p>' 
                . t("page-login-userloggedin") . '<br><br>'
                . '<strong>' . $oUser->getUsername() . '</strong><br><br>'
                . t("page-login-usergroups") . '<br>'
                . '<ul>'.$sGrouplist . '</ul><br>'
                . '<div style="clear: both; margin-bottom: 1em;"></div>'
                . ' ' . aPrjHome() . ' '
                . '<a href="?logoff=1" class="btn btn-default btn-danger">' . $oHtml->getIcon('poweroff') . t('logoff') . '</a>'
            
                // . '<br><br>INFO: <pre style="">roles:<br>' . print_r($oUser->getUserPermission(), true) . '</pre>'
            . '</p>'
            . '</div>';
} else {
    if (!array_key_exists("goback", $_SESSION) || true){
        $sUrlback=$_SERVER["HTTP_REFERER"];
        if(
           strpos($sUrlback, $_SERVER["SERVER_NAME"])>0
           && !strpos($sUrlback, '/all/login/')
        ){
            $_SESSION["goback"]=$sUrlback;
        }
    }
    $i = 0;
    require_once ("./classes/formgen.class.php");

    $aForms = array(
        'login' => array(
            'meta' => array(
                'method' => 'POST',
                'action' => '?',
            ),
            'validate' => array(),
            'form' => array(
                'input' . $i++ => array(
                    'type' => 'text',
                    'name' => 'user',
                    'label' => t('page-login-username'),
                    'required' => 'required',
                    'validate' => 'isastring',
                    'size' => 10,
                    'value' => $aParams['user'],
                    'placeholder' => t('page-login-username'),
                    'autofocus' => 'autofocus',
                    'inline' => '1',
                ),
                'input' . $i++ => array(
                    'type' => 'markup',
                    'value' => '<div style="clear: both; "></div>'
                ),
                'input' . $i++ => array(
                    'type' => 'password',
                    'name' => 'password',
                    'label' => t('page-login-password'),
                    'required' => 'required',
                    'validate' => 'isastring',
                    'size' => 10,
                    'value' => $aParams['password'],
                    'placeholder' => t('page-login-password'),
                    'inline' => '1',
                ),
                'input' . $i++ => array(
                    'type' => 'markup',
                    'value' => '<div style="clear: both; margin-bottom: 3em;"></div>'
                    . '<div style="text-align: left; margin-left: 12em;">'
                ),
                'input' . $i++ => array(
                    'type' => 'submit',
                    'name' => 'btnsave',
                    'label' => t("login"),
                    'value' => $oHtml->getIcon('sign-ok') . t("login"),
                ),
                'input' . $i++ => array(
                    'type' => 'markup',
                    'value' => '</div>'
                ),
            ),
        )
    );

    $oForm = new formgen($aForms);
    $sOut.='<div style="width: 50%; min-width: 60em; margin-left: 15%;">'
            . '<h2>' . t("page-login-info") . '</h2>'
            . '<p>' . t("page-login-info-introtext") . '</p>';
    if (array_key_exists('user', $aParams)) {
        $sOut.='<div class="alert alert-danger" role="alert">'.t('page-login-auth-failed').'</div>';
    }
    $sOut.= $oForm->renderHtml("login")
            . '</div>';
}
// $sOut.= '<div id="navbuttom">' . aPrjHome() . '</div>';

// -- Ausgabe
echo $sOut;
