<?php

/* ######################################################################

  IML DEPLOYMENT

  webgui - overview
 * for all projects
 * for a single project

  ---------------------------------------------------------------------
  2014-11-17  Axel <axel.hahn@iml.unibe.ch>  added tags and branches
  2014-04-24  Axel <axel.hahn@iml.unibe.ch>  new visual; sortorder in 
              project overview
  2013-11-08  Axel <axel.hahn@iml.unibe.ch>
  ###################################################################### */


if (!array_key_exists("prj", $aParams)) {

    // ----------------------------------------------------------------------
    // overview over all projects
    // ----------------------------------------------------------------------
    require_once("./classes/projectlist.class.php");
    $oPrjList = new projectlist();
    $sOut = $oPrjList->renderOverview();
} else {
    
    // ----------------------------------------------------------------------
    // overview of a single project
    // ----------------------------------------------------------------------
    require_once("./classes/project.class.php");
    $oPrj = new project($aParams["prj"]);
    
    $iCountOfBranches=0;
    $iCountOfBuildErrors=count($oPrj->getBuildErrors());
    $iCountOfpackages=count($oPrj->getVersions());
    $iCountOfPhases=count($oPrj->getActivePhases());

    $sBuildErrorContent='<p>'.t('build-failes-hint').'</p>';
    if($iCountOfBuildErrors){
        $aTabdata=array();
        $aErrorfiles=$oPrj->getBuildErrors();
        rsort($aErrorfiles);
        foreach ($aErrorfiles as $sNumber=>$sErrorfile){
            $aTabdata[$oHtml->getIcon('file-any').' '.$sErrorfile]=''
                    // . 'file: ' . $oHtml->getIcon('file-target'). ''.$sErrorfile.'<br>'
                    // . 'date: ' . .'<br>'
                    // . 'age: ' .  .'<br>'
                    . $oPrj->getBuildErrorContent($sErrorfile);
        }
        $sBuildErrorContent.=$oHtml->getNav(array(
                'options' => array(
                    'type'=>'pills',
                    'justified'=>0,
                ),
                'tabs'=>$aTabdata)
            );
    } else {
        $sBuildErrorContent=$oHtml->getBox('info', t('build-failes-none'));
    }

    $sListOfBranches='<h4>'.t('branch-select').'</h4><ol>';
    foreach($oPrj->getRemoteBranches() as $aBranch){
        $sListOfBranches.='<li title="'.$aBranch['revision'].'">'.$aBranch['label'] . '</li>';
        $iCountOfBranches++;
    }
    $sListOfBranches.='</ol>';


    $sOut = '
                
            ' . $oPrj->renderLink("setup") . '<br>
                <br>
        
            <ul class="nav nav-tabs">
                <li class="active"><a href="#tab1" data-toggle="tab">' . $oHtml->getIcon('workflow') . t("way-of-packages") . '</a></li>
                <li><a href="#tab2" data-toggle="tab">' . $oHtml->getIcon('repository') . t("repositoryinfos") . ($iCountOfBranches ? ' <span class="badge badge-light">'.$iCountOfBranches.'</span>' : '' ).'</a></li>
                <li><a href="#tab3" data-toggle="tab">' . $oHtml->getIcon('sign-error') . t("build-failes") . ($iCountOfBuildErrors ? ' <span class="badge badge-light">'.$iCountOfBuildErrors.'</span>' : '' ).'</a></li>
                <li><a href="#tab4" data-toggle="tab">' . $oHtml->getIcon('package') . t("packages") . ($iCountOfpackages ? ' <span class="badge badge-light">'.$iCountOfpackages.'</span>' : '' ).'</a></li>
                <li><a href="#tab5" data-toggle="tab">' . $oHtml->getIcon('phase') . t('phases') . ($iCountOfPhases ? ' <span class="badge badge-light">'.$iCountOfPhases.'</span>' : '' ) . '</a></li>
            </ul>
            <br>
            <div class="tab-content">
                <div class="tab-pane active" id="tab1">
                    '
                    . '<h3 id="h3visual">' . $oHtml->getIcon('workflow') . t("way-of-packages") . '</h3>
                    ' . $oPrj->renderVisual() . '
                </div>
                <div class="tab-pane" id="tab2">
                    <h3 id="h3repo">' . $oHtml->getIcon('repository') . t("repositoryinfos") . '</h3>
                    ' . ($oPrj->canAcceptPhase() ? '<br>'.$oPrj->renderLink("build") : '') 
                    // . $oPrj->renderRepoInfo()
                    // . $oPrj->renderSelectRemoteBranches()
                    . $sListOfBranches . '
                </div>
                <div class="tab-pane" id="tab3">
                    <h3 id="h3versions">' . $oHtml->getIcon('sign-error') . t("build-failes") . '</h3>
                    '.$sBuildErrorContent.'
                </div>
                
                <div class="tab-pane" id="tab4">
                    <h3 id="h3versions">' . $oHtml->getIcon('package') . t("packages") . '</h3>
                    ' . $oPrj->renderVersionUsage() .'
   
                </div>
                <div class="tab-pane" id="tab5">
                    
                    <h3 id="h3phases">' . $oHtml->getIcon('phase') . t("phases") . '</h3>
                    '.($oPrj->getActivePhases()
                            ? '<p>' 
                                . t("page-overview-phase-infos") 
                                . '</p>' 
                                . $oPrj->renderPhaseInfo()
                            : $oHtml->getBox("info", t("page-overview-no-phase")) .$oPrj->renderLink("setup")
                    ).'
                </div>
            </div>
        <div style="clear: both"></div>
        <div id="navbuttom">' . aGotop() . aHome() . '</div>';
}
// 
echo $sOut;
