<?php
/*
 * script to be used as ajax poll request to get current status of an action
 */

header('Content-Type: application/json');
require_once('plugins_shellcmd.class.php');

$oShell=new shellcmd();
$oShell->sendResponse();

/*

// width of load=1
$iMaxWidth=100;

$sPlugin=isset($_GET['plugin']) && $_GET['plugin'] ? preg_replace('/^a-z0-9/', '', $_GET['plugin']) : false;

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------
function execCommand($sCmd){
    echo "DEBUG: ".__FUNCTION__ . "($sCmd)<br>";
    exec($sCmd, $aOut, $iResult);
    return [
        'command'=>$sCmd,
        'exitcode'=>$iResult,
        'output'=>$aOut,
    ];
}


if (!$sPlugin){
    echo "DEBUG: Missing param for a plugin.<br>";
    return [ 'error' => 'Missing param for a plugin.' ];
}

$sPluginfile=$sPlugin.'/command.php';
$sPluginclass='shellplugin_'.$sPlugin;

echo "DEBUG: sPluginfile=$sPluginfile<br>";

if (!file_exists($sPluginfile)){
    echo "DEBUG: Plugin seems to be corrupt. File not found: '. $sPluginfile.'<br>";
    return [ 'error' => 'Plugin seems to be corrupt. File not found: '. $sPluginfile ];
}


include($sPluginfile);

$oPlugin=new $sPluginclass();

echo "DEBUG: sCmd=$sCmd<br>";

$aResult=execCommand($sCmd);
if (function_exists("parsedata")){
    $aResult=parsedata($aResult);
}

echo '<pre>$aResult = '.print_r($aResult, 1).'<pre>';
return $aResult;


// ----------------------------------------------------------------------
function getLoad(){
    $sCmd='uptime';
    $aResult=execCommand($sCmd);
    $aTmp1=explode(',', $aResult['output'][0]);
    $aResult['data']=[
        'uptime'=>$aTmp1[0],
        'users'=>$aTmp1[1],
        'load'=>preg_replace('/^.*:/', '', $aTmp1[2]),
        'load5'=>$aTmp1[3],
        'load15'=>$aTmp1[4],
    ];
    return $aResult;
}

function getProcesses($sFilter){
    $sRegex=$sFilter ? $sFilter : 'SomethingThatWontMatchInProcessList';
    $sCmd="ps -f --forest | egrep -v '($sRegex)' | fgrep -v 'ps -f' | fgrep -v grep";
    return execCommand($sCmd);
}


// ----------------------------------------------------------------------
// ----------------------------------------------------------------------
function load(){
    global $iMaxWidth;
    $sReturn='';

    $aData=getLoad()['data'];

    $iMaxLoad=round(max($aData['load'], $aData['load5'], $aData['load15']))+1;
    $iScale=$iMaxWidth/$iMaxLoad;

    $sScalaPart=str_repeat('_', (round($iScale)-1)).'|';
    $sScala=str_repeat($sScalaPart, $iMaxLoad).$iMaxLoad;


    $sBar1=str_repeat('#', (int)($aData['load']*$iScale));
    $sBar5=str_repeat(' ', (int)($aData['load5']*$iScale - 1)).'|';
    $sBar15=str_repeat(' ', (int)($aData['load15']*$iScale - 1)).'^';

    $sReturn.= 'LOAD '.$aData['load'].' .. '.$aData['load5'].' .. '.$aData['load15'].'<br>'
        . $sScala.'<br>'
        . substr($sBar1, 0, $iMaxWidth).'<br>'
        . substr($sBar5, 0, $iMaxWidth).'<br>'
        . substr($sBar15, 0, $iMaxWidth).'<br>'
        ;

    return $sReturn;
}


function processes(){

    return 'PROCESSES:<br>'
        .shell_exec("ps -f --forest | egrep -v '(apache|httpd)' | fgrep -v 'ps -f' | fgrep -v grep")
        .'<hr>all processes:<br>'
        .shell_exec("ps -f --forest")
    ;
}

// ----------------------------------------------------------------------
// MAIN
// ----------------------------------------------------------------------

$sRemove='apache|httpd|php-fpm';

echo '<pre>'
    . load()
    // .'<hr size="1">'
    
    .'<hr size="1">'
    .'API DATA'
    .'<pre>getLoad()='.print_r(getLoad(), 1).'</pre>'
    .'<pre>getProcesses(\''.$sRemove.'\')='.print_r(getProcesses($sRemove), 1).'</pre>'
    ;
*/