<?php

class shellcmd {

    protected $_sPlugin=false;
    protected $_oPlugin=false;
    protected $_aReturn=false;

    protected $_debug=false;

    /**
     * constructor
     * @return bool
     */
    public function __construct(){
        return $this->detectPlugin();
    }


    /**
     * write debug output ... if enabled
     */
    protected function _wd($s){
        echo $this->_debug ? 'DEBUG '.__CLASS__ . ' '.$s."<br>\n" : '';
    }

    /**
     * detect plugin name to load from GET param "plugin"
     */
    public function detectPlugin(){
        $this->_sPlugin=isset($_GET['plugin']) && $_GET['plugin'] ? preg_replace('/^a-z0-9/', '', $_GET['plugin']) : false;
        $this->_wd("detected plugin: ".$this->_sPlugin);
        return true;
    }


    /**
     * initialize the shellcmd plugin
     * @returm boolean
     */
    protected function _loadPlugin(){
        $this->_oPlugin=false;
        if (!$this->_sPlugin){
            $this->_wd("Missing param for a plugin");
            $this->_aReturn=[ 'error' => 'Missing param for a plugin.' ];
            return false;
        }
        $sPluginfile=$this->_sPlugin.'/plugin.php';
        $sPluginclass='shellcmd_'.$this->_sPlugin;

        if (!file_exists($sPluginfile)){
            $this->_wd("Plugin seems to be corrupt. File not found: '. $sPluginfile.");
            $this->_aReturn=[ 'error' => 'Plugin seems to be corrupt. File not found: '. $sPluginfile ];
            return false;
        }
        include($sPluginfile);        
        $this->_oPlugin=new $sPluginclass();
        return true;
    }
    /**
     * helper execute a given command and return array with executed
     * command, returncode, output
     * @return
     */
    protected function _execCommand($sCmd){
        exec($sCmd, $aOut, $iResult);
        return [
            'command'=>$sCmd,
            'exitcode'=>$iResult,
            'output'=>$aOut,
        ];
    }

    /**
     * get data from plugin command and return array with executed
     * command, returncode, output, parsed data
     * @return array
     */
    public function get(){
        $this->_loadPlugin();
        if (!$this->_oPlugin){
            return $this->_aReturn;
        }
        
        $sCmd=$this->_oPlugin->getCommand();
        $this->_wd("sCmd=$sCmd");
        
        $this->_aResult=$this->_execCommand($sCmd);
        if (method_exists($this->_oPlugin, "parsedata")){
            $this->_aResult=$this->_oPlugin->parsedata($this->_aResult);
        }
        return $this->_aResult;
    }

    /**
     * send response as json
     */
    public function sendResponse(){
        header('Content-Type: application/json');
        echo json_encode($this->get(), JSON_PRETTY_PRINT);
    }

}
