<?php

/* ######################################################################

  IML DEPLOYMENT

  class projectlist to render overview page

  ---------------------------------------------------------------------
  2013-11-08  Axel <axel.hahn@iml.unibe.ch>
  ###################################################################### */

require_once 'base.class.php';
require_once 'project.class.php';

/**
 * class for project overview
 */
class projectlist extends base{
    // ----------------------------------------------------------------------
    // CONFIG
    // ----------------------------------------------------------------------    
    // ----------------------------------------------------------------------
    // constructor
    // ----------------------------------------------------------------------

    /**
     * constructor2 called from constructor of base class
     */
    public function __construct() {
        $this->oUser=new user();
        // define 
    }

    // ----------------------------------------------------------------------
    // private functions
    // ----------------------------------------------------------------------
    // ----------------------------------------------------------------------
    // GETTER
    // ----------------------------------------------------------------------
    // ----------------------------------------------------------------------
    // SETTER
    // ----------------------------------------------------------------------
    // ----------------------------------------------------------------------
    // ACTIONS
    // ----------------------------------------------------------------------

    /**
     * render html for overview table
     * @return string
     */
    public function renderOverview() {
        
        $sOut = '';  // table
        $sOut2 = ''; // tiles
        $oPrj = false;
        $sTrClass = "trproject";
        $sColClass = "tdphase";

        $oPrj1 = new project();

        $sPrjFilter = '';
        $sPhaseFilter = '';
        $sPrjFilter.='<option value="' . $sTrClass . '">' . t("all") . '</option>';
        $sPhaseFilter.='<option value="' . $sColClass . '">' . t("all") . '</option>';
        // foreach (array_keys($this->_aPhases) as $sPhase) {
        foreach (array_keys($oPrj1->getPhases()) as $sPhase) {
            $sPhaseFilter.='<option value="' . $sPhase . '" >' . $sPhase . '</option>';
        }
        foreach ($oPrj1->getProjects() as $sPrj) {
            $oPrj = new project($sPrj);
            $sPrjFilter.='<option value="' . $sPrj . '">' . $oPrj->getLabel() . '</option>';

            $sOutPhases = '';
            $sOutPhases2 = '';

            // loop over phases ...
            foreach (array_keys($oPrj->getPhases()) as $sPhase) {
                $sOutPhases.=$oPrj->renderAllPhaseDetails($sPhase, true, false);
                if ($oPrj->canAcceptPhase($sPhase)) {
                    // $sOutPhases2.=' <span class="'.$sPhase.'" style="padding: 1em 0.5em 0.5em;">'.$oPrj->renderLink("accept", $sPhase).'</span>';
                    $sOutPhases2.=' ' . $oPrj->renderLink("accept", $sPhase);
                }
            }

            $sOut2 .= '<div class="' . $sPrj . ' ' . $sTrClass . ' prjbox"><div class="title">'
                    . '<a href="" onclick="$(\'#prjfilter\').val(\'' . $sPrj . '\'); window.setTimeout(\'filterOverviewTable();\', 10);setview(\'extended\'); return false;" '
                    . 'style="float: right;" '
                    . 'title="' . t("overview-filter-hint") . '"><i class="glyphicon glyphicon-filter"></i> ' . t("overview-filter") . '</a>'
                    . '<strong>'
                    . '<a href="/deployment/' . $sPrj . '/" title="' . t("menu-project-home") . ' ' . $oPrj->getLabel() . '"><i class="glyphicon glyphicon-book"></i> ' . $oPrj->getLabel() . '</a>'
                    . '</strong>'
                    . '</div><div class="box" '
                    . 'onclick="location.href=\'/deployment/' . $sPrj . '/\'">'
                    . $oPrj->getDescription()
                    . '<br>'
                    . '';

            // render output
            $sOut.='
                <tr class="' . $sPrj . ' ' . $sTrClass . '">
                    <td class="prj">
                        <strong>
                            <a href="/deployment/' . $sPrj . '/" title="'.$oPrj->getDescription().'">
                                <i class="glyphicon glyphicon-book"></i>
                                ' . $oPrj->getLabel() . '
                            </a>
                        </strong>'
                    . '    <br>' 
                    // . $oPrj->getDescription() 
                    . '</td>'
                    . '<td class="prj">'
                    . '<a href="#" onclick="setProjectFilter(\'' . $sPrj . '\'); return false;" '
                    . 'style="float: right;" '
                    . 'class="btn btn-default" '
                    . 'title="' . t("overview-filter-hint") . '"><i class="glyphicon glyphicon-filter"></i> ' . t("overview-filter") . '</a>'
                    . '</td>'
                    . '<td class="prj">';
            if ($oPrj->canAcceptPhase()) {
                $sOut .=$oPrj->renderLink("build");
                $sOut2.=$oPrj->renderLink("build");
                // $sOut.='<a href="/deployment/'.$sPrj.'/build/" class="btn btn-default '.$sNext.'"><i class=" icon-forward"></i> Build f&uuml;r ['.$sNext.']</a><br>';
            }
            $sOut.='</td>
                ' . $sOutPhases . '
                </tr>';
            $sOut2.=$sOutPhases2 . '</div></div>';
        }
        if ($sOut) {
            $sRowHead1 = '';
            $sRowHead2 = '';

            foreach (array_keys($oPrj1->getPhases()) as $sPhase) {
                // Anzahl colspan ist hartcodiert :-/
                $sRowHead1.='<th class="' . $sPhase . ' ' . $sColClass . '" colspan="3">' . $sPhase . '</th>';
                $sRowHead2.=$oPrj->renderPlacesAsTd($sPhase);
            }
            $sOut = '
                <script>
                
                    /**
                    * filter table by chosen select values for project and phase
                    */
                    function filterOverviewTable(){
                        var sPrj=$("#prjfilter").val();
                        // var sPhase=$("#phasefilter").val();
                        // localStorage.setItem("selectedPhase", sPhase);
                        // $(\'.' . $sColClass . '\').hide(); $(\'.\' + sPhase).show();
                        localStorage.setItem("selectedPrj", sPrj);
                        $(\'.' . $sTrClass . '\').hide().removeClass("trprojectfiltered"); 
                        $(\'.\' + sPrj).show();
                        if (sPrj!="' . $sTrClass . '"){
                            $(\'.\' + sPrj).addClass("trprojectfiltered");
                        }
                        showResetbtn();
                    }
                    
                    /**
                    * toggle: show a single project/ all projects
                    */
                    function setProjectFilter(sPrj){
                        var sCurrentPrj=$(\'#prjfilter\').val();
                        if (sCurrentPrj != \'' .$sTrClass. '\'){
                            $(\'#prjfilter\').val(\'' .$sTrClass. '\'); 
                        } else {
                            $(\'#prjfilter\').val(sPrj); 
                        }
                        window.setTimeout(\'filterOverviewTable();\', 10);
                        setview(\'extended\'); 
                    }
                    
                    /**
                    * filter table and tiles by filtertext
                    */
                    function filterTable(){
                        var sVisible="";
                        var sSearch=$("#efilter").val();
                        localStorage.setItem("efilter", sSearch);
                        var Regex = new RegExp(sSearch, "i");
                        $(".trproject").each(function() {
                            sVisible="none";
                            if ( Regex.exec(this.innerHTML)) {
                                sVisible="";
                            }
                            $(this).css("display", sVisible);
                        });
                        showResetbtn();
                        return false;
                    }
                    
                    /**
                    * switch view between tiles and table
                    */
                    function setview(sMode){
                        $(\'.view\').hide(); 
                        $(\'.view\'+sMode).show();
                        localStorage.setItem("mode", sMode);
                        return false;
                    }
                    
                    /**
                    * switch view between tiles and table
                    */
                    function setrole(){
                        var sRole=$("#rolefilter").val();
                        $(\'.role\').hide(); 
                        $(\'.role\'+sRole).show();
                        localStorage.setItem("role", sRole);
                        showResetbtn();
                        return false;
                    }
                    
                    /**
                    * set default view; it gets the last values for filter text,
                    * and selected values in dropdowns and restores the
                    * last view
                    */
                    function setDefaultView(){

                        if(localStorage.getItem("selectedPrj") && localStorage.getItem("selectedPrj")!=\'null\'){
                            $("#prjfilter").val(localStorage.getItem("selectedPrj"));
                        } else {
                            $("#prjfilter").val($("#prjfilter option:first").val());
                        }

                        if (localStorage.getItem("selectedPhase") && localStorage.getItem("selectedPhase")!=\'null\'){
                            $("#phasefilter").val(localStorage.getItem("selectedPhase"));
                        } else {
                            $("#phasefilter").val($("#phasefilter option:first").val());
                        }
                        // window.setTimeout("filterOverviewTable();", 10);
                        filterOverviewTable();
                        
                        if (localStorage.getItem("efilter") && localStorage.getItem("efilter")!=\'null\') {
                            $("#efilter").val(localStorage.getItem("efilter"));
                            window.setTimeout("filterTable();", 10);
                        }
                        if (localStorage.getItem("role") && localStorage.getItem("role")!=\'null\') {
                            $("#rolefilter").val(localStorage.getItem("role"));
                            window.setTimeout("setrole();", 20);
                        }
                        
                        if (localStorage.getItem("mode") && localStorage.getItem("mode")!=\'null\') {
                            var sMode=localStorage.getItem("mode");
                            if (sMode)setview(sMode);
                        }
                    }
                    
                    /**
                    * Button zum Filter reset anzeigen/ verbergen
                    */
                    function showResetbtn(){                        
                        var sVisible=($("#efilter").val())?"visible":"hidden";
                        if ($("#prjfilter").val()!="' . $sTrClass . '")sVisible="visible";
                        // if ($("#phasefilter").val()!="' . $sColClass . '")sVisible="visible";
                        if ($("#rolefilter").val())sVisible="visible";
                        $("#btnresetfilter").css("visibility", sVisible);
                        return false;
                    }
                    
                    /**
                    * Aktion des Filter reset: Filter zurücksetzen
                    */
                    function resetFilter(){
                        $(\'#prjfilter\').val(\'' .$sTrClass. '\');
                        // $("#phasefilter").val("");
                        filterOverviewTable();
                        $("#efilter").val("");                        
                        window.setTimeout("filterTable();", 10);
                        $("#rolefilter").val("");
                        window.setTimeout("setrole();", 20);
                        showResetbtn();
                        return false;
                    }
                </script>
                <div class="filterbar">
                
                    <form class="form-inline">

                        <a href="#" class="view viewextended" onclick="setview(\'simple\');"><i class="glyphicon glyphicon-th-large"></i> ' . t("overview-simpleview") . '</a>
                        <a href="#" class="view viewsimple" onclick="setview(\'extended\');" ><i class="glyphicon glyphicon-th-list"></i> ' . t("overview-extview") . '</a>
                        |

                        
                        <label for="efilter">
                            <i class="glyphicon glyphicon-filter"></i>
                            ' . t("overview-textsearch") . ':
                        </label>
                        <input type="text" id="efilter" name="efilter" 
                            class="form-control"
                            style="width: 150px;"
                            onchange="filterTable();"
                            onKeypress="filterTable(); "
                            onKeyup="filterTable(); "
                            title="' . t("overview-textsearch-hint") . '"
                            >
                        
                        <span class="view viewextended">
                            &nbsp;&nbsp;&nbsp;
                            <label for="prjfilter">
                            ' . t("overview-filterprj") . ': 
                            </label>
                            <select id="prjfilter" class="form-control" onchange="filterOverviewTable(); return false;">
                                ' . $sPrjFilter . '
                            </select>

                            <span style="display: none;">
                            &nbsp;&nbsp;&nbsp;
                            <label for="phasefilter">Phasen:</label>
                            <select id="phasefilter" class="form-control" onchange="filterOverviewTable(); return false;">
                                ' . $sPhaseFilter . '
                            </select>
                            </span>

                        </span>
                        &nbsp;&nbsp;&nbsp;
                        <label for="rolefilter">
                        ' . t("overview-filterrole") . ':
                        </label>
                        <select id="rolefilter" class="form-control" onchange="setrole(); return false;">
                            <option value="">' . t("all") . '</option>
                            <option value="developer">' . t("developer") . '</option>
                            <option value="pl">' . t("projectmanager") . '</option>
                        </select>

                        <a href="#" class="btn btn-danger" id="btnresetfilter" 
                            title="' . t("overview-filterreset-hint") . '"
                            onclick="resetFilter();"><i class="glyphicon glyphicon-remove"></i> ' . t("overview-filterreset") . '</a>
                    </form>
                    <div style="clear: both; margin-bottom: 1em"></div>
                </div>


                <div class="view viewsimple">
                    ' . $sOut2 . '
                    <div style="clear: both;"></div>
                    <br>
                </div>

		<table class="table view viewextended" id="tbloverview">
			<thead>
				<tr>
					<th class="prj" rowspan="2">' . t("project") . '<br><br></th>
					<th class="prj" rowspan="2"></th>
					<th class="prj" rowspan="2"></th>
                                        ' . $sRowHead1 . '
				</tr>
                                <tr>
                                        ' . $sRowHead2 . '
                                </tr>
			</thead>
			<tbody>
		' . $sOut . '</tbody></table>'
                    . '<script>window.setTimeout("setDefaultView();", 50);</script>';
        } else {
            $sOut = t("class-pl-error-no-project") . '<br><br>'
                    . $oPrj1->renderLink("new")
            ;
        }
        return $sOut;
    }

}
