<?php
/* ______________________________________________________________________
 * 
 * A P P M O N I T O R  ::  CLIENT - CHECK  ::  GENERAL INCLUDE
 * ______________________________________________________________________
 * 
 * @author: Axel Hahn
 * ----------------------------------------------------------------------
 * 2018-06-30  v0.1
 */

// ----------------------------------------------------------------------
// SECURITY STUFF ... protect access to monitoring data
// ----------------------------------------------------------------------

// --- restrict ip access

// check local ips and IML networks (includes the monitor)
// appmonitor is not available on EDUROAM or VPN
$oMonitor->checkIp(array(
    '127.0.0.1',
    '::1',
    '10.0.2.2',
    '130.92.30.11',
    '130.92.30.44',
    '130.92.79.49',
));

// --- check a token
// an incoming request must have the GET param "token=123"
// $oMonitor->checkTokem('token', '123');


// ----------------------------------------------------------------------
// NOTIFICATION
// ----------------------------------------------------------------------

// $oMonitor->addEmail('sysadmin@example.com');
// $oMonitor->addSlackWebhook(array("mywebhook"=> "https://hooks.slack.com/services/(...)"));
$oMonitor->addEmail('axel.hahn@iml.unibe.ch');


// ----------------------------------------------------------------------
// set a tag with phase
// ----------------------------------------------------------------------
$sHost=$_SERVER['HTTP_HOST'];
$sHost2=php_uname("n");   
$sMyPhase='live';
foreach (array('dev', 'preview', 'stage', 'demo') as $sPhase){
    if(
        strstr($sHost.'.', $sPhase)!==false
        || strstr($sHost.'-', $sPhase)!==false
        || strstr($sHost2.'.', $sPhase)!==false
        || strstr($sHost2.'-', $sPhase)!==false
    ) {
        $sMyPhase=$sPhase;
        break;
    }
}
$oMonitor->addTag($sMyPhase);

