<?php

/* ######################################################################

  IML DEPLOYMENT

  webgui - documentation of the classes

  ---------------------------------------------------------------------
  2013-11-19  Axel <axel.hahn@iml.unibe.ch>
  ###################################################################### */

require_once("./classes/classinfos.class.php");
$aClasses = array(
    "actionlog" => array("name" => "actionLog"),
    "cache" => array("name" => "AhCache"),
    "config-replacement" => array("name" => "configreplacement"),
    "deploy-foreman" => array("name" => "deployForeman"),
    "foremanapi" => array("name" => "ForemanApi"),
    "formgen" => array("name" => "formgen"),
    "htmlguielements" => array("name" => "htmlguielements"),
    "ldap" => array("name" => "imlldap"),
    "logger" => array("name" => "logger"),
    "messenger" => array("name" => "messenger"),
    "page" => array("name" => "Page"),
    "project" => array("name" => "project"),
    "projectlist" => array("name" => "projectlist"),
    "rollout_base" => array("name" => "rollout_base"),
    "user" => array("name" => "user"),
    "vcs.git" => array("name" => "vcs"),

);

$sOut = '';
$sOut.='<a href="/deployment/all/doc/">Start</a> | ';
foreach ($aClasses as $sClassfile => $aInfos) {
    $sOut.='<a href="/deployment/all/doc/' . $sClassfile . '/">' . $sClassfile . '</a> | ';
}
$sOut.= '<hr>';

if (array_key_exists("par3", $aParams)) {
    $sClass = $aParams["par3"];
    if (!array_key_exists($sClass, $aClasses)) {
        $sOut.= $oHtml->getBox("error", sprintf(t("page-doc-error-class-not-configured"), $sClass, __FILE__));
    } else {
        require_once("./classes/$sClass.class.php");
        $o = new classinfos($aClasses[$sClass]["name"]);
        $sOut.=t("page-doc-info-" . $sClass) . $o->render();
    }
} else {
    $sOut.=t("page-doc-info-select-class") . '<ul>';
    foreach (array_keys($aClasses) as $sClassfile) {
        $sOut.='<li>'
                . '<a href="/deployment/all/doc/' . $sClassfile . '/">' . $sClassfile . '</a>'
                . ' ' . t("page-doc-info-" . $sClassfile)
                . '</li>';
    }
    $sOut.='</ul>';
}

// -- Ausgabe
echo $sOut;
?>

