<?php

/**
 * 
 * Rollout plugin - ssh
 * 
 * Run a SSH command on remote targets
 *
 * @author <axel.hahn@iml.unibe.ch>
 */
class rollout_ssh extends rollout_base {

    /**
     * check requirements if the plugin could work
     */
    public function checkRequirements() {
        // no specific checks needed ... always true
        return true;
    }

    /**
     * check access to a deploy target
     */
    public function checkConnectionToTarget() {
        // do nothing ... always true
        return true;
    }

    /**
     * get array with commands to execute to deploy a package
     * 
     * @param string  $sPhase  phase
     * @return array
     */
    public function getDeployCommands($sPhase){
        $aReturn=array();
        $aConfig=$this->getConfig($sPhase);
        $aTargethosts = explode(',', $aConfig['hosts']);
        
        // loop over hosts and create shell commands for it
        foreach(explode(',', $aConfig['hosts']) as $sMyHost){
            $aReturn[]= sprintf($aConfig['addkeycommand'], $sMyHost, $sMyHost);
            $aReturn[]='ssh '
                    . ($aConfig['privatekey'] ? '-i \''.$aConfig['privatekey'].'\' ' : '')
                    . ($aConfig['user'] ? $aConfig['user'].'@' : '')
                    . $sMyHost.' '
                    . '\''.$aConfig['command'].'\''
                    ;
        }
        
        return $aReturn;
    }
    
}
