<?php
/**
 * 
 * SHELLCMD PLUGIN :: Processes
 * 
 * ----------------------------------------------------------------------
 * 2022-09-19  axel.hahn@iml.unibe.ch
 */
class shellcmd_processes {
    /**
     * @var fallback command line to exectute; command in config.josn has priority
     */
    protected $_command="ps -ef --forest ";

    /**
     * constructor ... returns command
     * @return string
     */
    public function __constructor(){
        return $this->getCommand();
    }

    /**
     * get command
     * @return string
     */
    public function getCommand(){
        return $this->_command;
    }

    /**
     * parse output and extract wanted values in section "data"
     * @return array
     */
    public function parsedata($aResult){
        $aResult['data']=[
            'count'=>count($aResult['output'])-1,
        ];
        return $aResult;
    }

}
/*

EXAMPLE OUTPUT

{
    "command": "ps -ef --forest ",
    "exitcode": 0,
    "time": "12:02:47",
    "output": [
        "UID          PID    PPID  C STIME TTY          TIME CMD",
        "www-data       1       0  0 11:21 ?        00:00:00 apache2 -DFOREGROUND",
        "www-data      17       1  0 11:21 ?        00:00:00 apache2 -DFOREGROUND",
        "www-data      20       1  0 11:21 ?        00:00:00 apache2 -DFOREGROUND",
        "www-data      21       1  0 11:21 ?        00:00:00 apache2 -DFOREGROUND",
        "www-data      24       1  0 11:21 ?        00:00:00 apache2 -DFOREGROUND",
        "www-data     270       1  0 11:27 ?        00:00:00 apache2 -DFOREGROUND",
        "www-data    2929     270  0 12:02 ?        00:00:00  \\_ sh -c ps -ef --forest",
        "www-data    2930    2929  0 12:02 ?        00:00:00      \\_ ps -ef --forest",
        "www-data     278       1  0 11:27 ?        00:00:00 apache2 -DFOREGROUND",
        "www-data     279       1  0 11:27 ?        00:00:00 apache2 -DFOREGROUND",
        "www-data    2569       1  0 11:59 ?        00:00:00 apache2 -DFOREGROUND",
        "www-data    2570       1  0 11:59 ?        00:00:00 apache2 -DFOREGROUND",
        "www-data    2571       1  0 11:59 ?        00:00:00 apache2 -DFOREGROUND"
    ],
    "data": {
        "count": 13
    }
}

*/