<?php

/* ######################################################################

  IML DEPLOYMENT

  webgui - accept a phase to rollout it to the next phase

  ---------------------------------------------------------------------
  2013-11-08  Axel <axel.hahn@iml.unibe.ch>
  ###################################################################### */

require_once("./classes/project_gui.class.php");

// --- Checks
$oPrj = new projectgui($aParams["prj"]);

if (array_key_exists("par3", $aParams)) {
    $sPhase = $aParams["par3"];
}

$sOut = '';
if (array_key_exists("confirm", $aParams)) {
    $sOut.=$oPrj->accept($sPhase);
} else {
    if (!$sPhase) {
        $sOut.=$oHtml->getBox("error", t("error-no-phase"));
    } else {
        if (!$oPrj->canAcceptPhase($sPhase)) {
            $sOut.= sprintf(t("page-accept-error-cannot-accept-phase"), $sPhase);
        } else {
            $aPhaseData = $oPrj->getPhaseInfos($sPhase);
            $aConfigPrj = $oPrj->getConfig();
            $sUrl = $aConfigPrj["phases"][$sPhase]["url"];

            $sNext = $oPrj->getNextPhase($sPhase);
            $aPhaseData2 = $oPrj->getPhaseInfos($sNext);

            if (
                    array_key_exists("revision", $aPhaseData2["onhold"]) && $aPhaseData2["onhold"]["revision"] == $aPhaseData["deployed"]["revision"]
            ) {
                $sOut.=$oHtml->getBox("warning", sprintf(t("page-accept-warning-version-exists-in-next-queue"), $sNext, $sPhase));
            }
            if (
                    array_key_exists("revision", $aPhaseData2["ready2install"]) && $aPhaseData2["ready2install"]["revision"] == $aPhaseData["deployed"]["revision"]
            ) {
                $sOut.=$oHtml->getBox("warning", sprintf(t("page-accept-warning-version-exists-in-next-repo"), $sNext, $sPhase));
            }
            $sOut.='
                   <table>
                    <thead>
                        <tr>
                            <th class="' . $sPhase . '">' . $sPhase . '</th>
                            <th> </th>
                            <th class="' . $sNext . '" colspan="2">' . $sNext . '</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class="' . $sPhase . '">
                                ' . t("deployed") . ':<br>
                                ' . $oPrj->renderPhaseDetail($sPhase, "deployed", false) . '
                            </td>
                            <td style="vertical-align: middle;">
                                <img src="/deployment/images/nuvola64x64/apps/noatun.png">
                            </td>
                            <td class="' . $sNext . '">
                                ' . t("onhold") . ':<br>
                                ' . $oPrj->renderPhaseDetail($sNext, "onhold", false) . '
                            </td>
                            <td class="' . $sNext . '">
                                ' . t("ready2install") . ':<br>
                                ' . $oPrj->renderPhaseDetail($sNext, "ready2install", false) . '
                            </td>
                        </tr>
                        </tbody>
                   </table>
                   <br>
            ';

            // Eingabe Kommentare zum Deployment
            $sOut.='
                <hr>
                   <p>
                        ' . t("url") . ': <a href="' . $sUrl . '">' . $sUrl . '</a><br>
                        ' . sprintf(t("page-accept-info"), $sPhase, $sPhase, $sNext, $sNext) . '
                   </p>';
            $sOut.='
                 <form action="?" method="post" enctype="multipart/form-data">
                    <input type="hidden" name="confirm" value="1">
                    <fieldset>
                        '.aGoback().'
                        <button type="submit" class="btn btn-large '.$sNext.'" >' . $oHtml->getIcon('accept') . sprintf(t("page-accept-buttonlabel"), $sPhase, $sNext) . '</button>
                    </fieldset>
                 </form>
                 ';
            $BODY=
            $renderAdminLTE->addRow(
                $renderAdminLTE->addCol(
                    $renderAdminLTE->getCard([
                    'type'=>'success',
                    'variant'=>'outline',
                    'text'=>$sOut,
                    ]), 12
                )
            );
         
        }
    }
}

// $sOut.= '<div id="navbuttom">' . aPrjHome() . '</div>';

// -- Ausgabe
echo $sOut;
?>
