<?php

/**
 * 
 * VALUE HANDLER API
 * 
 * Syntax des Aufrufs (als GET Schreibweise; ein POST einzelner Variablen geht ebenso):
 * 
 * update
 * http://dev.ci.iml.unibe.ch:8002/valuestore/?action=update&package=player&phase=stage&place=deployed&host=stage01.player&variable=version&value=false
 * 
 * get:
 * http://dev.ci.iml.unibe.ch:8002/valuestore/?action=get&package=player&phase=stage&place=deployed
 * 
 * Parameter:
 * 
 *      action=update (get-Funktionen muss ich später noch bauen)
 *      project=[Projekt-ID (=Name des Package, das installiert wird); bei Versionen leer!]
 *      package=[Package-name]
 *      phase=(preview|stage|live)
 *      host=[FQDN]
 *      variable=version (andere noch nicht unterstützt/ vorgesehen)
 *      value=[Versionsdaten]
 * 
 * 2017-04-07  hahn  first lines
 */
// ----------------------------------------------------------------------
// functions
// ----------------------------------------------------------------------

/**
 * show an error message and quit with http status code 400 (Bad request)
 * @param string  $sMessage  message to show
 * @return boolean
 */
function quit($sMessage) {
    $sProtocol = (isset($_SERVER['SERVER_PROTOCOL']) ? $_SERVER['SERVER_PROTOCOL'] : 'HTTP/1.0');
    header("$sProtocol 400: Bad request");
    die("<h1>Bad request</h1>" . $sMessage);
    return false;
}

/**
 * get a request param from GET and POST scope (POST has priority) and
 * verify it with execution of a cleanup array
 * @param string  $sKey            key to search for in GET or POST
 * @param string  $sRegex4Cleanup  regex for filtering
 * @return type
 */
function getParam($sKey, $sRegex4Cleanup = false) {
    $sValue = false;
    if (array_key_exists($sKey, $_GET)) {
        $sValue = $_GET[$sKey];
    }
    if (array_key_exists($sKey, $_POST)) {
        $sValue = $_POST[$sKey];
    }
    if (!$sValue) {
        return false;
    }
    $sReturn = $sRegex4Cleanup ? preg_replace($sRegex4Cleanup, '', $sValue) : $sValue;

    if ($sReturn !== $sValue) {
        quit("ERROR: the parameter value in [$sKey = ...] has a wrong format.");
    }
    return $sReturn;
}

// ----------------------------------------------------------------------
// check required params
// ----------------------------------------------------------------------
/*
if (!$_GET || !count($_GET)) {
    quit("no parameter was found.");
}
 */


// ----------------------------------------------------------------------
// get vars
// ----------------------------------------------------------------------

$sAction = getParam('action', '/[^a-z]/');
if ($sAction !== "cleanup" 
        && $sAction !== "delete" 
        && $sAction !== "get" 
        && $sAction !== "show"
        && $sAction !== "update" 
        ) {
    quit("action is unknown or not implemented yet.");
}

$sProject = getParam('project', '/[^a-z\-\_0-9]/');
$sPackage = getParam('package', '/[^a-z\-\_0-9]/');
$sPhase = getParam('phase', '/[^a-z]/');
$sPlace = getParam('place', '/[^a-z]/');
$sHost = getParam('host', '/[^a-z\.\-0-9]/');

if ($sHost && !$sPlace) {
    $sPlace = 'deployed';
}

$sVarname = getParam('variable', '/[^a-z]/');
$sValue = getParam('value', '');


// ----------------------------------------------------------------------
// init class
// ----------------------------------------------------------------------

require './classes/valuestore.class.php';

$oVersion = new valuestore();

switch ($sAction) {
    case 'cleanup':
        $oVersion->cleanup();
        echo "Cleanup was done.";
        break;
    case 'delete':
        $oVersion->setProject($sProject, $sPackage, $sPhase, $sPlace, $sHost);
        if ($oVersion->deleteValues($sVarname)) {

            echo "OK: " . print_r($oVersion->whereiam()) . " ($sVarname) was deleted.";
        } else {
            echo "ERROR: update for $sVarname failed.";
        }
        break;

        break;
    case 'get':
        $oVersion->setProject($sProject, $sPackage, $sPhase, $sPlace, $sHost);
        header('Content-Type: application/json');
        echo json_encode($oVersion->getVersion());

        break;
    case 'update':
        $oVersion->setProject($sProject, $sPackage, $sPhase, $sPlace, $sHost);
        if (!$sVarname) {
            quit("ERROR: the update action requires a variable and a value.");
        }
        switch ($sVarname) {
            // case 'other-varname':
            case 'version':
                if ($oVersion->updateVar($sVarname, $sValue)) {
                    echo "OK: $sVarname was updated.".PHP_EOL."new value: $sValue".PHP_EOL;
                } else {
                    echo "ERROR: update for $sVarname failed.";
                }
                break;

            default:
                quit("ERROR: update of variable [$sVarname] is not supported.");
                break;
        }
        break;
    case 'show':
        $oVersion->setProject($sProject, $sPackage, $sPhase, $sPlace, $sHost);
        
        echo '<h1>package ['.$sPackage.'] on '.$sHost.'</h1>'
                . 'Host: '.$sHost.'<br>'
                . 'package: '.$sPackage.'<br>'
                . 'phase: '.$sPhase.'<br>'
                . 'place: '.$sPlace.'<br>'
                . '<br>'
                . '<button onclick="history.back();">back</button><br>'
                . '<hr>'
                . '<pre>'.json_encode($oVersion->getVersion(), JSON_PRETTY_PRINT).'</pre>'
                . '<hr>'
                . '<button onclick="history.back();">back</button>'
                . '';

        break;


    default:
        quit("ERROR: the action is not supported.");
        break;
}
