<?php
/**
 * INTERFACE for rollout plugins
 * 
 * @author hahn
 */
interface iRolloutplugin {

    // ----------------------------------------------------------------------
    // VERIFY
    // ----------------------------------------------------------------------
    
    /**
     * check requirements if the plugin could work
     */
    public function checkRequirements();
    
    /**
     * check access to a deploy target
     */
    public function checkConnectionToTarget();

    // ----------------------------------------------------------------------
    // SETTER
    // ----------------------------------------------------------------------
    
    // ----------------------------------------------------------------------
    // GETTER
    // ----------------------------------------------------------------------

    /**
     * get configuration for the project .. or more specifi for a given phase
     * @param  string   $sPhase
     * @param  boolean  $bMask   Flag for public output; if true then mask your secrets
     * @return array
     */
    public function getConfig($sPhase=false, $bMask=false);
    
    /**
     * get an array with shell commands to execute
     * @param  string   $sPhase
     * @param  boolean  $bMask   Flag for public output; if true then mask your secrets
     * @return array
     */
    public function getDeployCommands($sPhase, $bMask=false);

    /**
     * get name of plugin as string ... language specific
     */
    public function getName();
    
    /**
     * get description of plugin as string ... language specific
     */
    public function getDescription();
    
    /**
     * get array of data in info.js
     */
    public function getPluginInfos();
    // ----------------------------------------------------------------------
    // RENDERER
    // ----------------------------------------------------------------------
    public function renderFormdata4Project();
    public function renderFormdata4Phase($sPhase);

    // ----------------------------------------------------------------------
    // ACTIONS
    // ----------------------------------------------------------------------

    
}

