<?php

/* ######################################################################

  IML DEPLOYMENT

  webgui - index file - controller like
  ensure that you activated the rewrite rules

  RewriteEngine on
  RewriteCond %{REQUEST_FILENAME} !-f
  RewriteCond %{REQUEST_URI} !^/server-status$
  RewriteRule ^(.*)$ index.php [QSA,L]

  ---------------------------------------------------------------------
  2013-11-08  Axel <axel.hahn@iml.unibe.ch>
  ###################################################################### */

session_start();

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once("./classes/page.class.php");
require_once("./classes/plugins_renderer.class.php");

// detect first run
$bFirstRun=!file_exists("../../config/config_custom.php") || !file_exists("../../config/inc_user2roles.php");

require_once("../../config/inc_projects_config.php");
require_once("./classes/logger.class.php");
require_once("./classes/user.class.php");
global $oCLog;
$oCLog = new logger();
$oCLog->enableDebugByIp($aConfig['showdebug']['ip']);
require_once("./inc_functions.php");
require_once("./classes/htmlguielements.class.php");
$oHtml=new htmlguielements();

$sPrj = "";
$sAction = "overview";

// ----------------------------------------------------------------------
// check params
// ----------------------------------------------------------------------

if (array_key_exists("prj", $aParams)) {
    $sPrj = $aParams["prj"];
}
if (array_key_exists("action", $aParams)) {
    if (file_exists(__DIR__ . '/pages/act_' . $aParams["action"] . ".php")) {
        $sAction = $aParams["action"];
    }
}
$oCLog->add("parsing params "
        . '<pre>GET '.print_r($_GET, true).'</pre>'
        . '<pre>POST '.print_r($_POST, true).'</pre>'
        . '<pre>aParams: '.print_r($aParams, true).'</pre>'
        );

if($bFirstRun){
    $sAction='installer';
}
    
// ----------------------------------------------------------------------
// html header
// ----------------------------------------------------------------------

$sHeader = "\n<!-- generated CSS for phases -->\n<style>\n";
foreach ($aConfig["phases"] as $sPhase => $aData) {
    $sHeader.=array_key_exists("bgdark", $aData["css"]) ? 'th.' . $sPhase . '{' . $aData["css"]["bgdark"] . '}' : '';
    $sHeader.=array_key_exists("bglight", $aData["css"]) ? 'td.' . $sPhase . ', div.' . $sPhase . '{' . $aData["css"]["bglight"] . '}' : '';
    $sHeader.=array_key_exists("bgbutton", $aData["css"]) ? 'a.' . $sPhase . ',a.' . $sPhase . ':hover,button.' . $sPhase . ',button.' . $sPhase . ':hover{' . $aData["css"]["bgbutton"] . '}' : '';
}
$sHeader.="</style>\n";

// add shellcmd files
$sShellOuptut='';
$sTopRight='';

$CI_plugins=new plugin_renderer(isset($aConfig['plugins']) ? $aConfig['plugins'] : []);
$CI_plugins->setType('shellcmd');

$aEnabledShellPlugins=$CI_plugins->getEnabledPlugins('shellcmd');
$sHeader.= count($aEnabledShellPlugins) 
    ? '' 
        ."\n<!-- for shellcmd plugins -->\n"
        .'<script src="/vendor/axelhahn/js/ubd.class.js"></script>'."\n"
        .'<script src="/vendor/winbox/0.2.82/winbox.min.js"></script>'."\n"
        .'<link rel="stylesheet" type="text/css" href="/vendor/winbox/0.2.82/winbox.min.css"/>'."\n"
        ."<!-- shellcmd scripts -->\n"
    : ''
    ;
foreach ($aEnabledShellPlugins as $sPlugin){
    if ($CI_plugins->testPlugin($sPlugin)){
        $aPluginConfig=$CI_plugins->getPluginConfig();
        $sHeader.=$CI_plugins->getHtmlLoadScript('render.js');
        $sShellOuptut.=$CI_plugins->getHtmlOutwindow();
        $sTopRight.=''
            .'<li >'
            .$oHtml->getLink(array(
                'href'=>'#',
                // 'onclick'=>'toggleShellWindow(\''.$CI_plugins->getHtmlOutIdWrapper().'\', this);',
                'onclick'=>'toggleShellWindow(\''.$CI_plugins->getHtmlOutId().'\', this);',
                'role'=>'button',
                'aria-expanded'=>'false',
                'icon'=> (isset($aPluginConfig['icon']) ? $aPluginConfig['icon'] : ''),
                'label'=>$sPlugin,
            ))
            .'</li>'
        ;
    }
}

// ----------------------------------------------------------------------
// html body
// ----------------------------------------------------------------------

$sTopArea=getTopArea(['right'=>$sTopRight]);
$sBanner=isset($aConfig['banner']) && $aConfig['banner'] ? '<div class="alert alert-info">'.$aConfig['banner'].'</div>' : '';
$sTopAction=getAction();

// ------ action 
$oUser=new user();
if (isset($aConfig["auth"]['forceuser']) && $aConfig["auth"]['forceuser']){
    $oCLog->add("Found config -> auth -> forceuser: using fake identity [".$aConfig["auth"]['forceuser'].']', "warning");
    $oUser->setUser($aConfig["auth"]['forceuser']);
}

if ($oUser->hasPermission('page_'.$sAction)){

    $sActionFile = __DIR__ . '/pages/act_' . $sAction . ".php";

    $oCLog->add("including $sActionFile");
    ob_start();
    if (!@include($sActionFile)) {
        include("./pages/error_404.php");
    }
    $sPhpOut = ob_get_contents();
    ob_end_clean();
    $oCLog->add("including done $sActionFile");

    $oCLog->add("adding actionlog.class");

    if ($oUser->getUsername()){
        require_once("./classes/actionlog.class.php");
        $aFilter=array('limit'=>'0, 10');
        if ($sPrj && $sPrj!="all"){
            $aFilter['project']=$sPrj;
        }
        $oLog=new Actionlog($sPrj);
        $sPhpOut.='<div class="logs">' . $oLog->renderLogs($aFilter).'</div>';
    }
    $oCLog->add("adding actionlog.class done");
} else {
    $sPhpOut=$oUser->showDenied();
    // return false;
}

// ----------------------------------------------------------------------
// render page
// ----------------------------------------------------------------------

$oCLog->add("Finally: rendering page ...");

$sPhpOut = '
    <br>
    ' 
    . $sTopArea  
    . $sShellOuptut
    .'
    <div id="content">
        ' . $sBanner . $sTopAction . '
        ' . $sPhpOut . '
    </div>
    <div id="footer">
        '.t("menu-brand").' &copy; 2013-' . date("Y") . ' <a href="https://git-repo.iml.unibe.ch/iml-open-source/imldeployment/" target="_blank">Institut f&uuml;r Medizinische Lehre; Universit&auml;t Bern</a>
    </div>

    '
    .$oCLog->render();

$oPage = new Page();
$oPage->addResponseHeader("Pragma: no-cache");
$oPage->setOutputtype('html');
$oPage->setHeader($sHeader);
$oPage->addJsOnReady('');

$oPage->setContent($sPhpOut);
echo $oPage->render();
