<?php

/* ######################################################################

  IML DEPLOYMENT

  webgui - overview
 * for all projects
 * for a single project

  ---------------------------------------------------------------------
  2014-11-17  Axel <axel.hahn@iml.unibe.ch>  added tags and branches
  2014-04-24  Axel <axel.hahn@iml.unibe.ch>  new visual; sortorder in 
              project overview
  2013-11-08  Axel <axel.hahn@iml.unibe.ch>
  ###################################################################### */


if (!array_key_exists("prj", $aParams)) {

    // ----------------------------------------------------------------------
    // overview over all projects
    // ----------------------------------------------------------------------
    require_once("./classes/projectlist.class.php");
    $oPrjList = new projectlist();
    $BODY = $oPrjList->renderOverview();
} else {
    
    // ----------------------------------------------------------------------
    // overview of a single project
    // ----------------------------------------------------------------------
    require_once("./classes/project_gui.class.php");
    $oPrj = new projectgui($aParams["prj"]);
    
    $iCountOfBranches=0;
    $iCountOfBuildErrors=count($oPrj->getBuildErrors());
    $iCountOfpackages=count($oPrj->getVersions());
    $iCountOfPhases=count($oPrj->getActivePhases());

    $sBuildErrorContent='<p>'.t('build-failes-hint').'</p>';
    if($iCountOfBuildErrors){
        $aTabdata=array();
        $aErrorfiles=$oPrj->getBuildErrors();
        rsort($aErrorfiles);
        foreach ($aErrorfiles as $sNumber=>$sErrorfile){
            $aTabdata[$oHtml->getIcon('file-any').' '.$sErrorfile]=''
                    // . 'file: ' . $oHtml->getIcon('file-target'). ''.$sErrorfile.'<br>'
                    // . 'date: ' . .'<br>'
                    // . 'age: ' .  .'<br>'
                    . $oPrj->getBuildErrorContent($sErrorfile);
        }
        /*
        $sBuildErrorContent.=$oHtml->getNav(array(
                'options' => array(
                    'type'=>'pills',
                    'justified'=>0,
                ),
                'tabs'=>$aTabdata)
            );
        */
        $sBuildErrorContent.=$renderAdminLTE->getTabbedContent(['tabs'=>$aTabdata]);
    } else {
        $sBuildErrorContent=$oHtml->getBox('info', t('build-failes-none'));
    }

    $sListOfBranches='';
    foreach($oPrj->getRemoteBranches() as $aBranch){
        $sListOfBranches.='<li title="'.$aBranch['revision'].'">'.$aBranch['label'] . '</li>';
        $iCountOfBranches++;
    }
    if($sListOfBranches){
        $sListOfBranches='<h4>'.t('branch-select').'</h4><ol>'.$sListOfBranches.'</ol>';
    }

    $aTabdata=

    $sOut = '

            '.$renderAdminLTE->getTabbedContent([
                'tabs'=>[
                    $oHtml->getIcon('workflow') . t("way-of-packages") 
                        => $oPrj->renderVisual() . ''
                    ,
                    /*
                    $oHtml->getIcon('repository') . t("repositoryinfos") . ($iCountOfBranches ? ' <span class="badge badge-secondary">'.$iCountOfBranches.'</span>' : '' )
                        => '<br>'
                            .($oPrj->canAcceptPhase() ? $oPrj->renderLink("build").'<br><br>' : '') 
                            // . $oPrj->renderRepoInfo()
                            // . $oPrj->renderSelectRemoteBranches()
                            . $sListOfBranches
                    ,
                    */
                    $oHtml->getIcon('sign-error') . t("build-failes") . ($iCountOfBuildErrors ? ' <span class="badge badge-danger">'.$iCountOfBuildErrors.'</span>' : '' )
                        => '<br>'.$sBuildErrorContent
                    ,
                    $oHtml->getIcon('package') . t("packages") . ($iCountOfpackages ? ' <span class="badge badge-secondary">'.$iCountOfpackages.'</span>' : '' )
                        => '<br>'.$oPrj->renderVersionUsage() 
                    ,
                    $oHtml->getIcon('phase') . t('phases') .' '. ($iCountOfPhases ? '<span class="badge badge-secondary">'.$iCountOfPhases.'</span>' : '<span class="badge badge-danger">0</span>' )
                        => '<br>'.($oPrj->getActivePhases()
                            ? '<p>' 
                                . t("page-overview-phase-infos") 
                                . '</p>' 
                                . $oPrj->renderPhaseInfo()
                            : $oHtml->getBox("info", t("page-overview-no-phase"))
                            )
                ]
            ])
            ;
            
    $sPhaselinks='';
    $sLastPhase = '';
    foreach($oPrj->getActivePhases() as $sPhase){
        $sPhaselinks.='<div class="btn-group w-100">'.$oPrj->renderLink("phase", $sPhase).'</div>'
            //. (!$oPrj->canAcceptPhase($sPhase) ? '<div class="btn-group w-100">'.$oPrj->renderLink("accept", $sPhase).'</div>' : '')
            // .'<br><br>'
            ;
        $sLastPhase = $sPhase;
    }
    $BODY=
        $renderAdminLTE->addRow(
            $renderAdminLTE->addCol(
                $renderAdminLTE->getCard([
                'type'=>'gray',
                'variant'=>'outline',
                'text'=>$sOut,
                ]), 10
            )
            . $renderAdminLTE->addCol(
                $renderAdminLTE->getCard([
                'type'=>'gray',
                'type'=>'gray',
                'variant'=>'outline',
                'title'=> t('overview-actions-title'),
                'text'=> ''
                    . t('overview-actions-hint').'<br>'
                    . '<div class="btn-group w-100">'.$oPrj->renderLink("setup").'</div><br><br>'
                    .($oPrj->canAcceptPhase() ? '<div class="btn-group w-100">'.$oPrj->renderLink("build").'</div><br><br>' : '')
                    .($sPhaselinks
                        ? t("page-overview-phase-infos").'<br>'.$sPhaselinks
                        : ''
                    )
                ]), 2
            )

        );
        // $sOut.='<div id="navbuttom">' . aGotop() . aHome() . '</div>';
}
// 
echo $sOut;
