<?php
/**
 * 
 * Rollout plugin - default
 * 
 * no action
 *
 * @author <axel.hahn@iml.unibe.ch>
 */
class rollout_default extends rollout_base {

    /**
     * check requirements if the plugin could work
     */
    public function checkRequirements(){
        // no specific checks needed ... always true
        return true;
    }

    /**
     * check access to a deploy target
     */
    public function checkConnectionToTarget(){
        // do nothing ... always true
        return true;
    }

    /**
     * get array with commands to execute to deploy a package
     * 
     * @param  string   $sPhase
     * @param  boolean  $bMask   Flag for public output; if true then mask your secrets
     * @return array
     */
    public function getDeployCommands($sPhase, $bMask=false){
        return [
            'echo "SKIP"'
        ];
    }

    /**
     * override general form renderer: show a single message that no
     * configuration items exist
     * 
     * @return string
     */
    public function renderFormdata4Project() {
        return $this->_t('no-cfg');
    }

    /**
     * override general form renderer: show a single message that no
     * configuration items exist
     * 
     * @return string
     */
    public function renderFormdata4Phase($sPhase) {
        return $this->_t('no-cfg');
    }    
}
