<?php

/* ######################################################################

  IML DEPLOYMENT

  webgui - index file - controller like
  ensure that you activated the rewrite rules

  RewriteEngine on
  RewriteCond %{REQUEST_FILENAME} !-f
  RewriteCond %{REQUEST_URI} !^/server-status$
  RewriteRule ^(.*)$ index.php [QSA,L]

  ---------------------------------------------------------------------
  2013-11-08  Axel <axel.hahn@iml.unibe.ch>
  ###################################################################### */

session_start();
require_once("./classes/page.class.php");
require_once("../../config/inc_projects_config.php");
require_once("./classes/logger.class.php");
require_once("./classes/user.class.php");
global $oCLog;
$oCLog = new logger();
$oCLog->enableDebugByIp($aConfig['showdebug']['ip']);
require_once("./inc_functions.php");
require_once("./classes/htmlguielements.class.php");
$oHtml=new htmlguielements();

$sPrj = "";
$sAction = "overview";

// ------ check parameters

if (array_key_exists("prj", $aParams)) {
    $sPrj = $aParams["prj"];
}
if (array_key_exists("action", $aParams)) {
    if (file_exists(__DIR__ . '/pages/act_' . $aParams["action"] . ".php")) {
        $sAction = $aParams["action"];
    }
}
$oCLog->add("parsing params "
        . '<pre>GET '.print_r($_GET, true).'</pre>'
        . '<pre>POST '.print_r($_POST, true).'</pre>'
        . '<pre>aParams: '.print_r($aParams, true).'</pre>'
        );


// ------ Ausgabe
$sHeader = '<style>';
foreach ($aConfig["phases"] as $sPhase => $aData) {
    $sHeader.=array_key_exists("bgdark", $aData["css"]) ? 'th.' . $sPhase . '{' . $aData["css"]["bgdark"] . '}' : '';
    $sHeader.=array_key_exists("bglight", $aData["css"]) ? 'td.' . $sPhase . ', div.' . $sPhase . '{' . $aData["css"]["bglight"] . '}' : '';
    $sHeader.=array_key_exists("bgbutton", $aData["css"]) ? 'a.' . $sPhase . ',a.' . $sPhase . ':hover{' . $aData["css"]["bgbutton"] . '}' : '';
}
$sHeader.='</style>';
$sTopArea=getTopArea();
$sTopAction=getAction();

// ------ action 
$oUser=new user();
if ($oUser->hasPermission('page_'.$sAction)){

    $sActionFile = __DIR__ . '/pages/act_' . $sAction . ".php";

    $oCLog->add("including $sActionFile");
    ob_start();
    if (!@include($sActionFile)) {
        include("./pages/error_404.php");
    }
    $sPhpOut = ob_get_contents();
    ob_end_clean();
    $oCLog->add("including done $sActionFile");

    $oCLog->add("adding actionlog.class");

    if ($oUser->getUsername()){
        require_once("./classes/actionlog.class.php");
        $aFilter=array('limit'=>'0, 10');
        if ($sPrj && $sPrj!="all"){
            $aFilter['project']=$sPrj;
        }
        $oLog=new Actionlog($sPrj);
        $sPhpOut.='<div class="logs">' . $oLog->renderLogs($aFilter).'</div>';
    }
    $oCLog->add("adding actionlog.class done");
} else {
    $sPhpOut=$oUser->showDenied();
    // return false;
}

$oCLog->add("Finally: rendering page ...");

$sPhpOut = '
    <div id="header" style="display: none;">
        IML DEPLOYMENT GUI
    </div>
    <br>
    ' . $sTopArea . '
    <div id="content">
        ' . $sTopAction . '
        ' . $sPhpOut . '
    </div>
    <div id="footer">
        IML Deployment &copy; 2015-' . date("Y") . ' <a href="https://gitlab.iml.unibe.ch/admins/imldeployment/tree/master" target="_blank">Institut f&uuml;r medizinische Lehre; Universit&auml;t Bern</a>
    </div>
    '.$oCLog->render();

$oPage = new Page();
$oPage->addResponseHeader("Pragma: no-cache");
$oPage->setOutputtype('html');
$oPage->setHeader($sHeader);
$oPage->addJsOnReady('');

$oPage->setContent($sPhpOut);
echo $oPage->render();
