<?php

/* ######################################################################

  IML DEPLOYMENT

  webgui - deploy th package of the queue to repo

  ---------------------------------------------------------------------
  2013-11-08  Axel <axel.hahn@iml.unibe.ch>
  ###################################################################### */

require_once("./classes/project.class.php");
require_once("./classes/formgen.class.php");
require_once("./inc_functions.php");

// --- Checks
$oPrj = new project($aParams["prj"]);

$sOut = '';
if (array_key_exists("par3", $aParams)) {
    $sPhase = $aParams["par3"];
}

if (array_key_exists("confirm", $aParams)) {
    $bIgnoreDeploytimes = false;
    if (array_key_exists("aIgnore", $aParams)) {
        $bIgnoreDeploytimes = $aParams["aIgnore"][0] == "bIgnoreDeploytimes";
    }
    $sOut.=$oPrj->deploy($sPhase, $bIgnoreDeploytimes);
} else {
    if ($sPhase) {
        $sPhase = $aParams["par3"];

        $aPhaseData = $oPrj->getPhaseInfos($sPhase);
        if (!array_key_exists('version', $aPhaseData['onhold'])){
            $sOut.=$oHtml->getBox("error", 
                    sprintf(t("deploy-impossible"), $sPhase).'<br>'
                    . (array_key_exists('info', $aPhaseData['onhold']) ? $aPhaseData['onhold']['info'].'<br>' : '')
                    . (array_key_exists('warning', $aPhaseData['onhold']) ? $aPhaseData['onhold']['warning'].'<br>' : '')
                    . (array_key_exists('error', $aPhaseData['onhold']) ? $aPhaseData['onhold']['error'].'<br>' : '')
                    );
        } else {
            $sOut.='
                   <p>
                        ' . t("onhold") . ':<br>
                        ' . $oPrj->renderPhaseDetail($sPhase, "onhold", false) . '
                   </p>
            ';

            // Eingabe Kommentare zum Deployment
            $i = 0;
            $aForms = array(
                'deploy' => array(
                    'meta' => array(
                        'method' => 'POST',
                        'action' => '?',
                    ),
                    'validate' => array(),
                    'form' => array(
                        'input' . $i++ => array(
                            'type' => 'hidden',
                            'name' => 'confirm',
                            'value' => '1',
                        ),
                        'input' . $i++ => array(
                            'type' => 'checkbox',
                            'name' => 'aIgnore',
                            'label' => t("deploy-settings"),
                            'validate' => 'isastring',
                            'options' => array(
                                'bIgnoreDeploytimes' => array(
                                    'label' => t("page-deploy-info-ignore-deploytime"),
                                    'checked' => false,
                                ),
                            ),
                        ),
                        'button' . $i++ => array(
                            'type' => 'submit',
                            'value' => t("deploy"),
                        ),
                    ),
                ),
            );
            $oForm = new formgen($aForms);
            $sOut .= $oForm->renderHtml("deploy");
        }
    } else {
        $sOut.=$oHtml->getBox("error", t("error-no-phase"));
    }
}

$sOut.= '<div id="navbuttom">' . aPrjHome() . '</div>';

// -- Ausgabe
echo $sOut;
?>
