# Usage

## Include the ldap class

```php
require_once '[APPROOT]/classes/ldap.class.php';
```

## Create a config with connection data

As an example I create a hash named $aConfig and save it as "inc_config.php".

```php
return [
      ...

       'ldap' => [
           'server'     => 'ldaps://ldap.example.com',
           'DnLdapUser' => 'cn=Lookup,ou=Service,dc=some,dc=example.com',
           'PwLdapUser' => 'PasswordOfLookupUser',

           // node where to find users that are allowed to login
           'DnUserNode' => 'ou=People,dc=some,dc=example.com',

           // node where to find my app
           'DnAppNode'  => 'cn=MyApp,dc=some,dc=example.com',
           'debugLevel' => 0,
       ],
      ...

];
```

## initialize connection

```php
$aConfig = require_once('inc_config.php');
require_once '[APPROOT]/classes/ldap.class.php';

$oLdap=new imlldap($aConfig['ldap']);
```

## Methods

### Object handling

* objAdd(string $sDn, array $aItem): bool
* objGet(string $sDn, string $sSearchFilter = '(objectclass=*)', array $aAttributesToGet = ["*"]): bool|array
* objUpdate(string $sDn, array $aItem): bool
* objDelete(string $sDn): bool

### Attributes

* objAddAttr(string $sDn, array $aItem): bool
* objDeleteAttr(string $sDn, array $aItem): bool
* objectAttributeExists(string $sDn, string $sAttribute): bool
* objectAttributeAndValueExist(string $sDn, string $sAttribute, string $sAttrValue): bool - check only
* objectAttributeAndValueMustExist(string $sDn, string $sAttribute, string $sAttrValue): bool - force the existence of attribute and value

### User functions

* userAdd(array $aItem, string $sDn = "")
* getUserInfo(string $sUser, array $aAttributesToGet = ["*"]): bool|array
* userDelete(string $sUserDn)
* userUpdate(array $aItem)
* setPassword(string $sUser, string $sPW): bool
* verifyPassword(string $sUser, string $sPW): bool

### Debugging

Turn debugging on or off

* debugOff()
* debugOn()

## Examples

### read user attributes

Use the username or an email address to get user data. The 2nd parameter defines the attributes to fetch (`["*"]` is default).

```php
$aUser = $oLdap->getUserInfo("john@example.com", []);
$aUser = $oLdap->getUserInfo("john@example.com", ["memberof", "uid"]);        

// simplify result array:
print_r($oLdap->normalizeSearchentry($aUser));
```

### Verify user and password for login

```php
// set values from $_FORM or $_POST data of your login form here
// The variable $bAuthenticated is true if authentication of the user was successful.
$bAuthenticated=oLdap->verifyPassword($sUser, $sPassword);
```

### Example: search

When using special chars in search then you can sanitize the search string.

```php
$sCn = 'John Smith (john)';
$sSearchFilter = '(cn='.$oLdap->sanitizeFilter($sCn).')';
$aResults = $oLdap->searchDn("<DN here>", $sSearchFilter, ["*"]);
$oLdap->close();
```
