# ldap.class.php

<!-- BEGIN DOC-COMMENT H2 ../src/ldap.class.php -->

---
## `class imlldap`

IML LDAP CONNECTOR

2022-02-22  ah  added objGet(), sanitizeFilter() 2022-08-18  ah  mask password (showing 4 chars only) 2022-08-22  ah  mhash is deprecated 2022-08-26  ah  fix verifyPassword 2024-07-11  ah  php8 only: use variable types

---
## `private array $_aLdap = [ 'server' => false, 'port' => false, 'DnLdapUser' => false, // ldap rdn oder dn 'PwLdapUser' => false, 'DnUserNode' => false, // ou=People... 'DnAppNode' => false, // cn=AppGroup... 'protoVersion' => 3, 'debugLevel' => 0, ]`

---
## `private object|bool $_ldapConn = false`

---
## `private object|bool $_ldapBind = false`

ldap bind object - bind was done?

---
## `var bool $bDebug = false`

Flag if debug mode is on

---
## `public function __construct(array $aConfig = [])`

constructor
**Parameters:**

Var | Type | Desciption
--  |--    |--
$aConfig | array | optional set ldap connection

---
## `public function debugOn(): void`

turn debug messages on; if this detail level is not enough, set a value with key debugLevel in ldap config array

---
## `public function debugOff(): void`

turn debug messages off

---
## `private function _w(string $sText): bool`

write debug message if denugOn() was fired.

**Parameters:**

Var | Type | Desciption
--  |--    |--
$sText | string | message text

**Return:**

  boolean

---
## `private function _wLdaperror(string $sText = ''): bool`

write last ldap error as debug

**Parameters:**

Var | Type | Desciption
--  |--    |--
$sText | string | message text

**Return:**

  boolean

---
## `public function setConfig(array $aConfig = []): void`

set a ldap config

            'server'       => 'ldaps://ldap.example.com',
            'port'         => 636,
            'DnLdapUser' => 'cn=Lookup,ou=ServiceAccounts,dc=org,dc=example.com',     // ldap rdn oder dn
            'PwLdapUser' => 'IkHEFFzlZ...99j0h8WdI0LrLhxU',  // password
            'DnUserNode'   => 'ou=People,ou=ORG,dc=org,dc=example.com',
            'DnAppNode'    => '' optional dn ... if a user must be member of a given group
            'protoVersion' => 3
            'debugLevel'   => 0 // for debugging set higher 0 AND call debugOn()

**Parameters:**

Var | Type | Desciption
--  |--    |--
$aConfig | array | new config items

---
## `public function close(): void`

close an existing ldap connection

---
## `public function connect(): void`

connect to ldap

---
## `public function bind(string $sUser = '', string $sPw = ''): bool`

ldap bind connects with a ldap user. If the ldap connection was not opened yet the connection will be established. If a binding exists it will be unbind

**Parameters:**

Var | Type | Desciption
--  |--    |--
$sUser | string | optional: username (overrides _aLdap['DnLdapUser'])
$sPw | string | optional: password (overrides _aLdap['PwLdapUser'])

---
## `public function unbind(): void`

ldap unbind ... if a bind exists

---
## `public function DnExists(string $sDn): bool`

check if a DN already exists; return is true/ false
**Parameters:**

Var | Type | Desciption
--  |--    |--
$sDn | string | DN to check

**Return:**

  boolean

---
## `public function normalizeSearchentry(array $aRecord): bool|array`

get simpler array from ldap_get_entries after ldap_search If the given array doesn't contain the key "dn" it returns "false"

**Parameters:**

Var | Type | Desciption
--  |--    |--
$aRecord | array | single result item

**Return:**

  array

---
## `static public function sanitizeFilter(string $s): string`

sanitize value to put into a search filter WARNING: the implementation is incomplete! I replaces the first N ascii chars only

source: https://www.rfc-editor.org/rfc/rfc4515.txt

$sCn = 'John Smith (john)'; $sSearchFilter = '(cn='.$oLdap->sanitizeFilter($sCn).')';
**Parameters:**

Var | Type | Desciption
--  |--    |--
$s | string | value to sanitize

**Return:**

  string

---
## `public function searchDn(string $sDn, string $sSearchFilter = '(objectclass=*)', array $aAttributesToGet = ["*"], bool $bRecursive = true): bool|array`

search in ldap directory and get result as array. It returns "false" on error: - no ldap connection - search failed

**Parameters:**

Var | Type | Desciption
--  |--    |--
$sDn | string | DN to search for
$sSearchFilter | string | filter in ldap filter syntax
$aAttributesToGet | array | flat array of attributes to fetch
$bRecursive | boolean | recusrive (uses ldap_search) or not (ldap_list)

**Return:**

  boolean|array

---
## `public function searchUser(string $sSearchFilter = '', array $aAttributesToGet = ["*"], bool $bRecursive = true): bool|array`

search for entries in in ldap user node and get result as array

**Parameters:**

Var | Type | Desciption
--  |--    |--
$sSearchFilter | string | filter in ldap filter syntax
$aAttributesToGet | array | flat array of attributes to fetch
$bRecursive | bool | flag: recursive search? default: true (=yes, recursive)

**Return:**

  boolean|array

---
## `public function getUserInfo(string $sUser, array $aAttributesToGet = ["*"]): bool|array`

search user by a given username or email address. It returns false if the user does not exist or is not member of the group 'DnAppNode' (if it was set).

**Parameters:**

Var | Type | Desciption
--  |--    |--
$sUser | string | user id (uid) or email (mail) to search
$aAttributesToGet | array | i.e. ["ou", "sn", "vorname", "mail", "uid", "memberOf"]

**Return:**

  boolean|array

---
## `public function getUserDn(string $sUser): bool|string`

search for a DN entry with the lookup user by a given username or email address. It returns false if the user does not exist or is not member of the group 'DnAppNode' (if it was set).

**Parameters:**

Var | Type | Desciption
--  |--    |--
$sUser | string | %s

**Return:**

  string

---
## `public function setPassword(string $sUser, string $sPW): bool`

set a password for a given user; this requires a ldap bind with master/ admin account

**Parameters:**

Var | Type | Desciption
--  |--    |--
$sUser | string | username or email
$sPW | string | password

**Return:**

  boolean

---
## `private function _getNTLMHash(string $Input): string`

get NTLM hash from a string taken from https://secure.php.net/manual/en/ref.hash.php

**Parameters:**

Var | Type | Desciption
--  |--    |--
$Input | string | %s

**Return:**

  string

---
## `public function setPasswordSamba(string $sUser, string $sPW): bool`

set a password for a given user for Samba this requires a ldap bind with master/ admin account see https://msdn.microsoft.com/en-us/library/cc223248.aspx see http://php.net/ldap-modify-batch  - last examle see https://secure.php.net/manual/en/ref.hash.php

**Parameters:**

Var | Type | Desciption
--  |--    |--
$sUser | string | username or email
$sPW | string | password

**Return:**

  boolean

---
## `public function objAdd(string $sDn, array $aItem): bool`

update an ldap object this requires a ldap bind with master/ admin account It returns true if the action was successful

**Parameters:**

Var | Type | Desciption
--  |--    |--
$sDn | string | dn to update
$aItem | array | array of new ldap properties

**Return:**

  boolean

---
## `public function objAddAttr(string $sDn, array $aItem): bool`

update an ldap attribute this requires a ldap bind with master/ admin account

**Parameters:**

Var | Type | Desciption
--  |--    |--
$sDn | string | dn to update
$aItem | array | array of new ldap properties

**Return:**

  boolean

---
## `public function objGet(string $sDn, string $sSearchFilter = '(objectclass=*)', array $aAttributesToGet = ["*"]): bool|array`

read attributes from ldap node with given DN (using ldap_read) It returns "false" if the action was not successful - no ldap connection - DN or filter didn't match

**Parameters:**

Var | Type | Desciption
--  |--    |--
$sDn | string | DN to search for
$sSearchFilter | string | filter in ldap filter syntax
$aAttributesToGet | array | flat array of attributes to fetch

**Return:**

  boolean|array

---
## `public function objUpdate(string $sDn, array $aItem): bool`

update an ldap object with given key-value array if the attribute (key) does not exist it will be created. this requires a ldap bind with master/ admin account It returns "false" if the action failed

**Parameters:**

Var | Type | Desciption
--  |--    |--
$sDn | string | full DN where to update the item
$aItem | array | updated entry

**Return:**

  boolean

---
## `public function objDelete(string $sDn): bool`

delete an ldap object this requires a ldap bind with master/ admin account It returns "false" if the action failed

**Parameters:**

Var | Type | Desciption
--  |--    |--
$sDn | string | full DN to remove

**Return:**

  boolean

---
## `public function objDeleteAttr(string $sDn, array $aItem): bool`

delete attributes of an ldap object this requires a ldap bind with master/ admin account It returns "false" if the action failed

remove attribute "userPassword" of user $sUserDn: <code>$oLdap->objDeleteAttr($sUserDn, ['userPassword'=>[]]</code>
**Parameters:**

Var | Type | Desciption
--  |--    |--
$sDn | string | DN
$aItem | array | item to remove

**Return:**

  boolean

---
## `public function objectAttributeExists(string $sDn, string $sAttribute): bool`

check if an attribute exists in a DN

**Parameters:**

Var | Type | Desciption
--  |--    |--
$sDn | string | DN
$sAttribute | string | attribute name to check
$sAttrValue | string | value to check

**Return:**

  boolean

---
## `public function objectAttributeAndValueExist(string $sDn, string $sAttribute, string $sAttrValue): bool`

check if an attribute and value exist in a DN

**Parameters:**

Var | Type | Desciption
--  |--    |--
$sDn | string | DN
$sAttribute | string | attribute name to check
$sAttrValue | string | value to check

**Return:**

  boolean

---
## `public function objectAttributeAndValueMustExist(string $sDn, string $sAttribute, string $sAttrValue): bool`

check an attribute and value; it will be created if it does not exist this requires a ldap bind with master/ admin account

**Parameters:**

Var | Type | Desciption
--  |--    |--
$sDn | string | dn to update
$sAttribute | string | attribute name to check
$sAttrValue | string | value to check

**Return:**

  boolean

---
## `public function userAdd(array $aItem, string $sDn = ""): bool`

create a new user item this requires a ldap bind with master/ admin account

**Parameters:**

Var | Type | Desciption
--  |--    |--
$aItem | array | ldap properties
$sDn | string | optional DN where to create the user

**Return:**

  boolean

---
## `public function userDelete(string $sUserDn): bool`

delete a user this requires a ldap bind with master/ admin account

**Parameters:**

Var | Type | Desciption
--  |--    |--
$sUser | string | user to update
$sPW | string | new password to set

**Return:**

  boolean

---
## `public function userUpdate(array $aItem): bool`

update an ldap object this requires a ldap bind with master/ admin account

**Parameters:**

Var | Type | Desciption
--  |--    |--
$aItem | array | new user data to update

**Return:**

  boolean

---
## `public function verifyPassword(string $sUser, string $sPW): bool`

verify user and password
**Parameters:**

Var | Type | Desciption
--  |--    |--
$sUser | string | username or email
$sPW | string | password

**Return:**

  boolean

<!-- END DOC-COMMENT -->