<?php
/**
 * 
 * TEST
 * Verify if a redirect works
 * 
 * Usage:
 * cd ./tests
 * php get_redirect.php
 * 
 */
require_once '../public_html/classes/redirect.class.php';

// ------------------------------------------------------------------------
// CONFIG
// ------------------------------------------------------------------------
$aTests=[
    'www.example.com - static entry /mail' => [
        'host'=>'www.example.com',
        'request'=>'/mail',

        'target'=>'https://www.example.com/webmail',
        'code'=>301,
    ],
    'www.example.com - /mail2 should not match /mail but the regex' => [
        'host'=>'www.example.com',
        'request'=>'/mail2',

        'target'=>'https://www.example.com/',
        'code'=>307,
    ],
    'www.example.com - regex' => [
        'host'=>'www.example.com',
        'request'=>'/somethingold',

        'target'=>'https://www.example.com/',
        'code'=>307,
    ],
    'www.example.com - /iml must match regex ^/iml' => [
        'host'=>'www.example.com',
        'request'=>'/iml',

        'target'=>'https://www.iml.unibe.ch/',
        'code'=>307,
    ],
    'www.example.com - /iml2 must match regex ^/iml too' => [
        'host'=>'www.example.com',
        'request'=>'/iml2',

        'target'=>'https://www.iml.unibe.ch/',
        'code'=>307,
    ],
];

// ------------------------------------------------------------------------
// INIT
// ------------------------------------------------------------------------

$oR=new redirect();
$oR->setDebug(isset($_GET['debugredirect']) && $_GET['debugredirect'] ? true : false);

echo "\n";
echo "##################### TEST REDIRECT #####################\n";
echo "\n";


// ------------------------------------------------------------------------
// LOOP :: Redirects
// ------------------------------------------------------------------------

foreach ($aTests as $sTestName => $aTest) {
    echo "==========|  $sTestName  |==>  ".$aTest['host']." - ".$aTest['request']." \n";
    // echo "To check\n";
    // print_r($aTest);

    // set data
    $oR->setHost($aTest['host']);
    $oR->setRequest($aTest['request']);

    // verify
    $bOk=true;

    if ($oR->getRedirectTarget() != $aTest['target']) {
        $bOk=false;
        echo ">>>> CONFIG FAILED: target returned ".$oR->getRedirectTarget()." - not ".$aTest['target']."\n";
    }
    if ($oR->getRedirectCode() != $aTest['code']) {
        $bOk=false;
        echo ">>>> CONFIG FAILED: Redirect code retuned ".$oR->getRedirectCode()." - not ".$aTest['code']."\n";
    }
    if($bOk) {
        echo ">>>> OK: redirects with ".$aTest['code']." to ".$aTest['target']."\n";
    } else {
        echo "Detected redirect from config\n";
        print_r($oR->getRedirect());    
        echo "\n";
    }
    echo "\n";    
}


echo "DONE\n";

// ------------------------------------------------------------------------
