
# IML Redirect #

Redirect urls of any domain that points here.

Author: Axel Hahn; Institute for Medical Education; University of Bern

License: GNUP GPL 3.0

## Requirements ##

* PHP 7+
* Webserver (docs describe usage for Apache httpd)

## Installation ##

Extract archive 1 level above webroot. The document root of the web must point 
to the public_html directory. The config folder is outside the webroot.

Redirect all requests to the index.php. Activate the .htaccess or (better)
add the config of the htaccess file to the vhost config.

```text
RewriteEngine On
RewriteBase /
RewriteCond %{REQUEST_FILENAME} !-f
RewriteCond %{REQUEST_FILENAME} !-d
RewriteRule ^.*$ /index.php [L]
```

In the DNS point all hostnames with redirects only to this server (i.e. with 
a CNAME).

If you don't have a single vhost in the webserver then additionally add the
domains to "catch" as ServerAlias.

## Configuration ##

In the config folder are json files. Copy the dist files to the same filename without ".dist"

* redirects_[FQDN].json
* aliases.json

### Redirects ###

There are 2 required sections to define redirects:

* direct
* regex

The section "direct" will be scanned first and has priority.
The json will be read into a hash ... if you define a direct rule twice then
the last rule will win.

If no direct rule matches the regex section will be scanned. Winner is the 
first matching regex.

If no rule matches a 404 will be shown.

Hint: if you set regex ".*" as last entry it works as a catchall for unmatched
requests and you can define a default redirect target instead of showing a 404. 

Both redirect section contain a redirect definition

* code - http status code for redirection
* target - target url of the redirect

Status codes

* 301 => 'Moved Permanently'; the url is outdated
* 307 => 'Temporary Redirect'; the url is valid
* 308 => 'Permanent Redirect'; the url is outdated

Suggestion for redirection lifecycle:

* an active redirect (i.e. a campaign) use code 307
* if the redirect has finished its life, switch the code to 308 or 301.
* remove the redirect (which results into 404)

Example:

```json
{
    "direct":{
        "heise":   {"code": 307, "target": "https://www.heise.de" }
    },

    "regex":{
        "^$":      {"code": 307, "target": "https://www.iml.unibe.ch" },
        "^ax.l.*": {"code": 307, "target": "https://www.axel-hahn.de" }
    }
}
```

### Server aliases ###

If you have multiple domains with the same rules you can define aliases.

Example:

```json
{
    "www.example.com": "example.com",
    "zzz-domainname":  "existing-host-with-redirect-config"
}
```

The key is the name of the alias. The value is a domain for that was written a 
redirect_[hostname].json already.

The existance of a redirect config has higher priority than an entry in the
aliases config.

## Ideas ##

The current functionality is available with rewrite rules. Maybe in future
one of these features could be implmeneted:

* track request before redirecting to generate a statistic
* lifecycle of campaign short urls
* admin interface / just a viewer for all definitions
